/* Driver functions for input devices and video cards */

/* Any device drivers you write should be added to this list */

extern vrl_DeviceDriverFunction
#ifdef VRL_PC_COMPATABLE
	/* these first few devices only exist on PC's */
	vrl_KeypadDevice,     /* keypad arrows, plus PgUp and PgDn keys */
	vrl_JoystickDevice,   /* analog joystick */
	vrl_PadDevice,        /* Game controller with cable from July 1990 Byte */
	vrl_FifthDevice,      /* 5th Dimension Technologies glove device */
	vrl_CyberwandDevice,  /* CyberWand controller */
	vrl_7thSenseDevice,   /* 7th Sense headtracker */
#endif
	/* the rest are (theoretically) platform-independent */
	vrl_MouseDevice,      /* standard mouse */
	vrl_GlobalDevice,     /* GDC controller */
	vrl_CybermanDevice,   /* Logitech Cyberman */
	vrl_RedbaronDevice,   /* Logitech ultrasonic tracker */
	vrl_CTMDevice,        /* CTM tracker in CyberMaxx HMD */
	vrl_SpaceballDevice,  /* Spatial Systems Spaceball */
	vrl_IsotrakDevice,    /* Polhemus Isotrak */
	vrl_VIODevice;        /* Virtual i/o tracker device */

extern vrl_VideoDriverFunction
	vrl_VideoDriverMode13,   /* regular VGA (320x200, 256 colors, 1 page */
	vrl_VideoDriverModeY,    /* unchained VGA (320x200, 256 colors, 4 pages) */
	vrl_VideoDriver7thSense; /* 7th Sense HMD adapter card (320x200, 256 colors, 1 page) */

/* end of list */