#include <iostream.h>
#include <math.h>
#include <stdio.h>
#include <fstream.h>
#include <time.h>
// VOL 14/ TWOD.CPP C++ PROGRAM TO CALCULATE A TWO DIMENSIONAL//
// FINITE ELEMENT PROBLEM WITH TEMPERATURE BASED ON THE PENALTY
// APPROACH.  8/12/97 JOHN STEARNS  VER 3.0
//
// PROGRAM VARIABLES
//el= ELEMENT LENGTH
//eal=e*a/l= STIFFNESS
//ne=ELEMENT NUMBER
//nl=LOAD NUMBER
//nd=DISPLACEMENT NUMBER
//a[]=ELEMENT AREA
//p[i][1]=ELEMENT YOUNGS MODULUS
//p[i][2]=ELEMENT THERMAL EXPANSION
//temp[i]=DELTA TEMPERATURE
//nbw=BANDWIDTH
//cnst=PENALTY APPROACH
//stressp[i]=STRESS VECTOR
void output(char* outfile, fstream& f)
{
outfile="twod.txt";
f.open(outfile,ios::out);
}
void main()
{
struct tm *systime;
time_t t;
t=time(NULL);
systime=localtime(&t);

int ne,nn,nd,nl,nm,nq,noc[22][5],i,ild[20],nbw,c,na,ntel,j,n,i1,i2,i3,i4,ii,
nrt,it,nr,jj,nct,jt,nc,ijt,n1,k,nk,j1,kk,nu[20],j2,k2,k1;
float x[20][2],pm[5][2],area[5],u[20], temp[5],el,eal,cs,sn,eeo,cnst,dt,stress,
nset[20],stressp[20], react[30], y21, al[20],x21,s[20][20], f[20], se[6][6],c1;
fstream fout;
char outfile[12];
cout<<"============================================\n\n";
cout<<"Two dimensional Finite Element Analysis\n";
cout<<"      with temperature effects\n\n";
cout<<"Programming in Turbo C++, by John C Stearns\n\n";
cout<<"              Version 3.15\n";
cout<<"============================================\n\n";
cout<<"Enter data seperated by a space, Do NOT enter ";
cout<<"data in exponential form i.e. 30e6\n\n";
cout<<"Number of elements = ";
cin>>ne;
cout<<"\nNumber of nodes = ";
cin>>nn;
cout<<"\nNumber of constrained DOF = ";
cin>>nd;
cout<<"\nNumber of component loads = ";
cin>>nl;
cout<<"\nNumber of materials = ";
cin>>nm;
cout<<"\nNumber of Areas of cross section = ";
cin>>na;
cout<<"\nNumber of elements with temperature change = ";
cin>>ntel;
nbw=0;
nq=2*nn;
cout<<"node1 node2 material# area#\n";
for(i=1;i<=ne;i++)
	{
	cout<<"For element# "<<i<<": ";
	cin>>noc[i][1]>>noc[i][2]>>noc[i][3]>>noc[i][4];
	c=2*abs(noc[i][2]-noc[i][1])+2;
	if (nbw<c) nbw=c;
	}
if(ntel==0) goto notemp;
cout<<"elem# temperature change\n";
for(i=1;i<=ntel;i++)
	{
	cin>>nset[i]>>temp[i];
	}
notemp: cout<<"area\n";
for(i=1;i<=na;i++)
	{
	cout<<"area# "<<i<<" ";
	cin>>area[i];
	}
cout<<"The bandwidth is "<<nbw<<"\n";
for (i=1;i<=nq;i++)
	{
	f[i]=0;
	for (j=1;j<=nbw;j++)
		{
		s[i][j]=0;
		}
	}
cout<<"Input the X-Coord Y-Coord\n";
for (i=1;i<=nn;i++)
	{
	cout<<"Node # "<<i<<" ";
	cin>>x[i][1]>>x[i][2];
	}
cout<<"Input the E Alpha\n";
for (i=1;i<=nm;i++)
	{
	cout<<"Material # "<<i<<" ";
	cin>>pm[i][1]>>pm[i][2];
	}
cout<<"DOF#  Displacement\n";
for (i=1;i<=nd;i++)
	{
	cin>>nu[i]>>u[i];
	}
cout<<"Input the DOF# Applied load\n";
for (i=1;i<=nl;i++)
	{
	cin>>n;
	cin>>f[n];
	ild[i]=n;
	al[i]=f[n];
	}
// GLOBAL STIFFNESS MATRIX //
for(n=1;n<=ne;n++)
	{
	i1=noc[n][1];
	i2=noc[n][2];
	i3=noc[n][3];
	i4=noc[n][4];
	x21=x[i2][1]-x[i1][1];
	y21=x[i2][2]-x[i1][2];
	el=sqrt(x21*x21+y21*y21);
	eal=pm[i3][1]*area[i4]/el;
	cs=x21/el;
	sn=y21/el;
	se[1][1]=cs*cs*eal;
	se[1][2]=cs*sn*eal;
	se[2][1]=se[1][2];
	se[1][3]=-cs*cs*eal;
	se[3][1]=se[1][3];
	se[1][4]=-cs*sn*eal;
	se[4][1]=se[1][4];
	se[2][2]=sn*sn*eal;
	se[2][3]=-cs*sn*eal;
	se[3][2]=se[2][3];
	se[2][4]=-sn*sn*eal;
	se[4][2]=se[2][4];
	se[3][3]=cs*cs*eal;
	se[3][4]=cs*sn*eal;
	se[4][3]=se[3][4];
	se[4][4]=sn*sn*eal;
	cout<<"!!!! Placing Stiffness in Global locations!!!!\n";
	for (ii=1;ii<=2;ii++)
		{
		nrt=2*(noc[n][ii]-1);
		for (it=1;it<=2;it++)
			{
			nr=nrt+it;
			i=2*(ii-1)+it;
			for(jj=1;jj<=2;jj++)
				{
				nct=2*(noc[n][jj]-1);
				for(jt=1;jt<=2;jt++)
					{
					j=2*(jj-1)+jt;
					nc=nct+jt-nr+1;
					if(nc<=0) goto skip;
					s[nr][nc]=s[nr][nc]+se[i][j];
                                        skip:// skip//;
					}
				 }
			 }
		}
	for (ijt=1;ijt<=ntel;ijt++)
		{
		if (n==nset[ijt]) goto eeo;
		break;
		eeo: eeo=pm[i3][2]*temp[ijt]*pm[i3][1]*area[i4];
		f[2*i1-1]=f[2*i1-1]-eeo*cs;
		f[2*i1]=f[2*i1]-eeo*sn;
		f[2*i2-1]=f[2*i2-1]+eeo*cs;
		f[2*i2]=f[2*i2]+eeo*sn;
		}
	}
// MODIFY FOR BOUNDARY CONDITIONS //
cnst=s[1][1]*10000;
for (i=1;i<=nd;i++)
	{
	n=nu[i];
	s[n][1]=s[n][1]+cnst;
	f[n]=f[n]+cnst*u[i];
       	}
// EQUATION SOLVING //
n1=nq-1;
// FORWARD ELIMINATION //
for (k=1;k<=n1;k++)
	{
	nk=nq-k+1;
	if(nk>nbw) nk=nbw;
	for(i=2;i<=nk;i++)
		{
		c1=s[k][i]/s[k][1];
		i1=k+i-1;
		for (j=i;j<=nk;j++)
			{
			j1=j-i+1;
			s[i1][j1]=s[i1][j1]-c1*s[k][j];
			}
		f[i1]=f[i1]-c1*f[k];
		}
	}
// BACK SUBSTITUTION //
f[nq]=f[nq]/s[nq][1];
for (kk=1;kk<=n1;kk++)
	{
	k=nq-kk;
	c1=1/s[k][1];
	f[k]=c1*f[k];
	nk=nq-k+1;
	if(nk>nbw) nk=nbw;
	for (j=2;j<=nk;j++)
		{
		f[k]=f[k]-c1*s[k][j]*f[k+j-1];
		}
	}
// RESULTS //
cout.precision(5);
cout<<"Two dimensional Problem with temperature\n";
cout<<"Turbo C++ Version 3.15\n";
cout<<"4600:420 Introduction to Finite Element Method\n";
cout<<"Date: "<<systime->tm_mon+1<<":"<<systime->tm_mday<<":"<<
systime->tm_year+1900<<"\n";
cout<<"\nNode#\tX-Displ\t\tY-Displ\n";
cout.precision(4);
for (i=1;i<=nn;i++)
	{
	cout<<i<<"\t"<<f[2*i-1]<<"\t"<<f[2*i]<<"\n";
	}
//STRESS CALCULATION stress=E*strain //
cout<<"\nElement#\tStress\n";
for (i=1;i<=ne;i++)
	{
	i1=noc[i][1];
	i2=noc[i][2];
	i3=noc[i][3];
	x21=x[i2][1]-x[i1][1];
	y21=x[i2][2]-x[i1][2];
	el=sqrt(x21*x21+y21*y21);
	cs=x21/el;
	sn=y21/el;
	j2=2*i1;
	j1=j2-1;
	k2=2*i2;
	k1=k2-1;
	dt=(f[k1]-f[j1])*cs+(f[k2]-f[j2])*sn;
	stress=dt*pm[i3][1]/el;
//THERMAL STRESS ADD - ON
	for(ijt=1;ijt<=ntel;ijt++)
		{
		if(i==nset[ijt]) goto heat;
		goto noheat;
		heat: stress=stress-pm[i3][1]*pm[i3][2]*temp[ijt];
		noheat:
		}
	cout<<i<<"\t\t"<<stress<<"\n";
//STORE STRESS IN VECTOR FORMAT//
	stressp[i]=stress;
	}
//REACTION //
cout<<"\nDOF#\tReaction\n";
for (i=1;i<=nd;i++)
	{
	n=nu[i];
	react[i]=cnst*(u[i]-f[n]);
	cout<<n<<"\t"<<react[i]<<"\n";
	}

//CALL FILE OUTPUT TO DISK
cout<<"Output to text file called twod.txt\n";
cout<<"is now being created...\n";
output(outfile, fout);
fout.precision(5);
fout.width(25);
fout<<"Two dimensional Problem with temperature\n";
fout<<"Turbo C++ Version 3.15\n";
fout<<"4600:420 Introduction to Finite Element Method\n";
fout<<"Date of printing: "<<systime->tm_mon+1<<":"<<systime->tm_mday<<":"<<
systime->tm_year+1900<<"\n";
fout<<"NE, NN, ND, NL, NM, NA, NTEL, NBW=\n";
fout<<ne<<" "<<nn<<" "<<nd<<" "<<nl<<" "<<nm<<" "<<na<<" "<<ntel<<" "<<nbw<<"\n";
fout<<"Elem#\tNode1\tNode2\tMaterial#\tArea#\n";
for(i=1;i<=ne;i++)
	{
	fout<<i<<"\t"<<noc[i][1]<<"\t"<<noc[i][2]<<"\t"<<noc[i][3]<<"\t"<<noc[i][4]<<"\n";
	}
if (ntel==0) goto lessheat;
fout<<"Elem#\tTemperature Change\n";
for(i=1;i<=ntel;i++)
	{
	fout<<nset[i]<<"\t"<<temp[i]<<"\n";
	}
lessheat:fout<<"Area#\tArea\n";
for(i=1;i<=na;i++)
	{
	fout<<i<<"\t"<<area[i]<<"\n";
	}
fout<<"Node#\tX-Coord\tY-Coord\n";
for(i=1;i<=nn;i++)
	{
	fout<<i<<"\t"<<x[i][1]<<"\t"<<x[i][2]<<"\n";
	}
fout<<"Mat#\tE\tAlpha\n";
for(i=1;i<=nm;i++)
	{
	fout<<i<<"\t"<<pm[i][1]<<"\t"<<pm[i][2]<<"\n";
	}
fout<<"DOF#\tDisplacement\n";
for(i=1;i<=nd;i++)
	{
	fout<<nu[i]<<"\t"<<u[i]<<"\n";
	}
fout<<"DOF#\tApplied Load\n";
for(i=1;i<=nl;i++)
	{
	fout<<ild[i]<<"\t"<<al[i]<<"\n";
	}
fout<<"Node#\tX-Displacement\tY-Displacment\n";
for (i=1;i<=nn;i++)
	{
	fout<<i<<"\t"<<f[2*i-1]<<"\t"<<f[2*i]<<"\n";
	}
fout<<"Element#\tStress\n";
for (i=1;i<=ne;i++)
	{
	fout<<i<<"\t"<<stressp[i]<<"\n";
	}
fout<<"\nDOF#\tReaction\n";
for (i=1;i<=nd;i++)
	{
	 fout<<nu[i]<<"\t"<<react[i]<<"\n";
	 }
fout<<"\nProgram end...\n";
fout.close();
cout<<"\nProgram end...\n";
}

