// ME420 VOL14: INV.CPP //
// MATRIX INVERSION IN THE C++ LANGUAGE. THIS IS A WINDOWS BASED PROGRAM
// TO HANDLE UP TO A 15 X 15 MATRIX, USING GAUSS JORDAN ELIMINATION
// METHOD. THE ROWS ARE REARRANGED IN EACH PASS TO USE THE MAXIMUM
// AVAILABLE PIVOTTHE DETERMINANT IS ALSO CALCULATED.  IF DET =0, THE
// CALCULATION IS TERMINATED AND A DIAGNOSTIC STATEMENT IS PRINTED
// PROGRAM VARIABLES:
// a[i][j]= MATRIX TO BE INVERTED, DESTROYED ONCE USED.
// ainv[i][j]= INVERTED MATRIX.
// ac[i][j]= STORED MATRIX FOR ERROR CHECKING.
// ipass= CURRENT ROW IN OPERATION.

#include <iostream.h>
#include <math.h>
#include <fstream.h>

const unsigned NAME_SIZE = 64;

// OUTPUT TO TEXT FILE //
void output(char* outfile, fstream& f)
{
outfile="inv.txt";
f.open(outfile,ios::out);
}

void main()
{
struct tm *systime;
time_t t;
t=time(NULL);
systime=localtime(&t);

int d,i,j,n,ipass,imx,icol,irow;
float a[15][15],ainv[15][15],ac[15][15],det,temp,pivot,factor;
fstream fout;
char outfile[NAME_SIZE+1];
// INITIALIZATION //
det=1;
cout<<"==================================\n";
cout<<"Matrix inversion in the C language\n";
cout<<"Programming by John Stearns 7/6/97\n";
cout<<"             Version 3.0\n";
cout<<"==================================\n";
cout<<"\nNumber of rows?\n";
cin>>n;
for (i=1;i<=n;i++)
	{
	for(j=1;j<=n;j++)
		{
		cout<<"Input value for row["<<i<<"] , column["<<j<<"]\n";
		cin>>a[i][j];
		ac[i][j]=a[i][j];
		}
	 }
// INITIALLY STORE THE IDENTITY MATRIX IN AINV AFTER THE LAST PASS THIS
// WILL BE REPLACED BY THE INVERSE OF A
for (i=1;i<=n;i++)
	{
	for(j=1;j<=n;j++)
		{
		ainv[i][j]=0;
		if(i==j) ainv[i][i]=1;
		}
	 }
// COMPUTATION //
// THE CURRENT PIVOT ROW IS IPASS, FOR EACH PASS, FIRST FIND THE MAXIMUM
// ELEMENT IN THE PIVOT COLUMN
for (ipass=1;ipass<=n;ipass++)
	{
	imx=ipass;
	for(irow=ipass;irow<=n;irow++)
		{
		if (fabs(a[irow][ipass])>fabs(a[imx][ipass])) imx=irow;
		}
// INTERCHANGE THE ELEMENTS OF ROW IPASS AND ROW IMX IN BOTH A AND AINV
	if(imx!=ipass)
	{
	for(icol=1;icol<=n;icol++)
		{
		temp=ainv[ipass][icol];
		ainv[ipass][icol]=ainv[imx][icol];
		ainv[imx][icol]=temp;
		if(icol >= ipass)
		{
		temp=a[ipass][icol];
		a[ipass][icol]=a[imx][icol];
		a[imx][icol]=temp;
		}
		}
	}
// THE CURRENT PIVOT IS NOW A[IPASS][IPASS]  //
// THE DETRMINANT IS THE PRODUCT OF THE PIVOT ELEMENTS

pivot=a[ipass][ipass];
cout<<"\nPivot = "<<a[ipass][ipass]<<"\n";
det=det*pivot;
if (det==0)
{
cout<<"Error in MINV -- The matrix is singular\n";
goto stop;
}
for(icol=1;icol<=n;icol++)
	{
	//NORMALIZING PIVOT ROW BY DIVIDING ACCROSS BY
	//THE PIVOT ELEMENT//
	cout<<"Normalizing pivot row\n";
	ainv[ipass][icol]=ainv[ipass][icol]/pivot;
	if (icol>=ipass) a[ipass][icol]=a[ipass][icol]/pivot;
	}
for(irow=1;irow<=n;irow++)
// NOW REPLACE EACH ROW BY THE ROW PLUS A MULTIPLE OF THE PIVOT
// ROW WITH A FACTOR CHOSEN SO THAT THE ELEMNT OF A ON THE
// PIVOT COLUMN IS 0
	{
	if(irow!=ipass) factor=a[irow][ipass];
	for(icol=1;icol<=n;icol++)
		{
		if(irow!=ipass)
			{
			ainv[irow][icol]=ainv[irow][icol]-factor*ainv[ipass][icol];
			a[irow][icol]=a[irow][icol]-factor*a[ipass][icol];
			}
		 }
	 }
}
cout<<"The inverted matrix:\n";
for (i=1;i<=n;i++)
	{
	cout<<"\n";
	for(j=1;j<=n;j++)
		{
		cout<<ainv[i][j]<<"\t";
		}
	 }
cout<<"\n\nThe original matrix:\n";
for (i=1;i<=n;i++)
	{
	cout<<"\n";
	for(j=1;j<=n;j++)
		{
		cout<<ac[i][j]<<"\t";
		}
	 }
cout<<"Output to text file? y=1, 2=n\n";
cin>>d;
if (d==1)
{
cout<<"Filename will be inv.txt\n";
output(outfile, fout);
fout<<"==================================\n";
fout<<"Matrix inversion in the C language\n";
fout<<"Programming by John Stearns 7/6/97\n";
fout<<"        Version 3.0\n";
fout<<"==================================\n";
fout<<"Date of printing: "<<systime->tm_mon+1<<":"<<systime->tm_mday<<":"<<
systime->tm_year<<"\n";
fout<<"The inverted matrix:\n";
for (i=1;i<=n;i++)
	{
	fout<<"\n";
	for(j=1;j<=n;j++)
		{
		fout<<ainv[i][j]<<"\t";
		}
	 }
fout<<"\n\nThe original matrix:\n";
for (i=1;i<=n;i++)
	{
	fout<<"\n";
	for(j=1;j<=n;j++)
		{
		fout<<ac[i][j]<<"\t";
		}
	 }
fout.close();
}
stop:cout<<"\n\nProgram end execution..\n";
}
