#include<iostream.h>
#include<math.h>
#include<fstream.h>
#include <time.h>
// VOL14 HEAT1D.CPP C++ PROGRAM TO CALCULATE A ONE DIMENSIONAL
// HEAT CONDUCTION SCALER FIELD PROBLEM.  THE C CODE UTILIZES
// THE PENALTY APPROACH, 20 NODE LIMIT V1.0  Version 3.0
//
// PROGRAM VARIABLES
// ne=ELEMENT NUMBER
// nbc=NUMBER OF BOUNDARY CONDITIONS
// v[i]=TEMPERATURE / HEAT FLUX BC
// h[i]=FILM COEFFICIENT FOR CONVECTION
// ell=ELEMENT LENGTH
// ekl=CONDUCTIVITY/ELEMENT LENGTH
// nbw=2 HALF THE BANDWIDTH
void output(char* outfile, fstream &f)
{
outfile="hot.txt";
f.open(outfile,ios::out);
}
void main()
{
struct tm *systime;
time_t t;
t=time(NULL);
systime=localtime(&t);

int ne,nbc,nq,nn,i,i1,i2,bc[5],nbw,n,j,k,nbk,j1,j2,ii,nbi;
float x[20],d[20][3],tc[20],f[20],v[5],h[5],nb[5],s[15][3]
,ell,ekl,amax,cnst,sum,c;
fstream fout;
char outfile[12];

cout<<"============================================\n\n";
cout<<"        Scaler Field Problems \n";
cout<<"      with Finite Element Analysis\n\n";
cout<<"Programming in Turbo C++, by John C Stearns\n\n";
cout<<"               Version 3.1\n";
cout<<"============================================\n\n";
cout<<"Enter data seperated by a space, ";
cout<<"data in exponential form i.e. 30e6 is accepted\n\n";
cout<<"Number of elements = ";
cin>>ne;
cout<<"\nNumber of boundary conditions = ";
cin>>nbc;
cout<<"\nNumber of nodes with heat source = ";
cin>>nq;
nn=ne+1;
nbw=2;
cout<<"Input the Thermal conductivity for each element\n";
for (i=1;i<=ne;i++)
	{
	cout<<"Element# "<<i<<" \n";
	cin>>tc[i];
	}
cout<<"Input coordinate for nodes\n";
for (i=1;i<=nn;i++)
	{
	cout<<"Node# "<<i<<" \n";
	cin>>x[i];
	}
cout<<"Give Boundary condition (BC) data **\n";
for (i=1;i<=nbc;i++)
	{
	cout<<"Input node number\n";
	cin>>nb[i];
	cout<<"BC type:Type 1 for applied temperature\n";
	cout<<"        Type 2 for imparting heat\n";
	cout<<"        Type 3 for convection\n";
	cin>>bc[i];
	if(bc[i]==1)
		{
		cout<<"T0 =\n";
		cin>>v[i];
		}
	if(bc[i]==2)
		{
		cout<<"Q0 =\n";
		cin>>v[i];
		}
	if(bc[i]==3)
		{
		cout<<"H Tinf =\n";
		cin>>h[i]>>v[i];
		}
	}
// CALCULATE AND INPUT NODAL HEAT SOURCE VECTOR//
for (i=1;i<=nn;i++)
	{
	f[i]=0;
	}
if (nq==0) goto noheat;
for (i=1;i<=nq;i++)
	{
	cout<<"The flag for a nodal heat sources has been detected\n";
	cout<<"Input node number\n";
	cin>>n;
	cout<<"Input corresponding heat value\n";
	cin>>f[n];
	}
noheat:for (j=1;j<=nbw;j++)
	{
	for(i=1;i<=nn;i++)
		{
		s[i][j]=0;
		}
	}
//STIFFNESS MATRIX//
for(i=1;i<=ne;i++)
	{
	i1=i;
	i2=i+1;
	ell=fabs(x[i2]-x[i1]);
	ekl=tc[i]/ell;
	s[i1][1]=s[i1][1]+ekl;
	s[i2][1]=s[i2][1]+ekl;
	s[i1][2]=s[i1][2]-ekl;
	}
//ACCOUNT FOR BOUNDARY CONDITIONS //
amax=0;
for (i=1;i<=nn;i++)
	{
	if(s[i][1]>amax) amax=s[i][1];
	}
cnst=amax*10000;
for(i=1;i<=nbc;i++)
	{
	n=nb[i];
	if(bc[i]==3) goto conv;
	if(bc[i]==2) goto hflux;
	s[n][1]=s[n][1]+cnst;
	f[n]=f[n]+cnst*v[i];
	goto skip;
	conv: s[n][1]=s[n][1]+h[i];
	f[n]=f[n]+h[i]*v[i];
	goto skip;
	hflux: f[n]=f[n]-v[i];
   skip:}
// EQUATION SOLVING FOR A BANDED SYMMETRIC STIFFNESS MATRIX //
n=nn;
cout<<"Forward elimination";
for (k=1;k<=n-1;k++)
	{
	cout<<".";
	nbk=n-k+1;
	if (nbk>nbw) nbk=nbw;
	for (i=k+1;i<=nbk+k-1;i++)
		{
		i1=i-k+1;
		c=s[k][i1]/s[k][1];
		for (j=i;j<=nbk+k-1;j++)
			{
			j1=j-i+1;
			j2=j-k+1;
			s[i][j1]=s[i][j1]-c*s[k][j2];
			}
		f[i]=f[i]-c*f[k];
		}
	}
		cout<<"\nBack Substitution\n";
// BACK SUBSTITUTION //
f[n]=f[n]/s[n][1];
for (ii=1;ii<=n-1;ii++)
	{
	i=n-ii;
	nbi=n-i+1;
	if (nbi>nbw) nbi=nbw;
	sum=0;
	for(j=2;j<=nbi;j++)
		{
		sum=sum+s[i][j]*f[i+j-1];
		}
	f[i]=(f[i]-sum)/s[i][1];
	}
cout.precision(3);
output(outfile, fout);
cout<<"\n\nScaler field problem: Heat transfer\n";
cout<<"Turbo C++ Version 3.1\n";
cout<<"4600:420 Introduction to Finite Element Method\n";
cout<<"\nThe nodal temperatures are:\n\n";
cout<<"Node#\tTemperature\n";
fout<<"\n\nScaler field problem: Heat transfer\n";
fout<<"Turbo C++ Version 3.1\n";
fout<<"4600:420 Introduction to Finite Element Method\n";
fout<<"Date of printing: "<<systime->tm_mon+1<<":"<<systime->tm_mday<<":"<<
systime->tm_year+1900<<"\n";
fout<<"\nThe nodal temperatures are:\n\n";
fout<<"Node#\tTemperature\n";
for(i=1;i<=n;i++)
	{
	cout<<i<<"\t"<<f[i]<<"\n";
	fout<<i<<"\t"<<f[i]<<"\n";
	}

fout<<"Thermal conductivity for each element\n";
for (i=1;i<=ne;i++)
	{
	fout<<"Element# "<<i<<" = "<<tc[i]<<"\n";
	}
fout<<"Coordinates for nodes\n";
for (i=1;i<=nn;i++)
	{
	fout<<"Node# "<<i<<" ="<<x[i]<<"\n";
	}
fout<<"\nInput values:\n";
for (i=1;i<=nq;i++)
{
fout<<"Heat source magnitude #"<<i<<"= "<<f[i]<<"\n";
}
for (i=1;i<=nbc;i++)
{
if (bc[i]==1) fout<<"BC is applied nodal temperature to node "<<nb[i]<<"= "<<v[i]<<"\n";
if (bc[i]==2) fout<<"BC is imparting heat to node "<<nb[i]<<"= "<<v[i]<<"\n";
if (bc[i]==3)
	{
	fout<<"BC is applied convection to node "<<nb[i]<<"\n";
	fout<<"Film Coeff. H = "<<h[i]<<" At temperature of "<<v[i]<<"\n";
	}
}
cout<<"Input values:\n";
for (i=1;i<nq;i++)
{
cout<<"Heat source magnitude #"<<i<<"= "<<f[i]<<"\n";
}
for (i=1;i<nbc;i++)
{
if (bc[i]==1) cout<<"BC is applied nodal temperature to node "<<nb[i]<<"= "<<v[i]<<"\n";
if (bc[i]==2) cout<<"BC is imparting heat to node "<<nb[i]<<"= "<<v[i]<<"\n";
if (bc[i]==3)
	{
	cout<<"BC is applied convection to node "<<nb[i]<<"\n";
	cout<<"Film Coeff. H = "<<h[i]<<" At temperature of "<<v[i]<<"\n";
	}
}
cout<<"Results are now written to text file HOT.txt\nProgram end..";
fout.close();
fout<<"\nProgram end..";

}
