// VOL16\BEAMER.CPP C++ PROGRAM TO CALCULATE A ONE DIMENSIONAL
// BEAM PROBLEM.  INTERACTIVE INPUT.  MEMORY IS ALLOCATED
// DYNAMICALLY  5/2/00 JOHN C. STEARNS ver 3.15

#include <iostream.h>
#include <math.h>
#include <alloc.h>
#include <fstream.h>
#include <time.h>
void output(char* outfile, fstream &f)
{
outfile="beam.txt";
f.open(outfile, ios::out);
}
void main()
{
	struct tm *systime;
	time_t t;
	t=time(NULL);
	systime=localtime(&t);

   clock_t first, second;
   int n,nq,i,j,k,m,i1,i2,ii,nrt,it,nr,jj,nct,jt,nc,n1,nk;
   int ne,nn,nm,nd,nl,nen,ndn,ndim,npr,nbw,nmpc,j1,kk;
   int *noc, *nu, *mat, *mpc;
   float *x, *smi, *pm, *u, *s, *f, *beta, se[4][4];
   float c, el, eil, cnst, reaction,c1,length;
   char outfile[12];
   fstream fout;
   cout<<"=========================================\n\n";
   cout<<"\tBEAMER\n";
   cout<<"One dimensional beam problem, ie. bending\n";
   cout<<"Programming in Turbo C++ by John Stearns\n";
   cout<<"=========================================\n";
   cout<<"Enter data seperated by a space, \n";
   cout<<"data in exponential form, i.e. 30e6 is accepted\n\n";
   cout<<"Number of elements?\n";
   cin>>ne;
   cout<<"Number of nodes?\n";
   cin>>nn;
   cout<<"Number of constrained DOF?\n";
   cin>>nd;
   cout<<"Number of component loads?\n";
   cin>>nl;
   cout<<"Number of materials?\n";
   cin>>nm;
   cout<<"Number of degrees of freedom per node\n";
   cout<<" x-trans, y-trans, rotation =3\n";
   cout<<" y-trans, rot =2 (classic beam example) = 2\n";
   cin>>ndn;
   ndn=2;
   npr=1;
   cout<<"Number of multipoint constraints?\n";
   cout<<"If not sure, use 0\n";
   cin>>nmpc;
   ndim=1;
   nen=2;
   /* ----- total dof is nq ----- */
   nq = ndn*nn;
/* ----- memory allocation ----- */
   x = (float *) calloc(nn*ndim, sizeof(float));
   noc = (int *) calloc(ne*nen, sizeof(int));
   u = (float *) calloc(nd, sizeof(float));
   nu = (int *) calloc(nd, sizeof(int));
   mat = (int *) calloc(ne,sizeof(int));
   smi = (float *) calloc(ne, sizeof(float));
   f = (float *) calloc(nn*ndn, sizeof(float));
   pm = (float *) calloc(nm*npr, sizeof(float));
   mpc = (int *) calloc(2*nmpc, sizeof(int));
   beta = (float *) calloc(3*nmpc, sizeof(float));
fout.precision(5);
fout.width(15);
/*DATA INPUT*/
   cout<<"Coordinate input\n";
   for (i=0;i<nn;i++)
	{
	cout<<"Node #"<<i+1<<"\n";
	cin>>c;
	x[i]=c;
	length=c;
	}

   for (i = 0; i < ne; i++) {
      cout<<"Input element number\n";
      cin>>n;
      for (j = 0; j < nen; j++) {
	 cout<<"Input global node number for element "<<n<<"\n";
	 cin>>k;
	 noc[(n-1)*nen+j]=k;
      }
	 cout<<"Input Material number for element "<<n<<"\n";
	 cin>>k;
	 mat[n-1] = k;
	 cout<<"Input Moment of inertia for element "<<n<<"\n";
	 cin>>c;
	 smi[n-1] = c;
   }
/* ----- boundary conditions ----- */
   for (i = 0; i < nd; i++) {
      cout<<"Input DOF#  (seperated by space then) Displacement\n";
      cin>>k>>c;
      nu[i] = k;
      u[i] = c;
   }
/* ----- component loads ----- */
   for (i = 0; i < nl; i++) {
      cout<<"Input DOf# (seperated by space then) Load\n";
      cin>>k>>c;
      f[k-1] = c;
   }
/* ----- material properties ----- */
   for (i = 0; i < nm; i++){
      cout<<"Enter Material Property Number\n";
      cin>>k;
      for (j = 0; j < npr; j++) {
	 cout<<"Enter Youngs Modulus\n";
	 cin>>c;
	 pm[(k-1)*npr+j] = c;
      }
   }
/* ----- multipoint constraints ----- */
   if (nmpc > 0)
	{
	cout<<"Enter multipoint constraints\n";
	for(j=0;j<nmpc;j++){
	   cout<<"Enter Beta 1\n";
	   cin>>c;
	   beta[3*j]=c;
	   cout<<"Enter Qi\n";
	   cin>>k;
	   mpc[2*j]=k;
	   cout<<"Enter Beta 2\n";
	   cin>>c;
	   beta[3*j+1]=c;
	   cout<<"Enter Qj \n";
	   cin>>k;
	   mpc[2*j+1]=k;
	   cout<<"Enter Beta 3\n";
	   cin>>c;
	   beta[3*j+2]=c;
	   }
	}
/* ----- Start process clock ------ */
first=clock();
/* ----- bandwidth evaluation ----- */
   nbw = 0;
   for (i = 0; i < ne; i++) {
      n = ndn * (abs(noc[nen*i] - noc[nen*i+1])+1);
      if (nbw < n)
	 nbw = n;
   }
   for (i = 0; i < nmpc; i++) {
      n = abs(mpc[2*i] - mpc[2*i+1])+1;
      if (nbw < n)
	 nbw = n;
   }
   cout<<"\n\n====================\n";
   cout<<"bandwidth = "<<nbw<<"\n";
/* ----- allocate memory for stiffness ----- */
   s = (float *) calloc(nq*nbw, sizeof(float));
/* ----- assemble the stiffness matrix ----- */
   for (n = 0; n < ne; n++) {
      cout<<"forming stiffness matrix of element... "<<n+1<<"\n";
	 i1 = noc[nen*n];
	 i2 = noc[nen*n+1];
	 m = mat[n];
	 el = fabs(x[i1-1] - x[i2-1]);
	 eil = pm[m-1]* smi[n] / (el*el*el);
	 se[0][0] = 12 * eil;
	 se[0][1] = eil * 6 * el;
	 se[0][2] = -12 * eil;
	 se[0][3] = eil * 6 * el;
	    se[1][0] = se[0][1];
	    se[1][1] = eil * 4 * el * el;
	    se[1][2] = -eil * 6 * el;
	    se[1][3] = eil * 2 * el * el;
	 se[2][0] = se[0][2];
	 se[2][1] = se[1][2];
	 se[2][2] = eil * 12;
	 se[2][3] = -eil * 6 * el;
	    se[3][0] = se[0][3];
	    se[3][1] = se[1][3];
	    se[3][2] = se[2][3];
	    se[3][3] = eil * 4 * el * el;
	cout<<".... placing in global locations\n";
	for (ii = 0; ii < nen; ii++) {
	   nrt = ndn * (noc[nen*n + ii] - 1);
	   for (it = 0; it < ndn; it++) {
	      nr = nrt + it;
	      i = ndn * ii + it;
	      for (jj = 0; jj < nen; jj++) {
		 nct = ndn * (noc[nen*n+jj] - 1);
		 for (jt = 0; jt < ndn; jt++) {
		    j = ndn * jj + jt;
		    nc = nct + jt - nr;
		    if (nc >= 0)
		       s[nbw*nr+nc] = s[nbw*nr+nc] + se[i][j];
		    }
		  }
	     }
	  }
   }
/* ----- decide penalty parameter cnst ----- */
   cnst = 0;
   for (i = 0;i < nq; i++){
       if (cnst < s[i*nbw])
	  cnst = s[i*nbw];
       }
   cnst = 10000 * cnst;
/* ----- modify for displacement boundary conditions ----- */
   for (i = 0; i < nd; i++) {
      k = nu[i];
      s[(k-1)*nbw] = s[(k-1)*nbw] + cnst;
      f[k-1] = f[k-1] + cnst * u[i];
   }
/* ----- modify for multipoint constraints ----- */
   for (i = 0; i < nmpc; i++){
       i1 = mpc[2*i];
       i2 = mpc[2*i+1];
       s[(i1-1)*nbw] = s[(i1-1)*nbw] + cnst*beta[3*i]*beta[3*i];
       s[(i2-1)*nbw] = s[(i2-1)*nbw] + cnst*beta[3*i+1]*beta[3*i+1];
       n=i1;
       if (n > i2)
	  n = i2;
       m = abs(i2-i1);
       s[(n-1)*nbw+m] = s[(n-1)*nbw+m]+cnst*beta[3*i]*beta[3*i+1];
       f[i1-1] = f[i1-1] + cnst*beta[3*i]*beta[3*i+2];
       f[i2-1] = f[i2-1] + cnst*beta[3*i+1]*beta[3*i+2];
       }

/* solver */
 n1 = nq - 1;
  /* --- forward elimination --- */
  for (k = 1; k <= n1; k++) {
     nk = nq - k + 1;
     if (nk > nbw)
	nk = nbw;
     for (i = 2; i <= nk; i++) {
       c1 = s[nbw*(k-1)+i-1] / s[nbw*(k-1)];
       i1 = k + i - 1;
       for (j = i; j <= nk; j++) {
	j1 = j - i + 1;
	s[nbw*(i1-1)+j1-1] = s[nbw*(i1-1)+j1-1] - c1 * s[nbw*(k-1)+j-1];
	}
       f[i1-1] = f[i1-1] - c1 * f[k-1];
       }
     }
  /* --- back-substitution --- */
  f[nq-1] = f[nq-1] / s[nbw*(nq-1)];
  for (kk = 1; kk <= n1;kk++) {
     k = nq - kk;
     c1 = 1 / s[nbw*(k-1)];
     f[k-1] = c1 * f[k-1];
     nk = nq - k + 1;
     if (nk > nbw)
       nk = nbw;
       for (j = 2; j <= nk; j++) {
	 f[k-1] = f[k-1] - c1 * s[nbw*(k-1)+j-1] * f[k + j - 2];
	}
     }
/* ----- printing displacements ----- */
   cout<<"node#\tdispl.\trotation (degrees)\n";
   for (i = 0; i < nn; i++) {
      cout<<i+1<<"\t"<<f[2*i]<<"\t"<<f[2*i+1]*57.3<<"\n";
   }
/* ----- reaction calculation ----- */
   cout<<"DOF#   reaction\n";
   for (i = 0; i < nd; i++) {
      k = nu[i];
      reaction = cnst * (u[i] - f[k-1]);
      cout<< k<<"\t"<< reaction<<"\n";
   }
/* -----output to file called 'beam.txt -----*/
output(outfile,fout);
fout<<"\n\nOne dimensional Beam Problem\n";
fout<<"Turbo C++ version 3.15\n";
fout<<"4600:420 Introduction to the finite Element Method\n";
fout<<"Date of printing: "<<systime->tm_mon+1<<":"<<systime->tm_mday<<":"<<
systime->tm_year+1900<<"\n";
fout<<"NE\tNN\tND\tNM\tNL\tNMPC\n";
fout<<ne<<"\t"<<nn<<"\t"<<nd<<"\t"<<nm<<"\t"<<nl<<"\t"<<nmpc<<"\n";
fout<<"Total beam length = "<<length<<"\n";
for (i=0;i<nm;i++)
	{
	fout<<"Property "<<i<<" Young's Modulus "<<pm[i]<<"\n";
	}
   cout<<"\n";
   fout<<"node#   displacement     rotation (degrees)\n";
   for (i = 0; i < nn; i++) {
      fout<<i+1<<"\t"<<f[2*i]<<"\t"<<f[2*i+1]*57.3<<"\n";
   }
/* ----- reaction calculation ----- */
   fout<<"DOF#   reaction\n";
   for (i = 0; i < nd; i++) {
      k = nu[i];
      reaction = cnst * (u[i] - f[k-1]);
      fout<< k<<"\t"<< reaction<<"\n";
   }
fout.close();
/* ----- Stop process clock ------ */
second=clock();
cout<<"\nEnd processing..Execution time = "<<(second-first)/CLK_TCK<<" Seconds";
}