
#include <iostream.h>
#include <math.h>
#include <stdio.h>
#include <fstream.h>
#include <time.h>
// VOL12/ONED.CPP C++ PROGRAM TO CALCULATE A ONE DIMENSIONAL
// FINITED ELEMENT PROBLEM WITH TEMPERATURE BASED ON THE
// PENALTY APPROACH.  6/1/00 JOHN STEARNS VER 3.15
//
// PROGRAM VARIABLES
//
// s[][]= ELEMENT STIFFNESS MATRIX
// ne=ELEMENT NUMBER
// nl=LOAD NUMBER
// nd=DISPLACEMENT NUMBER
// a[]= ELEMENT AREA
// alp[]= ELEMENT COEFFICEINT OF THERMAL EXPANSION
// dt[]= NODAL TEMPERATURE DIFFERENCE
// r= REACTION
// stress[]= STRESS VECTOR
// eal= EA/LENGTH (STIFFNESS)
// el= ELEMENT LENGTH
// x21= ELEMENT COORDIDANE DIFFERENCE
// tl= ENERGY DUE TO DELTA T
// f[]= APPLIED LOAD AT NODE
// u[]= PRESCRIBED DISPLACEMENT AT NODE.
// cnst= STIFFNESS VALUE AT [1][1]*10000: PENALTY APPROACH
// nbw= BANDWIDTH = 2
void output(char* outfile, fstream& f)
{
outfile="oned.txt";
f.open(outfile, ios::out);
}
void main()
{
struct tm *systime;
time_t t;
t=time(NULL);
systime=localtime(&t);
int ne,nl,nd,nn,nbw,i,n,i1,i2,k,nbk,ii,j,nu[10],j1,j2,nbi,ll;
float x[50],a[50],c,u[10],dt[50],s[51][2],f[50],load[10],outf[10],
e[50],alp[50],stress[50],react[10],x21,eal,eps,r,tl,el,sum,cnst;
fstream fout;
char outfile[12];
cout <<"============================================\n\n";
cout <<"                ONED\n";
cout <<"One dimensional Finite Element Analysis\n";
cout <<"      with Temperature effects\n\n";
cout <<"Programming in Turbo C++, by John C Stearns\n\n";
cout <<"                Ver 3.15\n";
cout <<"============================================\n\n";
cout <<"Enter data seperated by a space,";
cout <<"data in exponential form i.e. 30e6 is accepted\n\n";
cout <<"Number of elements?\n";
cin >>ne;
cout <<"Number of loads?\n";
cin >>nl;
cout <<"Number of known displacements?\n";
cin >>nd;
nn=ne+1;
nbw=2;
cout <<"Enter the following data on one line seperated by spaces\n";
cout <<"Use 0 for non thermal problem\n";
cout <<"Area\tE\tAlpha\tTemp rise\n";
 for (i=1;i<=ne;i++)
	{
	cout<<"\nElement #"<<i<<"\n";
	cin >>a[i]>>e[i]>>alp[i]>>dt[i];
	}
cout <<"Coordinate input\n";
for (i=1;i<=nn;i++)
	{
	cout<<"Node # "<<i<<" ";
	cin >>x[i];
	}
for (i=1;i<=25;i++)
	{
	f[i]=0;
	for (j=1;i<=25;i++)
		{
		s[i][j]=0;
		}
	}
cout <<"Input Node # Displacement\n";
for (i=1;i<=nd;i++)
	{
	cin >>nu[i]>>u[i];
	}

if (nl==0) goto stiff;
cout <<"Enter known loads\n";
for (i=1;i<=nl;i++)
	{
	cout<<"Node # ";
	cin >>ll;
	load[i]=ll;
	cout<<"Applied load ";
	cin >>f[ll];
	outf[i]=f[ll];
	}

stiff: //STIFFNESS MATRIX//
for (i=1;i<=ne;i++)
	{
	i1=i;
	i2=i+1;
	x21=x[i2]-x[i1];
	el=fabs(x21);
	eal=e[i]*a[i]/el;
	tl=e[i]*alp[i]*dt[i]*a[i]*el/x21;
	//TEMPERATURE NODES//
	f[i1]=f[i1]-tl;
	f[i2]=f[i2]+tl;
	//ELEMENT STIFFNESS CREATES ONE HALF OF A SYMMTERIC MATRIX //
	s[i1][1]=s[i1][1]+eal;
	s[i2][1]=s[i2][1]+eal;
	s[i1][2]=s[i1][2]-eal;

	}
// MODIFY FOR BOUNDARY CONDITIONS USING PENALTY APPROACH//

cnst=s[1][1]*10000;
for (i=1;i<=nd;i++)
	{
	n=nu[i];
	s[n][1]=s[n][1]+cnst;
	f[n]=f[n]+cnst*u[i];
	}
// EQUATION SOLVING FOR A BANDED SYMMETRIC STIFFNESS MATRIX //
n=nn;
cout<<"Forward elimination";
for (k=1;k<=n-1;k++)
	{
	cout<<".";
	nbk=n-k+1;
	if (nbk>nbw) nbk=nbw;
	for (i=k+1;i<=nbk+k-1;i++)
		{
		i1=i-k+1;
		c=s[k][i1]/s[k][1];
		for (j=i;j<=nbk+k-1;j++)
			{
			j1=j-i+1;
			j2=j-k+1;
			s[i][j1]=s[i][j1]-c*s[k][j2];
			}
		f[i]=f[i]-c*f[k];
		}
	}
		cout<<"\nBack Substitution\n";
// BACK SUBSTITUTION //
f[n]=f[n]/s[n][1];
for (ii=1;ii<=n-1;ii++)
	{
	i=n-ii;
	nbi=n-i+1;
	if (nbi>nbw) nbi=nbw;
	sum=0;
	for(j=2;j<=nbi;j++)
		{
		sum=sum+s[i][j]*f[i+j-1];
		}
	f[i]=(f[i]-sum)/s[i][1];
	}
// END SUBROUTINE //
cout.precision(5);
cout<<"Output to text file called oned.txt\n";
cout<<"Is now being created\n";
output(outfile, fout);
fout <<"============================================\n\n";
fout <<"                ONED\n";
fout <<"One dimensional Finite Element Analysis\n";
fout <<"      with Temperature effects\n\n";
fout <<"Programming in Turbo C++, by John C Stearns\n\n";
fout <<"               Version 3.15\n";
fout<<"Date of printing: "<<systime->tm_mon+1<<":"<<systime->tm_mday<<":"<<
systime->tm_year+1900<<"\n";
fout <<"============================================\n\n";
fout <<"Number of nodes, elements, loads, displacements\n";
fout <<nn<<"\t\t"<<ne<<"\t"<<nl<<"\t"<<nd<<"\n";
fout <<"Nodal data\n";
for (i=1;i<=nn;i++)
	{
	fout<<"Node # "<<i<<" x coordinate = "<<x[i]<<"\n";
	}
fout <<"Element data\n";
fout <<"Element #\tArea\tE\tAlpha\tTemperature rise\n";
 for (i=1;i<=ne;i++)
	{
	fout <<i<<"\t\t"<<a[i]<<"\t"<<e[i]<<"\t"<<alp[i]<<"\t"<<dt[i]<<"\n";
	}
cout <<"\nResults....\n\n";
fout <<"\nResults....\n\n";
cout <<"Node #\tDisplacement\n";
fout <<"Node #\tDisplacement\n";
for (i=1;i<=nn;i++)
	{
	fout <<i<<"\t"<<f[i]<<"\n";
	cout <<i<<"\t"<<f[i]<<"\n";
	}
// STRESS CALCULATION //
cout <<"Element #\tStress\n";
fout <<"Element #\tStress\n";
for (i=1;i<=ne;i++)
	{
	eps=(f[i+1]-f[i])/(x[i+1]-x[i]);
	stress[i]=e[i]*(eps-alp[i]*dt[i]);
	cout <<i<<"\t\t"<<stress[i]<<"\n";
	fout <<i<<"\t\t"<<stress[i]<<"\n";
	}
// REACTION CALCULATION //
cout <<"Node #\tReaction\n";
fout <<"Node #\tReaction\n";
for (i=1;i<=nd;i++)
	{
	n=nu[i];
	r=cnst*(u[i]-f[n]);
	react[i]=r;
	cout <<n<<"\t"<<r<<"\n";
	fout <<n<<"\t"<<r<<"\n";
	}
// LOAD OUTPUT //
cout <<"Node #\tForce\n";
fout <<"Node #\tForce\n";
for (i=1;i<=nl;i++)
	{
	cout<<load[i]<<"\t"<<outf[i]<<"\n";
	fout<<load[i]<<"\t"<<outf[i]<<"\n";
	}
fout.close();
cout<<"End execution.....";

}
