
{    BAMIGAME v.0.1, a silly game..                                         }
{    Copyright (C) 2002 Royi "Uncle Ro" Eltink <unclero@ranmamail.com>      }
{                                                                           }
{    This program is free software; you can redistribute it and/or modify   }
{    it under the terms of the GNU General Public License as published by   }
{    the Free Software Foundation; either version 2 of the License, or      }
{    (at your option) any later version.                                    }
{                                                                           }
{    This program is distributed in the hope that it will be useful,        }
{    but WITHOUT ANY WARRANTY; without even the implied warranty of         }
{    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          }
{    GNU General Public License for more details.                           }
{                                                                           }
{    You should have received a copy of the GNU General Public License      }
{    along with this program; if not, write to the Free Software            }
{    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA }
{                                                                           }
{    The game can be found at: http://www.angelfire.com/ne/Eltink/software  }
{    SEE README.TXT FOR DETAILS..                                           }

{ Level 1.. }

procedure LEVEL1;
var
  ch: char;
begin
    A3D_init;
    
    if A3D_loadMAP('DATA\LEVEL1.DAT') <> 0 then
    begin
        A3D_close;
        StopThaMusic;
        writeln('BAMIGAME: AFWAS3D: Couldnt find MAP-file (DATA\LEVEL1.DAT)..');
        halt;
    end;
    if A3D_loadGFX('GFX\PCXFLOOR.PCX','GFX\PCXWALL.PCX','GFX\PCXCEIL.PCX') then
    begin
        if XKeyEnabled then XKey_init;
        
        A3D_setShade;
        A3D_drawMAP;
        
        A3D_FIRST := A3D_TIMER;
        A3D_FRAMES := 0;
        A3D_FPSEC := 15;
        ch := #0;
        
        repeat
            
            if not XKeyEnabled then
            begin
                if KeyPressed then ch := ReadKey;
            end;
            PlayThaMusic;
            
            if XKEY[XKEY_LEFT] or ((ch = KEY_LEFT) and not XKeyEnabled) then
            begin
                ch := #0;
                if A3D_turn < 1 then A3D_turn := 1
                else if A3D_turn < 8 then A3D_turn := A3D_turn * 2;
            end
            else if XKEY[XKEY_RIGHT] or ((ch = KEY_RIGHT) and not XKeyEnabled) then
            begin
                ch := #0;
                if A3D_turn > -1 then A3D_turn := -1
                else if A3D_turn > -8 then A3D_turn := A3D_turn * 2;
            end
            else
            begin
                A3D_turn := A3D_turn * 0.6;
            end;

            if XKEY[XKEY_DOWN] or ((ch = KEY_DOWN) and not XKeyEnabled) then
            begin
                ch := #0;
                if A3D_step > -0.1 then A3D_step := -0.1
                else if A3D_step > -0.25 then A3D_step := A3D_step * 1.1;
            end
            else if XKEY[XKEY_UP] or ((ch = KEY_UP) and not XKeyEnabled) then
            begin
                ch := #0;
                if A3D_step < 0.1 then A3D_step := 0.1
                else if A3D_step < 0.25 then A3D_step := A3D_step * 1.1;
            end
            else
            begin
                A3D_step := A3D_step * 0.8;
            end;
            
            A3D_renderScreen;
            
        until XKEY[XKEY_ESCAPE] or ((ch = KEY_ESCAPE) and not XKeyEnabled);
        A3D_close;
        
        if XKeyEnabled then XKey_restore;
        
        writeln('BAMIGAME: End of Level 1..');
        writeln('BAMIGAME: AFWAS3D: Renderspeed: ',A3D_FPSEC,' frames/second');
        writeln('BAMIGAME: AFWAS3D: Stops...');
        writeln('BAMIGAME: Poking AFWAS2D engine..');
        writeln('BAMIGAME: AFWAS2D: Up and running..');
    end
    else
    begin
        A3D_close;
        StopThaMusic;
        writeln('BAMIGAME: AFWAS3D: Errors at the graphics..');
        halt;
    end;
end;