{    NewCrt, Win98/2K compatible replacement for Borland's Crt unit..       }
{    Copyright (C) 2002 Royi "Uncle Ro" Eltink <unclero@ranmamail.com>      }
{                                                                           }
{    This program is free software; you can redistribute it and/or modify   }
{    it under the terms of the GNU General Public License as published by   }
{    the Free Software Foundation; either version 2 of the License, or      }
{    (at your option) any later version.                                    }
{                                                                           }
{    This program is distributed in the hope that it will be useful,        }
{    but WITHOUT ANY WARRANTY; without even the implied warranty of         }
{    MERchANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          }
{    GNU General Public License for more details.                           }
{                                                                           }
{    You should have received a copy of the GNU General Public License      }
{    along with this program; if not, write to the Free Software            }
{    Foundation, Inc, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA }
{                                                                           }
{    This unit can be found at: http://www.angelfire.com/ne/Eltink/software }
{    And oh, before I forget, of course this is not fully complete... but   }
{    hey, most of it, you will not use, except for the cases you can        }
{    actually add some stuff to this.. I truly look forward to your         }
{    contributions... - Ro'                                                 }
{    Thanks for all those online ppl who let me drag all these from their   }
{    code.. your code will not be in vain... ^___^                          }

{ 10-july 2002: Well, fixed something in the KeyPressed and ReadKey code..
                Someone, tought, that reading the keyboard is great without
		poking int16. I hope, my fix will work on Win2K... - Ro'    }
{ 12-july 2002: Well, I added some code from the SmallCrt.pas thing..
		Thanks for the tip from someone on http://gathering.tweakers.net
		And I hope to find something to color text and textbg soon.. - Ro' }

unit NewCrt;

{$D-,I-,S-}

interface

const

{ CRT modes }

    BW40        = 0;            { 40x25 B/W on Color Adapter }
    CO40        = 1;            { 40x25 Color on Color Adapter }
    BW80        = 2;            { 80x25 B/W on Color Adapter }
    CO80        = 3;            { 80x25 Color on Color Adapter }
    Mono        = 7;            { 80x25 on Monochrome Adapter }
    Font8x8     = 256;          { Add-in for ROM font }

{ Mode constants for 3.0 compatibility }

    C40         = CO40;
    C80         = CO80;

{ Foreground and background color constants }

    black       = 0;
    blue        = 1;
    Green       = 2;
    Cyan        = 3;
    Red         = 4;
    Magenta     = 5;
    Brown       = 6;
    LightGray   = 7;

{ Foreground color constants }

    DarkGray        = 8;
    Lightblue       = 9;
    LightGreen      = 10;
    LightCyan       = 11;
    LightRed        = 12;
    LightMagenta    = 13;
    Yellow          = 14;
    White           = 15;

{ Add-in for blinking }

    blink       = 128;

var
    LastMode: word;            { text mode of CRT }
    TextAttr: byte;            { text and background colour }
    WindMin: word;
    WindMax: word;    { window position }
    { timing blah.}
    TicksPerMs: longint;
    SystemClock: longint absolute $0000:$046C;

    procedure InitDelay;
    procedure InitMode;
    procedure ClrEol;
    procedure ClrScr;
    procedure GotoXY(x, y: byte);
    function KeyPressed: boolean;
    function ReadKey: char;
    procedure HighVideo;
    procedure LowVideo;
    procedure Sound(Hz: word);
    procedure NoSound;
    procedure TextBackground(bgcolor: byte);
    procedure TextColor(color: byte);
    procedure TextMode(mode: integer);
    function WhereX: byte;
    function WhereY: byte;
    procedure InitWin2K;    { This one sets the screenmode to $3. }
    { Bla... }

    procedure Write_Line(line: string; field_size: byte);
    procedure Write_Num(num: longint; field_size: byte);
    procedure Write_Real(num: real; field_size, decimal: byte);
    procedure Delay(bla: word);

    procedure Window(x1, y1, x2, y2: byte);



implementation

    procedure InitWin2K; assembler;
    asm
	mov ax, 3
	int 10h
    end;

    { counts the amount of incs the CPU does in 1 clock tick.. }
    procedure InitDelay;
    var
      t,n: longint;
      
    begin
	t := SystemClock;
	n := 0;
	repeat until (SystemClock <> t);
	t := SystemClock;
	repeat inc(n); until (SystemClock <> t);
	TicksPerMs := n div 55;
    end;

    procedure InitMode;
    var
      CurMode: byte;
    begin
	{ Get mode register from gfx card,, }
	CurMode := PORT[$3D8] and 15;
	{ Translate those into known constants.. }
	case CurMode of
	    0: LastMode := CO40;
	    1: LastMode := CO80;
	    4: LastMode := BW40;
	    5: LastMode := BW80;
	end;
    end;

    procedure ClrEol; assembler;
    asm
        push es
        mov ax, 0B800h
        mov es, ax
        mov ax, 0300h  { get cursor position }
        xor bx, bx
        int 10h        { cursor X = dl  Y = dh }
        xor ax, ax
        mov al, dh     { ax = Y }
        xor bx, bx     { clear bx }
        xor cx, cx
        mov cl, dl     { cx = X }
        mov bl, 160    { bytes per line }
        mul bl         { ax = Y * bytes per line }
        add ax, cx     { ax = Y offset + ( 2 * X) }
        add ax, cx
    
        mov di, ax     { es:di points to cursor }
        mov al, 32
        mov ah, TextAttr
    
        mov dx, WindMax
        xor dh, dh          { ignoure Y }
        @ClrEol_start:
            cmp cx, dx
            jg @ClrEol_done
            stosw
            inc cx
            jmp @ClrEol_start
    
        @ClrEol_done:
        pop es
    end;


    procedure ClrScr;{assembler;
    asm
        mov ah, 06h
        mov al, 0
        mov bh, TextAttr
        mov cx, WindMin
        dec ch
        dec cl
        mov dx, WindMax
        dec dh
        dec dl
        int 10h
    
        mov ax, 0200h
        xor bx, bx
        mov dx, WindMin
        dec dl
        dec dh
        int 10h}
    var
      Pos : Word;

    begin
	{Clear memory, to grey on black}
	for Pos := 0 to 1999 do begin
	    MemW [$B800:Pos shl 1] := $0700;
	end;

	{Return cursor to top left}
	GotoXY (1, 1);
    end;

    procedure GotoXY(x, y: byte); assembler;
    asm
        mov cx, WindMin
        mov ah, 02
        xor al, al
        xor bx, bx    { display page 0 }
        mov dl, x
        dec dl        { convert Pascal to asm }
        add dl, cl    { add min window value }
        dec dl
    
        mov dh, y
        dec dh        { convert Pascal to asm }
        add dh, ch    { add min window position }
        dec dh
        int 10h
    end;



    function KeyPressed: boolean; assembler;
    asm
{        mov ax, 0B00h
        int 21h}
	{ Who the fuck was trying to use a Keypress without int 16?? }
	mov ah, 01h
	int 16h
	mov ax, 00h
	jz @1
	inc ax
	@1:
    end;


    function ReadKey: char; assembler;
    asm
{        mov ax, 0800h
        int 21h}
	{ Again... }
	xor ah, ah
	int 16h
    end;

    procedure TextBackground(bgcolor: byte); assembler;
    asm
        mov al, TextAttr
        mov bl, bgcolor
        shl bl, 1
        shl bl, 1
        shl bl, 1
        shl bl, 1
    
        and al, 0Fh
        or al, bl
        mov TextAttr, al
    end;

    procedure TextColor(color: byte); assembler;
    asm
        mov al, TextAttr
        mov bl, color
        and al, 0F0h
        or al, bl
        mov TextAttr, al
    end;

    procedure TextMode(mode: integer); assembler;
    asm
        xor ax, ax
        mov WindMin, ax
        mov ax, 1950h
        mov WindMax, ax
        mov al, 7
        mov TextAttr, al
    
        mov ah, 06h
        mov al, 0
        mov bh, TextAttr
        mov cx, WindMin
        mov dx, WindMax
        int 10h
    
        mov ax, 0200h
        xor bx, bx
        mov dx, WindMin
        int 10h
    end;

    function WhereX: byte; assembler;
    asm
        mov ax, 0300h  { get cursor position }
        xor bx, bx     { display page 0 }
        int 10h        { X position in dl }
        mov al, dl
        mov cx, WindMin
        sub al, cl
        inc al
    end;

    function WhereY: byte; assembler;
    asm
        mov ax, 0300h  { get cursor position }
        xor bx, bx     { display page }
        int 10h        { Y position returned in dh }
        mov al, dh
        mov cx, WindMin
        sub al, ch
        inc al
        inc al
    end;

    procedure Scroll_Up; assembler;
    asm
        mov ax, WindMax
        mov bx, WindMin
        sub ah, bh         { number of lins to scroll in ah }
    
        mov al, ah
        mov ah, 6
        mov ah, TextAttr
        mov cx, WindMin
        dec ch
        dec cl
        mov dx, WindMax
        dec dh
        dec dl
        int 10h
    end;

    procedure Print_char(letter: char); assembler;
    asm
        mov ah, 0Eh
        mov al, letter;
        xor bx, bx
        mov bl, TextAttr
        int 10h
    end;

    procedure Write_Line(line: string; field_size: byte);
    var
      len: byte;
      count: byte;
      x, y: byte;
    begin
        if field_size <> 0 then
        begin
            len := length(line);
            while len < field_size do
            begin
                line := ' ' + line;
                inc(len);
            end;
        end;
        len := length(line);
        for count := 1 to len do
        begin
            print_char(line[count]);
            x := whereX;
            y := whereY;
            if x > ( LO(WindMax) - LO(WindMin) ) then
            begin
                x := 1;
                inc(y);
                if y > ( HI(WindMax) - HI(WindMin) )then
                begin
                    scroll_up;
                    dec(y);
                end;
                gotoxy(x, y);
            end;
        end;
    end;

    procedure Write_Num(num: longint; field_size: byte);
    var
      line: string;
    
    begin
        str(num, line);
        Write_Line(line, field_size);
    end;

    procedure Write_Real(num: real; field_size, decimal: byte);
    var
      line: string;
    begin
        str(num: field_size: decimal, line);
        Write_Line(line, field_size + decimal);
    end;

    procedure Window(x1, y1, x2, y2: byte); assembler;
    asm
        mov ah, y1
        mov al, x1
        mov WindMin, ax
    
        mov ah, y2
        mov al, x2
        mov WindMax, ax
    end;
    
    procedure Delay(bla: word);
    var
      a,b,c: longint;
    begin
	for a := 1 to bla do
	begin
	    for b := 1 to TicksPerMs do inc(c);
	end;
    end;
    
    procedure HighVideo; assembler;
    asm
	mov ax, 1003h
	mov bx, 0000h
	int 0010h
    end;

    procedure LowVideo; assembler;
    asm
	mov ax, 1003h
	mov bx, 0001h
	int 0010h
    end;

    procedure NoSound; assembler;
    asm
	in al, 0061h
	and al, 00FCh
	out 0016h, al
    end;
    
    procedure Sound(Hz: word); assembler;
    asm
	mov al, 00B6h
	out 0043h, al
	mov dx, 0014h
        mov ax, 4F38h
	div Hz
	out 0042h, al
	mov al, ah
	out 0042h, al
	in al, 0061h
	or al, 0003h
	out 0061h, al
    end;
    
begin
    TextAttr := 7;
    WindMin := 0;
    WindMax := $1950;
    LastMode := 3;
    InitMode;
    InitDelay;
end.


