unit Afwas3D;

{
    Copyright (C) 2002 Royi "Uncle Ro" Eltink
    <unclero@ranmamail.com>
    This is an Turbo Pascal 7.0 implementation on Gabor Nagy's
    C/ASM implementation of the WolfEnstein 3D engine..
}

{$N+,E+}

interface

uses Dos, NewCrt;

type real = double;

const DEG2RAD: real = PI/180;

const
    A3D_horizon: word = 100;
    A3D_width: word = 320;
    A3D_height: word = 200;
    A3D_magicconst: real= 128;
    A3D_cast_angle: real= 0.2;
    A3D_offs: word = 0;

    _3DE_addr: Pointer = NIL;
    _3DE_wall: pointer = NIL;
    _3DE_floor: pointer = NIL;
    _3DE_ceiling: Pointer = NIL;

    A3D_heading: real = 0;
    A3D_turn: real = 0;
    A3D_step: real = 0;
    A3D_frames: Longint = 0;

    A3D_start: byte = 1;
    A3D_end: byte = 2;
    A3D_wall: byte = 3;

type
    PCXHeader = record
        Manufacturer,
        Version,
        Encoding,
        BitsPerPixel: byte;
        xMin,
        yMin,
        xMax,
        yMax:word;
        Other: array[0..115] of byte;
    end;

var
    _3DE_shade: pointer;
    A3D_PAL: array[0..255] of record
        R,
        G,
        B: byte;
    end;

    _3DE_hmh,
    _3DE_hph: integer;
    _3DE_x,
    _3DE_darkness: word;
    _3DE_v,
    _3DE_h,
    _3DE_stp,
    _3DE_px128,
    _3DE_py128,
    _3DE_sina,
    _3DE_cosa,
    _3DE_magic: longint;

    A3D_Map: array[0..32*32-1] of byte;
    shade: array [0..17 * 256 - 1] of byte;

    px,
    py: real;
    destx,
    desty: real;
    Header:PCXHeader;

procedure A3D_drawWallFloor;
procedure Retrace;
procedure A3D_setPAL(C,R,G,B: byte);
procedure LoadPCX(FileName: string; Where:Pointer; offset,width:word);
procedure loadmap(filename: string);
procedure Set_Shade;
function tan(x: real): real;
function InRange(X,Y: real):Boolean;
procedure compute_view;
procedure flip(src,dst:word);
procedure cls(lvseg:word);
procedure draw_map;


implementation

    procedure A3D_drawWallFloor; external;
    {$L 3DENGINE.LIB}

    procedure Retrace;
    begin
        while ((PORT[$3DA] and 8) > 0) do;
        while ((PORT[$3DA] and 8) = 0) do;
    end;

    procedure A3D_setPAL(C,R,G,B: byte);
    begin
        PORT[$3c8] := C;
        PORT[$3c9] := r;
        PORT[$3c9] := g;
        PORT[$3c9] := b;
    end;

    procedure LoadPCX(FileName: string; Where: Pointer; offset, width: word);
    var
      pcxFile:FILE;
      DataByte,
      HowMany: byte;
      Pos,
      anz:word;
      x,
      y,
      c:word;
      temp:pointer;
    begin
        {$I-}
        assign(PCXFile,filename);
        reset(PCXFile,1); 
        {$I+}
        if IOResult<>0 then
        begin
            asm
                mov     ax,3
                int     10h
            end;
            writeln('AFWAS3D: LoadPCX: PCX File (',filename,') Missing');
            halt(1);
        end;
        BlockRead(pcxfile,Header,128);
        if (Header.Version <> 5) then
        begin
            asm
                mov     ax,3
                int     10h
            end;
            close(PCXFile);
            writeln('AFWAS3D: LoadPCX: ',filename,' is not a v.5 PCX-file.');
            halt(1);
        end;
        if (Header.xMax>319) or (Header.xMin<0) or
           (Header.yMax>200) or (Header.yMin<0) then
        begin
            asm
                mov     ax,3
                int     10h
            end;
            writeln('AFWAS3D: LoadPCX: ',filename,' is a corrupt file.');
            close (PCXFile);
            halt(1);
        end;

        Seek(PCXFile,FileSize(PCXFile) - 769);
        BlockRead(PCXfile,DataByte,1);
        BlockRead(PCXfile,A3D_PAL,768);
        for c := 0 to 255 do
            A3D_setPAL(c,A3D_PAL[c].R shr 2,A3D_PAL[c].G shr 2,A3D_PAL[c].B shr 2);

        Seek(PCXFile,128);
        y := Header.yMin; 
        x := Header.xMin;
        inc(Header.xMax);
        inc(Header.yMax);

        GetMEM(temp,64000);

        repeat
            Pos := 0;
            BlockRead(PCXfile,temp^,$FFFF,anz);
            
            while (y<Header.yMax) and (Pos<anz) do
            begin
                databyte := MEM[Seg(temp^):ofs(temp^) + Pos];
                inc(Pos);
                HowMany := 1;
                if ((DataByte and $C0)=$C0) then
                begin
                    HowMany := (DataByte and $3F);
                    DataByte := MEM[Seg(temp^):ofs(temp^) + Pos];
                    inc(Pos);
                end;

                for c := 1 to HowMany do
                begin
                    MEM[Seg(where^):ofs(where^) + offset + x + y * width] := DataByte; 
                    inc(x);
                    if (x>=Header.xMax) then
                    begin
                        inc(y);
                        x := Header.xMin;
                    end;
                end;
            end;
        until (y < header.ymax) or (anz = 0);
        FreeMEM(temp,64000);
        close(PCXFile);
    end;


    procedure LoadMap(filename: string);
    var
      F:file;
      x,
      y: word;
    begin
        assign(F,filename);
        reset(F,1);
        blockread(F,A3D_Map,SizeOf(A3D_Map));
        close(f);
        for x := 0 to 31 do
        begin
            for y := 0 to 31 do
            begin
                if A3D_Map[x + y * 32] = A3D_start then
                begin
                    px := x + 0.5;
                    py := y + 0.5;
                    A3D_Map[x + y * 32] := 0;
                end
                else if A3D_Map[x + y * 32] = A3D_end then
                begin
                    destx := x;
                    desty := y;
                    A3D_Map[x + y * 32] := A3D_wall;
                end;
            end;
        end;
    end;
    
    procedure Set_Shade;
    var
      color,
      st,
      diff,
      tc,
      tdiff,
      red,
      green,
      blue: integer;
    begin
        for color := 0 to 255 do
            shade[color] := color;
        for st := 1 to 16 do
        begin
            for color := 0 to 255 do
            begin
                red := (integer(A3D_PAL[color].R) shr 4) * (16 - st);
                green := (integer(A3D_PAL[color].G) shr 4) * (16 - st);
                blue := (integer(A3D_PAL[color].B) shr 4) * (16 - st);
                diff := 1000;
                for tc := 0 to 255 do
                begin
                    tdiff := abs(integer(A3D_PAL[tc].R - red)) +
                             abs(integer(A3D_PAL[tc].G - green)) +
                             abs(integer(A3D_PAL[tc].B - blue));
                    if (tdiff < diff) then
                    begin
                        diff := tdiff;
                        shade[color + (st shl 8)] := tc;
                    end;
                end;
            end;
        end;
    end;

    function tan(x: real): real;
    begin
        tan := Sin(x) / Cos(x);
    end;

    function InRange(X,Y: real): boolean;
    var
      px,
      py: real;
    begin
        px := int(x);
        py := int(y);
        if (px < 00) or (py < 00) or (px > 27) or (py > 27) or
           (A3D_Map[round(px) + round(py) shl 5] > 0) then
            InRange := true
        else InRange := false;
    end;

    procedure compute_view;
    var
      a,
      x1,
      x2,
      y1,
      y2,
      dist1,
      dist2,
      step: real;
      height,
      dist: longint;
    begin
        _3DE_px128 := round(px * 128);
        _3DE_py128 := round(py * 128);

        a := A3D_heading + 32;
        for _3DE_x := 0 to A3D_width - 1 do
        begin
            a := a - A3D_cast_angle;
      
            { tabellen defineren }
            _3DE_magic := round(int(A3D_magicconst * 1024 / cos((a - A3D_heading) * DEG2RAD)));
            _3DE_sina := round(int(sin(a * DEG2RAD) * 128 * 1024));
            _3DE_cosa := round(int(cos(a * DEG2RAD) * 128 * 1024));
    
            { Verplaats over de Y-as }
            if (a <> 180) and (a <> 0) then
            begin
                if (_3DE_sina > 0) then
                begin
                    step := tan((90 - a) * DEG2RAD);
                    x1 := int(px) + 1;
                    y1 := py + (x1 - px) * step;
                    while true and not inrange(x1,y1) do
                    begin
                        x1 := x1 + 1;
                        y1 := y1 + step;
                    end;
                end
                else
                begin
                    step := tan((a - 270) * DEG2RAD);
                    x1 := int(px) - 0.0000001;
                    y1 := py + (px - x1) * step;
                    while true and not inrange(x1,y1) do
                    begin
                        x1 := x1 - 1;
                        y1 := y1 + step;
                    end;
                end
            end;
            
            { Verplaatsen langs de Y-as }
            if(a <> 270) and (a <> 90) then
            begin
                if(_3DE_cosa > 0) then { naar voren.. }
                begin
                    step := tan(a * DEG2RAD);
                    y2 := int(py) + 1;
                    x2 := px + (y2 - py) * step;
                    while true and not inrange(x2,y2) do
                    begin
                        y2 := y2 + 1;
                        x2 := x2 + step;
                    end;
                end
                else
                begin
                    step := tan((a - 180) * DEG2RAD );
                    y2 := int(py) - 0.000001;
                    x2 := px - (py - y2) * step;
                    while true and not inrange(x2,y2) do { achteren.. }
                    begin
                        y2 := y2 - 1;
                        x2 := x2 - step;
                    end;
                end;
            end;
    
            dist1 := sqr(px - x1) + sqr(py - y1);
            dist2 := sqr(px - x2) + sqr(py - y2);
            if (dist1 > dist2) then
            begin
                dist := round(int(sqrt(dist2) * 1024));
                _3DE_h := Abs(128 - round(128 * x2));
            end
            else
            begin
                dist := round(int(sqrt(dist1) * 1024));
                _3DE_h := abs(128 - round(128 * y1));
            end;
    
            height := _3DE_magic div dist;
            _3DE_stp := 64 * 65536 div height;
            _3DE_hmh := A3D_horizon - height;
            _3DE_hph := A3D_horizon + height;
    
            _3DE_darkness := dist shr 10;
            if (_3DE_darkness > 16) then _3DE_darkness := 16
            else if _3DE_darkness > 0 then dec(_3DE_darkness);
            _3DE_darkness := (_3DE_darkness shl 8);
    
            if (_3DE_hmh < 0) then
            begin
                _3DE_v := (0 - _3DE_hmh) * _3DE_stp;
                _3DE_hmh := 0;
                _3DE_hph := A3D_height;
            end
            else _3DE_v := 0;
    
            A3D_drawWallFloor;
        end;
    end;

    procedure flip(src,dst:word); assembler;
    asm
        push    ds
        mov     ax, [dst]
        mov     es, ax
        mov     ax, [src]
        mov     ds, ax
        xor     si, si
        xor     di, di
        mov     cx, 320 * 200 / 4
        rep;    db 66h; movsw
        pop ds
    end;

    procedure cls(lvseg:word); assembler;
    asm
        mov     es, [lvseg]
        xor     di, di
        db      66h; xor ax,ax
        mov     cx, 320 * 200 / 4
        rep;    db 66h; stosw
    end;

    procedure draw_map;
    var
      i,
      j,
      offset,
      color: word;
    begin
        color := 100;
        for i := 0 to 31 do
        begin
            for j := 0 to 31 do
            begin
                if A3D_Map[i + (j shl  5)] > 0 then
                begin
                    offset := 62 * 320 + 228 + (i * 3) + (j * 3) * 320;
                    MEM[Seg(_3DE_addr^):ofs(_3DE_addr^) + offset] := color;
                    MEM[Seg(_3DE_addr^):ofs(_3DE_addr^) + offset + 1] := color;
                    MEM[Seg(_3DE_addr^):ofs(_3DE_addr^) + offset + 2] := color;
    
                    offset := offset + 320;
                    MEM[Seg(_3DE_addr^):ofs(_3DE_addr^) + offset] := color;
                    MEM[Seg(_3DE_addr^):ofs(_3DE_addr^) + offset + 1] := color;
                    MEM[Seg(_3DE_addr^):ofs(_3DE_addr^) + offset + 2] := color;

                    offset := offset + 320;
                    MEM[Seg(_3DE_addr^):ofs(_3DE_addr^) + offset] := color;
                    MEM[Seg(_3DE_addr^):ofs(_3DE_addr^) + offset + 1] := color;
                    MEM[Seg(_3DE_addr^):ofs(_3DE_addr^) + offset + 2] := color;
                end;
            end;
        end;
    end;

end.