; Original from a guy called Gabor Nagy
; Ported to Turbo Assembler by Royi "Uncle Ro" Eltink <unclero@ranmamail.com>
; 

ideal

P386
model small,pascal

locals @@

dataseg

extrn _3DE_addr: dword, _3DE_darkness: word, _3DE_v: dword, _3DE_h: dword
extrn _3DE_wall: dword, _3DE_X: word, _3DE_hmh: word, _3DE_hph: word, _3DE_shade: word
extrn _3DE_stp: dword, _3DE_magic: dword, _3DE_sina: dword, _3DE_cosa: dword
extrn _3DE_px128: dword, _3DE_py128: dword, _3DE_floor: dword, _3DE_ceiling: dword
extrn A3D_offs: word, A3D_horizon: word, A3D_height: word

codeseg

public A3D_drawWallFloor

proc A3D_drawWallFloor
	push bp si di es
	mov ax,ds
	mov bp,[word _3DE_darkness]
	mov fs,ax
	mov ebx,[dword _3DE_v]
	mov si,[word _3DE_h]
	mov di,[word _3DE_addr]
	add di,[word A3D_offs]
	and si,7Fh
	add di,[word _3DE_X]
	add si,[word _3DE_wall]
	mov ax,[word _3DE_hmh]
	mov dx,[word _3DE_hph]
	mov cx,ax
	shl ax,6
	add di,ax
	shl ax,2
	add di,ax
	mov ax,[word _3DE_addr+2]
	mov es,ax 
	mov ax,[word _3DE_wall+2]
	mov ds,ax

@@Cycl0:
	cmp cx,dx
	jae @@End0

	push ebx
	shr ebx,16
	shl bx,7
	add si,bx
	xor ax,ax
	mov al,[si]
	sub si,bx
	pop ebx
	rol esi,16
	mov si,[word fs: _3DE_shade]
	add si,ax
	add si,bp
	mov al,[fs:si]
	mov [es:di],al
	ror esi,16

	inc cx
	add di,320
	add ebx,[dword fs: _3DE_stp]
	jmp @@Cycl0
@@End0:
	mov ax,fs
	mov ds,ax
	mov ax,[word A3D_height]
	cmp [word _3DE_hph],ax
	je @@End1
	mov ax,[word _3DE_addr+2]
	mov bx,[word _3DE_addr]
	add bx,[word A3D_offs]
	mov es,ax
	add bx,[word _3DE_X]
	mov di,bx
	mov ax,[word _3DE_hph]
	mov dx,ax
	shl ax,6
	add di,ax
	shl ax,2
	add di,ax
	rol edi,16
	mov di,bx
	mov ax,[word _3DE_hmh]
	shl ax,6
	add di,ax
	shl ax,2
	add di,ax
	sub di,320
	ror edi,16
	xor ebx,ebx
	mov bx,dx  
	mov ax,[word _3DE_floor+2]
	sub bx,[word A3D_horizon] 
	mov fs,ax
	mov ax,[word _3DE_ceiling+2]
	mov gs,ax
@@Cycl1:
	cmp bx, [word A3D_horizon]
	jae @@End1

	xor edx,edx
	mov eax,[dword _3DE_magic]
	div ebx
	mov ebp,eax
	mov eax,[dword _3DE_sina]
	mul ebp
	shr eax,20
	add eax,[dword _3DE_px128]
	and ax,7Fh
	mov si,ax
	mov eax,[dword _3DE_cosa]
	mul ebp
	shr eax,20
	add eax,[dword _3DE_py128]
	and ax,7Fh
	shl ax,7
	add si,ax
	shr ebp,10 
	cmp bp,0
	jne @@NumberZero
	inc bp
@@NumberZero:
	cmp bp,16
	jbe @@No16
	mov bp,16
@@No16:
	shl bp,8
	mov cx,si
	xor ax,ax
	add si,[word _3DE_floor]
	mov al,[fs:si]
	mov si,[word _3DE_shade]
	add si,ax
	add si,bp
	mov al,[si]
	mov [es:di],al
	add di,320
	rol edi,16
	mov si,cx
	xor ax,ax
	add si,[word _3DE_ceiling]
	mov al,[gs:si]
	mov si,[word _3DE_shade]
	add si,ax
	add si,bp
	mov al,[si]
	mov [es:di],al
	sub di,320
	ror edi,16
	inc bx
	jmp @@Cycl1
@@End1:
	pop es di si bp
	ret
endp

end