#include <windows.h>
#include <winioctl.h>

#include "winampcmd.h"
#include "wadll.h"

void JNICALL Java_WADll_addfile
  (JNIEnv *e, jobject o, jint hwnd, jbyteArray file)
{
	jbyte *str;
    jsize i,len;
    jboolean iscopy;

	len=(*e)->GetArrayLength(e,file);
    str=(*e)->GetByteArrayElements(e,file,&iscopy);
    
	for(i=0;i<len;i++)
    {
    	PostMessage((HWND)hwnd,WM_WA_IPC,(WPARAM)str[i],IPC_PLAYFILE);
    }

  	PostMessage((HWND)hwnd,WM_WA_IPC,(WPARAM)0,IPC_PLAYFILE);

    (*e)->ReleaseByteArrayElements(e,file,str,0);
}

void JNICALL Java_WADll_eject
  (JNIEnv *e, jobject o, jbyteArray drive)
{
    HANDLE cd;
    DWORD aread;
	jsize len;
	char *str,*cddrive;
    jboolean iscopy;

	// Get drive name
	len=(*e)->GetArrayLength(e,drive);
    str=(*e)->GetByteArrayElements(e,drive,&iscopy);

	if(len && str)
    {
		// Temporary string
        cddrive=(char *)malloc(len+1);
        
        memcpy(cddrive,str,len);
        cddrive[len]=0;
        
	    cd=CreateFile(cddrive,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	    if(cd!=INVALID_HANDLE_VALUE)
	    {
		    DeviceIoControl(cd,IOCTL_STORAGE_EJECT_MEDIA,NULL,0,NULL,0,&aread,NULL);
		    CloseHandle(cd);
		}
        
        free(cddrive);
    }

	// Release bytes
    (*e)->ReleaseByteArrayElements(e,drive,str,0);
}

void JNICALL Java_WADll_load
  (JNIEnv *e, jobject o, jbyteArray drive)
{
    HANDLE cd;
    DWORD aread;
	jsize len;
	char *str,*cddrive;
    jboolean iscopy;

	// Get drive name
	len=(*e)->GetArrayLength(e,drive);
    str=(*e)->GetByteArrayElements(e,drive,&iscopy);

	if(len && str)
    {
		// Temporary string
        cddrive=(char *)malloc(len+1);
        
        memcpy(cddrive,str,len);
        cddrive[len]=0;
        
	    cd=CreateFile(cddrive,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	    if(cd!=INVALID_HANDLE_VALUE)
	    {
		    DeviceIoControl(cd,IOCTL_STORAGE_LOAD_MEDIA,NULL,0,NULL,0,&aread,NULL);
		    CloseHandle(cd);
		}
        
        free(cddrive);
    }

	// Release bytes
    (*e)->ReleaseByteArrayElements(e,drive,str,0);
}

jint JNICALL Java_WADll_init
  (JNIEnv *e, jobject o, jbyteArray wclass)
{
	jbyte *str,*tmp;
    jsize len;
    jboolean iscopy;
	HWND hwnd;

	len=(*e)->GetArrayLength(e,wclass);
    str=(*e)->GetByteArrayElements(e,wclass,&iscopy);

    if(len && str)
    {
        tmp=(char *)malloc(len+1);
        memcpy(tmp,str,len);
        tmp[len]=0;

	    hwnd=FindWindow(tmp,NULL);

		free(tmp);
    }

    (*e)->ReleaseByteArrayElements(e,wclass,str,0);

    return (jint)hwnd;
}

void JNICALL Java_WADll_postmessage
  (JNIEnv *e, jobject o, jint hwnd, jint code, jint wparam, jint lparam)
{
   	PostMessage((HWND)hwnd,(UINT)code,(WPARAM)wparam,(LPARAM)lparam);
}

jint JNICALL Java_WADll_sendmessage
  (JNIEnv *e, jobject o, jint hwnd, jint code, jint wparam, jint lparam)
{
	jint res;
    
   	res=(jint)SendMessage((HWND)hwnd,(UINT)code,(WPARAM)wparam,(LPARAM)lparam);

	return res;
}

void JNICALL Java_WADll_shutdown
   (JNIEnv *e, jobject o, jint mode)
{
    UINT flags;

    // Default mode
    flags=EWX_SHUTDOWN;

    // Shutdown / power off
    if(mode&WADll_SD_POWEROFF)
    {
        flags=EWX_POWEROFF;
    }

    // Force / don't force
    if(mode&WADll_SD_FORCE)
    {
        flags|=EWX_FORCE;
    }

    // Do the exit stuff
    ExitWindowsEx(flags,0);
}




