;
;Project IR receiver
;Date    9.11.1999
;Author  Matti Kantola
;
;History 9.11.1999  wrote it
;

;------------------------------------------------
;Includes
;------------------------------------------------

;.include "\avrinc\avrasm\2313def.inc"
.include "C:\USERS\ibm560c\mka\avr\avrtools\inc\8515def.inc"

.include "irjvc.inc"

;------------------------------------------------
;Constants
;------------------------------------------------

;Port definitions

.equ wportb         =PORTB
.equ wportd         =PORTD

.equ rportb         =PINB
.equ rportd         =PIND

.equ dportb         =DDRB
.equ dportd         =DDRD

;
;Port   76543210  Name        Type Bit#
;
;PORTB %00000000
;       ||||||||_ READYLED    O    0
;       |||||||__ DONELED     O    1
;       ||||||___ NC          -    2
;       |||||____ NC          -    3
;       ||||_____ NC          -    4
;       |||______ NC          -    5
;       ||_______ NC          -    6
;       |________ NC          -    7
;
;PORTD %00000000
;       ||||||||_ BCONT       I    0
;       |||||||__ TX          O    1
;       ||||||___ NC          -    2
;       |||||____ NC          -    3
;       ||||_____ NC          -    4
;       |||______ IRPLED      I    5
;       ||_______ NC          -    6
;       |________ IROUT       O    7
;
;NC = no connect
;I  = input
;O  = output
;Z  = high impedance
;

;I/O data bits

;Port B
.equ bit_readyled   =0
.equ bit_doneled    =1

;Port D
.equ bit_bcont      =0
.equ bit_tx		=1
.equ bit_irpled     =5
.equ bit_irout      =7

;                Bit#  76543210
.equ dportbbits     =0b00000011
.equ wportbbits     =0b00000011

.equ dportdbits     =0b10000000
.equ wportdbits     =0b10000000

;Internal data bits

;Constants

.equ cpu_clk        =4000000       ;Hz
.equ baud           =9600          ;bps
.equ ubrr_init      =((cpu_clk/(16*baud))-1)

; Stack

;.equ stackptr       =0xe0-2        ;313
.equ stackptr       =0x260-2       ;515

;------------------------------------------------
;Register aliases
;------------------------------------------------

;mii = modified in interrupt

;Low (0-15)

.def templo         =r0
.def zero           =r1
.def tickhi         =r2       ;mii
.def tickovf        =r3       ;mii
.def store          =r4       ;mii

;High (15-31)

.def _stack_        =r16
.def temp           =r16
.def temphi         =r17
.def datacount      =r18
.def t1compa        =r19      ;mii

.def complolo	    =r20
.def complohi       =r21
.def comphilo       =r22
.def comphihi       =r23

.def counttilo	    =r24
.def counttihi      =r25

.def xlo            =r26
.def xhi            =r27

.def ylo            =r28
.def yhi            =r29

.def zlo            =r30
.def zhi            =r31

;------------------------------------------------
;Macros
;------------------------------------------------

; params @0, @1, @2, ...
; .macro  <name>
;         <stuff>
; .endmacro

.macro cmpbw @0,@1
     ldi  complolo,(@0)&0xff
     ldi  complohi,(@0)>>8
     ldi  comphilo,(@1)&0xff
     ldi  comphihi,(@1)>>8
     rcall _cmpbw
.endmacro

.macro locodeptr
     ldi  @0,((@1)*2)&0xff
.endmacro

.macro hicodeptr
     ldi  @0,(((@1)*2)>>8)&0xff
.endmacro

.macro lodataptr
     ldi  @0,(@1)&0xff
.endmacro

.macro hidataptr
     ldi  @0,((@1)>>8)&0xff
.endmacro

;------------------------------------------------
;Code
;------------------------------------------------

.cseg
;313 interrupt table
;     rjmp main      ;reset
;     reti           ;ext0
;     reti           ;ext1
;     reti           ;t1cap
;     reti           ;t1comp
;     reti           ;t1ovf
;     rjmp timer0int ;t0ovf
;     reti           ;rx
;     reti           ;txdre
;     reti           ;tx
;     reti           ;ancomp

;515 interrupt table
     rjmp main      ;reset
     reti           ;ext0
     reti           ;ext1
     reti           ;t1cap
     rjmp timer1compaint ;t1compa
     reti           ;t1compb
     reti           ;t1ovf
     rjmp timer0int ;t0ovf
     reti           ;spi
     reti           ;rx
     reti           ;txdre
     reti           ;tx
     reti           ;ancomp

;------------------------------------------------
;Constant tables
;------------------------------------------------

;
;This is the main program.
;  

;.include "debug.asm"
;dtest:    .db  'R','0',':',' ','%','0','0',0

main:
     cli                      ;disable all

     ldi  _stack_,stackptr    ;initialize stack pointer lo (313 & 515)
     out  SPL,_stack_

     ldi  _stack_,stackptr>>8 ;initialize stack pointer hi (515)
     out  SPH,_stack_

     ;Register inits

     clr  zero
     clr  t1compa
     
	;HW inits

     ;I/O

     ldi  temp,dportdbits     ;dir
     out  dportd,temp		;set

     ldi  temp,wportdbits     ;data
     out  wportd,temp         ;set

     ldi  temp,dportbbits     ;dir
     out  dportb,temp         ;set

     ldi  temp,wportbbits     ;data
     out  wportb,temp         ;set

     ;Timers

     clr  tickhi
     clr  tickovf
     out  TCNT0,tickhi

     ldi  temp,0b00000010     ;CK/8
     out  TCCR0,temp

     ldi  temp,0b01000010     ;t0 overflow, t1 comp a
     out  TIMSK,temp

     ;UART

     ldi  temp,ubrr_init      ;set baud
     out  UBRR,temp
     ldi  temp,0b00001000     ;tx enable
     out  UCR,temp

     sei                      ;enable

;     locodeptr zlo,dtest
;     hicodeptr zhi,dtest
;     rcall debug

;     ldi  temp,   (650/2)>>8
;     ldi  temphi, (650/2)
;     rcall     sendirburst    ;send burst

;     tst  t1compa
;     breq PC-1

;sendi:
;     sbic rportd,bit_bcont    ;check button
;     rjmp PC-1
;
;     cbi  wportb,bit_readyled
;
;     ldi  temp,25             ;code number
;     clt                      ;first
;     rcall     jvcsendcode
;     
;     sbi  wportb,bit_readyled
;
;sendrep:
;     sbic rportd,bit_bcont    ;check again
;     rjmp sendi
;
;     cbi  wportb,bit_readyled
;
;     ldi  temp,25             ;code number
;     set                      ;repeat
;     rcall     jvcsendcode
;
;     sbi  wportb,bit_readyled
;
;     rjmp sendrep

     out  TIMSK,zero          ;disable all
     ldi  temp,0b00000010     ;CK/8
     out  TCCR1B,temp


;     clr  temp
;     clr  temphi
;     ;ldi  temp,9997&0xff
;     ;ldi  temphi,9997>>8
;          
;     clr  counttilo
;     clr  counttihi
;     
;tloop:
;     cmpbw 8000,20000
;     brcs PC+2
;     adiw counttilo,1
;     
;     inc  temp
;     brne tloop
;     inc  temphi
;     brne tloop
;     
;     rjmp PC

recloop:
     rcall     jvcreceive     ;receive jvc data

     cbi  wportb,bit_readyled

     mov  temp,jvc_repeat     ;send code to host pc
     rcall     uarttxchar
     mov  temp,jvc_reshi
     rcall     uarttxchar
     mov  temp,jvc_reslo
     rcall     uarttxchar
     
     sbi  wportb,bit_readyled

     rjmp recloop

again:
     ;ldi  datacount,25        ;2*25 words=100 bytes (313)
     ldi  datacount,100       ;2*100 words=400 bytes (515)
     lodataptr xlo,timedata   ;pointer to sram
     hidataptr xhi,timedata

     sbi  wportb,bit_doneled  ;set leds
     cbi  wportb,bit_readyled

forever:
     ;Wait for falling edge
     sbic rportd,bit_irpled
     rjmp PC-1

     cli
     in   temp,TCNT0          ;lo
     ;tst  tickovf             ;overflow?
     ;breq PC+4
     ;clr  temp
     ;clr  tickovf
     st   X+,tickhi           ;store
     st   X+,temp
     clr  tickhi
     out  TCNT0,tickhi
     sei

     ;Wait for rising edge
     sbis rportd,bit_irpled
     rjmp PC-1

     cli
     in   temp,TCNT0          ;lo
     ;tst  tickovf             ;overflow?
     ;breq PC+4
     ;clr  temp
     ;clr  tickovf
     st   X+,tickhi           ;store
     st   X+,temp
     clr  tickhi
     out  TCNT0,tickhi
     sei

     dec  datacount           ;--
     brne forever             ;loop

     cbi  wportb,bit_doneled  ;set leds
     cbi  wportb,bit_readyled

;     ldi  datacount,50        ;50 words=100 bytes (313)
     ldi  datacount,200       ;200 words=400 bytes (515)

     lodataptr xlo,timedata   ;pointer to sram
     hidataptr xhi,timedata

     ld   temp,X+             ;load data
     rcall     uarttxchar     ;transfer
     ld   temp,X+             ;load data
     rcall     uarttxchar     ;transfer
     dec  datacount           ;--
     brne PC-5                ;loop

     sbi  wportb,bit_doneled  ;set leds
     sbi  wportb,bit_readyled

     sbic rportd,bit_bcont    ;check button
     rjmp PC-1

     rjmp again

;
;Inputs:  temp      character to send
;
;Outputs: -
;
;Uses:    -
;

uarttxchar:
     out  UDR,temp            ;data
     sbi  USR,TXC             ;start tx
     sbis USR,TXC             ;wait for complete
     rjmp PC-1               
     ret

;
;Inputs:  -
;
;Outputs: temp      received character
;
;Uses:    temp
;

uartrxchar:
     ret

;
;Inputs:  -
;
;Outputs: -
;
;Uses:    tickhi
;         tickovf
;

timer0int:
     in   store,SREG          ;store flags
     inc  tickhi              ;hi++
     brne PC+2                ;zero?
     inc  tickovf             ;set overflow
     out  SREG,store          ;restore flags
     reti

;
;Inputs:  -
;
;Outputs: -
;
;Uses:    t1compa
;

timer1compaint:
     out  TCCR1B,zero         ;stop counting
     ser  t1compa             ;set flag
     reti

;
;Inputs:  temp      timeout msb (us/2)
;         temphi    timeout lsb (us/2)
;
;Outputs: -
;
;Uses:    temp
;

settimeout:
     out  OCR1AH,temp         ;set compare value
     out  OCR1AL,temphi
     
     clr  t1compa             ;clear flag
     
     ldi  temp,0b00001010     ;clear on comp match, CK/8
     out  TCCR1B,temp

     ret

;
;Inputs:  temp      wait time msb (us/2)
;         temphi    wait time lsb (us/2)
;
;Outputs: -
;
;Uses:    temp
;         temphi
;

waittimeout:
     rcall     settimeout

     tst  t1compa             ;timeout?
     breq PC-1

     ret

;
;Inputs:  temp      burst time msb (us/2)
;         temphi    burst time lsb (us/2)
;
;Outputs: -
;
;Uses:    temp
;         temphi
;

sendirburst:
     rcall     settimeout

sirloop:
     cbi  wportd,bit_irout    ;light on
     ldi  temp,18             ;waste 13.889us
     dec  temp
     brne PC-1

     sbi  wportd,bit_irout
     ldi  temp,17             ;waste 13.889us
     dec  temp
     brne PC-1

     tst  t1compa             ;timeout?
     breq sirloop

     ret

;
;Inputs:  temp      value to be compared lsb
;         temphi    value to be compared msb
;         complolo  lower limit lsb
;         complohi  lower limit msb
;         comphilo  higher limit lsb
;         comphihi  higher limit msb
;
;Outputs: C=0 is between
;         C=1 is not between
;
;Uses:    temp
;         temphi
;

_cmpbw:
     sub  complolo,temp
     sbc  complohi,temphi
     brcc PC+4
     sub  comphilo,temp
     sbc  comphihi,temphi
     ret
     sec
     ret

;Bring in remote control support
.include "irjvc.asm"

;------------------------------------------------
;Data
;------------------------------------------------

.dseg

;timedata: .byte     100       ;313
timedata: .byte     400       ;515




