;
;Sends/receives JVC remote controller data.
;Waveform format:
;First press:
;____          ______     ____
;    |________|      |___|    |______
;     8000     4000   600 400/1400
;Repeats:
;____     ____
;    |___|    |______
;     600 400/1400
;

jvcsendcode:
     subi temp,-(jvc_codebase)     ;add base address

     out  EEARL,temp          ;set EEPROM address
     out  EEARH,zero

     sbi  EECR,EERE           ;read code msb
     in   jvc_reshi,EEDR
     ldi  jvc_reslo,0xb3      ;code lsb

     brts PC+3                ;repeat
     rcall     jvcsend
     ret

     rcall     jvcsendrepeat
     ret

jvcsend:
     ldi  temp,jvc_agc_on>>8  ;agc on pulse
     ldi  temphi,jvc_agc_on
     rcall     sendirburst
     
     ldi  temp,jvc_agc_off>>8 ;agc off pulse
     ldi  temphi,jvc_agc_off
     rcall     waittimeout

jvcsendrepeat:
     ldi  jvc_count,jvc_bits  ;number of bits
jvc_send_loop:
     ldi  temp,jvc_bit_on>>8  ;bit on time
     ldi  temphi,jvc_bit_on
     rcall     sendirburst
     
     ldi  temp,jvc_bit0_off>>8 ;bit0 off time
     ldi  temphi,jvc_bit0_off
     
     ror  jvc_reshi
     ror  jvc_reslo
     brcc PC+3
     
     ldi  temp,jvc_bit1_off>>8 ;bit1 off time
     ldi  temphi,jvc_bit1_off

     rcall     waittimeout

     dec  jvc_count           ;--
     brne jvc_send_loop       ;loop

     ldi  temp,jvc_bit_on>>8  ;stop bit
     ldi  temphi,jvc_bit_on
     rcall     sendirburst

     ldi  temp,jvc_pause>>8   ;pause time
     ldi  temphi,jvc_pause
     rcall     waittimeout
     
     ret

jvcreceive:
jvc_idle:
     ldi  jvc_count,jvc_bits  ;number of data bits
     ser  jvc_repeat          ;a repeat
      
     sbis irport,bit_irpled   ;wait for idle
     rjmp PC-1

     ;wait start of transmission
     rcall jvc_wait10         ;falling

     ;wait agc on period     
     rcall jvc_wait01         ;rising

     cmpbw jvc_agc_on_lo,jvc_agc_on_hi
     brcs jvc_rxbit	      ;not agc pulse -> repeat code?

     clr  jvc_repeat
     rcall jvc_wait10         ;falling

     cmpbw jvc_agc_off_lo,jvc_agc_off_hi
     brcs jvc_idle            ;not agc pulse -> idle

jvc_rxbitloop:
     rcall jvc_wait01         ;rising

jvc_rxbit:
     cmpbw jvc_bit_on_lo,jvc_bit_on_hi
     brcs jvc_idle	      ;not a bit -> idle

     ;wait bit off period
     rcall jvc_wait10         ;falling

     cmpbw jvc_bit0_off_lo,jvc_bit0_off_hi
     brcs PC+3                ;not a zero bit

     sec                      ;set carry
     rjmp jvc_shiftres        ;-> result

     cmpbw jvc_bit1_off_lo,jvc_bit1_off_hi
     brcs jvc_idle            ;unknown bit length

jvc_shiftres:
     ror  jvc_reshi           ;carry -> data
     ror  jvc_reslo

     dec  jvc_count           ;--
     brne jvc_rxbitloop       ;loop

     sbis irport,bit_irpled   ;rising (stop bit)
     rjmp PC-1

     ret                      ;return

jvc_wait10:
     sbic irport,bit_irpled   ;falling
     rjmp PC-1

     in   temp,TCNT1L         ;get timer value
     in   temphi,TCNT1H

     out  TCNT1H,zero         ;clear timer
     out  TCNT1L,zero

     ret

jvc_wait01:
     sbis irport,bit_irpled   ;rising
     rjmp PC-1

     in   temp,TCNT1L         ;get timer value
     in   temphi,TCNT1H

     out  TCNT1H,zero         ;clear timer
     out  TCNT1L,zero

     ret

.eseg
     ;JVC key codes (high bytes, low byte always 0xb3)
     .db  0x61      ;1
     .db  0x62      ;2
     .db  0x63      ;3
     .db  0x64      ;4
     .db  0x65      ;5
     .db  0x66      ;6
     .db  0x67      ;7
     .db  0x68      ;8
     .db  0x69      ;9
     .db  0x6e      ;10
     .db  0x6f      ;10+
     .db  0x44      ;open/close
     .db  0x6a      ;program
     .db  0x6d      ;cancel
     .db  0x72      ;random
     .db  0x43      ;.   (stop)
     .db  0x4d      ;||  (pause)
     .db  0x4c      ;>   (play)
     .db  0x5b      ;repeat
     .db  0x54      ;display
     .db  0x58      ;|<< (seek -)
     .db  0x59      ;>>| (seek +)
     .db  0x57      ;<-  (index )
     .db  0x56      ;->  (index +)
     .db  0x70      ;<<  (search -)
     .db  0x76      ;>>  (search +)

.cseg
