public class WAMachine implements IRCodeListener, IRMachine
{
    private String root;
    private String[] patterns;

    private static String defroot="c:\\windows\\desktop";
    private static String[] defpatt={".mp2",".mp3"};
    private static String defdrive="\\\\.\\D:";

    WAControl wa;
    Readdir dir;

    int num,numcount=0,numref=2;
    boolean trayopen=false;
    long repeattime;
    boolean active=false;

    public WAMachine() throws Exception
    {
        // Default options
        this(defroot,defpatt,defdrive);
    }

    public WAMachine(String root,String[] patterns,String drive) throws Exception
    {
        this.root=root;
        this.patterns=patterns;
    
        // Winamp control
        wa=new WAControl(drive);

        // Directory handler
        dir=new Readdir(root);
    
        System.out.println("WA machine running...");
    }

    // IRMachine
    public void setActive(boolean active)
    {
        this.active=active;
        
        if(!active)
        {
            wa.stop();
        }
    }

    public boolean isActive()
    {
        return active;
    }

    // IRCodeListener
    public void IRCodeProcess(int code,boolean repeat)
    {
        if(!active) return;

        if(repeat)
        {
            long delay=System.currentTimeMillis()-repeattime;

            // Handle codes
            switch(code)
            {
                // Numbers
                case JVC.KEY_1:
                case JVC.KEY_2:
                case JVC.KEY_3:
                case JVC.KEY_4:
                case JVC.KEY_5:
                case JVC.KEY_6:
                case JVC.KEY_7:
                case JVC.KEY_8:
                case JVC.KEY_9:
                case JVC.KEY_10:
                case JVC.KEY_10P:

                // Others
                case JVC.KEY_OPEN:
                case JVC.KEY_PROGRAM:
                case JVC.KEY_STOP:
                case JVC.KEY_PAUSE:
                case JVC.KEY_PLAY:
                case JVC.KEY_RANDOM:        
                case JVC.KEY_REPEAT:        
                case JVC.KEY_DISPLAY:
                    break;        

                case JVC.KEY_CANCEL:        
                    if(delay>1000)
                    {
                        System.exit(0);
                        //wa.shutdown();
                    }
                    break;

                case JVC.KEY_PREV:
                    if(delay>500)
                    {
                        wa.prev();
                        repeattime=System.currentTimeMillis()-300;
                    }
                    break;        
                case JVC.KEY_NEXT:        
                    if(delay>500)
                    {
                        wa.next();
                        repeattime=System.currentTimeMillis()-300;
                    }
                    break;
                case JVC.KEY_REW:        
                    if(delay>500)
                    {
                        wa.rew();
                        repeattime=System.currentTimeMillis();
                    }
                    break;
                case JVC.KEY_FFWD:        
                    if(delay>500)
                    {
                        wa.ffwd();
                        repeattime=System.currentTimeMillis();
                    }
                    break;
                case JVC.KEY_IPREV:        
                    if(delay>100)
                    {
                        wa.voldn();
                        repeattime=System.currentTimeMillis();
                    }
                    break;
                case JVC.KEY_INEXT:        
                    if(delay>100)
                    {
                        wa.volup();
                        repeattime=System.currentTimeMillis();
                    }
                    break;

                default:
                    System.out.println("Unknown: "+code);
                    break;
            }    
        }
        else
        {        
            repeattime=System.currentTimeMillis();

            // Handle codes
            switch(code)
            {
                // Numbers
                case JVC.KEY_1:
                    handleNumber(1);
                    break;
                case JVC.KEY_2:
                    handleNumber(2);
                    break;
                case JVC.KEY_3:
                    handleNumber(3);
                    break;
                case JVC.KEY_4:
                    handleNumber(4);
                    break;
                case JVC.KEY_5:
                    handleNumber(5);
                    break;
                case JVC.KEY_6:
                    handleNumber(6);
                    break;
                case JVC.KEY_7:
                    handleNumber(7);
                    break;
                case JVC.KEY_8:
                    handleNumber(8);
                    break;
                case JVC.KEY_9:
                    handleNumber(9);
                    break;
                case JVC.KEY_10:
                    handleNumber(0);
                    break;
                case JVC.KEY_10P:
                    numref=3;
                    numcount=0;
                    num=0;
                    break;
                
                // Others
                case JVC.KEY_OPEN:
                    if(trayopen)
                    {
                        wa.load();
                        trayopen=false;
                    }
                    else
                    {
                        wa.eject();
                        trayopen=true;
                    }
                    break;
                case JVC.KEY_PROGRAM:
                    // Scan & add
                    String[] files=dir.scan(patterns);
                    if(files!=null)
                    {
                        wa.addFiles(files);
                    }
                    break;
                case JVC.KEY_STOP:
                    wa.stop();
                    break;        
                case JVC.KEY_PAUSE:
                    wa.pause();
                    break;        
                case JVC.KEY_PLAY:
                    wa.play();
                    break;        
                case JVC.KEY_PREV:
                    wa.prev();
                    break;        
                case JVC.KEY_NEXT:        
                    wa.next();
                    break;
                case JVC.KEY_REW:        
                    wa.rew();
                    break;
                case JVC.KEY_FFWD:        
                    wa.ffwd();
                    break;
                case JVC.KEY_IPREV:        
                    wa.voldn();
                    break;
                case JVC.KEY_INEXT:        
                    wa.volup();
                    break;
                case JVC.KEY_CANCEL:        
                    break;
                case JVC.KEY_RANDOM:        
                case JVC.KEY_REPEAT:        
                case JVC.KEY_DISPLAY:
                    break;        

                default:
                    System.out.println("Unknown: "+code);
                    break;
            }    
        }
    }

    public void handleNumber(int n)
    {
        // Add number
        num*=10;
        num+=n;
        
        // Add digit count
        numcount++;
        
        if(numcount==numref)
        {
            wa.setIndex(num);        
            numref=2;
            numcount=0;
            num=0;
        }
    }
}