public class WAControl
{
    public static final int
        WM_COMMAND=0x0111,
        WM_WA_IPC=0x0400;

    WADll wadll;
    int hwnd;
    byte[] drive;

    public WAControl(String drive) throws Exception
    {
        // New control dll
        wadll=new WADll();
	
    	// Initialize and get window handle
        hwnd=wadll.init("Winamp v1.x".getBytes());
        this.drive=drive.getBytes();

        // Check if window was not found
        if(hwnd==0) throw new Exception("Winamp not running");
    }

    public void prev()
    {
        wadll.postmessage(hwnd,WM_COMMAND,40044,0);
    }
    
    public void next()
    {
        wadll.postmessage(hwnd,WM_COMMAND,40048,0);
    }
    
    public void startplay()
    {
        wadll.postmessage(hwnd,WM_WA_IPC,0,102);
    }

    public void play()
    {
        wadll.postmessage(hwnd,WM_COMMAND,40045,0);
    }
    
    public void stop()
    {
        wadll.postmessage(hwnd,WM_COMMAND,40047,0);
    }
    
    public void pause()
    {
        wadll.postmessage(hwnd,WM_COMMAND,40046,0);
    }
    
    public void resume()
    {
        play();
    }

    public void ffwd()
    {
        wadll.postmessage(hwnd,WM_COMMAND,40060,0);
    }
    
    public void rew()
    {
        wadll.postmessage(hwnd,WM_COMMAND,40061,0);
    }
    
    public void eject()
    {
        stop();
        
        if(!isPlaying())
        {
            wadll.eject(drive);
        }
    }
    
    public void load()
    {
        wadll.load(drive);
    }

    public void volup()
    {
        wadll.postmessage(hwnd,WM_COMMAND,40058,0);
    }
    
    public void voldn()
    {
        wadll.postmessage(hwnd,WM_COMMAND,40059,0);
    }
    
    public void setIndex(int index)
    {
		if(index==0) index=1;
        wadll.postmessage(hwnd,WM_WA_IPC,index-1,121);
		play();
    }

    public boolean isPlaying()
    {
        int res;
        
        // Wait for window to process messages
        try{
            Thread.currentThread().sleep(10);
        } catch(Exception e){}

        res=wadll.sendmessage(hwnd,WM_WA_IPC,0,104);

        return res==1?true:false;
    }
    
    public void clear()
    {
        wadll.postmessage(hwnd,WM_WA_IPC,0,101);
    }
    
    public void addFiles(String[] files)
    {
        // 1. stop 2. check 3. clear 4. add files 5. play
        stop();

        if(!isPlaying())
        {
            clear();
            
            for(int i=0;i<files.length;i++)
            {
                wadll.addfile(hwnd,files[i].getBytes());
                
                // Don't want to fill message queues...
                try{
                    Thread.currentThread().sleep(10);
                } catch(Exception e){}
            }

            startplay();
        }
    }

    public void shutdown()
    {
        // Just use default flags
        wadll.shutdown(WADll.SD_SHUTDOWN);
    }
}