import java.io.*;
import java.util.*;

public class Readdir implements FileFilter, FilenameFilter
{
    String path;
    File base;
    Vector files;
    String[] pattern;

    public Readdir(String path)
    {
        this.path=path;
        base=new File(path);
    }
    
    public boolean accept(File dir)
    {
        return(dir.isDirectory());
    }
    
    public boolean accept(File dir, String name)
    {
        for(int i=0;i<pattern.length;i++)
        {
            if(name.indexOf(pattern[i])!=-1)
            {
                System.out.println(dir.getPath()+"\\"+name);
                files.addElement(dir.getPath()+"\\"+name);
                break;
            }
        }

        return false;
    }

    public String[] scan(String[] pattern)
    {
        File[] dirs;
        String[] names=null;
                
        this.pattern=pattern;
        
        files=new Vector();
        scanRec(base);

        if(files.size()>0)
        {
            names=new String[files.size()];
            
            for(int i=0;i<files.size();i++)
            {
                names[i]=(String)files.elementAt(i);
            }
        }
    
        // Free reference
        files=null;
        
        return names;
    }

    void scanRec(File root)
    {
        File[] level;

        // Scan for interesting files
        root.listFiles((FilenameFilter)this);

        // Read this level
        level=root.listFiles((FileFilter)this);

        // No dirs at this level
        if(level==null) return;
    
        // Scan all dirs at this level
        for(int i=0;i<level.length;i++)
        {
            //System.out.println(level[i].getPath());
            scanRec(level[i]);
        }
    }
}