public class Main implements IRCodeListener
{
    static IRReader irr;
    static WAMachine winamp;

    int mode=0;
    
    /*
    -create IR reader
    -create instances of control classes
     * Winamp
     * RealPlayer
     * DVD Player
    -add listeners
    */
   
    public Main() throws Exception
    {
        // IR reader
        irr=new IRReader();

        // Create & enable Winamp machine
        winamp=new WAMachine();
        winamp.setActive(true);

        // Add IR listeners
        irr.addIRListener(this);
        irr.addIRListener(winamp);
    }

    /*
    -create a new Main instance
    */

    public static void main(String[] argv)
    {
        try
        {
            new Main();
        } catch(Exception e)
        {
            System.out.println(e);
            System.exit(0);
        }
    }

    /*
    -capture control keys and switch between
    main control classes
    */

    public void IRCodeProcess(int code,boolean repeat)
    {
        if(repeat) return;
        
        switch(code)
        {
            case JVC.KEY_DISPLAY:
                // Just testing...
                System.out.println("Mode is: "+(mode++));
                
                if(winamp.isActive())
                {
                    winamp.setActive(false);
                }
                else
                {
                    winamp.setActive(true);
                }
                break;        
        }
    }
}