import javax.comm.*;
import java.io.*;
import java.util.*;

public class IRReader implements Runnable
{
	public int numbytes;
    public InputStream comin;
    public SerialPort com;
    public Vector listeners;

	public IRReader() throws Exception
    {
        // Usual parameters
        this("COM1",9600,3);
    }

	public IRReader(String portname,int baud,int numbytes) throws Exception
    {
    	CommPortIdentifier port;

        this.numbytes=numbytes;
        
        try
        {
	        port=CommPortIdentifier.getPortIdentifier(portname);

            com=(SerialPort)port.open("IR",5000);
            com.setSerialPortParams(
            	baud,
                com.DATABITS_8,
                com.STOPBITS_1,
                com.PARITY_NONE);
            com.setFlowControlMode(com.FLOWCONTROL_NONE);
        
			comin=com.getInputStream();
            listeners=new Vector();
            
            Thread t=new Thread(this);
            t.start();
       	}
        catch(Exception e)
        {
            // Print some info
            System.out.println(e);
            throw(e);
        }
    }

    public void addIRListener(IRCodeListener l)
    {
        listeners.addElement(l);
    }

    String hex(byte b)
    {
        final char hex[]={'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};
        int blo,bhi;
        
        blo=b&0x0f;
        bhi=(b>>4)&0x0f;
        
        return ""+hex[bhi]+hex[blo];
    }

    public void run()
    {
        byte[] irdata=new byte[numbytes];
		int off,code;
        boolean repeat;

        while(true)
        {
            try
            {
                off=0;
                
                // Read data
                while(off<numbytes)
                {
                	off+=comin.read(irdata,off,numbytes-off);
                }

                // Get code
                code=0;
                code|=((int)~irdata[1])&0xff;
                code<<=8;
                code|=((int)~irdata[2])&0xff;
                
                // Get repeat
                repeat=irdata[0]==0?false:true;
                
                // Pass data to listeners
                for(int i=0;i<listeners.size();i++)
                {
                    IRCodeListener l=(IRCodeListener)listeners.elementAt(i);
                    l.IRCodeProcess(code,repeat);
                }
            }
            catch(Exception e){}
        }
    }
}