(*
----------------------------------------------------------------------------
 SUPPORT.PAS - Interface unit for the Support TSR program
----------------------------------------------------------------------------
 Copy this file to your unit directory in Turbo Pascal or to the path where
 you will be running your Pascal program.
 Read SUPPORT.DOC for more information about this unit.
----------------------------------------------------------------------------
*)
unit Support;

interface

uses Strings;

const
	USEBIOS = 1;
	USESUPPORT = 2;

var
	SPTcounter : LongInt;
	SPTKeyb : array [0..255] of char;

procedure SPT16bitTimer(frec : LongInt);
procedure SPT8bitTimer(frec : Word);
procedure SPTKeyboard(kstate : Word);
procedure SPTLeave;
function SPTVersion(var year, month : Word) : Word;

implementation

(*
--------------------------------------------------
 SPT16bitTimer: This sub sets the timer frequency
 in 16bit mode.  This can only be done if version
 is 1.50 or better.
--------------------------------------------------
*)
procedure SPT16bitTimer(frec : LongInt);
var
	s, o : Word;
	bequis : Word;
begin
	s := Seg(SPTcounter);
	o := Ofs(SPTcounter);
	bequis := Word(abs(frec - 1) and $ffff);
	asm
		mov ax,s
		mov ds,ax
		mov ax,$100
		mov bx,bequis
		mov cx,$dd01
		mov dx,o
		int $f1
	end;
end;

(*
-------------------------------------------------
 SPT8bitTimer: This sub sets the timer frequency
 in 8 bits. A zero puts it back to normality. If
 Support's version is less than 1.00,  the timer
 will NOT change frequency, but only the special
 counter.
-------------------------------------------------
*)
procedure SPT8bitTimer(frec : Word);
var
	s, o, f : Word;
begin
	s := Seg(SPTcounter);
	o := Ofs(SPTcounter);
	f := $ee00 + (frec and $00ff);
	asm
		mov ax,s
		mov ds,ax
		mov ax,$100
		mov cx,f
		mov dx,o
		int $f1
	end;
end;

(*
-----------------------------------------------------
 SPTKeyboard: This sub sets the control mode for the
 keyboard;   it can be USEBIOS,  USESUPPORT or both,
 like this:
			 SPTKeyboard(USEBIOS + USESUPPORT);
-----------------------------------------------------
*)
procedure SPTKeyboard(kstate : Word);
var
	o, s, k : Word;
begin
	o := Ofs(SPTKeyb[0]);
	s := Seg(SPTKeyb[0]);
	k := kstate;
	asm
		mov ax,s
		mov ds,ax
		xor ax,ax
		mov bx,k
		mov dx,o
		int $f1
	end;
end;

(*
--------------------------------
 SPTLeave:  This sub sets every
 Support function to BIOS state
 so you can exit your program.
--------------------------------
*)
procedure SPTLeave;
var
	v : Word;
	dummy1, dummy2 : Word;
begin
	v := SPTVersion(dummy1, dummy2);
	if v <> 0 then
	begin
		SPTKeyboard(USEBIOS);
		SPT8bitTimer(0);
	end;
end;

(*
---------------------------------------------------
 SPTVersion: This function returns Support version
 number, if it is loaded; else, it returns zero.
 A version number of 0.10 indicates, in fact, any
 version prior to 0.11. You can include parameter
 variables for the year and mont% of release. If
 you do not want those data, just use two zeros.
 The version number will be multiplied by 100.
---------------------------------------------------
*)
function SPTVersion(var year, month : Word) : Word;
var
	s, o, desp : Word;
	aux1, aux2, aux3, aux4 : Word;
	text : array [0..7] of char;
begin
	text[7] := char(0);
	s := MemW[0:$3C6];
	o := $10C;

	for desp := 0 to 6 do
		text[desp] := char(Mem[s:o+desp]);

	if strcomp(text,'SUPPORT') = 0 then
	begin
		asm
			mov ax,$200
			int $f1
			mov aux1,ax
			mov ax,$201
			int $f1
			mov aux2,ax
			mov aux3,bx
			mov aux4,cx
		end;
		if aux1 <> aux2 then
		begin
			SPTVersion := 10;
			year := 2004;
			month := 3;
		end
		else
		begin
			SPTVersion := aux2;
			year := aux3;
			month := aux4 shr 8;
		end;
	end
	else
		SPTVersion := 0;
end;

end.