#define USEBIOS 1
#define USESUPPORT 2

#include <dos.h>
#include <string.h>

unsigned long spt_counter;
char spt_keyb[256];

unsigned int spt_version(unsigned int *year, unsigned int *month) {
	unsigned int far *aux;
	unsigned int s, o, first, second;
	char far *id;

	aux = (unsigned int far *)MK_FP(0, 0x3C6);
	s = *aux;
	o = 0x10C;

	id = (char far *)MK_FP(s, o);
	if (_fstrcmp(id, "SUPPORT")==0) {
		asm {
			mov ax,0x200
			int 0x0f1
			mov first,ax
			mov ax,0x201
			int 0x0f1
			mov second,ax
			mov o,bx
			mov s,cx
		};
		if (first != second) {
			*year = 2004;
			*month = 3;
			return 10;
		} else {
			*year = o;
			*month = s >> 8;
			return first;
		};
	} else
		return 0;
};

void spt_16bit_timer(unsigned long freq) {
	unsigned int s, o, f;

	s = FP_SEG(&spt_counter);
	o = FP_OFF(&spt_counter);
	f = (unsigned int)freq; f--;

	asm {
		push ds
		mov ax,s
		mov ds,ax
		mov ax,0x100
		mov dx,o
		mov bx,f
		mov cx,0x0dd01
		int 0x0f1
		pop ds
	};
};

void spt_8bit_timer(unsigned short freq) {
	unsigned int s, o, f;

	s = FP_SEG(&spt_counter);
	o = FP_OFF(&spt_counter);
	f = (freq & 0x0ff) | 0x0ee00;

	asm {
		push ds
		mov ax,s
		mov ds,ax
		mov ax,0x100
		mov dx,o
		mov cx,f
		int 0x0f1
		pop ds
	};
};

void spt_keyboard(unsigned short kstate) {
	unsigned short s, o;

	s = FP_SEG(spt_keyb);
	o = FP_OFF(spt_keyb);

	asm {
		push ds
		mov ax,s
		mov ds,ax
		xor ax,ax
		mov bx,kstate
		mov dx,o
		int 0x0f1
		pop ds
	};
};

void spt_leave(void) {
	unsigned int v;
	unsigned int *aux;

	v = spt_version(aux, aux);
	if (v != 0) {
		spt_keyboard(USEBIOS);
		spt_8bit_timer(0);
	};
};