DECLARE SUB SPTKeyboard (kstate%)
DECLARE SUB SPT8bitTimer (freq%)
DECLARE FUNCTION SPTVersion! (year%, month%)
'-----------------------------------------------------------------------'
' SUPPORT.BAS - Interface module to the Support TSR program             '
'-----------------------------------------------------------------------'
' QB command line option /L is needed for this module to work.          '
' Read SUPPORT.DOC for more information about this module.              '
'-----------------------------------------------------------------------'

'$INCLUDE: 'qb.bi'
DIM SHARED SPTreg AS RegTypeX, SPTKeyb(256) AS STRING * 1

CONST USEBIOS = 1, USESUPPORT = 2
COMMON SHARED /Support/ SPTKeyb() AS STRING * 1, SPTcounter AS LONG

'--------------------------------------------------'
' SPT16bitTimer: This sub sets the timer frequency '
' in 16bit mode.  This can only be done if version '
' is 1.50 or better.                               '
'--------------------------------------------------'
SUB SPT16bitTimer (freq&)
	SPTreg.ax = &H100
	SPTreg.ds = VARSEG(SPTcounter)
	SPTreg.dx = VARPTR(SPTcounter)
	SPTreg.cx = &HDD01
	SPTreg.bx = ABS(freq& - 1) AND &HFFFF&
	CALL INTERRUPTX(&HF1, SPTreg, SPTreg)
END SUB

'-------------------------------------------------'
' SPT8bitTimer: This sub sets the timer frequency '
' in 8 bits. A zero puts it back to normality. If '
' Support's version is less than 1.00,  the timer '
' will NOT change frequency, but only the special '
' counter.                                        '
'-------------------------------------------------'
SUB SPT8bitTimer (freq%)
	SPTreg.ax = &H100
	SPTreg.ds = VARSEG(SPTcounter)
	SPTreg.dx = VARPTR(SPTcounter)
	SPTreg.cx = &HEE00 OR freq%
	CALL INTERRUPTX(&HF1, SPTreg, SPTreg)
END SUB

'-----------------------------------------------------'
' SPTKeyboard: This sub sets the control mode for the '
' keyboard;   it can be USEBIOS,  USESUPPORT or both, '
' like this:                                          '
'             SPTKeyboard USEBIOS + USESUPPORT        '
'-----------------------------------------------------'
SUB SPTKeyboard (kstate%)
	SPTreg.ax = 0
	SPTreg.bx = kstate%
	SPTreg.ds = VARSEG(SPTKeyb(0))
	SPTreg.dx = VARPTR(SPTKeyb(0))
	CALL INTERRUPTX(&HF1, SPTreg, SPTreg)
END SUB

'--------------------------------'
' SPTLeave:  This sub sets every '
' Support function to BIOS state '
' so you can exit your program.  '
'--------------------------------'
SUB SPTLeave
	v% = SPTVersion(0, 0)
	IF v% THEN
		SPTKeyboard USEBIOS
		SPT8bitTimer 0
	END IF
END SUB

'---------------------------------------------------'
' SPTVersion: This function returns Support version '
' number, if it is loaded; else, it returns zero.   '
' A version number of 0.10 indicates, in fact, any  '
' version prior to 0.11. You can include parameter  '
' variables for the year% and month% of release. If '
' you do not want those data, just use two zeros.   '
'---------------------------------------------------'
FUNCTION SPTVersion (year%, month%)
	DEF SEG = 0
	s% = CVI(CHR$(PEEK(&H3C6)) + CHR$(PEEK(&H3C7)))
	DEF SEG = s%
	o% = &H10C

	b$ = ""
	FOR i% = o% TO o% + 6
		b$ = b$ + CHR$(PEEK(i%))
	NEXT i%
	DEF SEG

	IF b$ = "SUPPORT" THEN
		SPTreg.ax = &H200
		CALL INTERRUPTX(&HF1, SPTreg, SPTreg)
		first% = SPTreg.ax
		SPTreg.ax = &H201
		CALL INTERRUPTX(&HF1, SPTreg, SPTreg)
	   
		IF SPTreg.ax <> first% THEN
			SPTVersion = .1
			year% = 2004
			month% = 3
		ELSE
			SPTVersion = SPTreg.ax / 100
			year% = SPTreg.bx
			month% = SPTreg.cx \ 256
		END IF
	ELSE
		SPTVersion = 0
	END IF
END FUNCTION

