;---------------------------------------------------;
; SUPPORT.ASM - ISR support for games. Version 0.11 ;
; By Lucas Pedrosa (that is, Cas)                   ;
;---------------------------------------------------;
; This little program is meant to provide some help to not very experienced
; game programmers, who want to create something cool NOW (that is, before
; learning more complex stuff).
; I originally designed Support to help myself in a project, but I thought
; it could be useful to someone else. Read the DOC file for more information.

		org 100h                ; COM Program
		cmp byte [80h],0        ; Check if there's a commandline
		je load_program
		jmp unload_program

identif:        db 'SUPPORT'
minicounter:    db 0                    ; To count subcycles
frequency:      db 0                    ; Frecuency of "special counter"
p_counter:      dd ?                    ; Pointer to special counter
ex_tempo:       dd ?                    ; Pointer to old timer handler
keyarray:       dd ?                    ; Keyboard array address
keystatus:      db 1                    ; Keyboard status
isextended:     db 0                    ; Extended key flag

;-----------------------------------------------------------------------
control:        ; SERVICE ROUTINE FOR PROGRAM CONTROL
		cmp ah,0                        ; Choose keyboard array
		jne .speed                      ; DS:DX: destination array
		mov [cs:keyarray],dx
		mov ax,ds
		mov [cs:keyarray+2],ax          ; BL: bit 0: old routine on
		mov [cs:keystatus],bl           ;     bit 1: new routine on

.speed:         cmp ah,1                        ; Sets speed and special
		jne .exit                       ; counter.
		mov [cs:frequency],cl           ; CL: frequency (0=don't count)
		mov ax,ds                       ; DS:DX: special counter
		mov [cs:p_counter+2],ax
		mov [cs:p_counter],dx
		mov byte [cs:minicounter],0     ; Initialize minicounter
		cmp cl,0
		je .exit
		mov bx,dx                       ; Initialize special counter
		mov dword [bx],0
		
.exit:
		iret

;-----------------------------------------------------------------------
tempo:          ; TIMER LINK ROUTINE
		push cx
		mov cl,[cs:frequency]
		cmp cl,0
		je .exit
		push eax bx ds
		lds bx,[cs:p_counter]
		mov eax,[bx]
		inc eax
		mov [bx],eax
		mov al,[cs:minicounter]
		inc al
		cmp al,cl
		je .areequal
		mov [cs:minicounter],al
		mov al,20h
		out 20h,al
		pop ds bx eax cx
		iret
.areequal:      xor al,al
		mov [cs:minicounter],al
		
		pop ds bx eax
.exit:          pop cx
.jump:          jmp 0000:0000           ; Jump to old handler

;-----------------------------------------------------------------------
keyboard:       ; KEYBOARD LINK ROUTINE
		push ax
		mov al,[cs:keystatus]
		test al,2
		jz .exit

		push ds
		pusha
		in al,60h
		mov bl,al
		
		in al,61h                       ; This is supposed to be
		or al,82h                       ; done, but it works if you
		out 61h,al                      ; don't. Just in case...
		and al,7h
		out 61h,al

		mov si,[cs:keyarray]
		mov ax,[cs:keyarray+2]
		
		cmp bl,0e0h
		jne .goon
		mov byte [cs:isextended],1
		popa
		pop ds
		jmp .exit
.goon:
		test byte [cs:isextended],1
		jz .notextended
		add si,80h
		mov byte [cs:isextended],0
.notextended:
		mov ds,ax
		xor bh,bh
		test bl,80h
		setz cl
		and bl,7fh
		add si,bx
		mov [si],cl
		popa
		pop ds

.exit:          test al,1
		jz .escape
		pop ax
.jump:          jmp 0000:0000           ; To old handler

.escape:        mov al,20h              ; Say "interrupt=ok" and exit w/o
		out 20h,al              ; executing BIOS routine.
		pop ax
		iret

;-----------------------------------------------------------------------;
;======================== END OF RESIDENT PART =========================;
;-----------------------------------------------------------------------;
load_program:
		mov ah,9
		mov dx,.message
		int 21h
		
		xor ax,ax
		mov fs,ax
		mov bx,8h*4             ; Store old pointers
		mov eax,[fs:bx]
		mov [ex_tempo],eax
		mov [tempo.jump+1],eax
		mov bx,9h*4
		mov eax,[fs:bx]
		mov [keyboard.jump+1],eax
		
		mov dx,tempo            ; Establish new services
		mov ax,2508h
		int 21h

		mov dx,keyboard
		mov ax,2509h
		int 21h
		
		mov ax,25f1h            ; Establish control routine
		mov dx,control
		int 21h

		mov ax,[2ch]            ; Free environment block
		mov es,ax
		mov ah,49h
		int 21h

		mov dx,load_program     ; TSR
		shr dx,4
		inc dx
		mov ax,3100h
		int 21h

.message:       db 0Ah,0Dh,'Support 0.11 - ISR support for games. By Lucas Pedrosa'
		db 0Ah,0Dh,'Resident in memory',0Ah,0Dh,'$'

;-----------------------------------------------------------------------
unload_program:
		mov ah,9
		mov dx,.message
		int 21h
		
		xor ax,ax
		mov fs,ax
		mov bx,[fs:0f1h*4+2]
		mov fs,bx

		mov dx,[fs:ex_tempo]    ; Disable timer routine.
		mov ax,[fs:ex_tempo+2]
		mov ds,ax
		mov ax,2508h
		int 21h
		
		mov dx,[fs:keyboard.jump+1]     ; Disable keyboard routine.
		mov ax,[fs:keyboard.jump+3]
		mov ds,ax
		mov ax,2509h
		int 21h
		
		mov bx,fs               ; Unload code from memory
		mov es,bx
		mov ah,49h
		int 21h
		int 20h                 ; Exit program

.message:       db 0Ah,0Dh,'Support 0.11 - Unloaded from memory',0Ah,0Dh,'$'

