;-----------------------------------------------------------------------------
;
; TSPEC_A1.ASM
;
;       Copyright (c) 1991, 1995-Present  Robert Collins
;
;       You have my permission to copy and distribute this software for
;       non-commercial purposes.  Any commercial use of this software or
;       source code is allowed, so long as the appropriate copyright
;       attributions (to me) are intact, *AND* my email address is properly
;       displayed.
;
;       Basically, give me credit, where credit is due, and show my email
;       address.
;
;-----------------------------------------------------------------------------
;
;       Robert R. Collins               email:  rcollins@x86.org
;
;-----------------------------------------------------------------------------


;---------------------------------------------------------------
; Compiler directives
;---------------------------------------------------------------
	Title	PM_BASICS
	Page	60,132
	.Radix	16
	.286P

;---------------------------------------------------------------
; Equates & local variables
;---------------------------------------------------------------
; I/O Ports
;---------------------------------------------------------------
	Mstrmsk 	equ	021h	; 8259 master mask addr
	KBC_CTL 	equ	060h	; 8042 control port
	KBC_STAT	equ	064h	; 8042 status port
	Cmos_index	equ	070h	; CMOS address port
	Cmos_data	equ	071h	; CMOS data port
	Slv_msk 	equ	0a1h	; 8259 slave mask addr

;---------------------------------------------------------------
; CMOS RAM
;---------------------------------------------------------------
	Shut_down	equ	00fh	; CMOS index for shutdwn
	Type5		equ	5	; Shutdown type-5

;---------------------------------------------------------------
; Keyboard Controller
;---------------------------------------------------------------
	inpt_buf_full	equ	2	; Input buffer full
	Shutdown_CMD	equ	0feh	; Shutdown CMD for KBC
	enable_bit20	equ	0dfh	; enable A20 command
	disable_bit20	equ	0ddh	; disable A20 command

;---------------------------------------------------------------
; Misc
;---------------------------------------------------------------
	CS_access	equ	10011011b ; EXE/READ-only access
	DS_access	equ	10010011b ; R/W Data segment


;---------------------------------------------------------------
; Macro definitions
;---------------------------------------------------------------
Io_delay	macro
	out	0edh,ax 		;; about 1uS delay
	endm

Minit_descriptor	macro	segment,offset,desc_name
	mov	ax,&segment		;; get segment name
	mov	es,ax			;;   to form 32 bit addr
	mov	si,&offset		;;
	Call	Calc_pm_address 	;; calculate 32 bit addr
	mov	&desc_name.Base_A15_A00,ax ;; Save 32-bit linear
	mov	&desc_name.Base_A23_A16,dl ;; segment address in
	mov	&desc_name.Base_A31_A24,dh ;; GDT entry
endm


Mfarjmp macro	destination,selector	;dynamic JMP FAR SEG:OFF
	db	0eah			;; jmp instruction
	dw	offset destination	;; offset word
	dw	selector		;; segment selector word
	endm



;---------------------------------------------------------------
; External segments
;---------------------------------------------------------------
ABS0	SEGMENT AT 0h
	org	  0467h
	PM_Ret_off	  dw	?	; PM ret addr offset
	PM_Ret_seg	  dw	?	; PM ret addr segment
ABS0	ENDS


_DATA	SEGMENT WORD PUBLIC 'DATA'
;---------------------------------------------------------------
; Structure definitions
;---------------------------------------------------------------
    Descriptor	STRUC
	Seg_limit	dw	?	; Segment limit
	Base_A15_A00	dw	?	; A00..A15 of base addr
	Base_A23_A16	db	?	; A16..A23 of base addr
	Access_rights	db	?	; Segment access rights
	GDLimit_A19_A16 db	?	; Granularity, Op-size,
					;   Limit A16..A19
	Base_A31_A24	db	?	; A24..A31 of base addr
    Descriptor	ENDS


    _DWORD	STRUC
	DD_offset	dw	?
	DD_segment	dw	?
    _DWORD	ENDS


;---------------------------------------------------------------
; Global Descriptor Table & pointers
;---------------------------------------------------------------
	GDT_286 Descriptor	<>	; NULL DESCRIPTOR
	CSEG2	Descriptor	<0ffffh,,,CS_access>	; CS
	DSEG2	Descriptor	<0ffffh,,,DS_access>	; DS
	SSEG2	Descriptor	<0ffffh,,,DS_access>	; SS
	ESEG2	Descriptor	<0ffffh,0,10h,DS_access>; 1M
	Gdt286_len	equ	$-Gdt_286

	GDT_PTR Label	Fword
		dw	Gdt286_len-1	; length of table
	GDT_LW	dw	0
	GDT_HB	db	0
		db	0

;---------------------------------------------------------------
; Misc. local variables
;---------------------------------------------------------------
	Mem_buffer	db	400h dup (0)
	Orig_stack	_DWORD <>
	i8259_1 db	?	; Status for master device
	i8259_2 db	?	; Status of slave device
_DATA	ENDS


_TEXT	SEGMENT WORD PUBLIC 'CODE'
	ASSUME CS:_TEXT, DS:_DATA, ES:_DATA, SS:STACK
;---------------------------------------------------------------
; Include subroutines from LISTINGS in the article
;---------------------------------------------------------------
; TSPEC_A1.L1:
;   SETPM_RET_ADDR	GET_INT_STATUS		ENABLE_GATE20
;   SET_SHUTDOWN_TYPE	CALC_PM_ADDRESS 	GATE_A20
;   EMPTY_8042
;---------------------------------------------------------------
	Include TSPEC_A1.L1

;---------------------------------------------------------------
; TSPEC_A1.L3:
;   SET_INT_STATUS	SHUT_A20
;---------------------------------------------------------------
	Include TSPEC_A1.L3

;---------------------------------------------------------------
; TSPEC_A1.L4:
;    PM_BASICS
;---------------------------------------------------------------
	Include TSPEC_A1.L4


_TEXT	ENDS


STACK	SEGMENT PARA STACK 'STACK'
	DW	100H DUP (0)
STACK	ENDS

	END	PM_BASICS
