#ifndef __THREAD_H__
#define __THREAD_H__

#include <signal.h>
#include <sys/time.h>

#ifndef NULL
#define NULL 		0
#endif

#ifndef ITIMER_REAL
#define ITIMER_REAL 	0
#endif

#ifndef ITIMER_VIRTUAL
#define ITIMER_VIRTUAL 	1
#endif

#define SIGVTALRM	26
#define SIGALRM		14
#define NR_SYNC		$0x24
#define _NSIG           64
#define _NSIG_BPW       32
#define _NSIG_WORDS     (_NSIG / _NSIG_BPW)
#define YET_2_RUN	0
#define	RAN		1
#define KERNEL_SPACE 	(0xC0000000)


struct sigframe
{
       	char *pretcode;
       	int sig;
       	struct sigcontext sc;
       	struct _fpstate fpstate;
       	unsigned long extramask[_NSIG_WORDS-1];
       	char retcode[8];
};

struct cached_frame
{
	struct sigcontext sc;
};

		/* Here, starts the THREAD structure */
struct thread {
	void (*entry)();
	int  state;
	char *stack;
	struct cached_frame context;
	struct thread *next, *prev;
	unsigned int stacksize;
};

#endif
