/*
 * Aim:
 *	Demonstrate Multi-threading in Linux-kernel-versrion-2.4.3.
 * Note:
 *	I haven't used any POSIX features. The code heavily depends on
 *	the stack-layout during signal delivery. The code may not run
 *	if the kernel lays out the signal stack differently in future
 *	releases.
 *	This was just to verify my understanding of signal delivery in
 *	Linux kernel 2.4.3
 * Limitations:
 *	1. One cannot pass arguments to threads.. Actually this can be
 *	   cooly done by pushing them into the stack. Thats not a big deal.
 *	   But this version doesn't have it.
 *	2. This is a nasty limitation. Threads can't terminate.. Thats too
 *	   bad. What i need to do is to "push a common return address" before
 *	   passing control to the thread. I should do this. 
 *		
 *	Since I thought, these were periferal issues, i haven't done them
 *	yet. I need to do them one day.
 *
 * Kernel Sources referred: 				entry.S, signal.c
 * 
 * Important Kernel Routines:
 *
 *	0. do_signal	 ->	 Called to deliver signals. Called at the end
 *				 of system calls,interrupts asyncronously.
 *	1. handle_signal ->	 Called from "do_signal".
 *	2. setup_frame	 -> 	 This function dictates the stack-layout during
 *				 signal delivery. Internally uses 
 *				 "save_sigcontext".
 *	3. restore_sigcontext -> Restores the kernel-stack from 
 *				 User-Space. The slightest carelessness
 *				 in this code can provide a big room for
 *				 a Hacker.
 *								Sarnath.K
 */

#include "thread.h"
#include <string.h>
#include <fcntl.h>

#define ASSERT(x)	if ( !(x) ) {\
				printf ("\n Assertion Failed%d\n", __LINE__);\
				sync();\
				exit (1);\
			}

struct thread *head = NULL, *tail = NULL, *current = NULL;
struct cached_frame original_context;
int first = 1;

int thread1();
int thread2();
int thread3();

/*
 *	Disable SIGVTALRM.
 */
void *
cli()
{
	void *retval;

	retval = signal( SIGVTALRM, SIG_IGN);
	if ( retval == SIG_ERR ) {
		printf("\n cli failed\n");
		exit(1);
	}
	return retval;
}

/*
 *	Enable SIGVTALRM.
 */
void 
sti ( void *oldhandler )
{
	void *test;

	test = signal(SIGVTALRM, oldhandler);
	if ( test == SIG_ERR ) {
		printf("\n sti failed\n");
		exit(1);
	}
}

/*
 * 	Functionality:
 * 	Takes a Thread Entry Point and StackSize.
 *	Adds it to the AddressSpaceWide thread queue.
 */
int enqueue ( unsigned long entry, unsigned int stacksize )
{
	struct thread *node;
	void (*oldhandler)();

	oldhandler = cli();

	ASSERT( entry < KERNEL_SPACE );

		/* Allocate for thread structure */
	node = (struct thread *) malloc( sizeof(struct thread) );
	if ( node == NULL )
		return -1;
	memset ( (void *)node, 0, sizeof(struct thread) );
	node->state = YET_2_RUN;	
		/* Allocate for stack */
	node->stack = (char *) malloc (stacksize);
	if ( (node->stack) == NULL )
		return -1;
	node->stacksize = stacksize;
	node->next = node->prev = NULL;
	node->entry = (void *) entry;

		/* Add it to queue */
	if ( head == NULL ) {
		head = tail = node;
		return 0;
	}
	ASSERT ( tail != NULL );

	/* Now, add the process to tail */
	tail->next = node;
	node->prev = tail;
	tail = node;

	ASSERT ( head != node );
	sti(oldhandler);
	return 0;
}

/*
 *	SYNC in data.
 *	Used to sync "printf" output onto screen while debugging.
 *	Can be removed from being called from unnecessary places.
 */
int sync()
{
	int retval;

	asm ("movl $0x24 , %%eax":::"ax"); /* $0x24 = "SYNC" syscall number */
	asm("int $0x80");
	asm ("movl %%eax, %0"::"m"(retval));
	if ( retval != 0) {
		printf("\n SYNC system call failed. retval = %d", retval);
		exit (1);
	}
}

/*
 * Save context of the interrupted (via SIGVTALRM) thread "t"
 */
int
save_context ( struct thread *t , struct sigframe *src )
{
	char *dest;

	dest = (char *) &(t->context);
	memcpy(dest, (char *)((char *)src + 8), sizeof (struct cached_frame));
	return 0;
}

int
retrieve_context( struct thread *t , struct sigframe *dest)
{
	memcpy((char *)((char *)dest+8),(char *)&(t->context),sizeof(struct cached_frame));
	return 0;
}

#define service()	if (current)\
			  next = (current->next == NULL ? head:current->next);\
			else\
			  next = head;

/*
 * If in the kernel, "setup_frame" function is changed then,
 * this code will become non-sense. Just refer "sigframe" structure
 * in the Linux Kernel Source Code for more detail.
 * The code solely depends on the intricacies of signal delivery in
 * Linux. Thanks to Linus for giving some room to play with.
 * A small digress:
 * ===============
 * I started this program to panic the kernel, by corrupting the USER
 * context , the kernel stores in my address-space. he he.. but only 
 * to get a nose-cut. Linux is smart (it needs to be). Oh, That (cs | 3) 
 * in restore_sigcontext :(, he stopped me from acquiring kernel priveleges. 
 * Fine, atleast I learnt something.
 *							Sarnath.K
 */
/*
 * Note:
 * Never use -fomit-frame-pointer while compiling with GCC. That option
 * would preclude the handler from being sane.
 */
int 
handler ( int sig )
{
	struct thread *next;
	struct sigframe *ptr;
	void *oldhandler;
/* 
 * Hack baby hack, ... 
 */
	asm ("movl %ebp, %eax");
	asm ("addl $0x4, %%eax":::"ax");
	asm ("movl %%eax, %0"::"m"(ptr):"ax");
	asm ("":::"memory");

	oldhandler = cli();

	if ( first ) {
		first = 0;
		memcpy((char *)&original_context, (char *)((char *)ptr+8), sizeof(struct  cached_frame));
	}
/* 
 * Achcha..we got the PTR..Now, start the work.
 */
	if ( current == NULL ) {
		service();
		if (  next == NULL ) {
			exit(0);
		} else {
			switch_context(next, ptr);
			current = next;
			next->state = RAN;
			sti(oldhandler);
			sync();
			return 0;
		}
	}

	service();
	ASSERT( next != NULL );
	switch_context (next, ptr);
	current = next;
	next->state = RAN;
	sync();
	sti(oldhandler);
	return 0;
}

int
switch_context ( struct thread *t, struct sigframe *ptr )
{
	/* Save the context, if present. */
	if ( current != NULL )
		save_context ( current ,ptr);
		
	/* Create a context for a YET-2-RUN Thread */
	if ( t->state == YET_2_RUN ) {
		memcpy ((char *)&t->context, (char *)&original_context, sizeof(struct cached_frame));
		t->context.sc.eip = (unsigned int)(t->entry);
		t->context.sc.esp = (unsigned int) (t->stack + t->stacksize - 100);
		t->context.sc.esp_at_signal = t->context.sc.esp;
	}

	/* Retrieve context */
	retrieve_context ( t, ptr);
	sync();
}

struct itimerval timer;


int main()
{
	/* First, create the threads and then STI */

	current = NULL;
	enqueue ((unsigned int)thread1, 10000 );
	enqueue ((unsigned int)thread2, 10000 );
	enqueue ((unsigned int)thread3, 10000 );

	timer.it_interval.tv_sec = 0;
	timer.it_interval.tv_usec = 1000;	/* ClockTick = 1000 MicroSecs */
	timer.it_value.tv_sec = 0;
	timer.it_value.tv_usec = 1000;
	setitimer ( ITIMER_VIRTUAL , &timer, NULL);
	signal( SIGVTALRM , (void *)&handler); /* SIGVTALRM */
	while(1);
	return 0;
}

int thread1()
{
	while (1) {
		printf("\n1st thread");
/*
 *	Add ur code here.	
 */ 
		sync();
	}
}

int thread2()
{
	while (1) {
		printf("\n2nd thread");
/*
 *	Add ur code here.	
 */ 
		sync();
	}
}

int thread3()
{
	while (1) {
		printf("\n3rd thread");
/*
 *	Add ur code here.	
 */ 
		sync();
	}
}
