
                        .286P


;--------------------------------------------------------------------------
;defns of constants,defn of data structures.
;--------------------------------------------------------------------------

DESCRIPTOR  STRUC
        SEG_LIMIT     DW         0
        BASE_LO_WORD  DW         0   ;24-bit address
        BASE_HI_BYTE  DB         0
        ACCESS_RIGHTS DB         0
                      DW       0    ;reserved for intel.
DESCRIPTOR  ENDS


CODE_ACCESS	EQU	10011011b   ;access rights
DATA_ACCESS	EQU	10010011b
PB_SIZE         EQU     26

;protected mode values for segment registers
; CS value contains CS_PVAL during Pmode which indexes the GDT
; where the address, protection info are stored..
;-------------------------------------------
CS_PVAL		EQU     0008H
DS_PVAL		EQU     0010H
SS_PVAL		EQU     0018H
DOS_PVAL	EQU     0020H
PDOS_PVAL	EQU     0028H
VIDEO_PVAL	EQU	0030H




;8259 port addresses.

INTA01		EQU	021H
INTA02		EQU	0A1H

;structure  length of para_block

TL		EQU     25

;process state
;-------------
FIRST_RUN       EQU     00H
EXECUTING       EQU     01H
READY		EQU	02H
DEAD		EQU	03H

PARA_BLOCK 	STRUC
        DUMMY   DW      0000H
        PATHOFF DW      0000H
        PATHSEG DW      0000H
        FCB1OFF DW      0000H
        FCB1SEG DW      0000H
        FCB2OFF DW      0000H
        FCB2SEG DW      0000H
        SPTR    DW      ?
        SSEG    DW      ?
        _IP     DW      ?
        _CS     DW      ?
        PSP     DW      ?
        BANK    DB      ?
        PSTATE  DB      ?
PARA_BLOCK      ENDS


;para block offsets
;------------------
SS_OFF		EQU	16
SP_OFF		EQU	14
PSP_OFF		EQU	22
CS_OFF		EQU	20
IP_OFF		EQU	18
PSTATE_OFF	EQU	25


; Some Macros ..... needed to set interrupt handlers.

SETKBVECT	MACRO
        PUSH    DS
        MOV     AX,_TEXT
        MOV     DS,AX
        MOV     DX,OFFSET NEWKBHANDLER
        MOV     AH,25H
        MOV     AL,09H
        INT     21H
        POP     DS
ENDM

SETDISKVECT	MACRO
        PUSH    DS
        MOV     AX,_TEXT
        MOV     DS,AX
        MOV     DX,OFFSET NEWDISKHANDLER
        MOV     AH,25H
        MOV     AL,13H
        INT     21H
        POP     DS
ENDM



;--------------------------------------------------------------------------

;segments & code starts here.

;--------------------------------------------------------------------------




STACKSG	SEGMENT	STACK	'STACK'

        DW      400 DUP(?)

STACKSG	ENDS



BIOS_DATA	SEGMENT	AT	0040H

                ORG     67H
        IO_ROM_INIT     DW      ?
        IO_ROM_SEG      DW      ?
                ORG     17H
        KBSTATE         DB      ?

BIOS_DATA	ENDS





DATASG	SEGMENT  PARA  PUBLIC	'DATA'
ASSUME  DS:DATASG

        TOTPARA         DW      ?
        OUR_PSP         DW      ?
        CHILD_PSP       DW      ?
        MSG             DB      'A20 CAN"T BE GATED.PREUMABLY SOME HARDWARE PROBS.... $'
        LOADERROR       DB      'ERROR IN LOADING... $'
        COUNT           DW      ?
        DISKBUSY        DB      ?
        SPPTR           DW      ?
        NPROCESS        DW      5       ; This field , needs 2 b changed if u want 2 add more processes
        CURID           DW      0000H
        I82591  DB   ?
        I82592  DB   ?
        PIC1    DB   ?
        PIC2    DB   ?


GDT  	LABEL  BYTE

        GDT1    DESCRIPTOR      <OFFSET GDT_LEN-OFFSET GDT,,,DATA_ACCESS,0> ;gdt
        GDT2    DESCRIPTOR      <OFFSET  CSEG_LEN,,,CODE_ACCESS,0>          ;cs
        GDT3    DESCRIPTOR      <0FFFFH,,,DATA_ACCESS,0>                    ;ds
        GDT4    DESCRIPTOR      <400,,,DATA_ACCESS,0>                       ;ss
        GDT5    DESCRIPTOR      <0ffffh,0000h,00h,DATA_ACCESS,0>            ;dos
        GDT6    DESCRIPTOR      <0ffffh,0000h,00h,DATA_ACCESS,0>            ;pdos
        GDT7    DESCRIPTOR      <4000h,8000h,0Bh,DATA_ACCESS,0>             ;video mem
GDT_LEN		LABEL   BYTE

        PATH            DB      00H,00h,00H
        FCB1            DB      16 DUP(0)
        FCB2            DB      16 DUP(0)

;---------------------------------------------------------------------------
;These should always be in pair.code has been written
;that way. (Progname and ParaBlock)
;Again one has to add Progname and Para_Block inorder to
;add a new process.....
;---------------------------------------------------------------------------

PROGNAME        DB  'TASKS\EDIT.COM',00H
                DB  'TASKS\DR.COM',00H
                DB  'TASKS\s.EXE',00H
                DB  'TASKS\task1.EXE',00H
                DB  'TASKS\HD-COPY.EXE',00H

        TASK1   PARA_BLOCK      < , , , , , , , , , , , , 20H,>
        TASK2   PARA_BLOCK      < , , , , , , , , , , , , 30H,>
        TASK3   PARA_BLOCK      < , , , , , , , , , , , , 40H,>
        TASK4   PARA_BLOCK      < , , , , , , , , , , , , 50H,>
        TASK5   PARA_BLOCK      < , , , , , , , , , , , , 60H,>


;----------------------------------------------------------------------------

        HIBYTE  DB      ?
        LOWORD  DW      ?
        SIS     DW      ?
        DIS     DW      ?
        CXS     DW      ?
        PSTACK  DW      ?               ;This stack, i use while swithcing back 2 real mode.. 
        INCR    DW      ?
        BYTE_CTR  DW    00H
        START_BANK_NO   DB      00H
        END_BANK_NO     DB      00H
        CURPID          DB      0               ;Currently excuting process's ID
                                                ; It's based on the CurPid, i switch
                                                ; Processes
        ID              DW    ?
        PGNO            DW      ?
        DOSBUSY         DW      ?
                        DW      ?
DATA_LEN  	LABEL 	BYTE

DATASG	ENDS


;--------------------------------------------------------------------------

;code area begins here.

;--------------------------------------------------------------------------


_TEXT SEGMENT PARA PUBLIC 'CODE'

        ASSUME  CS:_TEXT,DS:DATASG
        OLDKBHANDLER    DW      ?
                        DW      ?
        OLDDISKHANDLER  DW      ?
                        DW      ?

MAIN:
;fill in descriptors

        MOV     AX,DATASG               ;store our psp address
        MOV     DS,AX
        MOV     OUR_PSP,ES

        MOV     AX,OFFSET CSEG_LEN
        XOR     DX,DX
        MOV     BX,010H
        DIV     BX
        ADD     AX,1
        PUSH    AX
        MOV     BX,_TEXT
        MOV     AX,ES
        SUB     BX,AX
        POP     AX
        ADD     BX,AX
        INC     BX
        MOV     TOTPARA,BX
        MOV     AH,4AH
        INT     21H                    ; reallocate memory.

        MOV     AX,DATASG
        MOV     DS,AX
        MOV     ES,AX



;fill  descriptors
;------------------

        PUSH   DS
        MOV    AX,OFFSET GDT
        PUSH   AX
        CALL   CONVERTO24BITS
        MOV    GDT1.BASE_HI_BYTE,AL
        MOV    GDT1.BASE_LO_WORD,BX
        POP     AX
        POP     AX

        PUSH   CS
        XOR    AX,AX
        PUSH   AX
        CALL   CONVERTO24BITS
        MOV    GDT2.BASE_HI_BYTE,AL
        MOV    GDT2.BASE_LO_WORD,BX
        POP     AX
        POP     AX

        PUSH    DS
        XOR     AX,AX
        PUSH    AX
        CALL    CONVERTO24BITS
        MOV     GDT3.BASE_HI_BYTE,AL
        MOV     GDT3.BASE_LO_WORD,BX
        POP     AX
        POP     AX

        MOV    AX,SS
        PUSH   AX
        XOR    AX,AX
        PUSH   AX
        CALL   CONVERTO24BITS
        MOV    GDT4.BASE_HI_BYTE,AL
        MOV    GDT4.BASE_LO_WORD,BX
        POP    AX
        POP    AX

        MOV     AX,DATASG
        MOV     DS,AX
        MOV     AH,34H
        INT     21H
        MOV     DOSBUSY,BX
        MOV     DOSBUSY+2,ES

        CALL    SWAPOUTALL


        ASSUME  CS:_TEXT

        MOV     AH,35H
        MOV     AL,09H
        INT     21H
        MOV     CS:OLDKBHANDLER,BX
        MOV     CS:OLDKBHANDLER+2,ES
        MOV     AH,35H
        MOV     AL,13H
        INT     21H
        MOV     CS:OLDDISKHANDLER,BX
        MOV     CS:OLDDISKHANDLER+2,ES
        SETKBVECT
        SETDISKVECT


;---------------------------------------------------------------------------
;fill parablocks  & loadnsave
;---------------------------------------------------------------------------



        MOV     AX,DATASG
        MOV     DS,AX
        MOV     ES,AX

        LEA     SI,TASK1
        LEA     DI,PROGNAME
        MOV     CX,NPROCESS

FILLPARAMS:
        LEA     BX,PATH         ;PATH_OFF
        MOV     DS:[SI+2],BX
        LEA     BX,FCB1
        MOV     DS:[SI+6],BX     ;FCB1_OFF
        LEA     BX,FCB2
        MOV     DS:[SI+10],BX    ;FCB2_OFF
        MOV     BX,DATASG
        MOV     DS:[SI+4],BX     ;PATH_SEG
        MOV     DS:[SI+8],BX     ;FCB1_SEG
        MOV     DS:[SI+12],BX    ;FCB2_SEG
        ADD     SI,PB_SIZE

SCAN:
        MOV     AH,DS:BYTE PTR[DI]
        CMP     AH,00H
        JZ      ZEROVAL
        INC     DI
        JMP     SCAN
ZEROVAL:
        INC     DI
        DEC     CX
        JNZ     FILLPARAMS

        XOR     AX,AX
        MOV     COUNT,AX
        LEA     SI,TASK1

;------------------------------------------------------------------------------------
;LOAD PROGRAMS SWAP IT IN PM  AND KILL THEM INSTANTLY.
;------------------------------------------------------------------------------------

LOADLOOP:
        PUSH    SI
        PUSH    COUNT
        CALL    LOADNSAVE
        POP     AX
        POP     SI

        MOV     AX,DATASG
        MOV     DS,AX
        MOV     ES,AX
        MOV     SIS,SI
        MOV     BX,CHILD_PSP
        MOV     ES,BX
        MOV     ES:WORD PTR [0AH],OFFSET RETURNADDRESS
        MOV     ES:WORD PTR [0CH],_TEXT
        MOV     SS,DS:WORD PTR [SI+16]
        MOV     SP,DS:WORD PTR [SI+14]
        MOV     AH,50H
        INT     21H
        MOV     AX,CHILD_PSP
        MOV     DS,AX
        MOV     ES,AX
        XOR     AX,AX
        MOV     AX,4C00H
        INT     21H

RETURNADDRESS:
        MOV     AX,DATASG
        MOV     DS,AX
        MOV     ES,AX
        MOV     SI,SIS
        MOV     AX,STACKSG
        MOV     SS,AX
        MOV     SP,200
        ADD     SI,PB_SIZE
        INC     COUNT
        MOV     AX,COUNT
        CMP     AX,NPROCESS
        JNZ     LOADLOOP
        MOV     TASK1.PSTATE,EXECUTING  ;if u change the value of FIRST_RUN
                                        ;other than 0, here u have to initialize
                                        ;all other Para_Block's PSTATE value to
                                        ;FIRST_RUN here..
        MOV     CURPID,00H
        XOR     AX,AX
        PUSH    AX
        CALL    EXECUTE

ULTEX:

        MOV     AX,DATASG
        MOV     DS,AX
        MOV     ES,AX
        MOV     AX,STACKSG
        MOV     SS,AX
        MOV     SP,300
        LEA     SI,TASK1
        MOV     AX,CURID
        MOV     BX,PB_SIZE
        MUL     BX
        ADD     SI,AX
        MOV     DS:BYTE PTR [SI+PSTATE_OFF],DEAD
        PUSH    CURID
        CALL    NEXTID
        POP     CURID
        CMP     CURID,AX
        JZ      ALLDEAD
        MOV     CURID,AX
        JMP     AFTERDEATH


ALLDEAD:
        MOV     AX,DATASG
        MOV     DS,AX
        MOV     AX,STACKSG
        MOV     SS,AX
        MOV     SP,300
        CALL    SWAPINALL
        MOV     AH,50H          ;Undocumented DOS call. for set_psp function
        MOV     BX,OUR_PSP
        INT     21H
        MOV     AX,4C00H
        INT     21H




;----------------------------------------------------------------------------
EXECUTE	PROC	NEAR
; parameter -> id ( 0,1,2..... Nprocess-1 )
; loads appropriate values in segment regs,SP,
; programs child PSP for  return addresses and
; jumps to program start and executes it.
;----------------------------------------------------------------------------

        ASSUME   DS:DATASG

        MOV      BP,SP
        MOV      AX,[BP+2]
        MOV      BX,DATASG
        MOV     DS,BX
        MOV      ID,AX

        PUSH     ID
        CALL    SWAPIN
        POP     ID

        LEA     SI,TASK1
        MOV     AX,ID
        MOV     BX,PB_SIZE
        MUL     BX
        ADD     SI,AX

;DS:SI contains address of process block of id.

        MOV     BX,DS:[SI+22]
        MOV     ES,BX
        MOV     AH,50H  ;set psp address
        INT     21H
        MOV     ES:WORD PTR [0AH],OFFSET ULTEX
        MOV     ES:WORD PTR [0CH],_TEXT
        MOV     AX,OUR_PSP
        MOV     ES:WORD PTR [16H],AX
        MOV     SS,DS:[SI+16]
        MOV     SP,DS:[SI+14]
        PUSH     DS:[SI+20]
        PUSH     DS:[SI+18]
        MOV      AX,ES
        MOV     DS,AX
        XOR     AX,AX
        XOR     BX,BX
        XOR     CX,CX
        XOR     DX,DX
        XOR     SI,SI
        XOR     DI,DI
        XOR     BP,BP
        RETF            ;This would execute the program ! See the 2 "pushes"
                        ; just above.. They contain the address where 2 land!
EXECUTE	ENDP


;----------------------------------------------------------------------------
NEXTID	PROC	NEAR
;finds the next waiting process & returns id in ax.
;----------------------------------------------------------------------------

        MOV     BP,SP
        MOV       AX,[BP+2]
        INC     AX
        CMP     AX,NPROCESS
        JNE       WITHIN1
        MOV     AX,0000H
WITHIN1:
        MOV     CX,AX
        MOV     BX,PB_SIZE
        MUL     BX
        MOV     SI,OFFSET TASK1
        ADD     SI,AX

LOOPNFIND:
        CMP     CX,CURID
        JE      FOUND
        CMP     DS:BYTE PTR [SI+PSTATE_OFF],DEAD
        JNZ     FOUND
        INC     CX
        CMP     CX,NPROCESS
        JNZ       WITHIN
        MOV     CX,0000H
        LEA     SI,TASK1
        JMP     LOOPNFIND

WITHIN:
        ADD     SI,PB_SIZE
        JMP     LOOPNFIND

FOUND:
        MOV     AX,CX
        RET
NEXTID	ENDP



NEWDISKHANDLER  PROC	NEAR

        ASSUME    DS:DATASG
        CLI
        PUSH    AX
        PUSH    BX
        PUSH    CX
        PUSH    DX
        PUSH    ES
        PUSH    DS
        PUSH      SI
        PUSH    DI
        PUSH    BP
        MOV     AX,DATASG
        MOV     DS,AX
        MOV     SPPTR,SP
        MOV     BP,SP
        MOV     AX,[BP+16]
        MOV     BP,[BP]
        MOV     DISKBUSY,1
        PUSHF                   ;Simulate an "old INT 13h"..
        CALL    CS:DWORD PTR OLDDISKHANDLER
        MOV       DISKBUSY,0
        MOV     BP,SPPTR
        MOV     [BP+16],AX
        MOV     [BP+14],BX
        MOV     [BP+12],CX
        MOV     [BP+10],DX
        MOV     [BP+8],ES
        POP     BP
        POP       DI
        POP       SI
        POP       DS
        POP       ES
        POP       DX
        POP     CX
        POP     BX
        POP     AX
        STI
        IRET
NEWDISKHANDLER  ENDP




;----------------------------------------------------------------------------
NEWKBHANDLER  PROC	NEAR

;task switch upon        ALT+TAB. MAIN CORE ROUTINE 

;----------------------------------------------------------------------------

        ASSUME    DS:DATASG
        CLI
        PUSH    AX
        PUSH    BX
        PUSH    CX
        PUSH    DX
        PUSH    ES
        PUSH    DS
        PUSH      SI
        PUSH    DI
        PUSH    BP
        MOV     AX,DATASG
        MOV     DS,AX
        MOV     BX,DOSBUSY
        MOV     ES,DOSBUSY+2
        CMP     BYTE PTR ES:[BX],0
        JE      SAFEDOS

        ; JMP    NORMALRETURN ...No longer v need 2 check DOSBUSY flag !!
        ; Since v maintain an entire DOS copy in each MB of RAM, no problem.
        ; i maintain it for shrewd source code readers who might suspect a
        ; loop hole here ...

SAFEDOS:
        CMP     DISKBUSY,00H
        JZ      DISKIDLE
        JMP     NORMALRETURN

DISKIDLE:
        IN      AL,60H
        MOV     BX,BIOS_DATA
        MOV     DS,BX
        MOV       BX,OFFSET KBSTATE
        MOV     BL,DS:BYTE PTR [BX]
        AND     BL,08H
        JNZ     ALTPRESSED
        JMP     NORMALRETURN

ALTPRESSED:
        CMP     AL,0FH
        JZ      SWITCHTASK
        JMP       NORMALRETURN


SWITCHTASK:
        MOV     BX,OFFSET KBSTATE
        AND     DS:BYTE PTR [BX],0F7H
        MOV     AX,DATASG
        MOV     DS,AX
        MOV     ES,AX
        MOV     AX,CURID
        MOV     BX,PB_SIZE
        MUL     BX
        LEA     SI,TASK1
        ADD     SI,AX                   ;offset of param block
        MOV     DS:[SI+SS_OFF],SS       ;store stack addresses
        MOV     DS:[SI+SP_OFF],SP
        MOV     DS:BYTE PTR [SI+PSTATE_OFF],READY
        MOV     AX,STACKSG
        MOV     SS,AX
        MOV     SP,300
        PUSH    CURID
        CALL    SWAPOUT
        POP     CURID
        MOV     AX,DATASG
        MOV     DS,AX
        MOV     ES,AX

;save screen...
;-----------
        PUSH    CURID
        CALL    NEXTID
        POP     CURID
        MOV     CURID,AX


AFTERDEATH:
        MOV     CURID,AX
        PUSH    AX
        CALL    SWAPIN
        POP     AX
        MOV     AX,DATASG
        MOV     DS,AX
        MOV     ES,AX
        MOV     AX,CURID
        LEA     SI,TASK1
        MOV     BX,PB_SIZE
        MUL     BX
        ADD     SI,AX
        CMP     DS:BYTE PTR [SI+PSTATE_OFF],READY
        JE        SWITCHSTACK                           ;This is where TaskSwitch occurs
        CMP     DS:BYTE PTR [SI+PSTATE_OFF],FIRST_RUN
        JE        EXECUTETASK

SWITCHSTACK:
        MOV     DX,20H
        MOV     AL,20H
        OUT     DX,AL
        MOV     SS,DS:[SI+SS_OFF]
        MOV     SP,DS:[SI+SP_OFF]
        MOV     DS:BYTE PTR [SI+PSTATE_OFF],EXECUTING
        JMP     NORMALRETURN
        POP     BP
        POP     DI
        POP     SI
        POP     DS
        POP     ES
        POP     DX
        POP     CX
        POP     BX
        POP     AX
        STI
        IRET                    ;Descend via the destination stack..This is exactly
                                ; the place where ctrl reaches next process..


EXECUTETASK:
        STI
        PUSH    CURID
        CALL    EXECUTE
        ;It will never return here ....

NORMALRETURN:
        POP     BP
        POP     DI
        POP     SI
        POP     DS
        POP     ES
        POP     DX
        POP     CX
        POP     BX
        POP     AX
        STI
        JMP     DWORD  PTR CS:OLDKBHANDLER      
NEWKBHANDLER  ENDP





;----------------------------------------------------------------------------
LOADNSAVE	PROC	NEAR
;               i/p -> task1 or task2 . which one should  i load
;		BX ->  OFFSET TASK1
;		DX ->  OFFSET PROGNAME
;		CL ->  BASE_HI_BYTE (starting from (2mb) to E0h (15 mb) )
;               (ROM area is duplicated both at end of 1st MB as well as at
;               end of 16mb.so one can use only upto 15mb at max to be on safer side.
;		LOADED PROGRAM'S' PSP WILL BE IN VARIABLE CHILD_PSP
;----------------------------------------------------------------------------
        ASSUME  DS:DATASG

        MOV BP,SP
        MOV AX,DATASG
        MOV DS,AX
        MOV AX,[BP+2]
        MOV PGNO,AX
        LEA SI,TASK1
        MOV AX,PGNO
        MOV BX,PB_SIZE
        MUL BX
        ADD SI,AX
        LEA DI,PROGNAME
        XOR  BX,BX

SCAN2:
        CMP  BX,PGNO
        JZ   PROCEED

SCAN1:
        MOV     AH,DS:BYTE PTR[DI]
        CMP     AH,00H
        JZ      ZEROVAL1
        INC     DI
        JMP     SCAN1
ZEROVAL1:
        INC     DI
        INC     BX
        JMP     SCAN2

PROCEED:
        MOV BX,SI
        MOV DX,DI
        MOV AX,4B01H
        INT 21H
        JNC SUCCESS

        MOV     AX,DATASG
        MOV     DS,AX
        MOV     AH,50H
        MOV     BX,OUR_PSP
        INT     21H
        MOV     AH,09H
        LEA     DX,LOADERROR
        INT     21H
        CALL    SWAPINALL
        MOV     AX,4C00H
        INT     21H


SUCCESS:
        MOV AH,62H
        INT 21H

        MOV  CHILD_PSP,BX
        LEA SI,TASK1
        MOV AX,PGNO
        MOV CX,PB_SIZE
        MUL CX
        ADD SI,AX
        ADD SI,22    ;psp
        MOV DS:WORD PTR [SI],BX



;-----------------------------------------------------------------------------

;To call copy which uses protectedmode

;-----------------------------------------------------------------------------
        PUSH PGNO
        CALL SWAPOUT
        POP  PGNO
        RET
LOADNSAVE	ENDP






;----------------------------------------------------------------------------
COPY	PROC	NEAR
;    expects PSP address in stack. start & end
;    copies into protected memory. (which memory bank in BANK_NO)
;    typical call
;	PUSH	START_PSP
;	PUSH	END_PSP
;       MOV	START_BANK_NO,(VALUE)
;       MOV	END_BANK_NO,(VALUE)

;	CALL	COPY
;----------------------------------------------------------------------------

        ASSUME  DS:DATASG

        CLI
        MOV     BP,SP
        MOV     AX,[BP+4]
        MOV     BX,[BP+2]
        SUB     BX,AX
        MOV     AX,DATASG
        MOV     DS,AX
        MOV     BYTE_CTR,BX
        MOV     PSTACK,SP
        PUSH    BP
        MOV     BX,[BP+2]
        PUSH    BX
        XOR     BX,BX
        PUSH    BX
        CALL    CONVERTO24BITS
        MOV     LOWORD,BX
        MOV     HIBYTE,AL
        MOV     AL,START_BANK_NO
        ADD     HIBYTE,AL
        POP     BX
        POP     BX
        POP     BP
        PUSH    BP
        MOV     AX,[BP+4]
        PUSH    AX
        XOR     AX,AX
        PUSH    AX
        CALL    CONVERTO24BITS
        MOV     GDT5.BASE_LO_WORD,BX
        MOV     GDT5.BASE_HI_BYTE,AL
        MOV     AL,START_BANK_NO
        ADD     GDT5.BASE_HI_BYTE,AL
        POP     AX
        POP     AX
        POP     BP
        PUSH    BP
        MOV     AX,[BP+4]
        PUSH    AX
        XOR     AX,AX
        PUSH    AX
        CALL    CONVERTO24BITS
        MOV     GDT6.BASE_LO_WORD,BX
        MOV     GDT6.BASE_HI_BYTE,AL
        MOV     AL,END_BANK_NO
        ADD     GDT6.BASE_HI_BYTE,AL
        POP     AX
        POP     AX
        POP     BP

        CLI
        CALL    SWITCH2PR

        LGDT    FWORD PTR GDT
        MOV     AX,BIOS_DATA
        MOV     DS,AX

        ASSUME  DS:BIOS_DATA
        MOV     IO_ROM_SEG,CS                  ;address to exit from
        MOV     IO_ROM_INIT,OFFSET  REAL_MODE    ; protected to real.
        MOV     AX,0001H
        LMSW    AX           ;load machine status word.


; This is a "far jump" instruction.
        DB      0EAH         ;code prefetched during real mode by instrn prefetch unit
        DW      OFFSET NEXT  ;but only to be executed in
        DW      CS_PVAL      ;protected  mode. & also to clear the
;instrn prefetch queue. & more also to make
;CS=CS_PVAL.(without which system'll try to execute garbage
;but anyhow trapped by 286 to our return address)




NEXT:
;-----------------------------------------------------------------------------
;here is  the code 2 copy

;-----------------------------------------------------------------------------
        ASSUME  DS:DATASG
        CLI
        MOV     AX,SS_PVAL
        MOV     SS,AX
        MOV     SP,300
        MOV     AX,DS_PVAL
        MOV     DS,AX
        MOV     BX,GDT5.BASE_LO_WORD
        MOV     GDT5.BASE_LO_WORD,0000H
        MOV     GDT6.BASE_LO_WORD,0000H

        MOV AX,DOS_PVAL  ;SELECTOR 2  GDT5
        MOV DS,AX
        MOV AX,PDOS_PVAL ;SELECTOR 2  GDT6
        MOV ES,AX

LOOPNCOPY:
        MOV      AL,DS:BYTE PTR [BX]
        MOV      ES:BYTE PTR [BX],AL
        INC      BX
        CMP      BX,0000H
        JNZ      LOOPNCOPY
        MOV      AX,DS_PVAL
        MOV      DS,AX
        INC      DS:GDT5.BASE_HI_BYTE
        INC      DS:GDT6.BASE_HI_BYTE
        MOV      AX,PDOS_PVAL
        MOV      ES,AX
        MOV      AL,DS:GDT5.BASE_HI_BYTE
        MOV      CL,DS:HIBYTE
        MOV      DX,DOS_PVAL
        MOV      DS,DX
        XOR      BX,BX
        CMP      AL,CL
        JNZ  LOOPNCOPY

        MOV      DX,DS_PVAL
        MOV      DS,DX
        MOV  CX,LOWORD
        MOV      DX,DOS_PVAL
        MOV      DS,DX
        MOV      DX,PDOS_PVAL
        MOV      ES,DX
        XOR      BX,BX


LOOPREM:
        MOV      AL,DS:BYTE PTR [BX]
        MOV      ES:BYTE PTR [BX],AL
        CMP      BX,CX
        JZ       BREAK
        INC      BX
        JMP      LOOPREM

BREAK:
;-----------------------------------------------------------------------------

;This is 2 exit the protected mode and back 2 real mode

;-----------------------------------------------------------------------------

        MOV     AL,0FEH   ;out 8042 status port. shut_cmd
        OUT     064H,AL

LOO:
        HLT
        JMP     LOO



REAL_MODE:

        ASSUME  DS:DATASG
        MOV     DX,DATASG
        MOV     DS,DX
        MOV     ES,DX
        MOV     AX,STACKSG
        MOV     SS,AX
        MOV     SP,PSTACK
        MOV     AH,0DDH
        CALL    GATE_A20
        MOV     AL,I82591
        OUT     INTA01,AL
        MOV     AL,I82592
        OUT     INTA02,AL
        STI
        RET
COPY	ENDP


SWAPOUTALL	PROC	NEAR

        ASSUME  DS:DATASG
        XOR     AX,AX
        PUSH    AX
        MOV     AX,OUR_PSP
        PUSH    AX
        MOV     START_BANK_NO,00H
        MOV     END_BANK_NO,070H
        CALL    COPY
        POP     AX
        POP     AX
        MOV     AX,TOTPARA
        ADD     AX,OUR_PSP
        PUSH    AX
        MOV     AX,0A000H
        PUSH    AX
        MOV     START_BANK_NO,00H
        MOV     END_BANK_NO,070H
        CALL    COPY
        POP     AX
        POP     AX
        RET
SWAPOUTALL	ENDP


SWAPINALL	PROC	NEAR

        ASSUME  DS:DATASG
        MOV     AX,DATASG
        MOV     DS,AX
        XOR     AX,AX
        PUSH    AX
        MOV     AX,OUR_PSP
        PUSH    AX
        MOV     START_BANK_NO,070H
        MOV     END_BANK_NO,00H
        CALL    COPY
        POP     AX
        POP     AX
        MOV     AX,TOTPARA
        ADD     AX,OUR_PSP
        PUSH    AX
        MOV     AX,0A000H
        PUSH    AX
        MOV     START_BANK_NO,070H
        MOV     END_BANK_NO,00H
        CALL    COPY
        POP     AX
        POP     AX
        RET
SWAPINALL	ENDP



;----------------------------------------------------------------------------

SWAPOUT PROC NEAR
;This procedure swaps in or swaps out a program using the routine copy
;The parameter is process no

;----------------------------------------------------------------------------

        MOV AX,DATASG
        MOV DS,AX
        MOV BP,SP
        MOV AX,[BP+2]
        MOV ID,AX
        XOR AX,AX
        PUSH AX
        MOV AX,OUR_PSP
        PUSH AX
        MOV START_BANK_NO,00h
        MOV AX,ID
        ADD AX,2
        MOV BX,10H
        MUL BX
        MOV END_BANK_NO,AL
        CALL COPY
        POP  AX
        POP  AX
        MOV     AX,DATASG
        MOV     DS,AX
        LEA SI,TASK1
        MOV AX,ID
        MOV BX,PB_SIZE
        MUL BX
        ADD SI,AX
        ADD SI,22    ;psp
        MOV AX,DS:WORD PTR [SI]
        MOV     AX,TOTPARA
        ADD     AX,OUR_PSP
        PUSH AX
        MOV  AX,0A000H
        PUSH AX
        MOV  START_BANK_NO,0
        MOV  AX,ID
        ADD  AX,2
        MOV  BX,10H
        MUL  BX
        MOV  END_BANK_NO,AL
        CALL COPY
        POP  AX
        POP  AX
        MOV     AX,0B800H
        PUSH AX
        MOV  AX,0C000H
        PUSH AX
        MOV  START_BANK_NO,0
        MOV  AX,ID
        ADD  AX,2
        MOV  BX,10H
        MUL  BX
        MOV  END_BANK_NO,AL
        CALL COPY                       ;Save Video Memory also
        POP  AX
        POP  AX
        RET
SWAPOUT ENDP





;----------------------------------------------------------------------------
SWITCH2PR	PROC	NEAR
; This procedure gates A20 line , saves 8259 status &
; programs CMOS ports for entering into protected mode.

; IMPORTANT NOTE FOR SRC CODE READERS:
; BIOS area for exit address & MSW & GDT aren't' programmmed here inorder
; to maintain generality.They should be done after | before this call appropriately.
;----------------------------------------------------------------------------
        CLI
        MOV     AH,0DFH
        CALL    GATE_A20   ;GATE A20 LINE
        OR      AL,AL
        JZ      OKFINE
        MOV     AH,09H
        LEA     DX,MSG
        INT     21H
        MOV     AX,DATASG
        MOV     DS,AX
        MOV     BX,OUR_PSP
        MOV     AH,50h
        INT     21H
        MOV     AX,4C00H
        INT     21H

OKFINE:

        IN      AL,INTA01
        MOV     I82591,AL
        IN      AL,INTA02
        MOV     I82592,AL
        MOV     AL,00FH          ; shut down command index
        OUT     070H,AL          ; cmos port

        jmp     short dely       ;i/o delay.
dely:
        MOV     AL,5             ; time delay
        MOV     AL,5
        OUT     071H,AL
        STI
        RET
SWITCH2PR	ENDP







;----------------------------------------------------------------------------

SWAPIN PROC NEAR
;This procedure swaps in or swaps out a program using the routine copy
;The parameter is process no

;----------------------------------------------------------------------------

        MOV AX,DATASG
        MOV DS,AX
        MOV BP,SP
        MOV AX,[BP+2]
        MOV ID,AX
        XOR AX,AX
        PUSH AX
        MOV AX,OUR_PSP
        PUSH AX
        MOV END_BANK_NO,0
        MOV AX,ID
        ADD AX,2
        MOV BX,10H
        MUL BX
        MOV START_BANK_NO,AL
        CALL    COPY
        POP     AX
        POP     AX
        LEA SI,TASK1
        MOV AX,ID
        MOV BX,PB_SIZE
        MUL BX
        ADD SI,AX
        ADD SI,22    ;psp
        MOV AX,DS:WORD PTR [SI]
        MOV     AX,TOTPARA
        ADD     AX,OUR_PSP
        PUSH AX
        MOV AX,0A000H
        PUSH AX
        MOV END_BANK_NO,0
        MOV AX,ID
        ADD AX,2
        MOV BX,10H
        MUL BX
        MOV START_BANK_NO,AL
        CALL COPY
        POP AX
        POP AX
        MOV     AX,0B800H
        PUSH AX
        MOV AX,0C000H
        PUSH AX
        MOV END_BANK_NO,0
        MOV AX,ID
        ADD AX,2
        MOV BX,10H
        MUL BX
        MOV START_BANK_NO,AL
        CALL COPY
        POP AX
        POP AX
        RET
SWAPIN ENDP

;----------------------------------------------------------------------------
CONVERTO24BITS  PROC	NEAR
;This procedure expects a segment address and an offset address in the
;stack.it converts it to 24 bits and returns in AL,BX.
;AL -> UPPER 8 BITS, BX->LOWER 16 BITS
;Typical call:
; push  es
; push  bx
; call  converto24bits
;store values
; pop  bx
; pop  es
;----------------------------------------------------------------------------

;    calcn
;    multiply AX by 16. extract upper 4 bits
;    equivalent to ax with f000h .SHR 12.place it somewhere
;    pop bx,ax
; 1. shl ax,4
;    add bx
;    store in bx
ASSUME	DS:DATASG

        MOV     BP,SP
        PUSH    DS
        MOV     AX,DATASG
        MOV     DS,AX
        MOV     INCR,00H
        MOV     AX,SS:WORD PTR [BP+4]
        MOV     BX,SS:WORD PTR [BP+2]
        MOV     CL,4
        SHL     AX,CL
        ADD     BX,AX
        JNC     EXTSEG
        MOV     INCR,01H
EXTSEG:
        MOV     AX,SS:WORD PTR [BP+4]
        AND     AX,0F000H
        MOV     CL,12
        SHR     AX,CL
        ADD     AX,INCR
        POP     DS
RETURN:
        RET
CONVERTO24BITS  ENDP




GATE_A20	PROC	NEAR

        CLI
        CALL    EMPTY_8042
        JNZ     GATE_EXIT
        MOV     AL,0D1H
        OUT     064H,AL      ;8042 status_port(dual in fn. according to r/w status)
        CALL    EMPTY_8042
        JNZ     GATE_EXIT
        MOV     AL,AH
        OUT     060H,AL      ;8042 port_a
        CALL    EMPTY_8042
GATE_EXIT:
        RET
GATE_A20	ENDP



EMPTY_8042	PROC	NEAR
        PUSH    CX
        XOR     CX,CX

E82:
        IN      AL,064H   ;status port 8042
        AND     AL,02H
        LOOPNZ  E82

E83:
        POP     CX
        RET
EMPTY_8042	ENDP
CSEG_LEN:
_TEXT   ENDS
END	MAIN
