unit WinState;
     {Component tp save the window position, size
     and state.
     This component uses the registry for these options
     and can be controlled from within the program.

     Copyright 2001 Ctoan Development
     Author: Mark Oxley}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TWinData = record
    Top : integer;
    Left : integer;
    Width : Integer;
    Height : Integer;
    State : TWindowState;
  end;

  TWinState = class(TComponent)
  private
    { Private declarations }
    fOwnerWindow : TForm;
    fCompany : string;
    fProduct : string;
    fWinPos : boolean;
    fWinSize : boolean;
    fWinState : boolean;
    fRegKey : string;
    fRegName : string;
    procedure Set_Company(NewCompany : string);
    procedure Set_Product(NewProduct : string);
    procedure Set_WinPos(NewWinPos : boolean);
    procedure Set_WinSize(NewWinSize : boolean);
    procedure Set_WinState(NewWinState : boolean);
    procedure SaveRegistryData;
    procedure LoadRegistryData;
  protected
    { Protected declarations }
    procedure Loaded; override;
  public
    { Public declarations }
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
    property Company : string read fCompany write Set_Company;
    property Product : string read fProduct write Set_Product;
    property WindowPosition : boolean read fWinPos write Set_WinPos;
    property WindowSize : boolean read fWinSize write Set_WinSize;
    property WindowState : boolean read fWinState write Set_WinState;
  end;

procedure Register;

implementation

uses Registry;

procedure Register;
begin
  RegisterComponents('Ctoan', [TWinState]);
end;

{ TWinState }

constructor TWinState.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     fCompany:='Ctoan Development';
     fProduct:='My Product';
     fRegName:=Concat(Owner.Name, 'State');
     fOwnerWindow:=(Owner as TForm);
     fWinPos:=True;
     fWinSize:=True;
     fWinState:=True;

end;

destructor TWinState.Destroy;
begin
     SaveRegistryData;
     inherited Destroy;
end;

procedure TWinState.Loaded;
begin
     LoadRegistryData;
end;

procedure TWinState.LoadRegistryData;
var
   RegData : TRegistry;
   WinData : TWinData;
begin
     fRegKey:=Concat('Software\', fCompany, '\', fProduct);
     RegData:=TRegistry.Create;
     RegData.Rootkey:=HKEY_LOCAL_MACHINE;
     RegData.OpenKey(fRegKey, False);
     if RegData.ValueExists(fRegName) then
     begin
          RegData.ReadBinaryData(fRegName, WinData, Sizeof(TWinData));
          if fWinPos then
          begin
             fOwnerWindow.Left:=WinData.Left;
             fOwnerWindow.Top:=WinData.Top;
          end;
          if fWinSize then
          begin
             fOwnerWindow.Width:=WinData.Width;
             fOwnerWindow.Height:=WinData.Height;
          end;
          if fWinState then
             fOwnerWindow.WindowState:=WinData.State;
     end;
     RegData.Free;
end;

procedure TWinState.SaveRegistryData;
var
   RegData : TRegistry;
   WinData : TWinData;
begin
     with WinData do
     begin
          Left:=fOwnerWindow.Left;
          Top:=fOwnerWindow.Top;
          Width:=fOwnerWindow.Width;
          Height:=fOwnerWindow.Height;
          State:=fOwnerWindow.WindowState;
     end;
     fRegKey:=Concat('Software\', fCompany, '\', fProduct);
     RegData:=TRegistry.Create;
     RegData.Rootkey:=HKEY_LOCAL_MACHINE;
     RegData.OpenKey(fRegKey, True);
     RegData.WriteBinaryData(fRegName, WinData, Sizeof(TWinData));
     RegData.Free
end;

procedure TWinState.Set_Company(NewCompany: string);
begin
     fCompany:=NewCompany;
end;

procedure TWinState.Set_Product(NewProduct: string);
begin
     fProduct:=NewProduct;
end;

procedure TWinState.Set_WinPos(NewWinPos: boolean);
begin
     fWinPos:=NewWinPos;
end;

procedure TWinState.Set_WinSize(NewWinSize: boolean);
begin
     fWinSize:=NewWinSize;
end;

procedure TWinState.Set_WinState(NewWinState: boolean);
begin
     fWinState:=NewWinState;
end;

end.
