VERSION 5.00
Begin VB.Form VBQForm 
   Caption         =   "VBQ Demo"
   ClientHeight    =   3675
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   4575
   Icon            =   "VBQForm.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   3675
   ScaleWidth      =   4575
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox txtOPS 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   1440
      Locked          =   -1  'True
      TabIndex        =   16
      TabStop         =   0   'False
      Top             =   2640
      Width           =   975
   End
   Begin VB.CommandButton cmdEmpty 
      Caption         =   "Empty the Queue"
      Height          =   375
      Left            =   2760
      TabIndex        =   14
      Top             =   3120
      Visible         =   0   'False
      Width           =   1455
   End
   Begin VB.TextBox txtCount 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   1440
      Locked          =   -1  'True
      TabIndex        =   9
      TabStop         =   0   'False
      Top             =   2160
      Width           =   975
   End
   Begin VB.TextBox txtDItem 
      Height          =   285
      Left            =   2520
      Locked          =   -1  'True
      TabIndex        =   6
      TabStop         =   0   'False
      Top             =   1680
      Width           =   1935
   End
   Begin VB.TextBox txtQItem 
      Height          =   285
      Left            =   2520
      Locked          =   -1  'True
      TabIndex        =   5
      TabStop         =   0   'False
      Top             =   1200
      Width           =   1935
   End
   Begin VB.TextBox txtDCount 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   1440
      Locked          =   -1  'True
      TabIndex        =   2
      TabStop         =   0   'False
      Top             =   1680
      Width           =   975
   End
   Begin VB.TextBox txtQCount 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   1440
      Locked          =   -1  'True
      TabIndex        =   1
      TabStop         =   0   'False
      Top             =   1200
      Width           =   975
   End
   Begin VB.CommandButton cmdGo 
      Caption         =   "Go"
      Height          =   375
      Left            =   360
      TabIndex        =   0
      Top             =   3120
      Width           =   1095
   End
   Begin VB.Label Label8 
      Alignment       =   1  'Right Justify
      Caption         =   "Q-ops / sec"
      Height          =   255
      Left            =   120
      TabIndex        =   15
      Top             =   2640
      Width           =   1215
   End
   Begin VB.Label lblEmptying 
      Alignment       =   2  'Center
      Caption         =   "Emptying Queue"
      ForeColor       =   &H000000FF&
      Height          =   255
      Left            =   2640
      TabIndex        =   13
      Top             =   2160
      Visible         =   0   'False
      Width           =   1695
   End
   Begin VB.Label Label6 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Using a VB Collection as a General-Purpose Queue"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   14.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FF0000&
      Height          =   735
      Left            =   120
      TabIndex        =   11
      Top             =   110
      Width           =   4335
      WordWrap        =   -1  'True
   End
   Begin VB.Label Label5 
      Alignment       =   1  'Right Justify
      Caption         =   "Q Depth"
      Height          =   255
      Left            =   120
      TabIndex        =   10
      Top             =   2160
      Width           =   1215
   End
   Begin VB.Label Label4 
      Alignment       =   2  'Center
      Caption         =   "Item"
      Height          =   255
      Left            =   2520
      TabIndex        =   8
      Top             =   960
      Width           =   1935
   End
   Begin VB.Label Label3 
      Alignment       =   2  'Center
      Caption         =   "Count"
      Height          =   255
      Left            =   1440
      TabIndex        =   7
      Top             =   960
      Width           =   975
   End
   Begin VB.Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "Dequeuing"
      Height          =   255
      Left            =   120
      TabIndex        =   4
      Top             =   1680
      Width           =   1215
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Queuing"
      Height          =   255
      Left            =   120
      TabIndex        =   3
      Top             =   1200
      Width           =   1215
   End
   Begin VB.Label Label7 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Using a VB Collection as a General-Purpose Queue"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   14.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFC0C0&
      Height          =   735
      Left            =   150
      TabIndex        =   12
      Top             =   135
      Width           =   4335
      WordWrap        =   -1  'True
   End
End
Attribute VB_Name = "VBQForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'VBQueue                        Bob Riemersma 10/14/2001
'                               BVO Computing Services
'                               Haslett, MI
'                               rriemersma@yahoo.com
'
'A demonstration of the use of a VB Collection object as
'a general-purpose first-in, first-out (FIFO) queue.
'
'For actual use the Collection should be wrapped as a class
'with methods such as QInsert, QRemove, and QFlush (and maybe
'QPeek to look at the top item?) as well as properties such
'as QDepth.
'
'For serious use one might want to implement a property such
'as QLimit along with a related event QOverflow.  Just a
'thought.  It is always good to plan for contingencies such
'as runaway memory consumption.
'
'This was left as-is to make it easier for you to play
'with.  Performance seems good though, and memory consumption
'seems quite reasonable.  No obvious leaks were observed in
'testing, but this may vary with VB versions and service
'packs.
'
'VB.Net breaks this concept, due to elimination of the VB
'Collection object and the Variant type it relies upon.
'
'This example intermittently queues and dequeues a series
'of varying-length strings.

Option Explicit
Private colQ As New Collection

Private Sub cmdGo_Click()
    Dim i As Long, j As Long
    Dim lQCount As Long, lDCount As Long
    Dim sItem As String
    Dim dtStart As Date
    Dim lSecs As Long
    
    cmdGo.Enabled = False
    cmdEmpty.Visible = False
    dtStart = Now
    
    'Do this a bunch of times.
    For j = 1 To 200
        'Stuff some things into the queue.
        For i = 1 To 107
            lQCount = lQCount + 1
            ' Build a good sized string to stuff into the queue.
            sItem = "String item " & CStr(lQCount) & Space(50 + i)
            txtQCount.Text = lQCount
            txtQItem.Text = sItem
            colQ.Add sItem
        Next i
        txtCount.Text = colQ.Count
        DoEvents
        'More or less take some stuff out.
        For i = 1 To 50
            sItem = colQ.Item(1)
            colQ.Remove 1
            lDCount = lDCount + 1
            txtDCount.Text = lDCount
            txtDItem.Text = RTrim(sItem)
        Next i
        txtCount.Text = colQ.Count
        DoEvents
        'Stuff some things into the queue.
        For i = 1 To 100
            lQCount = lQCount + 1
            ' Build a good sized string to stuff into the queue.
            sItem = "'Nuther item " & CStr(lQCount) & Space(200 * Rnd + 1)
            txtQCount.Text = lQCount
            txtQItem.Text = sItem
            colQ.Add sItem
        Next i
        txtCount.Text = colQ.Count
        DoEvents
        'Take some stuff out, more or less breaking even
        '(i.e. leave some junk behind to avoid too much
        'symmetry).
        For i = 1 To 150
            sItem = colQ.Item(1)
            colQ.Remove 1
            lDCount = lDCount + 1
            txtDCount.Text = lDCount
            txtDItem.Text = RTrim(sItem)
        Next i
        txtCount.Text = colQ.Count
        DoEvents
        
        'Performance report.
        lSecs = DateDiff("s", dtStart, Now)
        If lSecs > 0 Then
            txtOPS.Text = CLng((lQCount + lDCount) / lSecs)
        End If
    Next j
    
    cmdGo.Enabled = True
    If colQ.Count > 0 Then
        cmdEmpty.Visible = True
    End If
End Sub

Private Sub cmdEmpty_Click()
    lblEmptying.Visible = True
    
    Do
        colQ.Remove 1
        txtCount.Text = colQ.Count
        DoEvents
    Loop Until colQ.Count = 0
    
    lblEmptying.Visible = False
    cmdEmpty.Visible = False
End Sub
