'-------------------------------------------------------------------------
'QuickSort in VBScript!
'
'Bob Riemersma  12/14/2001
'
'This sort subroutine was derived from some VERY old Basic code Microsoft
'once distributed in a set of sample programs delivered with DOS Basics.
'A few tweaks and twists and I ended up with a fairly quick and versatile
'VBScript sort.
'
'It was never designed for extremely long sorts, using a recursive
'implementation of the classic QuickSort algorithm, and it only sorts an
'array of values from the first to the last in ascending order.  If your
'needs are not so modest you might consider bending it to your whim
'rather than starting from scratch on your own.
'
'Bug reports welcome, and look for more goodies at:
'
'            Bob's Beta and Freebies, www.angelfire.com/mi4/bvo

Function QSRandInt(ByVal Lower, ByVal Upper)
	'Returns a random integer greater than or equal to the Lower parameter
	'and less than or equal to the Upper parameter.
	QSRandInt = CInt(Rnd * (Upper - Lower)) + Lower
End Function

Const QSCompLess = -1
Const QSCompEqual = 0
Const QSCompGreater = 1

Function QSCompare(ByVal A, ByVal B, ByVal CompType)
	'Returns a value indicating the relationship between the two parameters
	'A and B.  If CompType is vbBinaryCompare (useful for nearly all data
	'types - numeric or string) a straightforward binary comparison is made.
	'If CompType is vbTextCompare (for strings only) a "text" compare is
	'done, which treats uppercase and lowercase letters as equal.

	If CompType = vbBinaryCompare Then
		If A < B Then
			QSCompare = -1
		ElseIf A = B Then
			QSCompare = 0
		Else
			QSCompare = 1
		End If
	ElseIf CompType = vbTextCompare Then
		QSCompare = StrComp(A, B, vbTextCompare)
	Else
		Err.Raise 5, "QSCompare", "Invalid procedure call or argument"
	End If
End Function

Sub QSSwap(A, B)
	Dim Temp
	
	Temp = B
	B = A
	A = Temp
End Sub

Sub QuickSort(SortArray, ByVal Low, ByVal High, ByVal CompType)
	'QuickSort works by picking a random "pivot" element in SortArray, Then
	'moving every element that is bigger to one side of the pivot, and every
	'element that is smaller to the other side.  QuickSort is then called
	'recursively with the two subdivisions created by the pivot.  Once the
	'number of elements in a subdivision reaches two, the recursive calls end
	'and the array is sorted.
	'
	'CompType may be vbBinaryCompare for numeric or binary string sorts, or
	'vbTextCompare for string sorts where you wish to treat upper and
	'lowercase letters as equal.
	Dim Partition, RandIndex, I, J
	
	If Low < High Then
		If High - Low = 1 Then
			'Only two elements in this subdivision; swap them if they are out of
			'order, then end recursive calls:
			If QSCompare(SortArray(Low), SortArray(High), CompType) = QSCompGreater Then
				QSSwap SortArray(Low), SortArray(High)
			End If
		Else
			'Pick a pivot element at random, then move it to the end:
			RandIndex = QSRandInt(Low, High)
			QSSwap SortArray(High), SortArray(RandIndex)
			Partition = SortArray(High)
			Do
				'Move in from both sides towards the pivot element:
				I = Low
				J = High
				Do While (I < J) And Not _
					(QSCompare(SortArray(I), Partition, CompType) = QSCompGreater)
						I = I + 1
				Loop
				Do While (J > I) And Not _
					(QSCompare(SortArray(J), Partition, CompType) = QSCompLess)
						J = J - 1
				Loop
				If I < J Then
					'If we haven't reached the pivot element, it means that two
					'elements on either side are out of order, so swap them:
					QSSwap SortArray(I), SortArray(J)
				End If
			Loop While I < J
			'Move the pivot element back to its proper place in the array:
			QSSwap SortArray(I), SortArray(High)

			'Recursively call the QuickSort procedure (pass the smaller
			'subdivision first to use less stack space):
			If (I - Low) < (High - I) Then
				QuickSort SortArray, Low, I - 1, CompType
				QuickSort SortArray, I + 1, High, CompType
			Else
				QuickSort SortArray, I + 1, High, CompType
				QuickSort SortArray, Low, I - 1, CompType
			End If
		End If
	End If
End Sub
  