; QuickEdit CMD file template
; Template player 04-14-00
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their command detection.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10
;

; -| Super Motions |--------------------------------------------------------
; The following two have the same name, but different motion.
; Either one will be detected by a "command = TripleKFPalm" trigger.
; Time is set to 20 (instead of default of 15) to make the move easier to do.

; -| Hypers Motions |--------------------------------------------------------
[Command]
name = "Captain Sword" 
command = ~D, DF, F, D, DF, F, x+y
time = 25

[Command]
name = "Shinkku Captain Fire 3" 
command = ~D, DF, F, D, DF, F, z
time = 25

;-| Special Motions |-------------------------------------------------------

[Command]
name = "Captain Fire Fraco"
command = ~D, DF, F, x

[Command]
name = "Captain Fire Medio"
command = ~D, DF, F, y

[Command]
name = "Captain Fire Forte"
command = ~D, DF, F, z

[Command]
name = "Captain Corridor Fraco"
command = ~D, DB, B, x

[Command]
name = "Captain Corridor Medio"
command = ~D, DB, B, y

[Command]
name = "Captain Corridor Forte"
command = ~D, DB, B, z

[Command]
name = "Captain Kick Fraco"
command = ~D, DB, B, a

[Command]
name = "Captain Kick Medio"
command = ~D, DB, B, b

[Command]
name = "Captain Kick Forte"
command = ~D, DB, B, c

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;<-- Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"    ;<-- Required (do not remove)
command = B, B
time = 10

[Command]
name = "Super Pulo"
command = D, U
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery"  ;<-- Required (do not remove)
command = x+y
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Segurar Boto|-----------------------------------------------------------
[Command]
name = "hold_a"  ;<-- Required (do not remove)
command = /$a
time = 1

[Command]
name = "hold_b" ;<-- Required (do not remove)
command = /$b
time = 1

[Command]
name = "hold_c"  ;<-- Required (do not remove)
command = /$c
time = 1

[Command]
name = "hold_x"  ;<-- Required (do not remove)
command = /$x
time = 1

[Command]
name = "hold_y" ;<-- Required (do not remove)
command = /$y
time = 1

[Command]
name = "hold_z"  ;<-- Required (do not remove)
command = /$z
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd"  ;<-- Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback" ;<-- Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup"  ;<-- Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown"  ;<-- ;Required (do not remove)
command = /$D
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.




[Statedef -1]    ;<-- Don't remove this line. It's required by the CMD standard.

; ===========================================================================
; Super Moves
; =====================================

; Super move example.
; Copy, Paste and Uncomment  after the line below for use with other moves.
; ---------------------------------------------------------------------------
;[State -1, SuperMove1]
;type = ChangeState
;value = 4000 
;triggerall = command = "GouBean"   
;trigger1 = statetype = S 
;trigger1 = ctrl

; ===========================================================================
; Special Moves
; =====================================

[State -1, Captain Fire]
type = ChangeState
value = 1000
triggerall = NumProjID(1010) = 0
trigger1 = command = "Captain Fire Fraco"
trigger1 = statetype = S 
trigger1 = ctrl

;------------------------
[State -1, Captain Fire]
type = ChangeState
value = 1005
triggerall = NumProjID(1010) = 0
trigger1 = command = "Captain Fire Medio"
trigger1 = statetype = S 
trigger1 = ctrl

;------------------------
[State -1, Captain Fire]
type = ChangeState
value = 1010
triggerall = NumProjID(1010) = 0
trigger1 = command = "Captain Fire Forte"
trigger1 = statetype = S 
trigger1 = ctrl

; ---------------------------------------------------------------------------

[State -1, Captain Fire]
type = ChangeState
value = 1020
triggerall = NumProjID(1010) = 0
trigger1 = command = "Captain Fire Fraco"
trigger1 = statetype = A 
trigger1 = ctrl

;------------------------
[State -1, Captain Fire]
type = ChangeState
value = 1025
triggerall = NumProjID(1010) = 0
trigger1 = command = "Captain Fire Medio"
trigger1 = statetype = A 
trigger1 = ctrl

;------------------------
[State -1, Captain Fire]
type = ChangeState
value = 1030
triggerall = NumProjID(1010) = 0
trigger1 = command = "Captain Fire Forte"
trigger1 = statetype = A 
trigger1 = ctrl

; ---------------------------------------------------------------------------
[State -1, Captain Corridor Fraco]
type = ChangeState
value = 1050
triggerall = command = "Captain Corridor Fraco"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = Var(20) = 1
trigger2 = MoveContact
trigger3 = statetype != A
trigger3 = MoveContact

;------------------------
[State -1, Captain Corridor Medio]
type = ChangeState
value = 1051
triggerall= command = "Captain Corridor Medio"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = Var(20) = 1
trigger2 = MoveContact
trigger3 = statetype != A
trigger3 = MoveContact

;------------------------
[State -1, Captain Corridor Forte]
type = ChangeState
value = 1052
triggerall = command = "Captain Corridor Forte"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = Var(20) = 1
trigger2 = MoveContact
trigger3 = statetype != A
trigger3 = MoveContact

; ---------------------------------------------------------------------------
[State -1, Captain Corridor Fraco]
type = ChangeState
value = 1100
triggerall = command = "Captain Kick Fraco"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = Var(20) = 1
trigger2 = MoveContact
trigger3 = statetype != A
trigger3 = MoveContact

;------------------------
[State -1, Captain Corridor Medio]
type = ChangeState
value = 1110
triggerall= command = "Captain Kick Medio"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = Var(20) = 1
trigger2 = MoveContact
trigger3 = statetype != A
trigger3 = MoveContact

;------------------------
[State -1, Captain Kick Forte]
type = ChangeState
value = 1120
triggerall = command = "Captain Kick Forte"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = Var(20) = 1
trigger2 = MoveContact
trigger3 = statetype != A
trigger3 = MoveContact

; ===========================================================================
; Basic Moves
; =====================================

; ---------------------------------------------------------------------------
;Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = 100
triggerall = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Run Back
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl


;===========================================================================
;---------------------------------------------------------------------------
[State -1, Soco Fraco]
type = ChangeState
value = 200
triggerall = command = "x"
triggerall = command != "holddown"
triggerall = statetype = S
trigger1 = ctrl
trigger2 = Var(20) = 1
trigger2 = Movecontact
trigger3 = StateNo = 230
trigger3 = MoveContact
trigger3 = StateNo = 210
trigger3 = MoveContact

;---------------------------------------------------------------------------
;Soco Mdio
[State -1, Soco Medio]
type = ChangeState
value = 210
triggerall = command = "y"
triggerall = command != "holddown"
triggerall = statetype = S
trigger1 = ctrl
trigger2 = Var(20) = 1
trigger2 = Movecontact
trigger3 = StateNo = 200
trigger3 = MoveContact
trigger4 = StateNo = 230
trigger4 = MoveContact

;---------------------------------------------------------------------------
;Soco Forte
[State -1, Soco Forte]
type = ChangeState
value = 220
triggerall = command = "z"
triggerall = command != "holddown"
triggerall = statetype = S
trigger1 = ctrl
trigger2 = Var(20) = 1
trigger2 = MoveContact
trigger3 = StateNo = 210
trigger3 = MoveContact

;---------------------------------------------------------------------------
;Chute Fraco
[State -1]
type = ChangeState
value = 230
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = statetype = S
trigger1 = ctrl
trigger2 = Var(20) = 1
trigger2 = Movecontact
trigger3 = StateNo = 200
trigger3 = MoveContact

;---------------------------------------------------------------------------
;Chute Mdio
[State -1]
type = ChangeState
value = 240
triggerall = command = "b"
triggerall = command != "holddown"
triggerall = statetype = S
trigger1 = ctrl
trigger2 = Var(20) = 1
trigger2 = Movecontact
trigger3 = StateNo = 230
trigger3 = MoveContact
trigger4 = StateNo = 210
trigger4 = MoveContact

;---------------------------------------------------------------------------
;Chute Forte
[State -1]
type = ChangeState
value = 245
triggerall = command = "c"
triggerall = command != "holddown"
triggerall = statetype = S
trigger1 = ctrl
trigger2 = Var(20) = 1
trigger2 = Movecontact
trigger3 = StateNo = 240
trigger3 = MoveContact
trigger4 = StateNo = 210
trigger4 = MoveContact

;---------------------------------------------------------------------------
;Taunt
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "start"
trigger1 = statetype = S
trigger1 = ctrl

;===========================================================================
;---------------------------------------------------------------------------
;Crunch - Soco Fraco
[State -1]
type = ChangeState
value = 400
triggerall = command = "x"
triggerall = command = "holddown"
triggerall = statetype = C
trigger1 = ctrl
trigger2 = StateNo = 430
trigger2 = MoveContact

;---------------------------------------------------------------------------
;Soco Mdio
[State -1]
type = ChangeState
value = 410
triggerall = command = "y"
triggerall = command = "holddown"
triggerall = statetype = C
trigger1 = ctrl
trigger2 = StateNo = 400
trigger2 = MoveContact
trigger3 = StateNo = 430
trigger3 = MoveContact

;---------------------------------------------------------------------------
;Soco Forte
[State -1]
type = ChangeState
value = 420
triggerall = command = "z"
triggerall = command = "holddown"
triggerall = statetype = C
trigger1 = ctrl
trigger2 = StateNo = 410
trigger2 = MoveContact
trigger3 = StateNo = 440
trigger3 = MoveContact

;---------------------------------------------------------------------------
;Chute Fraco
[State -1]
type = ChangeState
value = 430
triggerall = command = "a"
triggerall = command = "holddown"
triggerall = statetype = C
trigger1 = ctrl
trigger2 = StateNo = 400
trigger2 = MoveContact

;---------------------------------------------------------------------------
;Chute Mdio
[State -1]
type = ChangeState
value = 440
triggerall = command = "b"
triggerall = command = "holddown"
triggerall = statetype = C
trigger1 = ctrl
trigger2 = StateNo = 410
trigger2 = MoveContact
trigger3 = StateNo = 430
trigger3 = MoveContact

;---------------------------------------------------------------------------
;Chute Forte
[State -1]
type = ChangeState
value = 450
triggerall = command = "c"
triggerall = command = "holddown"
triggerall = statetype = C
trigger1 = ctrl
trigger2 = StateNo = 410
trigger2 = MoveContact
trigger3 = StateNo = 440
trigger3 = MoveContact

;---------------------------------------------------------------------------
;===========================================================================
;Areos
;---------------------------------------------------------------------------
;Soco Fraco
[State -1]
type = ChangeState
value = 600
triggerall = command = "x"
triggerall = Var(22) = 0
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = Var(20) = 1
trigger2 = Movecontact
trigger3 = (Var(21) = 1 && Var(22) = 0) && StateNo != 600
trigger3 = Movecontact
trigger4 = StateNo = 630
trigger4 = Movecontact

;---------------------------------------------------------------------------
;Soco Medio
[State -1]
type = ChangeState
value = 610
triggerall = command = "y"
triggerall = Var(22) = 0
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = Var(20) = 1
trigger2 = Movecontact
trigger3 = (Var(21) = 1 && Var(22) = 0) = 1 && StateNo != 610
trigger3 = Movecontact
trigger4 = StateNo = 600
trigger4 = Movecontact

;---------------------------------------------------------------------------
;Soco Forte
[State -1]
type = ChangeState
value = 620
triggerall = command = "z"
triggerall = Var(22) = 0
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = Var(20) = 1
trigger2 = Movecontact
trigger3 = (Var(21) = 1 && Var(22) = 0) && StateNo != 620 && StateNo != 650
trigger3 = Movecontact
trigger4 = StateNo = 610
trigger4 = Movecontact

;---------------------------------------------------------------------------
;Chute Fraco
[State -1]
type = ChangeState
value = 630
triggerall = command = "a"
triggerall = Var(22) = 0
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = Var(20) = 1
trigger2 = Movecontact
trigger3 = (Var(21) = 1 && Var(22) = 0) = 1 && StateNo != 630
trigger3 = Movecontact
trigger4 = StateNo = 600
trigger4 = Movecontact

;---------------------------------------------------------------------------
;Chute Medio
[State -1]
type = ChangeState
value = 640
triggerall = command = "b"
triggerall = Var(22) = 0
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = Var(20) = 1
trigger2 = Movecontact
trigger3 = (Var(21) = 1 && Var(22) = 0) && StateNO != 640
trigger3 = Movecontact
trigger4 = StateNo = 630
trigger4 = Movecontact

;---------------------------------------------------------------------------
;Chute Forte
[State -1]
type = ChangeState
value = 650
triggerall = command = "c"
triggerall = Var(22) = 0
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = Var(20) = 1
trigger2 = Movecontact
trigger3 = (Var(21) = 1 && Var(22) = 0) && StateNo != 650 && StateNo != 620
trigger3 = Movecontact
trigger4 = StateNo = 640
trigger4 = Movecontact

;---------------------------------------------------------------------------
;Super Pulo
[State -1, Super Pulo]
type = ChangeState
value = 900
triggerall = command = "Super Pulo"
triggerall = StateNo != 900
trigger1 = statetype = S && ctrl