#include "ti82.h"
#include "graph.h"
;all routines in graph.h and graph.inc written by Dines Justensen
;by Gerad Suyderhoud
.org START_ADDR
.db "ZPong! By Gerad Suyderhoud",0
y_paddle_p   = TEXT_MEM+1
enemy_pos    = TEXT_MEM+2
your_pos     = TEXT_MEM+15
e_paddle_p   = TEXT_MEM+3
ballx        = TEXT_MEM+4
bally        = TEXT_MEM+5
balldirx     = TEXT_MEM+6
balldiry     = TEXT_MEM+7
balldis      = TEXT_MEM
your_score   = TEXT_MEM+8
enemy_score  = TEXT_MEM+9
hyperspeed   = TEXT_MEM+10
offballx     = TEXT_MEM+11
offbally     = TEXT_MEM+12
leave        = TEXT_MEM+13
speed        = TEXT_MEM+14
    ld a, 0
    ld (your_score), a
    ld (enemy_score), a
    CALL initialize
    ld hl,$0001
    ld (CURSOR_POS),hl
    set 3,(IY+05)
    ld hl, zpong_title
    ROM_CALL(D_ZT_STR)
    res 3,(IY+05)
    ld hl,$0003
    ld (CURSOR_POS),hl
    ld hl, zpong_Gerad
    ROM_CALL(D_ZT_STR)
    ld hl,$0006
    ld (CURSOR_POS),hl
    ld hl, zpong_version
    ROM_CALL(D_ZT_STR)
    ld a, 4
    ld (speed), a
    CALL GET_KEY
    halt
Disp_Title:
    ROM_CALL(KEY_HAND)
    or a
    jr z, Disp_Title
    sub 143
    ld b, a
    ld a, 10
    sub b
    cp 10
    jr nc, nexust
    cp 1                                                                 
    jr c, nexust
    ld (speed), a
nexust:
    ROM_CALL(CLEARLCD)
    ld a,$8C
    out (2), a
    CALL draw_y_paddle
    CALL draw_e_paddle
    CALL upscore
    CALL DRAWBARRIERS
;##############Main, these routines control and initialize the other ones.
main1:
    CALL getkey
    CALL move_enemy
    CALL getkey
    CALL move_enemy
    CALL upscore
    CALL move_ball
    ld a, (speed)
    ld b, a
speed_loop:
    halt
    djnz speed_loop
    ld a, (leave)
    or a
    jr nz, quit
    jr main1
quit:
   ROM_CALL(CLEARLCD)
   ld hl, $0002
   ld (CURSOR_POS), hl
   set 3,(IY+05)
   ld hl, gover
   ROM_CALL(D_ZT_STR)
   CALL whathappened
   res 3,(IY+05)
   ld b, $FF
disp_end:
   halt
   djnz disp_end
   ROM_CALL(CLEARLCD)
   halt
   ret
;#########################MISC. Undefined routines
whathappened:
    ld a, (your_score)
    cp 5
    jr z, hewin
    ld a, (enemy_score)
    cp 5
    jr z, youwin
    jr youquit
youwin:
    ld hl, $0003
    ld (CURSOR_POS),hl
    ld hl, youwon
    ROM_CALL(D_ZT_STR)
    ret
hewin:
    ld hl, $0003
    ld (CURSOR_POS), hl
    ld hl, loser
    ROM_CALL(D_ZT_STR)
    ret
youquit:
    ld hl, $0003
    ld (CURSOR_POS),hl
    ld hl, dontlooknow
    ROM_CALL(D_ZT_STR)
    ret
upscore:
   ld hl, $0C03
   ld (CURSOR_POS), hl
   ld a, (your_score)
   or a
   jr z, you0
   cp 1
   jr z, you1
   cp 2
   jr z, you2
   cp 3
   jr z, you3
   cp 4
   jr z, you4
   cp 5
   jr z, you5
you0:
   ld hl, zero
   ROM_CALL(D_ZT_STR)
   jr othrscr
you1:
   ld hl, one
   ROM_CALL(D_ZT_STR)
   jr othrscr
you2:
   ld hl, two
   ROM_CALL(D_ZT_STR)
   jr othrscr
you3:
   ld hl, three
   ROM_CALL(D_ZT_STR)
   jr othrscr
you4:
   ld hl, four
   ROM_CALL(D_ZT_STR)
   jr othrscr
you5:
   ld hl, five
   ROM_CALL(D_ZT_STR)
othrscr:
   ld hl, $0203
   ld (CURSOR_POS), hl
   ld a, (enemy_score)
   or a
   jr z, en0
   cp 1
   jr z, en1
   cp 2
   jr z, en2
   cp 3
   jr z, en3
   cp 4
   jr z, en4
   cp 5
   jr z, en5
en0:
   ld hl, zero
   ROM_CALL(D_ZT_STR)
   ret
en1:
   ld hl, one
   ROM_CALL(D_ZT_STR)
   ret
en2:
   ld hl, two
   ROM_CALL(D_ZT_STR)
   ret
en3:
   ld hl, three
   ROM_CALL(D_ZT_STR)
   ret
en4:
   ld hl, four
   ROM_CALL(D_ZT_STR)
   ret
en5:
   ld hl, five
   ROM_CALL(D_ZT_STR)
   ret
die:
    ld a,(ballx)
    cp 45
    jr c, decyou
    jr dechim
decyou:
    ld a,(your_score)
    inc a
    ld (your_score), a
    cp 5
    CALL z, inquit
    jr xyx
dechim:
    ld a, (enemy_score)
    inc a
    ld (enemy_score), a
    cp 5
    CALL z, inquit
xyx:
    CALL initialize
    CALL draw_e_paddle
    CALL draw_y_paddle
    CALL upscore
    CALL DRAWBARRIERS
    ld b, 155
xyxxyx:
    halt
    djnz xyxxyx
    ret
initialize:
    ld a, $80
    ld (y_paddle_p), a
    ld (e_paddle_p), a
    ld a, 53
    ld (enemy_pos), a
    ld (your_pos), a
    ld a, 35
    ld (ballx), a
    ld (bally), a
    ld (offballx), a
    ld (offbally), a
    ld a, 0
    ld (balldirx), a
    ld (balldiry), a
    ld a, 1
    ld (balldis), a
    ld (hyperspeed), a
    ld hl, stballx
    CALL astloop
    ld hl, stbally
    CALL astloop
    ROM_CALL(CLEARLCD)
;    CALL DRAWBARRIERS
    ret
astloop:
    ld b, 4
astloop1:
    ld (hl), a
    inc hl
    djnz astloop1
    ret
hyperspeedlogic:
    ld a, (hyperspeed)
    cp 1
    jr nz, ldhyper1
    ld a, 2
    ld (hyperspeed), a
    ret
ldhyper1:
    ld a, 1
    ld (hyperspeed), a
    ret
inquit:
    ld a, 1
    ld (leave), a
    ret
DRAWBARRIERS:
    ld c, 1
    CALL drawb
    ld c, 2
    CALL drawb
    ld c, 63
    CALL drawb
    ld c, 62
    CALL drawb
    ret
drawb:
    ld b, 95
drawb1:
    CAll Point_on
    djnz drawb1
    ld b, 0
    CALL Point_on
    ret
;########################ROUTINES FOR MOVING THE BALL
move_ball:
    CALL saveball
    ld a, (balldiry)
    or a
    jr z, down
    jr up
up:
    ld a, (balldis)
    ld b, a
    ld a, (bally)
    add a, b
    cp 62
    jr nc, changedown
    ld (bally), a
    ld a, (balldirx)
    or a
    jr z, right
    jr left
down:
    ld a, (balldis)
    ld b, a
    ld a, (bally)
    sub b
    jr c, changeup
    cp 5
    jr c, changeup
    ld (bally), a
    ld a, (balldirx)
    cp 1
    jr z, left
    jr right
left:
    ld a, (hyperspeed)
    ld b, a
    ld a, (ballx)
    sub b
    jr c, changeright
    cp 4
    jr c, changeright
    ld (ballx), a
    CALL drawball
    ret
right:
    ld a, (hyperspeed)
    ld b, a
    ld a, (ballx)
    add a, b
    cp 93
    jr nc, changeleft
    ld (ballx), a
    CALL drawball
    ret
changedown:
    ld a, 0
    ld (balldiry), a
    jr down
changeup:
    ld a, 1
    ld (balldiry), a
    jr up
changeright:
    ld a, 0
    ld (balldirx), a
    CALL check_y_paddle
    jr right
changeleft:
    ld a, 1
    ld (balldirx), a
    CALL check_e_paddle
    jr left
saveball:
    ld a, (stballx)
    ld (offballx), a
    ld a, (stbally)
    ld (offbally), a
    ld hl, stballx
    ld b, 3
saveballx:
    inc hl
    ld a, (hl)
    dec hl
    ld (hl), a
    inc hl
    djnz saveballx
    ld a, (ballx)
    ld (hl), a
    ld hl, stbally
    ld b, 3
savebally:
    inc hl
    ld a, (hl)
    dec hl
    ld (hl), a
    inc hl
    djnz savebally
    ld a, (bally)
    ld (hl), a
    ret
drawball:
    ld a, (ballx)
    ld b, a
    ld a, (bally)
    ld c, a
    CALL Point_on
    dec b
    CALL Point_on
    dec c
    CALL Point_on
    inc b
    CALL Point_on
    ld a, (offballx)
    ld b, a
    ld a, (offbally)
    ld c, a
    CALL Point_off
    dec b
    CALL Point_off
    dec c
    CALL Point_off
    inc b
    CALL Point_off
    ret
subtract:
    ld a, (balldis)
    ld b, a
    ld a, (bally)
    ld h, a
    sub b
    ret c
    cp 2
    ret c
    ld h, a
    ret
addition:
    ld a, (balldis)
    ld b, a
    ld a, (bally)
    ld h, a
    add a, b
    cp 62
    ret nc
    ld h, a
    ret
changedirup:
    ld a, 1
    ld (balldis), a
    ld (balldiry), a
    ret
changedirdown:
    ld a, 1
    ld (balldis), a
    ld a, 0
    ld (balldiry), a
    ret
;######################ROUTINES FOR CHECKING THE PADDLES
check_y_paddle:
    ld a, %01111110
    out (1), a
    in a, (1)
    push af
    bit 3, a
    CALL z, hyperspeedlogic
    pop af
    bit 0, a
    CALL z, hyperspeedlogic
    ld a, (balldiry)
    or a
    CALL z, subtract
    ld a, (balldiry)
    or a
    CALL nz, addition
    ld a, (your_pos)
    add a, 8
    ld c, a
    ld a, 6
    ld b, a
    ld a, h
check_y_paddle1:
    cp c
    jr z, toppart
    dec c
    djnz check_y_paddle1
    ld b, 4
check_y_paddle2:
    cp c
    ret z
    dec c
    djnz check_y_paddle2
    ld b, 6
check_y_paddle3:
    cp c
    jr z, botpart
    dec c
    djnz check_y_paddle3
    CALL die
    ret
check_e_paddle:
    ld a, (balldiry)
    or a
    CALL z, subtract
    ld a, (balldiry)
    or a
    CALL nz, addition
    ld b, 4
    ld a, (enemy_pos)
    add a, 5
    ld c, a
    ld b, 3
    ld a, h
check_e_paddle1:
    cp c
    jr z, toppart
    dec c
    djnz check_e_paddle1
    ld b, 6
check_e_paddle2:
    cp c
    ret z
    dec c
    djnz check_e_paddle2
    ld b, 3
check_e_paddle3:
    cp c
    jr z, botpart
    dec c
    djnz check_e_paddle3
    CALL die
    ret
toppart:
    ld a, (balldiry)
    or a
    jr nz, incballdis
    jr decballdis
botpart:
    ld a, (balldiry)
    or a
    jr nz, decballdis1
    jr incballdis
incballdis:
    ld a, (balldis)
    cp 3
    ret nc
    inc a
    ld (balldis), a
    ret
decballdis:
    ld a, (balldis)
    push af
    dec a
    ld (balldis), a
    pop af
    cp 1
    CALL c, changedirup
    ret
decballdis1:
    ld a, (balldis)
    push af
    dec a
    ld (balldis), a
    pop af
    cp 1
    CALL c, changedirdown
    ret
;######################THE FOLLOWING ROUTINES DEAL WITH THE LEFT PADDLE
getkey:
    ld a, %01111100
    out (1), a
    in a, (1)
    bit 3, a
    jr z, upski
    bit 0, a
    jr z, downski
    bit 6, a
    call z, inquit
    ret
downski:
    ld a, (y_paddle_p)
    cp $AD
    ret z
    inc a
    ld (y_paddle_p), a
    ld a, (your_pos)
    dec a
    ld (your_pos), a
    jr draw_y_paddle
upski:
    ld a, (y_paddle_p)
    cp $7F
    ret z
    dec a
    ld (y_paddle_p), a
    ld a, (your_pos)
    inc a
    ld (your_pos), a
    jr draw_y_paddle
draw_y_paddle:
    ld a, (y_paddle_p)
    ld c, a
    CALL $7F3
    out (10h), a
    inc c
    ld a, $20
    CALL $7F3
    out (10h), a
    CALL $7F3
    in a,(11h)
    CALL $7F3
    in a,(11h)
    ld a, %00000000
    CALL $7F3
    out (11h),a
    ld b, 12
repeat1:
    ld a, c
    CALL $7F3
    out (10h), a
    inc c
    CALL $7F3
    in a,(11h)
    CALL $7F3
    in a,(11h)
    ld a, %01100000
    CALL $7F3
    out (11h),a
    djnz repeat1
    ld a, c
    CALL $7F3
    out (10h), a
    CALL $7F3
    in a, (11h)
    CALL $7F3
    in a, (11h)
    ld a, %00000000
    CALL $7F3
    out (11h),a
    ret
;##########################ROUTINES FOR MOVING TI
move_enemy:
    ld a, (enemy_pos)
    ld b, a
    ld a, (bally)
    cp b
    jr c, enemy_down
    jr nc, enemy_up
    ret
enemy_up:
    ld a, (e_paddle_p)
    cp $7F
    ret z
    dec a
    ld (e_paddle_p), a
    ld a, (enemy_pos)
    inc a
    ld (enemy_pos), a
    jp draw_e_paddle
enemy_down:
    ld a, (e_paddle_p)
    cp $AD
    ret z
    inc a
    ld (e_paddle_p), a
    ld a, (enemy_pos)
    dec a
    ld (enemy_pos), a
    jp draw_e_paddle
draw_e_paddle
    ld a, (e_paddle_p)
    ld c, a
    CALL $7F3
    out (10h), a
    inc c
    ld a, $2B
    CALL $7F3
    out (10h), a
    CALL $7F3
    in a,(11h)
    CALL $7F3
    in a,(11h)
    ld a, %00000000
    CALL $7F3
    out (11h),a
    ld b, 12
repeat2:
    ld a, c
    CALL $7F3
    out (10h), a
    inc c
    CALL $7F3
    in a,(11h)
    CALL $7F3
    in a,(11h)
    ld a, %00000110
    CALL $7F3
    out (11h),a
    djnz repeat2
    ld a, c
    CALL $7F3
    out (10h), a
    CALL $7F3
    in a, (11h)
    CALL $7F3
    in a, (11h)
    ld a, %00000000
    CALL $7F3
    out (11h),a
    ret
#include "graph.inc"
zpong_title:
 .db "P O N G ! !   by",0
zpong_Gerad:
 .db "Gerad Suyderhoud"
 .db "What Speed?(1-9)",0
zpong_version:
 .db "Version 1.12beta",0
youwon:
 .db "You won!!!!!!!!!",0
loser:
 .db "You are a LOSER!",0
dontlooknow:
 .db " You are a tool ",0
gover:
 .db "   Game  Over   ",0
zero:
 .db "0",0
one:
 .db "1",0
two:
 .db "2",0
three:
 .db "3",0
four:
 .db "4",0
five:
 .db "5",0
stballx:
 .db 0,0,0,0
stbally:
 .db 0,0,0,0
.END
;TIMELINE
;11/8, 8:34am-- First version of coding finished, completely un edited
;contains the following functions- speed, AI, diff ball movement off paddle
;score. . . I must check for bugs. Not ready to be assembled, ready to be
;printed, and checked.
;11/8, 4:48pm-- First version checked, nine more routines needed, 4 routines
;eliminated.
;11/9, 11:17am-- Changes made to first version found in editing, I need to
;write the new routines. I hope to be ready to compile it by this evening
;11/9, 11:48am-- Wrote the new routines (I only needed 7 new ones, and
;they were short!!). I have to check everything again
;but the program is almost ready to be compiled. After fixing errors found
;by tasm I will hopefully be able to play test it. However, it is more likely
;that it will crash my calc. TO DO, add two player mode and link mode
;two playermode will be easy, I will have to write two routines, and just
;CALL what I have already written. I'll have to write about eight more routines
;for link mode though.
;NOTE-- Talk to Sam Davies about the T-states for in a,(11h) do I need another
;display delay.
;11/9, 4:32pm Checked again am going to compile it. Probably will crash my calc
;but we will see.:-)
;11/9, 5:43pm Checked through compiler about 150 errors 90% were just not having
;call capitalized. The rest were minor. I had to change some routines because
;Point_on did not use the display like I thought, 0,0 was top right not
; bottom right. I am going to compile and try to play it until it crashes my
;calc, which shouldn't take to long.:-)
;11/9, 5:48pm amazingly it didn't crash my calc. However the paddle drawing
;routine didn't work very well. Plus the first part didn't pause. I need
;to make some other minor changes too.
;11/10 -- checked printed up copy. Made changes. Hopefully the paddle will
;go up when told to do so now. Changed so the paddle test routines should work
; Made minor changes to some more bugs
;11/10, 8:06pm-- typed in changes. Going to compile.
;11/10, 8:16pm-- play tested pong, had many problems that have not been fixed.
;The paddle part is moving up, but doing it wrong, the checking part is doing
;it wrong, and the score tells you you win when you have lost. Oh, whenever the
;ball hits the paddle the calc does all sorts of funky stuff on the rebound off
;of the next wall. Well I will attempt to fix the problems.
;11/11, 9:15am-- spent three hours working on pong this morning. Fixed each
;bug one by one. Almost ready to distribute.
;11/11, 2:16pm-- Re-enabled hyperspeed. I have a releasable version now.
;Just have to write the text file. TO be included in the next six months:
;Two-Player mode, Link mode. This program will be put on hold while I write
;turbo archery, the periodic table (like GFM), and then galaga. Version
;numbers will be like this R.MI where are is the number released, (1 for
;first time released, 2 for second, etc.) MI is the version number for minor
;changes. Also will add random numbers for where the ball starts. I must
; see how zpong does it. Renamed the program zpong82
