         .include "ti82.h"
         .include "keys.inc"

; -------------------------------------> Variables

score    =TEXT_MEM
x        =TEXT_MEM+2
l        =TEXT_MEM+3
r        =TEXT_MEM+4
v        =TEXT_MEM+5
ll       =TEXT_MEM+6
rl       =TEXT_MEM+22

; -------------------------------------> Game startup

         .org     START_ADDR

         .db      "Z-Kart v1.2",0

         LD A,$8C
	   OUT (2),A
         ld       (iy+13),0
         ld       hl,GRAPH_MEM
         ld       (hl),0
         ld       de,GRAPH_MEM+1
         ld       bc,767
         ldir

; -------------------------------------> Title screen

         ROM_CALL(CLEARLCD)
         ld       hl,0
         ld       (CURSOR_ROW),hl
         ld       hl,title_message
         ROM_CALL(D_ZT_STR)


         ld       hl,$0004
         ld       (CURSOR_ROW),hl
         ld       hl,speed_txt
         ROM_CALL(D_ZT_STR)

         ld       hl,$0006
         ld       (CURSOR_ROW),hl
         ld       hl,hitxt
         ROM_CALL(D_ZT_STR)

loopttl: call     GET_KEY
         cp       G_1
         jr       z,speed_1
         cp       G_2
         jr       z,speed_2
         cp       G_3
         jr       z,speed_3
         cp       G_4
         jr       z,speed_4
         cp       G_5
         jr       z,speed_5
         cp       G_CLEAR
         jr       nz,loopttl
         ret

speed_1: ld       hl,0
         ld       de,3000
         jr       start
speed_2: ld       hl,100
         ld       de,2400
         jr       start
speed_3: ld       hl,200
         ld       de,1800
         jr       start
speed_4: ld       hl,300
         ld       de,1200
         jr       start
speed_5: ld       hl,400
         ld       de,600
start:   ld       (score),hl
         ld       (loop+1),de

; -------------------------------------> Initialize game

         ld       hl,TEXT_MEM+2
         ld       (hl),48
         inc      hl
         ld       (hl),24
         inc      hl
         ld       (hl),72
         inc      hl
         inc      hl
         
         ld       a,24
         ld       b,16
lleft:   ld       (hl),a
         inc      hl
         djnz     lleft
         ld       a,72
         ld       b,16
lright:  ld       (hl),a 
         inc      hl
         djnz     lright

         ROM_CALL(CLEARLCD)
; -------------------------------------> Main loop

loop:    ld       bc,1
wait:    dec      bc
         ld       a,b
         or       c
         jr       nz,wait

         ROM_CALL(DISP_GRAPH)     






         ld       hl,$0007
         ld       (CURSOR_ROW),hl
         ld       hl,message
         ROM_CALL(D_ZT_STR)

         LD       HL,$0607
         ld       (CURSOR_ROW),hl
         ld       hl,(score)
         inc      hl
         ld       (score),hl
         ROM_CALL(D_HL_DECI)

         ld       c,25
         ld       a,(x)
         ld       b,a
         call     ptoff
         dec      b
         call     ptoff
         inc      b
         inc      b
         call     ptoff
         dec      b
         inc      c
         call     ptoff
         dec      c
         dec      c
         call     ptoff

         ld       de,GRAPH_MEM
         ld       hl,GRAPH_MEM + 12
         ld       bc,12 * 56
         ldir

         ld       hl,l
         ld       a,(hl)
         inc      hl
         inc      hl
         add      a,(hl)
         dec      hl
         dec      hl
         ld       (hl),a
         ld       b,a
         ld       c,8
         CALL     pton
         inc      hl
         ld       a,(hl)
         inc      hl
         add      a,(hl)
         dec      hl
         ld       (hl),a
         ld       b,a
         ld       c,8
         CALL     pton
         ld       a,%01111110
         out      (1),a
         in       a,(1)
         bit      1,a
         dec      hl
         dec      hl
         jr       nz,no_left
         dec      (hl)
no_left: bit      2,a
         jr       nz,no_right
         inc      (hl)
no_right:ld       a,(hl)
         ld       b,a
         ld       c,25
         call     pton
         dec      b
         call     pton
         inc      b
         inc      b
         call     pton
         dec      b
         inc      c
         call     pton
         dec      c
         dec      c
         call     pton
        
         ld       a,r
         cp       8
         jr       NC,nocc
         ld       hl,dirs
         and      7
         ld       e,a
         ld       d,0
         ADD      hl,de
         ld       a,(hl)
         ld       (v),a
nocc:    ld       hl,l
         ld       a,(hl)
         inc      hl
         cp       8
         jr       nz,noleftb
         inc      hl
         ld       (hl),1
         dec      hl
noleftb: ld       a,(hl)
         inc      hl
         cp       88
         jr       nz,norightb
         ld       (hl),-1
norightb:ld       hl,x
         ld       a,(ll)
         sub      (hl)
         rla
         jr       nc,lose
         ld       a,(rl)
         sub      (hl)
         rla
         jr       c,lose
         ld       hl,TEXT_MEM+7
         ld       de,TEXT_MEM+6
         ld       bc,32
         ldir
         ld       a,%00111111
         out      (1),a
         in       a,(1)
         bit      6,a
         jr z,lose

         ld       hl,l
         ld       a,(hl)
         ld       (ll+15),a
         inc      hl
         ld       a,(hl)
         ld       (rl+15),a
         ld       a,(score)
         and      63
         jr       nz,jloop
         dec      (hl)
         dec      hl
         inc      (hl)
jloop:   jp       loop

;--------------------------------------> Player lost the game

lose:
         ld       hl,0
         ld       (CURSOR_ROW),hl
         ld       hl,lose_
         ROM_CALL(D_ZT_STR)
         ld       hl,(best)
         ld       de,(score)
         CALL     CP_HL_DE
         jr       c,hisc
lwk:     jp       OTH_PAUSE

hisc:
         ld       de,(score)
         ld       (best),de
         ld       de,digits+3
         ld       hl,(score)
         ld       b,4
p_l:     CALL     UNPACK_HL
         add      a,'0'
         ld       (de),a
         dec      de
         djnz     p_l
         ld       hl,0
         ld       (CURSOR_ROW),hl
         ld       hl,hi_msg
         ROM_CALL(D_ZT_STR)
         ld       hl,$600
         ld       (CURSOR_ROW),hl
         ld       hl, name
         push     hl
         ld       b,9
space_loop:
         ld       (hl), ' '
         inc      hl
         djnz     space_loop
         pop      ix

enter_name_loop:
         CALL     GET_KEY
         or       A
         jr       z,enter_name_loop
         cp       G_DEL
         jr       z,backup
         SUB      9
         ret      z
         dec      a
         jp       m,enter_name_loop
         ld       hl,chartable
         ld       e,a
         ld       d,0
         add      hl,de
         ld       a,9
         cp       b
         jr       z,enter_name_loop
         ld       a,(hl)
         or       a
         jr       z,enter_name_loop
         ld       (ix),a
         ROM_CALL(TX_CHARPUT)
         inc      b
         inc      ix
         jr       enter_name_loop
backup:  xor      a
         cp       b
         jr       z,enter_name_loop
         dec      b
         dec      ix
         ld       a,' '

         ld       (ix),a
         ld       hl,CURSOR_COL
         dec      (hl)
         ROM_CALL(TX_CHARPUT)
         dec      (hl)
         jr       enter_name_loop

OTH_PAUSE:
         call     GET_KEY
         cp       G_ENTER
         jr       nz,OTH_PAUSE
         ret
; -------------------------------------> Text messages

hi_msg:  .db      "Name: _________ ",0
lose_:   .db      "YOU LOSE <ENTER>",0
message: .db      "Score:    0!",0

title_message:
         .db      "  Z-Kart  v1.2  "
         .db      " Programmed by  "
         .db      "Patrick Davidson",0
speed_txt:
         .db      "Select Speed 1-5",0
hitxt:
         .db      "  High score:   "
digits:  .db      "1000 / PATRICK D",0
name     =digits+7

; -------------------------------------> Pixel subroutines

ptoff:  
         push bc
         call     FIND_PIXEL         ;Get the pixel offset
         pop bc                ;Get the pixel offset
         ld       de,GRAPH_MEM
         add      hl,de             ;Point into graphics memory   
         cpl                        ;Invert the accumulator
         and      (hl)              ;A now contains the modified screen byte
         ld       (hl),a            ;Write back to screen to update
         ret

pton:    push     hl
         push bc
         call     FIND_PIXEL         ;Get the pixel offset
         pop bc
         ld       de,GRAPH_MEM
         add      hl,de             ;Point into the graphics memory
         or       (HL)              ;A now contains the modified screen byte
         ld       (HL),A            ;Write back to screen to update
         pop      hl
         ret



; -------------------------------------> Data tables

dirs:    .db      -1,1,-1,1,-1,1,0,0

chartable:
         .db      ":WRMH."
         .DB      "..0VQLG!..ZUPKFC"
         .DB      "..YTOJEBX.>SNIDA"
         .DB      ".12345.."

best:    .dw      1000

end:     .end
