;                                          
;                                              
;                                           
;                                          
;                                            

; (c) Tim FitzRandolph, 1996

;Well, I've decided to release the source code to my 1st ZShell game,
;Weave (1.4)...  PLEASE DON'T CUT-AND-PASTE from this code, without giving
;me credit for it!  Well, i guess thats about it, I've added a bunch of
;neat comments, so hopefully you can follow it....

;If this helps you any, please let me know by mailing me at:
;
;timfitz@ix.netcom.com

;thanks!
;-Tim FitzRandolph


#INCLUDE "TI82.H"
#INCLUDE "graph.h"

#INCLUDE "OLDCALL.H"
.org START_ADDR
.DB "Weave 1.3 by Tim FitzRandolph",0
;-------------------------------------------;
;  define memory for all the neat variables ;
;-------------------------------------------;


shipx   = TEXT_MEM      ;ships X position
shipy   = TEXT_MEM+1    ;ships Y position

wall1x  = TEXT_MEM+2    ;wall X and Y positions
wall1y  = TEXT_MEM+3
wall2x  = TEXT_MEM+4
wall2y  = TEXT_MEM+5

score   = TEXT_MEM+$10  ;self explanatory

walljump =TEXT_MEM+$21  ;amount of pixels the walls jump each loop


endit   = TEXT_MEM+$25  ;variable to track quitting
endit2  = TEXT_MEM+$26  ;variable to track DEATH

;-------------------------------------------;
;  Initialize the game variables and stuff  ;
;-------------------------------------------;
InitGame:

        GRAPH_START                          ;set the game to graphics mode

        ld A,5                          ;--INITIALIZE VARIABLES--;
        ld (shipy),A                    ;                        ;
        ld A,55                         ;                        ;
        ld (shipx),A                    ;                        ;
                                        ;                        ;
        ld A,8                          ;                        ;
        ld (wall1x),A                   ;                        ;
        ld A,59                         ;                        ;
        ld (wall2x),A                   ;                        ;
                                        ;                        ;
        ld A,60                         ;                        ;
        ld (wall1y),A                   ;                        ;
        ld A,28                         ;                        ;
        ld (wall2y),A                   ;---done initializing----;

        ld hl,0
        ld (score),hl

;-------------------------------------------;
;     Show the title screen and stuff!!     ;
;-------------------------------------------;
TitleScreen:
        TEXT_START
        set 3,(IY+05)           ;set text to White on Black

        ld hl, $0001                    ;Y=1,x=0
        ld ($800C),hl
        ld hl, blank1
        ROM_CALL(D_ZT_STR)                   ;show +-------------+
        ld hl, $0002                    ;Y=2,X=0
        ld ($800C),hl
        ld hl, weavetitle
        ROM_CALL(D_ZT_STR)                   ;show |   Weave 1.4  |
        ld hl, $0003                    ;Y=3,X=0
        ld ($800C),hl
        ld hl, blank2
        ROM_CALL(D_ZT_STR)               ;show +-------------+

        res 3, (IY+05)          ;reset text to Black on White

        ld hl, $2C14                    ;Y=2C,X=1A
        ld ($8215), hl
        ld hl,author
        ROM_CALL(D_ZM_STR)               ;print author text(menu style)

        ld hl, $3830                    ;Y=38,X=4C
        ld ($8215), hl
        ld hl,enterstring
        ROM_CALL(D_ZM_STR)

WaitKey1:                               ;wait for press of enter key
        call GET_KEY
        cp $09                  ;is ENTER pressed?
        jr z,SpeedScreen        ;yes, so jump to SpeedScreen
        jr WaitKey1             ;no, so try again.

;-------------------------------------------;
;     Show the title screen and stuff!!     ;
;-------------------------------------------;
SpeedScreen:

        ROM_CALL(CLEARLCD)               ;clear the screen

        ld hl, $0120                    ;Y=1,X=2A
        ld ($8215), hl
        ld hl,weavetext
        ROM_CALL(D_ZM_STR)               ;display "W  E  A  V  E" (menu style)

        ld hl, $0A12
        ld ($8215), hl
        ld hl,howfast
        ROM_CALL(D_ZM_STR)               ;display "HOW FAST?"

        ld hl, $1420
        ld ($8215), hl
        ld hl,speeds1
        ROM_CALL(D_ZM_STR)               ;display "MASTER"
        ld hl, $1A20
        ld ($8215), hl
        ld hl,speeds2
        ROM_CALL(D_ZM_STR)               ;display "GOOD"
        ld hl, $2020
        ld ($8215), hl
        ld hl,speeds3
        ROM_CALL(D_ZM_STR)               ;i forget what it says here...
        ld hl, $2620
        ld ($8215), hl
        ld hl,speeds4
        ROM_CALL(D_ZM_STR)               ;and here

        jr SpeedLoop        ;wait for the user's choice



;-------------;
;-------------;
SpeedLoop:
        call GET_KEY            ;check for a keypress
        cp $22                  ;is 1 pressed?
        jr z,speed1              ;yep, so set the speed

        cp $1A                  ;is 2 pressed?
        jr z,speed2               ;yep, so set the speed

        cp $12                  ;is 3 pressed?
        jr z,speed3               ;yep, so set the speed

        cp $23                  ;is 4 pressed?
        jr z,speed4               ;yep, so set the speed

        jr SpeedLoop            ;loop back if no key pressed.


speed1:         ;user chose fastest speed.
        ld A,4
        ld (walljump),A         ;walls will jump 4 pixels each game loop

        jr HowScreen

speed2:         ;user chose fast speed.
        ld A,3                  ;walls will jump 3 pixels each game loop
        ld (walljump),A

        jr HowScreen

speed3:         ;user chose average speed.
        ld A,2
        ld (walljump),A

        jr HowScreen

speed4:         ;user chose slow speed.
        ld A,1
        ld (walljump),A

        jr HowScreen


;-------------------------------------------;
;  Explain to the user the keys and stuff   ;
;-------------------------------------------;
HowScreen:
        ROM_CALL(CLEARLCD)               ;clear the screen

        ld hl, $0120
        ld ($8215), hl
        ld hl,weavetext
        ROM_CALL(D_ZM_STR)               ;diaplay "W E A V E"

        ld hl, $0A1A
        ld ($8215), hl
        ld hl,howtoplay
        ROM_CALL(D_ZM_STR)

        ld hl, $1415
        ld ($8215), hl
        ld hl,keys1
        ROM_CALL(D_ZM_STR)
        ld hl, $1A15
        ld ($8215), hl
        ld hl,keys2
        ROM_CALL(D_ZM_STR)
        ld hl, $2015
        ld ($8215), hl
        ld hl,keys3
        ROM_CALL(D_ZM_STR)


WaitKey2:
        call GET_KEY            ;get keypress
        cp $37          ;EXIT pressed?
        ret z           ;yep, so quit to ZShell
        cp $9           ;ENTER pressed?
        jr z,TheGame    ;yep, so goto the game
        jr WaitKey2     ;nothing pressed, try again



;-------------------------------------------;
;  THE ACTUAL GAME STARTS HERE!!! HOORAY!   ;
;-------------------------------------------;
TheGame:

        ROM_CALL(CLEARLCD)              ;clear the screen

;\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/

GameLoop:                               ;the actual game loop

        CALL_(EraseShip)                ;erase the player
        CALL_(EraseWalls)               ;erase the walls
        CALL_(KeyTest)                  ;test for keypresses

        ld A,(endit)                    ;time to quit?
        cp 1
        JUMP_Z(EndScreen)               ;yep!

        CALL_(DrawShip)                 ;draw the player
        CALL_(MoveWalls)                ;move the walls down
        CALL_(DrawWalls)                ;draw the walls
        CALL_(CheckDeath)               ;see if the player is dead
        ld A,(endit2)
        cp 1                            ;player dead for reals?
        JUMP_Z(EndScreen)               ;okay, quit!

        CALL_(Delay)                    ;pause for a bit
        jr GameLoop                             ;loop back to the top

;\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/





;------------------\
EraseShip:
        ld A,(shipx)
        ld B,A
        ld A,(shipy)
        ld C,A

        CALL_(Point_off)
        dec C
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        dec B
        dec B
        CALL_(Point_off)

        ret
;-------------------/



;------------------\
DrawShip:
        ld A,(shipx)
        ld B,A
        ld A,(shipy)
        ld C,A

        CALL_(Point_on)
        dec C
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        dec B
        dec B
        CALL_(Point_on)

        ret
;-------------------/


;------------------\
EraseWalls:
        ld A,(wall1x)
        ld B,A
        ld A,(wall1y)
        ld C,A
        CALL_(eraseloop)


        ld A,(wall2x)
        ld B,A
        ld A,(wall2y)
        ld C,A
        CALL_(eraseloop)

        ret
;-------------------/
eraseloop:
        CALL_(Point_off)       ;this could have been done with a loop,
        inc B                   ;but at the time I didn't want to figure
        CALL_(Point_off)       ;it all out, so i did it the long way.....
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)
        inc B
        CALL_(Point_off)       ;thats one big wall!
        ret

;------------------\
DrawWalls:
        ld A,(wall1x)
        ld B,A
        ld A,(wall1y)
        ld C,A
        ld h,0
        CALL_(drawloop)


        ld A,(wall2x)
        ld B,A
        ld A,(wall2y)
        ld C,A
        ld h,0
        CALL_(drawloop)

        ret
;-------------------/
drawloop:
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        CALL_(Point_on)
        inc B
        ret

;------------------\
MoveWalls:
        ld A,(wall1y)
        ld B,A
        ld A,(walljump)
        cp $01                  ;jump 1 pixel?
        CALL_Z(move1)
        cp $02                  ;jump 2 pixels?
        CALL_Z(move2)
        cp $03                  ;3?
        CALL_Z(move3)
        cp $04                  ;4?!?
        CALL_Z(move4)
        ld (wall1y),A

        ld B,A
        ld A,0          ;wall all the way down???
        cp B
        CALL_Z(reset1)  ;yep, so reset to the top!
        ld A,1
        cp B
        CALL_Z(reset1)
        ld A,2
        cp B
        CALL_Z(reset1)
        ld A,3
        cp B
        CALL_Z(reset1)


        ld A,(wall2y)
        ld B,A
        ld A,(walljump)
        cp $01
        CALL_Z(move1)
        cp $02
        CALL_Z(move2)
        cp $03
        CALL_Z(move3)
        cp $04
        CALL_Z(move4)
        ld (wall2y),A

        ld B,A
        ld A,0
        cp B
        CALL_Z(reset2)
        ld A,1
        cp B
        CALL_Z(reset2)
        ld A,2
        cp B
        CALL_Z(reset2)
        ld A,3
        cp B
        CALL_Z(reset2)

        ret

move1:
        ld A,B
        dec A   ;move down 1
        ret

move2:
        ld A,B
        dec A   ;move down 2...
        dec A
        ret

move3:
        ld A,B
        dec A   ;3....
        dec A
        dec A
        ret

move4:
        ld A,B
        dec A   ;or 4.
        dec A
        dec A
        dec A
        ret


reset1:
        ld A,63
        ld (wall1y),A   ;reset to the top
        ld A,(wall1x)
        cp $25
        CALL_Z(res1)
        inc a           ;add some to the x
        inc a
        inc a
        inc a
        inc a
        ld (wall1x),A
        ret

res1:
        ld a,0
        ld (wall1x),a
        ret
reset2:
        ld a,63
        ld (wall2y),A
        ld A,(wall2x)
        cp $4
        CALL_Z(res2)
        dec a
        dec a
        dec a
        dec a
        dec a
        dec a
        dec a
        dec a
        ld (wall2x),A
        ret

res2:
        ld a,127
        ld (wall2x),a
        ret



;------------------\
KeyTest:
        ld a,0
        out (1),a
        in a,(1)
        cp 0            ;no keys pressed?
        ret z           ;nope. back to game.
        bit 6,a         ;EXIT (among others) pressed?
        push af
        CALL_Z(QUIT)    ;yep.
        pop af
        bit 1,a         ;LEFT (among others) pressed?
        push af
        CALL_Z(moveleft);yep.
        pop af
        bit 2,a         ;RIGHT (among.. you get the idea.)
        push af
        CALL_Z(moveright)
        pop af

        ret
;-------------------/


QUIT:
        ld A,1          ;set quit variable to 1...
        ld (endit),A
        ret


;------------------\
moveleft:
        ld A,(shipx)
        dec A           ;move ship 3 to the left
        dec A
        dec a
        cp 96
        jr c,moveleftok
        ld a,94
moveleftok:
        ld (shipx),a
        ret
;-------------------/


;------------------\
moveright:
        ld A,(shipx)    ;3 to the right
        inc A
        inc A
        inc a
        cp 96
        jr c,moverightok
        ld a,1
moverightok:
        ld (shipx),a
        ret
;-------------------/



#INCLUDE "GRAPH.INC"
; GetPixel  : This function will get the pixel at b,c into a
; Point_on  : Turn on point in b,c
; Point_off : Turn off point in b,c
; Point_chg : Change point in b,c

;This routine was taken from Magnus Hagander's Useful Zshell Routines page..
;THANK YOU MAGNUS!!!!!!

;PlotPixel:
:
;        ROM_CALL(FIND_PIXEL)
;        ld de,$FC00
;        add hl,de
;        or (HL)
;        ld (HL),A
;        ret


;This routine was taken from Magnus Hagander's Useful Zshell Routines page..
;THANK YOU MAGNUS!!!!!!

;ErasePixel:
:
;        ROM_CALL(FIND_PIXEL)
;        ld de,$FC00
;        add hl,de
;        xor 255
;        and (HL)
;        ld (HL),A
;        ret


;this delay routine is very similar to the one in Mel Tsai's Columns2.asm
;source file.  THANKS! I never would of thought of this for a delay!!!
;THANKS AGAIN!!

Delay:
        ld a,$3F
        ld b,$3F
dloop:
        dec a
        jr nz,dloop
        dec b
        jr nz,dloop
        ret



;This routine was taken from Magnus Hagander's Useful Zshell Routines page..
;THANK YOU MAGNUS!!!!!!

;GetPixel:
;        ROM_CALL(FIND_PIXEL)
;        ld de,$FC00
;        add hl,de
;        and (hl)
;        ret


CheckDeath:
        ld a,(shipy)
        inc a
        inc a
        ld c,a
        ld a,(shipx)
        inc a
        ld b,a

        CALL_(GetPixel)         ;is there a pixel above the ship?
        or 0
        JUMP_NZ(DIE)            ;if so, DIE!


        ld a,(shipy)
        inc a
        inc a
        inc a
        ld c,a
        ld a,(shipx)
        inc a
        ld b,a

        CALL_(GetPixel)
        or 0
        JUMP_NZ(DIE)

        ld a,(shipy)
        inc a
        inc a
        inc a
        inc a
        ld c,a
        ld a,(shipx)
        inc a
        ld b,a

        CALL_(GetPixel)
        or 0
        JUMP_NZ(DIE)

        ret

DIE:
        ROM_CALL(CLEARLCD)       ;clear the screen...
        set 3,(IY+05)

        ld hl, $0001                    ;draw more text....
        ld ($800C), hl
        ld hl,thanx1
        ROM_CALL(D_ZT_STR)

        res 3,(IY+05)
        ld hl, $1520
        ld ($8215),hl
        ld hl, die1
        ROM_CALL(D_ZM_STR)
        ld hl, $3A29
        ld ($8215),hl
        ld hl, die2
        ROM_CALL(D_ZM_STR)
WaitLoopEnd:
        call GET_KEY
        cp $9
        jr z,nextend
        jr WaitLoopEnd

nextend:
        ld A,1
        ld (endit2),A
        ret

;------------------------------;
; Thank you screen and stuff   ;
;------------------------------;
EndScreen:

        ROM_CALL(CLEARLCD)       ;more neat text screens....

        set 3,(IY+05)

        ld hl, $0001
        ld ($800C), hl
        ld hl,thanx1
        ROM_CALL(D_ZT_STR)

        res 3,(IY+05)

        ld hl, $0003
        ld ($800C), hl
        ld hl,thanx2
        ROM_CALL(D_ZT_STR)

        ld hl, $0005
        ld ($800C), hl
        ld hl,thanx3
        ROM_CALL(D_ZT_STR)

        ld hl, $0006
        ld ($800C), hl
        ld hl,thanx4
        ROM_CALL(D_ZT_STR)

WaitKey5:
        call GET_KEY
        cp $09
        jr z,ENDITOKAY
        jr WaitKey5


ENDITOKAY:
        ret z



;Here is all of the text in the game..... PLEASE DO NOT CHANGE ANY OF THIS
;STUFF!!!!! (although you can change the difficulty settings if you want..

blank1:                 .db "+--------------+",0
blank2:                 .db "+--------------+",0
weavetitle:             .db "|  Weave  1.4  |",0
author:                 .db "Tim FitzRandolph",0
enterstring:            .db "press ",$0C1,"ENTER",$05D,0
scorestr:               .db "score:",0

weavetext:              .db "W   E   A   V  E",0
howfast:                 .db "Choose your ability.",0
speeds1:                 .db "1) Master",0
speeds2:                 .db "2) Good",0
speeds3:                 .db "3) Average",0
speeds4:                 .db "4) Pathetic",0

howtoplay:               .db "HOW  TO  PLAY",0
keys1:                   .db "LEFT - move left",0
keys2:                   .db "RIGHT- move right",0
keys3:                   .db "EXIT - quit",0

thanx1:         .db " W E A V E  1.4 ",0
thanx2:         .db " SPECIAL THANKS ",0
thanx3:         .db "Magnus Hagander ",0
thanx4:         .db "    Mel Tsai    ",0


blank:          .db "                  ",0
die1:           .db "    C R A S H !   ",0
die2:           .db "   press ",$0C1,"ENTER",$05D,0


;OH BOY! THE END!!! YEAH!!

.end

