; Wave v1.0
;
;By dEnNiS LaMbE Jr. in Ti-Basic
;malsyned@i84.net
;Adapted to CrAsh v1.3 by Eric Piel on July 98

#INCLUDE "CRASH82.INC"
Title:
.db "WaVe",0
;*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
; 		Memory Allocations
;*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
CrossY		=	TEXT_MEM
CrossX		=	CrossY + 1
OddY		=	CrossY + 2
OddX		=	OddY + 1	
Points		=	OddY + 2	; Points in a game
Time		=	Points + 1
Pattern		=	Points + 2	; 2 bytes	Address

PutPattern:
	ld	hl,Pat1
	ld	(Pattern),hl

Start:
	set	3,(IY+$05)	;set text to White on Black
;	set	1,(IY+$05)	;Display the entire 7 rows of the character
	res	1,(IY+$0D)	;Don't alter text memory with writes


	call	CR_GRBCopy

	ld	hl,0600h
	ld 	(CURSOR_POS),hl
	ld	HL,Title
	ROM_CALL(D_ZT_STR)

	ld	hl,0305h
	ld 	(CURSOR_POS),hl
	ld	HL,msgPattern
	ROM_CALL(D_ZT_STR)

	res	3,(IY+05)

	ld	hl,0002h
	ld 	(CURSOR_POS),hl
	ld	HL, msgAuthor
	ROM_CALL(D_ZT_STR)

	ld	a,221
	ld	(Points),a

Update_Pattern:
	ld	hl,0C05h
	ld 	(CURSOR_POS),hl
	ld	hl,(Pattern)
	ROM_CALL(D_ZT_STR)

Options_Test:
	call	CR_KHAND
	cp	K_MODE
	ret	z
	ld	hl,(Pattern)
	cp	K_ENTER
	jr	z,Initialize
	ld	bc,3
	cp	K_RIGTH
	jr	z,NextPat
	cp	K_LEFT
	jr 	nz,Options_Test

PrevPat:
	ld	de,Pat1
	call	CP_HL_DE
	jr	z,Options_Test
	sbc	hl,bc
	jr	FinishPat
NextPat:
	ld	de,Pat11
	call	CP_HL_DE
	jr	z,Options_Test
	add	hl,bc


FinishPat:
	ld	(Pattern),hl	
	jr	Update_Pattern

Initialize:
	call	CR_GRBCopy
	ld	hl,0103h
	ld 	(CURSOR_POS),hl
	ld	hl,msgReady
	ROM_CALL(D_ZT_STR)
	ld	b,090h
DisplayMsgReady:
	halt
	djnz	DisplayMsgReady

	ld	hl,0
	ld 	(CURSOR_POS),hl
	ld	hl,(Pattern)
	ld	c,8

	res	2,(IY+$0D)	;Don't scroll
IniBigLoop:
	ld	a,(CURSOR_ROW)
	rra
	jr	nc,IniAddHL
	dec	hl
	dec	hl

IniAddHL:
	inc	hl
	ld	a,(hl)
	ld	b,16
IniSmallLoop:
	ROM_CALL(TX_CHARPUT)
	djnz	IniSmallLoop

	dec	c
	jr	nz,IniBigLoop
	push	hl	;save pattern

	set	2,(IY+$0D)	;scroll

	ld	hl,0703h
	ld 	(CURSOR_POS),hl
	ld	(CrossY),hl
	ex	de,hl
	ld	a,09h	;'*'
	ROM_CALL(TR_CHARPUT)

PutOdd:
	call	RAND
	and	0Fh
	ld	h,a
	call	RAND
	and	7h
	ld	l,a
	call	CP_HL_DE
	jr	z,PutOdd
	ld	(CURSOR_POS),hl
	ld	(OddY),hl
	pop	hl
	ld	a,(CURSOR_ROW)
	rra
	jr	nc,PutOddNotAddHL
	inc	hl
PutOddNotAddHL:
	ld	a,(hl)
	ROM_CALL(TR_CHARPUT)

	ld	a,02Ch
	ld	(Time),a

Begin: 

	ld	a,(Points)
	cpl
	ld	b,a
Delay:
	halt
	djnz	Delay

KeyLoopGame:
	call	GET_KEY
	cp	G_MODE
	ret	z
	ld	hl,(CrossY)
	dec	a
	jr	z,Down
	dec	a
	jr	z,Left
	dec	a
	jr	z,Right
	dec	a
	jr	nz,AfterKey

Up:
	ld	a,l
	or	a
	jr	z,Begin
	dec	l
	jr	EndKeyLoopGame
Down:

	ld	a,l
	cp	7
	jr	z,AfterKey
	inc	l
	jr	EndKeyLoopGame
Right:
	ld	a,h
	cp	15
	jr	z,AfterKey
	inc	h
	jr	EndKeyLoopGame
Left:
	ld	a,h
	or	a
	jr	z,AfterKey
	dec	h

EndKeyLoopGame:
	ex	de,hl
	ld	hl,(CrossY)
	ld 	(CURSOR_POS),hl

	ld	hl,(Pattern)
	ld	a,(CURSOR_ROW)
	rra
	jr	c,EKLNotAddHL
	inc	hl
EKLNotAddHL:
	ld	a,(hl)
	ROM_CALL(TR_CHARPUT)
		
	ex	de,hl
	ld	(CrossY),hl
	ld 	(CURSOR_POS),hl
	ld	a,09h	;'*'
	ROM_CALL(TR_CHARPUT)

	ld	de,(OddY)
	call	CP_HL_DE
	jr	z,FindOdd
AfterKey:
	ld	a,(Time)
	dec	a
	jr	z,EndGameLost
	ld	(Time),a

	jr	Begin

FindOdd:
	ld	a,(Points)
	add	a,3
	ld	(Points),a
	cp	252
	jr	nc,EndGameWon
	jp	Initialize

EndGameLost:
	ld	hl,0303h
	ld 	(CURSOR_POS),hl
	ld	hl, msgLost
	ROM_CALL(D_ZT_STR)
	jr	EndGame

EndGameWon:
	ld	hl,0403h
	ld 	(CURSOR_POS),hl
	ld	hl, msgWon
	ROM_CALL(D_ZT_STR)

EndGame:
	ld	hl,0804h
	ld	(CURSOR_POS),hl
	ld	a,(Points)
	sub	221
	ld	l,a
	ld	h,0
	add	hl,hl
	add	hl,hl
	ROM_CALL(D_HL_DECI)

	ld	b,1
	ld	hl,msgScore1

EndLoop:
	push	hl
	call	GET_KEY
	pop	hl
	cp	G_MODE
	ret	z
	cp	G_ENTER
	jp	z,Start

	halt	
	djnz	EndLoop
	ld	a,03h
	ld	(CURSOR_COL),a
	ld	de,msgScore2
	call	CP_HL_DE
	jr	z,WriteSc

	ld	hl,msgScore1
WriteSc:
	ld	b,90
	ROM_CALL(D_ZT_STR)
	jr	EndLoop



msgAuthor:	.db "By:dEnNiS ",26h," eR",0BAh,"C",0
msgPattern	.db "P",0E0h,016h,"tEr",0D7h,":",0	;Pattern
Pat1		.db "()",0
Pat2		.db 7Bh,7Dh,0	;{}
Pat3		.db 0C1h,5Dh,0	;[]
Pat4		.db 3Ch,3Eh,0	;<>
Pat5		.db 17h,19h,0	;=<=>
Pat6		.db 2Fh,5Ch,0	;/\
Pat7		.db 0CFh,5h,0	;<- ->
Pat8		.db 3Fh,0B9h,0	;??
Pat9		.db 21h,0BAh,0	;!!
Pat10		.db 1Eh,1Fh,0	;\|/ /|\
Pat11		.db 6h,7h,0	;\|/ /|\
msgReady	.db "ArE yOu ReAdY?",0
msgWon		.db "Y",02h,"U wOn!",0
msgLost		.db "tImE iS uP",0
msgScore1	.db "sC",14h,"R",1Bh,":",0
msgScore2	.db "ScO",15h,"E",0

.end
