; Wak-A-Goomba v2.2 (TI-82 version for Ash/CrASH)
; Written by Kurt Tucker
; Last updated Oct. 29, 1998

#include "ti82.h"			; Various include files
#include "keys.inc"

goombax = TEXT_MEM			; 1 byte - Goomba x-coord
goombay = TEXT_MEM+1			; 1 byte - Goomba y-coord
score = TEXT_MEM+2			; 2 bytes - Player's total score
time = TEXT_MEM+4			; 1 byte - Total time remaining
goombasq = TEXT_MEM+5			; 1 byte - Goomba's square
playersq = TEXT_MEM+6			; 1 byte - Player's square (key)
goombasc = TEXT_MEM+7			; 1 byte - Current goomba score
temp = TEXT_MEM+8			; 1 byte - PutSprite temp variable
delay = TEXT_MEM+9			; 2 bytes - Delay variable
temp2 = TEXT_MEM+11
HiscoreTemp = TEXT_MEM+15		; 1 byte - Temp. variable for time
TempByte = TEXT_MEM+30
.org START_ADDR				; Starting point for all ASM progs
.db "Wak-A-Goomba v2.2",0

TitleScreen:
 	 LD A,$8C           ;Needed for
	 OUT (2),A          ;FIND_PIXEL
       res 2,(iy+13)

	ROM_CALL(CLEARLCD)
      call ClearGraph
	ld b,2 \ ld c,17
	ld hl,goomba_left_1		; Load goomba_left_1 into HL
	call PutSprite			; Display image in HL
	ld b,10
	ld hl,goomba_left_2
	call PutSprite
      ROM_CALL(DISP_GRAPH)
	set 3,(iy+5)			; Turn on inverse text
	ld de,$0000			; Load $0000 into H
	ld hl,Header1			; Load Header1 into HL			; Display text in HL (fixed-width)
      call DTX
	res 3,(iy+5)			; Turn off inverse text
	ld de,$0E22
	call DMX			; Display text in HL (variable-width)
	ld de,$1418
	call DMX
	ld de,$0305
	call DTX
	ld de,$0107
	call DTX
	ld de,$1C17
	call DMX

	ld de,$0406
	ld hl,HiScrName
      call DTX
	ld hl,$0706
	ld (CURSOR_ROW),hl
	ld hl,(Hiscore)
      ROM_CALL(D_HL_DECI)



TitleKeyLoop:
	call GET_KEY			; Get the last key pressed
	cp G_ENTER			; If ENTER was pressed
      call z,ClearGraph
	jp z,StartGame			; then goto StartGame
	cp G_CLEAR
	jp z,Exit
	jp TitleKeyLoop

Exit:					; Exit the game
	ret				; Return to TI-OS or shell

StartGame:				; Setup actual game screen
	call OnlyOnce
      ROM_CALL(DISP_GRAPH)	
	ld hl,$0000 \ ld (score),hl	; Set score to 0
	ld bc,$FFFF \ ld (delay),bc	; Set delay time to $FFFF (0.5 sec)
	ld a,60 \ ld (time),a		; Set total time to 60
	ld a,33 \ ld (temp2),a		; Set temp. time variable to 33

	ld de,$0402			; Display "Ready...Set...GO!"
	ld hl,ReadyMessage
      call DTX
	call Delay \ call Delay
	ld de,$0403
      call DTX
	call Delay \ call Delay
	ld de,$0404
      call DTX
	call Delay \ call Delay

	jr MainLoop

OnlyOnce:
	ROM_CALL(CLEARLCD)
DisplayGameScreen:			; Display main game screen
	ld      BC, 0*256
	ld      D, 63
	call    VLine

      ld      BC, 21*256
      ld      D, 63
      call      VLine

	ld      BC, 42*256
	ld      D, 63
	call    VLine

	ld      BC, 63*256
	ld      D, 63
	call    VLine

	ld      BC,0
	ld      D,64
      call    HLine

      ld      BC, 21
      ld      D, 64
      call      HLine

	ld      BC, 42
	ld      D, 64
	call    HLine

	ld      BC, 63
	ld      D, 64
	call    HLine
	ret

MainLoop:				; The actual game!
	ld bc,$1112 \ ld (delay),bc	; Set delay to $1112 (0.0333 sec)
	ld a,30 \ ld (goombasc),a	; Set cur. goomba score to 30
	call ClearGoomba
	ld a,(time)
	cp 0
	jp z,TimeUp
	ld a,9
	ld b,a 				; Create a Random number
 	ld a,r
 	add a,a
 	ld hl,0
 	ld d,0
 	ld e,a
RMul:
 	add hl,de
 	djnz RMul
 	ld a,h				; Get rand. # between 0 and 8
	inc a				; Rand. # is now between 1 and 9
	ld (goombasq),a
	call SquareToCoord
	ld a,(goombax) \ ld b,a
	ld a,(goombay) \ ld c,a
	ld hl,goomba_left_1
	call PutSprite
      push af
	ld a,b
      add a,8
      ld b,a	; B = B + 8
      pop af
	ld hl,goomba_left_2
	call PutSprite
      ROM_CALL(DISP_GRAPH)
      call UpdateStats
PlayKeyLoop1:
	call GET_KEY
	cp G_CLEAR \ jp z,CheckHighscore
	cp G_MODE \ jp z,PauseGame
	cp G_1 \ jp z,Square7
	cp G_2 \ jp z,Square8
	cp G_3 \ jp z,Square9
	cp G_4 \ jp z,Square4
	cp G_5 \ jp z,Square5
	cp G_6 \ jp z,Square6
	cp G_7 \ jp z,Square1
	cp G_8 \ jp z,Square2
	cp G_9 \ jp z,Square3
PlayKeyLoop2:
	call DoTime
	ld a,(goombasc)
	call Delay
	dec a
	ld (goombasc),a
	cp 0 \ jp z,MainLoop

	jr PlayKeyLoop1

PauseGame:				; Pauses the game
	ROM_CALL(CLEARLCD)
	set 3,(iy+5)
	ld de,$0000
	ld hl,Header1
      call DTX
	res 3,(iy+5)
	ld de,$0304
	ld hl,PauseMessage
      call DTX
PauseKeyLoop:
	call GET_KEY
	cp G_ENTER
	jp z,MainLoop
	cp G_CLEAR
	jp z,CheckHighscore
	jr PauseKeyLoop

UpdateStats:
     ; set 7,(iy+$14)			; Update score and time remaining
	ld de,$0B01			; Display "score" and "Time";
	ld hl,scoreCounter
      call DTX
	ld de,$0B05
      call DTX
	ld hl,$0B02
	ld (CURSOR_ROW),hl
	ld hl,(score)
	ROM_CALL(D_HL_DECI)
	ld hl,$0B06
	ld (CURSOR_ROW),hl
	ld a,(time)
	ld l,a \ ld h,0
	ROM_CALL(D_HL_DECI)
     ; res 7,(iy+$14)
	ret

SquareToCoord:				; Convert goomba sq. to x/y coord.
	ld a,(goombasq)
	cp 1 \ jr z,SetCoord1
	cp 2 \ jr z,SetCoord2
	cp 3 \ jr z,SetCoord3
	cp 4 \ jr z,SetCoord4
	cp 5 \ jr z,SetCoord5
	cp 6 \ jr z,SetCoord6
	cp 7 \ jr z,SetCoord7
	cp 8 \ jr z,SetCoord8
	jr SetCoord9

SetCoord1:
	ld a,3 \ ld (goombax),a
	ld a,3 \ ld (goombay),a
	ret
SetCoord2:
	ld a,24 \ ld (goombax),a
	ld a,3 \ ld (goombay),a
	ret
SetCoord3:
	ld a,45 \ ld (goombax),a
	ld a,3 \ ld (goombay),a
	ret
SetCoord4:
	ld a,3 \ ld (goombax),a
	ld a,24 \ ld (goombay),a
	ret
SetCoord5:
	ld a,24 \ ld (goombax),a
	ld a,24 \ ld (goombay),a
	ret
SetCoord6:
	ld a,45 \ ld (goombax),a
	ld a,24 \ ld (goombay),a
	ret
SetCoord7:
	ld a,3 \ ld (goombax),a
	ld a,45 \ ld (goombay),a
	ret
SetCoord8:
	ld a,24 \ ld (goombax),a
	ld a,45 \ ld (goombay),a
	ret
SetCoord9:
	ld a,45 \ ld (goombax),a
	ld a,45 \ ld (goombay),a
	ret	


ClearGoomba:				; Clear goomba at (goombax,goombay)
 call ClearGraph
 jp DisplayGameScreen
	
Square1:
	ld a,1 \ jr CheckSquare
Square2:
	ld a,2 \ jr CheckSquare
Square3:
	ld a,3 \ jr CheckSquare
Square4:
	ld a,4 \ jr CheckSquare
Square5:
	ld a,5 \ jr CheckSquare
Square6:
	ld a,6 \ jr CheckSquare
Square7:
	ld a,7 \ jr CheckSquare
Square8:
	ld a,8 \ jr CheckSquare
Square9:
	ld a,9 \ jr CheckSquare

CheckSquare:				; Check player's square for goomba
	ld (playersq),a
	ld a,(goombasq) \ ld b,a
	ld a,(playersq)
	cp b
	jp nz,PlayKeyLoop2

WhackGoomba:	; Whack goomba at (goombax,goombay)
      call ClearGoomba
	ld a,(goombax) \ ld b,a
	ld a,(goombay) \ ld c,a
	ld hl,goomba_squash_1
	call PutSprite
	ld a,b \ add a,8 \ ld b,a	; B = B + 8
	ld hl,goomba_squash_2
	call PutSprite
      ROM_CALL(DISP_GRAPH)
      call UpdateStats
	call WhackDelay
	ld a,(goombasc)			; Increase player's score
	ld d,0 \ ld e,a
	ld hl,(score)
	add hl,de
	ld (score),hl
	jp MainLoop

WhackDelay:
	call Delay 
	call DoTime
	inc e
	ld a,e
	cp 8
	ret z
	jp WhackDelay

DoTime:					; Deduct time remaining
	ld a,(temp2)
	dec a
	ld (temp2),a
	cp 0				; Is temp2 equal to 0?
	jp z,SubtractOneSecond		; If so, goto SubtractOneSecond
	ret				; Else return
SubtractOneSecond:			; Subtract one second from time
	ld a,(time)
	dec a
	ld (time),a
	ld a,48 \ ld (temp2),a		; Reset temp2
	call UpdateStats
	ret

TimeUp:					; Time's up!
	ld de,$0403
	ld hl,TimeUpMessage
      call DTX
TimeUpKeyLoop:
	call GET_KEY
	cp G_ENTER
	jr z,CheckHighscore

	jr TimeUpKeyLoop

CheckHighscore:				; Check if player beat high score
 ROM_CALL(CLEARLCD)
 ld hl, Hiscore
 call LD_HL_MHL
 ld de,(score)
 ld (HiscoreTemp),de
 call CP_HL_DE
 ret nc
 ld hl,Hiscore
 ex de,hl
 ld hl,HiscoreTemp
 ld c,2
 ldi
 ldi
 ld de,$0100
 ld hl,HiScr
 call DTX
 ld de,$0A0F
 call DMX
         ld       hl,$0603
         ld       (CURSOR_ROW),hl
         ld       hl, HiScrName
         push     hl
         ld       b,3
space_loop:
         ld       (hl), ' '
         inc      hl
         djnz     space_loop
         pop      ix

enter_name_loop:
	   call     GET_KEY
         or       A
         jr       z,enter_name_loop
         cp       $38
         jr       z,backup
         SUB      9
         ret      z
         dec      a
         jp       m,enter_name_loop
         ld       hl,chartable
         ld       e,a
         ld       d,0
         add      hl,de
         ld       a,3
         cp       b
         jr       z,enter_name_loop
         ld       a,(hl)
         or       a
         jr       z,enter_name_loop
         ld       (ix),a
	   ROM_CALL(TX_CHARPUT)
         inc      b
         inc      ix
         jr       enter_name_loop
backup:  xor      a
         cp       b
         jr       z,enter_name_loop
         dec      b
         dec      ix
         ld       a,' '

         ld       (ix),a
         ld       hl,CURSOR_COL
         dec      (hl)
	   ROM_CALL(TX_CHARPUT)
         dec      (hl)
         jr       enter_name_loop


; ----- Subroutines -----

PutSprite:
	push    BC
	push    DE
	ld      DE, GRAPH_MEM
convdone:
	ld      A, 63
	sub     C
	ld      C, A
	push    HL
	push    HL
	call    FIND_PIXEL
	add     HL, DE
	ex      DE, HL
	pop     HL
	ld      B, (HL)
	inc     HL
	ld      C, (HL)
	inc     HL
	push    HL
	pop     IX
	ex      DE, HL
PS_NewRow:
	push    BC
	ld      D, (IX)
	inc     IX
	push    AF
	push    HL
PS_NewCol:
	rl      D
	ld      E, A
	jr      nc, PS_NextPixel
	xor     (HL)
	ld      (HL), A
PS_NextPixel:
	ld      A, E
	rrca
	jr      nc, PS_SameByte
	inc     HL
PS_SameByte:
	djnz    PS_NewCol
	pop     HL
	pop     AF
	ld      DE, 12
	add     HL, DE
	pop     BC
	dec     C
	jr      nz, PS_NewRow
	pop     HL
	pop     DE
	pop     BC
      ret



Delay:
	push af
	push bc
	ld bc,(delay)
DelayLoop:
	dec bc
	ld a,b
	or c
	jr nz,DelayLoop
	pop bc
	pop af
	ret

; ----- Sprites -----

goomba_left_1:
	.db 8,16
	.db 00000011b
	.db 00001100b
	.db 00011110b
	.db 00001010b
	.db 00010001b
	.db 01100010b
	.db 10000010b
	.db 10000000b
	.db 10001111b
	.db 01000000b
	.db 00111111b
	.db 00000100b
	.db 01111000b
	.db 10111100b
	.db 11111100b
	.db 11111111b
goomba_left_2:
	.db 8,16
	.db 11000000b
	.db 00110000b
	.db 01111000b
	.db 01010000b
	.db 10001000b
	.db 01000110b
	.db 01000001b
	.db 00000001b
	.db 11110001b
	.db 00000010b
	.db 11111100b
	.db 00010000b
	.db 00001000b
	.db 00011110b
	.db 00111101b
	.db 11111111b

goomba_squash_1:
	.db 8,16
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000011b
	.db 00011100b
	.db 01111111b
	.db 10000110b
	.db 10000000b
	.db 01111111b
	.db 00100000b
	.db 01111111b
	.db 11111111b
goomba_squash_2:
	.db 8,16
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 00000000b
	.db 11000000b
	.db 00111000b
	.db 11111110b
	.db 01100001b
	.db 00000001b
	.db 11111110b
	.db 00000100b
	.db 11111110b
	.db 11111111b
; ----- Text Strings and Other Data -----

Header1:	.db "Wak-A-Goomba 2.2",0
TitleMsg1:	.db "By Kurt Tucker",0
TitleMsg2:	.db "yosterisle@aol.com",0
TitleMsg3:	.db "High Score",0
TitleMsg4:	.db "ENTER to play!",0
PortStr:    .db "Ported by: Sam Heald"

ReadyMessage:	.db "Ready...",0
SetMessage:	.db "Set..",0
GoMessage:	.db "GO!",0

PauseMessage:	.db "* PAUSED *",0

TimeUpMessage:	.db "TIME UP!",0


ClearGraph:
 ld hl, GRAPH_MEM
 ld (hl),0
 ld de,GRAPH_MEM+1
 ld bc,767
 ldir
 ret

HiScrTxt:  .db "Hiscore: ",0
HiScrName: .db "SAM",0
Hiscore:   .dw 10                       ;This is standard hi-score
HiScr:     .db "NEW HIGH SCORE!",0
EnterInit: .db "ENTER YOUR INITIALS:",0

;horizontal line: B = start x, D = len, C = y
HLine:
	ld      A, 63
	sub     C
	ld      C, A
	call    FIND_PIXEL
	ld      B, D
	ld      DE, GRAPH_MEM
	add     HL, DE
	ld      C, A
HLineLoop:
	ld      A, (HL)
	or      C
	ld      (HL), A
	rrc     C
	jr      nc, HLineLoop_
	inc     HL
HLineLoop_:
	djnz    HLineLoop
	ret

;vertical line: B = x, C = start y, D = len
VLine:
	ld      A, 63
	sub     C
	ld      C, A
	call    FIND_PIXEL
	ld      B, D
	ld      DE, GRAPH_MEM
	add     HL, DE
	ld      C, A
	ld      DE, 12
VLineLoop:
	ld      A, (HL)
	or      C
	ld      (HL), A
	add     HL, DE
	djnz    VLineLoop
	ret
scoreCounter:
 .db "Score",0
TimeCounter:
 .db "Time",0

DMX:
 ld (CURSOR_X),de
 ROM_CALL(D_ZM_STR)
 ret
DTX:
 ld (CURSOR_ROW),de
 ROM_CALL(D_ZT_STR)
 ret

chartable:
         .db      ":WRMH."
         .DB      "..0VQLG!..ZUPKFC"
         .DB      ". YTOJEBX.>SNIDA"	; w00h00! I added the space!!! Now I can type "Joe W"
         .DB      ".12345.."

.end
END