.include "ti82.h"
.include "keys.inc"
DIV_HL_A     = $00A3 ;HLA       HL=int(HL/A), A=HL MOD A
.ORG START_ADDR

CurPiece  = TEXT_MEM
NextPiece = TEXT_MEM+9
tmpPiece  = TEXT_MEM+18
xy	  = TEXT_MEM+27
time	  = TEXT_MEM+29
mult	  = TEXT_MEM+30
score	  = TEXT_MEM+31
;rotrel	  = TEXT_MEM+33
multtimer = TEXT_MEM+33
count	  = TEXT_MEM+34
string	  = TEXT_MEM+35		;6 bytes(buffer for ShowHLDec)
board	  = APD_BUF

.db "Squarez v1.1",0

        ROM_CALL(CLEARTEXT_F)	;clear screen and text memory

CheckAPD_BUF:
	ld	a,i
	or	a
	jr	z,OkAPD
	ld de,$1A10
	ld hl,UnloadStr
	call DMX
ChkAPDKey:
	call	GET_KEY
	cp	G_PRGM
	jr	z,OkAPD		; Want to play?
	or	a
	jr	z,ChkAPDKey
	ret
OkAPD:
	ld hl,APD_BUF
	ld (hl),0
	ld de,APD_BUF+1
	ld bc,307
	ldir

        ld hl,GRAPH_MEM
        ld (hl),0
        ld de,GRAPH_MEM+1
        ld bc,767
        ldir

 ld a,1
 ld (mult),a
 ld h,1			;Black line (white line =0)
	ld      BC, 3*256+1
	ld      DE, 3*256+62
	call    _ILine
	ld      BC, 68*256+1
	ld      DE, 68*256+62
	call    _ILine
	ld      BC, 4*256+62
	ld      DE, 67*256+62
	call    _ILine
	ld      BC, 4*256+1
	ld      DE, 67*256+1
	call    _ILine
 set 7,(iy+$14)
 ld hl,InfoText
 ld de,$0F4B
 call DMX
 ld de,$1746
 call DMX
 ld de,$2446
 call DMX
 ld de,$2B46
 call DMX
 ld de,$3946
 call DMX
 ld de,$174E
 call DMX
 ld hl,$1D4B
 ld (CURSOR_X),hl
 ld hl,(Hiscore)
 call ShowHLDec
 call ShowScore
 call ShowMult
 res 7,(iy+$14)
 ld hl,GRAPH_MEM+$24
 ld de,23
 ld b,6
PutDots:
 ld (hl),%00010101
 inc hl
 ld (hl),%01010101
 add hl,de
 djnz PutDots
 call NewPiece
 call NewPiece
 ld hl,board +2
 ld de,board+(16*18)+2
 ld b,18
 ld a,128
FillHBorder:
 ld (hl),a
 ld (de),a
 inc hl
 inc de
 djnz FillHBorder
 ld hl,board+18 +2
 ld b,16
FillVBorder:
 ld (hl),a
 ld de,17
 add hl,de
 ld (hl),a
 inc hl
 djnz FillVBorder
WaitKey:
 call UpdateTimer
 ld b,8
Wait:
 halt
 djnz Wait
 ld hl,(xy)
 ld a,(KEY_0)
 cp G_CLEAR
 jp z,Quit
 cp G_MODE
 jp z,Pause
 cp G_XTO
 jr z,TryDrop
 cp G_ENTER
 jr z,TryDrop
 cp G_YEDIT
 jr z,TryDrop
 cp G_2nd
 jr z,TryRotate
 cp G_ALPHA
 jr z,TryRotate
; push hl
; ld hl,rotrel
; res 0,(hl)
; pop hl
 dec a
 jr z,MoveDown
 dec a
 jr z,MoveLeft
 dec a
 jr z,MoveRight
 dec a
 jr nz,WaitKey
MoveUp:
 dec l
 jr TestUpdate
MoveLeft:
 dec h
 jr TestUpdate
MoveRight:
 inc h
 jr TestUpdate
MoveDown:
 inc l
TestUpdate:
 ld de,CurPiece
 call TestPiece
 jr nz,WaitKey
UpdatePiece:
 push hl
 ld hl,(xy)
 ld de,CurPiece
 call ShowPiece
 pop hl
 ld (xy),hl
 call ShowPiece
WillWaitKey:
 jr WaitKey

TryDrop:
 call TestCorner
 jr nz,WaitKey
 ld hl,(xy)
 call DropPiece
 call Search3x3Block
 ld a,(count)
 cp 16
 jr c,NoMultInc
 ld hl,mult
 inc (hl)
 call ShowMult
NoMultInc:
 ld d,0
 ld e,a
 ld a,(time)
 rrca
 rrca
 rrca
 rrca
 and $0F
 inc a
 ld h,d
 ld l,a
 add hl,de
 ex de,hl
 ld l,h
 push hl
 ld hl,mult
 ld b,(hl)
 pop hl
Multiply:
 add hl,de
 djnz Multiply

 ld de,(score)
 add hl,de
 ld (score),hl
 call ShowScore
 call NewPiece
WillWaitKey2:
 jr	WillWaitKey		;jp WaitKey

TryRotate:

; ld hl,rotrel
; bit 0,(hl)
; jp nz,WaitKey
; set 0,(hl)
 ;call RotatePiece
;RotatePiece:
 ld ix,RotateData
 cp G_2nd
 jr z,GoodData
 ld ix,RotateData+8
GoodData:
 ld hl,tmpPiece
 ld de,CurPiece
 ld b,9
Rotate:
 push bc
 push hl
 ld b,0
 ld c,(ix)
 add hl,bc
 ld a,(de)
 ld (hl),a
 inc de
 inc ix
 pop hl
 pop bc
 djnz Rotate
 ;ret
 xor	a
 ld	(KEY_0),a	;avoid repeating key
 ex	de,hl		;ld de,tmpPiece
 ld hl,(xy)
 call TestPiece
 jr nz,WillWaitKey		;;
 push de
 ld de,CurPiece
 call ShowPiece
 pop hl
 ld bc,9
 ldir
 ld hl,(xy)
 ld de,CurPiece
 call ShowPiece
WillWaitKey3:
 jr	WillWaitKey2		;jp WaitKey

Pause:
 ld	e,0F0h
 ld	c,10h
 ld	l,1Fh
HalfByte:
 ld	d,8
SendBlankLine:
 inc	l
 ld	b,60
 LD	h,81h		;call	DISP_DELAY
 OUT	(c),l		;select the coloum
SendBlankColoum:
 inc	h
 set	3,(iy+5)	;
 xor	a		;
 ld	(KEY_0),a	;CALL	DISP_DELAY
 OUT	(c),h		;select the line
 CALL	DISP_DELAY
 in	a,(11h)
 CALL	DISP_DELAY
 in	a,(11h)		;Get byte
 and	e		;Mask
 CALL	DISP_DELAY
 OUT	(c),h		;select the line
 CALL	DISP_DELAY
 out	(11h),a
 djnz	SendBlankColoum
 dec	d
 jr	nz,SendBlankLine
 ld	a,e
 ld	e,0Fh
 ld	l,20h
 rra
 jr	nc,HalfByte

 ;set 3,(iy+5)
 ld hl,$0203
 ld (CURSOR_ROW),hl
 ld hl,PauseTxt
 ROM_CALL(D_ZT_STR)
 res 3,(iy+5)

PauseW:
 call GET_KEY
 cp G_CLEAR
 jp z,Quit
 cp G_ENTER
 jr z,PauseEnd
 cp G_MODE
 jr nz,PauseW
PauseEnd:
 call	DISP_GRAPH
 jr	WillWaitKey3		;jp WaitKey

NewPiece:
 ld de,NextPiece
 ld hl,$1502
 call ShowPiece
 ex de,hl
 ld de,CurPiece
 ld bc,9
 ldir
 ld hl,$0302
 ld (xy),hl
 call ShowPiece
RandLoop:
 ld a,r
 srl a
 cp 39
 jr nc,RandLoop
InRange:
 call ExtractPiece
 ld hl,$1502
 call ShowPiece
 ld a,144
 ld (time),a
 ret

TestCorner:
 ld de,CurPiece
 ld hl,(xy)
 ld c,h
 ld b,3
TestCRow:
 push bc
 ld b,3
TestCCol:
 ld a,(de)
 or a
 jr z,TC_NextSq
 ld a,h
 cp 6
 jr nc,TC_NextSq
 ld a,l
 cp 5
 jr nc,TC_NextSq
 pop bc
 ret
TC_NextSq:
 inc de
 inc h
 djnz TestCCol
 pop bc
 ld h,c
 inc l
 djnz TestCRow
 xor a
 ret

TestPiece:
 push de
 push hl
 call GetBoardPos
 ld b,3
TestRow:
 push bc
 ld b,3
TestCol:
 ld a,(de)
 or a
 jr z,NoCollide
 ld a,(hl)
 or a
 jr nz,Collide
NoCollide:
 inc de
 inc hl
 djnz TestCol
 ld c,15
 add hl,bc
 pop bc
 djnz TestRow
 pop hl
 pop de
 xor a
 ret
Collide:
 pop bc
 pop hl
 pop de
 inc a
 ret

DropPiece:
 push hl
 call GetBoardPos
 ld de,CurPiece
 ld b,3
DropRow:
 push bc
 ld b,3
DropCol:
 ld a,(de)
 or (hl)
 ld (hl),a
 inc de
 inc hl
 djnz DropCol
 ld c,15
 add hl,bc
 pop bc
 djnz DropRow
 pop hl
 ret

Search3x3Block:
 ld hl,board+19+2
 ld b,13
SearchY:
 push bc
 ld b,14
SearchX:
 ld a,(hl)
 and $7F
 jr z,SB_NextSq
 ld ix,SurData
 push bc
 push ix
 push hl
 ld b,8
 ld d,0
CheckSurr:
 ld e,(ix)
 inc ix
 add hl,de
 ld a,(hl)
 and 7Fh
 jr z,NoBlock
 djnz CheckSurr
 pop hl
 pop ix
 push hl
 ld b,9
ClearSurr:
 ld (hl),2
 ld e,(ix)
 add hl,de
 inc ix
 djnz ClearSurr
 pop hl
 pop bc
 jr SB_NextSq
NoBlock:
 pop hl
 pop ix
 pop bc
SB_NextSq:
 inc hl
 djnz SearchX
 ld c,4
 add hl,bc
 pop bc
 djnz SearchY

 ld de,board+19	+2
 ld hl,count
 ld (hl),0
 ld hl,GRAPH_MEM+$18	;FC21
 ld c,$F0
 ld b,15
ClearY:
 push bc
 ld b,16
 push hl
ClearX:
 ld a,(de)
 cp 2
 jr nz,C_NextSq
 push hl
 ld hl,count
 inc (hl)
 pop hl
 xor a
 ld (de),a
 push bc
 push de
 ld de,12
 ld b,4
C_PutSq:
 ld a,c
 and (hl)
 ld (hl),a
 add hl,de
 djnz C_PutSq
 ld de,-48
 add hl,de
 pop de
 pop bc
C_NextSq:
 ld a,c
 cpl
 ld c,a
 rra			;cp $0F
 jr nc,CSameByte	;nz
 inc hl
CSameByte:
 inc de
 djnz ClearX
 pop hl
 ld c,48
 add hl,bc
 ex de,hl
 ld c,2
 add hl,bc
 ex de,hl
 pop bc
 djnz ClearY
 ret

ShowScore:
 set 7,(iy+$14)
 ld hl,$314B
 ld (CURSOR_X),hl
 ld hl,(score)
 call ShowHLDec
 res 7,(iy+$14)
 ret

ShowHLDec:
 ld de,string+5
 xor a
 ld (de),a
 ld b,5
Unpack:
 call UNPACK_HL
 add a,48
 dec de
 ld (de),a
 djnz Unpack
 ex de,hl
 ROM_CALL(D_ZM_STR)
 ret

ShowMult:
 push af
 push hl
 set 7,(iy+$14)
 ld hl,$2454
 ld (CURSOR_X),hl
 ld hl,MultText+1
 ld a,(mult)
 add a,'0'
 ld (hl),a
 dec hl
 ROM_CALL(D_ZM_STR)
 res 7,(iy+$14)
 pop hl
 pop af
 ret

UpdateTimer:
 ld a,(mult)
 dec a
 jr z,DecTimer
 ld hl,multtimer
 dec (hl)
 jr nz,DecTimer
 ld hl,mult
 dec (hl)
 call ShowMult
DecTimer:
 ld hl,time
 dec (hl)
 ld a,(hl)
 cp 255
 push af
 jr z,ShowTime
 rrca
 rrca
 rrca
 rrca
 and $0F
ShowTime:
 add a,49
 ld hl,$395B
 ld (CURSOR_X),hl
 ROM_CALL(M_CHARPUT)
 pop af
 ret nz

OutOfTime:
 pop hl
 call TestCorner
 ld a,0				;xor a affects z-flag
 ld (time),a
 jp z,TryDrop
 ld hl,$0303
 ld (CURSOR_ROW),hl
 ld hl,GameOverText
 set 3,(iy+5)
 ROM_CALL(D_ZT_STR)
 res 3,(iy+5)
GameOverWait:
 call GET_KEY
 cp G_ENTER
 jr z,Quit
 cp G_CLEAR
 jr nz,GameOverWait
Quit:

CheckHiscore:
 ROM_CALL(CLEARLCD)
 ld hl, Hiscore
 call LD_HL_MHL
 ld de,(score)
 call CP_HL_DE
 ret nc
 ld hl,Hiscore
 ld (hl),e
 inc hl
 ld (hl),d
 ld hl,$0100
 ld (CURSOR_ROW),hl
 ld hl,HiScr
 ROM_CALL(D_ZT_STR)
 ld de,$0A0F
 call DMX
 ld hl, $0603
 ld (CURSOR_ROW),hl
 ld hl,HiInitials
 ld c,3
 push hl
 ld d,$41
 ld a,(CURSOR_COL)
 ld e,a
 ld b,0
 jr InvLet
WaitKey2:
 push hl
 call GET_KEY
 pop hl
 cp G_UP
 jr z,LetUp
 cp G_DOWN
 jr z,LetDown
 cp G_2nd
 jr z,SelectLet
 cp G_ENTER
 jr nz,WaitKey2
SelectLet:
 ld (hl),d
 inc hl
 ld a,d
 ROM_CALL(TX_CHARPUT)
 inc e
 inc b
 ld a,c
 cp b
 jr nz,InvLet
 pop hl
 ret
LetUp:
 inc d
 ld a,d
 cp $5B
 jr nz,InvLet
 ld d,$41
 jr InvLet
LetDown:
 dec d
 ld a,d
 cp $40
 jr nz,InvLet
 ld d,$5A
InvLet:
 set 3,(iy+$05)
 ld a,d
 ROM_CALL(TX_CHARPUT)
 ld a,e
 ld (CURSOR_COL),a
 res 3,(iy+$05)
 jr WaitKey2

GetBoardPos: ;(=18*l+h)
 ld c,h
 ld h,0
 ld b,h
 ld a,l
 add a,a
 add a,a
 add a,a
 add a,l
 ld l,a
 add hl,hl
 add hl,bc
 ld bc,board-18
 add hl,bc
 ret

ShowPiece:
 push de
 push hl
 call GetScreenOfs
 ld b,3
PutRow:
 push bc
 push hl
 ld b,3
PutCol:
 ld a,(de)
 inc de
 or a
 jr z,NoSq
 push bc
 push de
 ld de,12
 ld b,4
PutSq:
 ld a,c
 xor (hl)
 ld (hl),a
 add hl,de
 djnz PutSq
 ld de,-48
 add hl,de
 pop de
 pop bc
NoSq:
 ld a,c
 cpl
 ld c,a
 cp $F0
 jr nz,SameByte
 inc hl
SameByte:
 djnz PutCol
 pop hl
 ld c,48
 add hl,bc
 pop bc
 djnz PutRow
 call	DISP_GRAPH
 pop hl
 pop de
 ret

GetScreenOfs:		; Converts H,L to its position on the screen
 push de
 ld a,h
 ld h,l
 ld l,0
 srl h
 rr l
 srl h
 rr l
 push af
 ROM_CALL($1901-$1A)	;Multiply HL by 9
 ld a,12		;Load 12 to A
 call DIV_HL_A		;Divide HL by A (9/12 = 3/4)
 pop af			;Restore AF (changed with call of DIV_HL_A)
 ld c,$F0
 srl a
 jr nc,EvenX
 ld c,$0F
EvenX:
 ld d,0
 ld e,a
 dec e			; because we shift the board of 2 square (+2)
 add hl,de
 ld de,GRAPH_MEM-$48
 add hl,de
 pop de
 ret

ExtractPiece:	   ; Extract piece no A into (DE)
 push de
 ld hl,Pieces
 ld b,0
 ld c,a
 srl c
 srl c
 srl c
 add hl,bc
 ld c,128
 and 7
 jr z,NoShift
 ld b,a
RepShift:
 srl c
 djnz RepShift
NoShift:
 ld b,9
ExtractBit:
 ld a,c
 and (hl)
 ld a,0
 jr z,NoBit
 inc a
NoBit:
 ld (de),a
 inc de
 inc hl
 inc hl
 inc hl
 inc hl
 inc hl
 djnz ExtractBit
 pop de
 ret

DMX:
 ld (CURSOR_X),de
 ROM_CALL(D_ZM_STR)
 ret

_ILine:
 ROM_CALL($2E60-$1A)			;jp to a ROM routine
 .dw $4025				;Address of routine?
 .db $04				;ROM page?

Pieces:   ; Data for the 39 pieces, 45 bytes
 .db %11111111,%11010110,%11101100,%11110000,%10100000
 .db %11111111,%11011110,%01111111,%11111100,%11100100
 .db %11011111,%10001111,%01110011,%01101000,%01000000
 .db %11110110,%10111011,%11111010,%00101111,%01111000
 .db %11101111,%11111111,%10011111,%11011111,%11111110
 .db %11110101,%01111101,%11111100,%00010111,%10011010
 .db %11011010,%11101001,%11000011,%00100010,%00001000
 .db %10101111,%01100110,%00011001,%11011101,%00000110
 .db %01111001,%00110001,%10100100,%10000010,%00010000
;each column is one piece from up to down

RotateData:
 .db 2,5,8,1,4,7,0,3,6
 .db 3,0,7,4,1,8,5,2
SurData:
 .db 1,1,16,1,1,16,1,1

GameOverText:
 .db " Game Over ",0
PauseTxt:
 .db " PAUSED ",0
InfoText:
 .db "Next",0
 .db "Hi:",0
 .db "M:",0
 .db "Score:",0
 .db "Time:",0
HiInitials:
 .db "---",0
MultText:
 .db 9,"1",0			;"x1"
Hiscore:
 .dw 0

HiScr:     .db "NEW HIGH SCORE!",0
EnterInit: .db "ENTER YOUR INITIALS:",0

UnloadStr   .db "Disable the interrupt",0

.end
