; Slippy v1.11 by Andrew Von Dollen

#include "ti82.h"

#DEFINE CALL_Z(ADDR)    call z,ADDR
#DEFINE CALL_(ADDR)     call ADDR
#DEFINE CALL_NZ(ADDR)   call nz,ADDR
#DEFINE CALL_C(ADDR)    call c,ADDR
#DEFINE CALL_NC(ADDR)   call nc,ADDR
#DEFINE JUMP_Z(ADDR)    jp   z,ADDR
#DEFINE JUMP_(ADDR)     jp ADDR
#DEFINE JUMP_NZ(ADDR)   jp nz,ADDR
#DEFINE JUMP_C(ADDR)    jp c,ADDR
#DEFINE JUMP_NC(ADDR)   jp nc,ADDR

temp_x 	= TEXT_MEM
temp_y 	= TEXT_MEM+1
CoinsLeft 	= TEXT_MEM+2
SlippyPos	= TEXT_MEM+3
real_x  = TEXT_MEM+4
real_y  = TEXT_MEM+5
GameBoard	= APD_BUF
BoxPos	= TEXT_MEM+10
Level	= TEXT_MEM+11
direction = TEXT_MEM+12		;1-up 2-down 3-left 4-right
box_x	= TEXT_MEM+13
box_y	= TEXT_MEM+14
bitmap	= TEXT_MEM+15	;word
smooth	= TEXT_MEM+17
old_x	= TEXT_MEM+18
old_y	= TEXT_MEM+19

 .org	START_ADDR
 .db	"Slippy  v1.11 by AVD",0
start:
 ld 	a,$8C
 out 	(2),a
 CALL_(CLRGBU)
 CALL_(set_up_level)
 CALL_(put_status)
InputLoop:
 ld	a,0ffh
 out	(1),a
 ld	a,0bfh
 out	(1),a
 in	a,(1)
 cp	191
 jr	z,StatusScreen
 cp	127
 jr	z,RestartLevel
 ld	a,0ffh
 out	(1),a
 ld	a,0fdh
 out	(1),a
 in	a,(1)
 cp	191
 ret	z
 CALL_(KeyGet)
 ld b,a
 bit 5,a
 JUMP_Z(PushMode)
MoveMode:
 bit 0,b
 JUMP_Z(GoDown)
 bit 1,b
 JUMP_Z(GoLeft)
 bit 2,b
 JUMP_Z(GoRight)
 bit 3,b
 JUMP_Z(GoUp)
 jr InputLoop

RestartLevel:
 CALL_(set_up_level)
 CALL_(CopyGraphMem)
 jr	InputLoop

StatusScreen:
 ld	b,54
scroll_loop:
 push	bc
 ld	hl,GRAPH_MEM+12
 ld	de,GRAPH_MEM
 ld	bc,756
 ldir
 CALL_(CopyGraphMem)
 pop	bc
 halt
 djnz	scroll_loop
 ld	hl,$2d06
 ld	(CURSOR_X),hl
 ld	hl,by
 ROM_CALL(D_ZM_STR)
 ld	hl,$3406
 ld	(CURSOR_X),hl
 ld	hl,email
 ROM_CALL(D_ZM_STR)
keyloop:
 ld	hl,$0902
 ld	(CURSOR_ROW),hl
 ld	hl,CurrentLevel
 ld	a,(hl)
 ld	h,0
 ld	l,a
 inc	hl
 ROM_CALL(D_HL_DECI)
 ld	hl,$0903
 ld	(CURSOR_ROW),hl
 ld	hl,MaxLevel
 ld	a,(hl)
 ld	h,0
 ld	l,a
 inc	hl
 ROM_CALL(D_HL_DECI)
 ld	hl,$0102
 ld	(CURSOR_ROW),hl
 ld	hl,curlevstr
 ROM_CALL(D_ZT_STR)
 ld	hl,$0103
 ld	(CURSOR_ROW),hl
 ld	hl,maxlevstr
 ROM_CALL(D_ZT_STR)
 ROM_CALL(KEY_HAND)
 cp	3
 jr	z,try_inc_level
 cp	4
 jr	z,try_dec_level
 cp	5
 JUMP_Z(done_with_status)
 cp	6
 ret	z
 jr	keyloop
try_inc_level:
 ld	hl,CurrentLevel
 push	hl
 pop	ix
 ld	a,(hl)
 cp	24
 jr	z,keyloop
 ld	b,a
 ld	hl,MaxLevel
 ld	a,(hl)
 cp	b
 JUMP_Z(keyloop)
 ld	a,b
 inc	a
 ld	(ix),a
 JUMP_(keyloop)
try_dec_level:
 ld	hl,CurrentLevel
 ld	a,(CurrentLevel)
 or	a
 JUMP_Z(keyloop)
 dec	a
 ld	(hl),a
 JUMP_(keyloop)
done_with_status:
 CALL_(set_up_level)
 CALL_(put_status)
 CALL_(CopyGraphMem)
 JUMP_(InputLoop)

GoLeft:
 ld a,(SlippyPos)
 and %00001111
 ld a,(SlippyPos)
 jr nz,MoGoLeft
 add a,16
 push	af
 ld	hl,(real_x)
 ld	(old_x),hl
 ld	a,1
 ld	(smooth),a
 ld	a,90
 ld	(real_x),a
 pop	af
MoGoLeft:
 push	af
 ld	a,3
 ld	(direction),a
 pop	af
 dec a
 JUMP_(GoStuff

GoRight:
 ld a,(SlippyPos)
 inc a
 and %00001111
 ld a,(SlippyPos)
 jr nz,MoGoRight
 sub 16
 push	af
 ld	hl,(real_x)
 ld	(old_x),hl
 ld	a,1
 ld	(smooth),a
 ld	a,0
 ld	(real_x),a
 pop	af
MoGoRight:
 push	af
 ld	a,4
 ld	(direction),a
 pop	af
 inc a
 JUMP_(GoStuff

GoUp:
 ld a,(SlippyPos)
 sub 16
 cp 200
 ld a,(SlippyPos)
 jr c,MoGoUp
 add a,144
 push	af
 ld	hl,(real_x)
 ld	(old_x),hl
 ld	a,1
 ld	(smooth),a
 ld	a,48
 ld	(real_y),a
 pop	af
MoGoUp:
 push	af
 ld	a,1
 ld	(direction),a
 pop	af
 sub 16
 jr GoStuff

GoDown:
 ld a,(SlippyPos)
 add a,16
 cp 144
 ld a,(SlippyPos)
 jr c,MoGoDown
 sub 144
 push	af
 ld	hl,(real_x)
 ld	(old_x),hl
 ld	a,1
 ld	(smooth),a
 ld	a,0
 ld	(real_y),a
 pop	af
MoGoDown:
 push	af
 ld	a,2
 ld	(direction),a
 pop	af
 add a,16
 jr GoStuff

GoStuff:
 ld d,0
 ld e,a
 ld hl,GameBoard
 add hl,de
 ld a,(hl)
 cp 2
 JUMP_NC(AdjustCoords)
 cp 1
 jr nz,MoGoStuff
 ld a,(CoinsLeft)
 dec a
 JUMP_Z(EarnedLevel)            ;Go to next level
 ld (CoinsLeft),a
MoGoStuff:
 ld a,(SlippyPos)
 ld b,0
 ld c,a
 ld hl,GameBoard
 add hl,bc
 ld (hl),0
 ld hl,GameBoard
 add hl,de
 ld (hl),5
 ld a,e
 ld (SlippyPos),a
 CALL_(GoSlippy)
 JUMP_(InputLoop)

AdjustCoords:
 ld	a,(smooth)
 cp	1
 JUMP_NZ(InputLoop)
 ld	hl,(old_x)
 ld	(real_x),hl
 CALL_(GoSlippy)
 JUMP_(InputLoop)

PushMode:
 bit 0,b
 JUMP_Z(PushDown)
 bit 1,b
 jr z,PushLeft
 bit 2,b
 jr z,PushRight
 bit 3,b
 JUMP_Z(PushUp
 JUMP_(InputLoop)

PushLeft:
 ld a,(SlippyPos)
 and %00001111
 ld a,(SlippyPos)
 jr nz,MoPushLeft
 JUMP_(InputLoop)
MoPushLeft:
 push	af
 ld	a,3
 ld	(direction),a
 ld	a,(real_x)
 sub	6
 ld	(box_x),a
 ld	a,(real_y)
 ld	(box_y),a
 pop	af
 dec a
 CALL_(PushStuff)
BoxLeft:
 ld a,(BoxPos)
 and %00001111
 ld a,(BoxPos)
 jr nz,MoBoxLeft
 JUMP_(BoxDeath)
MoBoxLeft:
 dec a
 CALL_(BoxStuff)
 jr BoxLeft

PushRight:
 ld a,(SlippyPos)
 inc a
 and %00001111
 ld a,(SlippyPos)
 jr nz,MoPushRight
 JUMP_(InputLoop)
MoPushRight:
 push	af
 ld	a,4
 ld	(direction),a
 ld	a,(real_x)
 add	a,6
 ld	(box_x),a
 ld	a,(real_y)
 ld	(box_y),a
 pop	af
 inc a
 CALL_(PushStuff)
BoxRight:
 ld a,(BoxPos)
 inc a
 and %00001111
 ld a,(BoxPos)
 jr nz,MoBoxRight
 JUMP_(BoxDeath)
MoBoxRight:
 inc a
 CALL_(BoxStuff)
 jr BoxRight

PushUp:
 ld a,(SlippyPos)
 sub 16
 cp 200
 ld a,(SlippyPos)
 jr c,MoPushUp
 JUMP_(InputLoop)
MoPushUp:
 push	af
 ld	a,1
 ld	(direction),a
 ld	a,(real_x)
 ld	(box_x),a
 ld	a,(real_y)
 sub	6
 ld	(box_y),a
 pop	af
 sub 16
 CALL_(PushStuff)
BoxUp:
 ld a,(BoxPos)
 sub 16
 cp 200
 ld a,(BoxPos)
 jr c,MoBoxUp
 JUMP_(BoxDeath)
MoBoxUp:

 sub 16
 CALL_(BoxStuff)
 jr BoxUp

PushDown:
 ld a,(SlippyPos)
 add a,16
 cp 144
 ld a,(SlippyPos)
 jr c,MoPushDown
 JUMP_(InputLoop)
MoPushDown:
 push	af
 ld	a,2
 ld	(direction),a
 ld	a,(real_x)
 ld	(box_x),a
 ld	a,(real_y)
 add	a,6
 ld	(box_y),a
 pop	af
 add a,16
 CALL_(PushStuff)
BoxDown:
 ld a,(BoxPos)
 add a,16
 cp 144
 ld a,(BoxPos)
 jr c,MoBoxDown
 JUMP_(BoxDeath)
MoBoxDown:

 add a,16
 CALL_(BoxStuff)
 jr BoxDown

PushStuff:
 ld d,0
 ld e,a
 ld hl,GameBoard
 add hl,de
 ld a,(hl)
 cp 4
 jr z,MoPushStuff
 pop hl ;Get rid of CALL_
 JUMP_(InputLoop)
MoPushStuff:
 ld a,e
 ld (BoxPos),a
 ret
 
BoxStuff:
 ld d,0
 ld e,a
 ld hl,GameBoard
 add hl,de
 ld a,(hl)
 cp 3
 jr nc,BoxStop
 cp 2
 jr z,BoxFill
BoxGo:
 ld a,(BoxPos)
 ld b,0
 ld c,a
 ld hl,GameBoard
 add hl,bc
 ld (hl),0
 ld hl,GameBoard
 add hl,de
 ld (hl),4
 ld a,e
 ld (BoxPos),a
 CALL_(GoBox)
 ret
BoxStop:
 pop hl ;Get rid of CALL_
 JUMP_(InputLoop)
BoxFill:
 ld a,(BoxPos)
 ld b,0
 ld c,a
 ld hl,GameBoard
 add hl,bc
 ld (hl),0
 ld hl,GameBoard
 add hl,de
 ld (hl),0
 CALL_(DrawBoard)
 pop hl ;Get rid of CALL_
 JUMP_(InputLoop)

BoxDeath:
 ld a,(BoxPos)
 ld d,0
 ld e,a
 ld hl,GameBoard
 add hl,de
 ld (hl),0
 CALL_(DrawBoard)
 JUMP_(InputLoop)

KeyGet:
 ld a,%00111110 ;masks out all but More, F1, 2nd, Exit, Up, Right, Left, Down
 out ($01),a
 in a,($01)
 ret

GoBox:
 ld	hl,box0
 ld	(bitmap),hl
 ld	hl,(box_x)
 ld	(temp_x),hl
 ld	a,(direction)
 cp	1
 CALL_Z(up)
 cp	2
 CALL_Z(down)
 cp	3
 CALL_Z(left)
 cp	4
 CALL_Z(right)
 ld	hl,(temp_x)
 ld	(box_x),hl
 ret

EarnedLevel:
 ld hl,MaxLevel
 ld a,(CurrentLevel)
 ld b,a
 ld a,(MaxLevel)
 cp b
 jr nz,ELEnd
 cp 24 ;There are 25 levels, 0-24
 jr z,Speecial
 inc a
 ld (hl),a
ELEnd:
 ld	(CurrentLevel),a
 CALL_(set_up_level)
 CALL_(CopyGraphMem)
 JUMP_(InputLoop)
Speecial:
 ROM_CALL(CLEARLCD)
 xor	a
 ld	(CurrentLevel),a
 ld	hl,$0403
 ld	(CURSOR_ROW),hl
 ld	hl,won
 ROM_CALL(D_ZT_STR)
 ROM_CALL(KEY_HAND)
 JUMP_(start)

GoSlippy:
 ld	hl,slippy
 ld	(bitmap),hl
 ld	hl,(real_x)
 ld	(temp_x),hl
 ld	a,(smooth)
 cp	1
 JUMP_Z(not_smooth)
 ld	a,(direction)
 cp	1
 CALL_Z(up)
 cp	2
 CALL_Z(down)
 cp	3
 CALL_Z(left)
 cp	4
 CALL_Z(right)
 ld	hl,(temp_x)
 ld	(real_x),hl
 ret

not_smooth:
 CALL_(DrawBoard)
 ld	a,(temp_x)
 ld	b,a
 ld	a,(temp_y)
 ld	c,a
 ld	hl,blank
 CALL_(PutSprite)
 CALL_(CopyGraphMem)
 ld	a,0
 ld	(smooth),a
 ret

left:
 ld	b,6
l_loop:
 push	bc
 ld	a,(temp_x)
 ld	b,a
 ld	a,(temp_y)
 ld	c,a
 ld	hl,blank
 CALL_(PutSprite)
 ld	a,(temp_x)
 dec	a
 ld	(temp_x),a
 ld	b,a
 ld	a,(temp_y)
 ld	c,a
 ld	hl,(bitmap)
 CALL_(PutSprite)
 CALL_(CopyGraphMem)
 CALL_(short_delay)
 pop	bc
 djnz   l_loop
 ret
right:
 ld	b,6
r_loop:
 push	bc
 ld	a,(temp_x)
 ld	b,a
 ld	a,(temp_y)
 ld	c,a
 ld	hl,blank
 CALL_(PutSprite)
 ld	a,(temp_x)
 inc	a
 ld	(temp_x),a
 ld	b,a
 ld	a,(temp_y)
 ld	c,a
 ld	hl,(bitmap)
 CALL_(PutSprite)
 CALL_(CopyGraphMem)
 CALL_(short_delay)
 pop	bc
 djnz   r_loop
 ret
up:
 ld	b,6
u_loop:
 push	bc
 ld	a,(temp_x)
 ld	b,a
 ld	a,(temp_y)
 ld	c,a
 ld	hl,blank
 CALL_(PutSprite)
 ld	a,(temp_x)
 ld	b,a
 ld	a,(temp_y)
 dec	a
 ld	(temp_y),a
 ld	c,a
 ld	hl,(bitmap)
 CALL_(PutSprite)
 CALL_(CopyGraphMem)
 CALL_(short_delay)
 pop	bc
 djnz   u_loop
 ret
down:
 ld	b,6
d_loop:
 push	bc
 ld	a,(temp_x)
 ld	b,a
 ld	a,(temp_y)
 ld	c,a
 ld	hl,blank
 CALL_(PutSprite)
 ld	a,(temp_x)
 ld	b,a
 ld	a,(temp_y)
 inc	a
 ld	(temp_y),a
 ld	c,a
 ld	hl,(bitmap)
 CALL_(PutSprite)
 CALL_(CopyGraphMem)
 CALL_(short_delay)
 pop	bc
 djnz   d_loop
 ret

short_delay:
 ld	b,2
del_loop:
 halt
 djnz	del_loop
 ret

DrawBoard:
 ld	hl,GameBoard
 ld	a,0
 ld	(temp_y),a
 ld	b,9
yloop1:
 push	bc
 ld	a,0
 ld	(temp_x),a
 ld	b,16
xloop1:
 push	bc
 ld	a,(temp_x)
 ld	b,a
 ld	a,(temp_y)
 ld	c,a
 ld	a,(hl)
 push	hl
 CALL_(PutBlock_wo)
 pop	hl
 ld	a,(temp_x)
 add	a,6
 ld	(temp_x),a
 inc	hl
 pop	bc
 djnz	xloop1
 ld	a,(temp_y)
 add	a,6
 ld	(temp_y),a
 pop	bc
 djnz	yloop1
 CALL_(PutSlippy)
 CALL_(CopyGraphMem)
 ret

set_up_level:
 ld	a,0
 ld	(direction),a
 ld	(smooth),a

 ld	hl,CurrentLevel
 ld	a,(hl)
 ld	(Level),a
 ld	h,0
 ld	l,a
 add	hl,hl		;*2
 add	hl,hl		;4
 ld	b,h
 ld	c,l
 add	hl,hl		;8
 ld	d,h
 ld	e,l
 add	hl,hl		;16
 add	hl,hl		;32
 add	hl,hl		;64
 add	hl,de
 add	hl,bc
 ld	de,LevelData
 add	hl,de
 ld	ix,GameBoard
 ld	a,0
 ld	(temp_y),a
 ld	b,9
yloop:
 push	bc
 ld	a,0
 ld	(temp_x),a
 ld	b,8
xloop:
 push	bc
 ld	a,(temp_x)
 ld	b,a
 ld	a,(temp_y)
 ld	c,a
 ld	a,(hl)
 srl	a
 srl	a
 srl	a
 srl	a
 and	15
 push	hl
 CALL_(PutBlock)
 pop	hl
 ld	a,(temp_x)
 add	a,6
 ld	(temp_x),a
 ld	b,a
 ld	a,(temp_y)
 ld	c,a
 ld	a,(hl)
 and	15
 push	hl
 CALL_(PutBlock)
 pop	hl
 inc	hl
 ld	a,(temp_x)
 add	a,6
 ld	(temp_x),a
 pop	bc
 djnz	xloop
 ld	a,(temp_y)
 add	a,6
 ld	(temp_y),a
 pop	bc
 djnz	yloop
 ld	de,CoinsLeft
 ld	bc,4
 ldir
 CALL_(PutSlippy)
 ret

PutSlippy:
 ld	a,(real_x)
 ld	b,a
 ld	a,(real_y)
 ld	c,a
 ld	hl,slippy
 CALL_(PutSprite)
 ret

PutBlock:
 ld	(ix),a
 inc	ix
PutBlock_wo:
 add	a,a
 add	a,a
 add	a,a
 ld	hl,sprites
 ld	d,0
 ld	e,a
 add	hl,de
 CALL_(PutSprite)
 ret

put_status:
 ld	hl,TitleBitmap
 ex	de,hl
 ld	hl,GRAPH_MEM+(12*55)+2
 ld	b,8
status_loop:
 push	bc
 ex	de,hl
 ld	bc,8
 ldir
 ex	de,hl
 ld	bc,4
 add	hl,bc
 pop	bc
 djnz	status_loop
 CALL_(CopyGraphMem)
 ret

PutSprite: ; Puts a sprite stored at (HL) at B,C
 push	ix
 push 	bc
 push 	de
 ld 	a,63
 sub 	c
 ld 	c,a
 push 	hl
 push 	hl
 call 	$4166
 ld 	de,$88B8
 add 	hl,de
 ex 	de,hl
 pop 	hl
 ld 	b,(hl)
 inc 	hl
 ld 	c,(hl)
 inc 	hl
 push 	hl
 pop 	ix
 ex 	de,hl
PS_NewRow:
 push 	bc
 ld 	d,(ix)
 inc 	ix
 push 	af
 push 	hl
PS_NewCol:
 rl 	d
 ld 	e,a
 jr 	nc,PS_NoPixel
 or 	(hl)
 ld 	(hl),a
 jr 	PS_NextPixel
PS_NoPixel:
 cpl
 and 	(hl)
 ld 	(hl),a
PS_NextPixel:
 ld 	a,e
 rrca
 jr 	nc,PS_SameByte
 inc 	hl
PS_SameByte:
 djnz 	PS_NewCol
 pop 	hl
 pop 	af
 ld 	de,12
 add 	hl,de
 pop 	bc
 dec 	c
 jr 	nz,PS_NewRow
 pop 	hl
 pop 	de
 pop 	bc
 pop	ix
 ret

CLRGBU:
 ld 	hl,GRAPH_MEM
 ld 	de,GRAPH_MEM+1
 ld 	bc,$2FF
 ld 	(hl),0
 ldir
 ret

CopyGraphMem:			;a fine routine from Showpic by Dines J.
 ld	hl,GRAPH_MEM
 LD 	A,7
 CALL 	$7F3
 OUT 	($10),A			;wacky port stuff, read 82-ports.txt for more info
 LD 	A,$80
LineLoop:
 LD 	D,A          		; Save currect coloum
 CALL 	$7F3
 OUT 	($10),A
 LD 	A,$20        		; Goto top
 CALL 	$7F3
 OUT 	($10),A
 LD 	BC,$0C11     		; 40 bytes to port 10
WriteLoop:              	; Write them
 NEG
 NEG
 NEG
 NEG
 OUTI
 JR 	NZ,WriteLoop
 LD 	A,D
 INC 	A
 CP 	$C0
 JR NZ,LineLoop
 RET


LevelData:
.db $33,$33,$33,$33,$33,$33,$33,$33
.db $31,$11,$11,$12,$00,$21,$11,$13
.db $32,$22,$22,$22,$00,$22,$22,$23
.db $31,$20,$00,$04,$00,$00,$00,$03
.db $31,$20,$00,$30,$00,$00,$44,$03
.db $31,$20,$00,$00,$00,$00,$00,$03
.db $32,$20,$00,$40,$00,$00,$00,$03
.db $30,$00,$00,$00,$00,$00,$00,$53
.db $33,$33,$33,$33,$33,$33,$33,$33
.db 13,126,84,42

.db $32,$32,$33,$30,$33,$33,$33,$33
.db $30,$00,$31,$11,$11,$13,$03,$03
.db $04,$00,$33,$33,$33,$03,$05,$02
.db $00,$00,$21,$11,$11,$13,$04,$03
.db $33,$33,$33,$33,$33,$33,$00,$03
.db $31,$11,$30,$03,$00,$00,$32,$33
.db $31,$33,$30,$00,$00,$40,$31,$13
.db $01,$30,$00,$30,$00,$40,$21,$10
.db $31,$30,$33,$32,$33,$33,$33,$33
.db 22,45,78,12

.db $33,$33,$33,$33,$33,$33,$33,$33
.db $35,$00,$00,$03,$22,$20,$13,$13
.db $30,$40,$40,$42,$32,$10,$03,$23
.db $30,$00,$30,$00,$02,$33,$33,$13
.db $30,$30,$00,$00,$04,$00,$00,$03
.db $32,$30,$00,$04,$00,$00,$00,$03
.db $31,$30,$40,$30,$00,$00,$00,$03
.db $31,$30,$00,$30,$00,$00,$00,$03
.db $33,$33,$33,$33,$33,$33,$33,$33
.db 6,17,6,6

.db $33,$33,$33,$33,$33,$33,$33,$33
.db $35,$00,$00,$00,$00,$00,$21,$13
.db $33,$30,$00,$04,$00,$40,$31,$13
.db $31,$20,$00,$00,$00,$00,$31,$13
.db $33,$30,$04,$00,$00,$40,$33,$33
.db $31,$20,$00,$00,$00,$00,$21,$13
.db $33,$30,$00,$04,$00,$00,$31,$13
.db $31,$20,$00,$00,$00,$00,$31,$13
.db $33,$33,$33,$33,$33,$33,$33,$33
.db 15,17,6,6

.db $30,$00,$30,$00,$30,$00,$30,$33
.db $00,$00,$00,$00,$00,$00,$00,$03
.db $30,$00,$00,$00,$00,$00,$00,$03
.db $00,$00,$00,$00,$40,$00,$04,$03
.db $23,$23,$04,$04,$00,$00,$00,$03
.db $21,$13,$00,$02,$22,$23,$30,$03
.db $21,$13,$33,$33,$32,$30,$00,$03
.db $21,$11,$11,$11,$11,$30,$04,$03
.db $22,$22,$22,$22,$22,$25,$00,$33
.db 13,139,66,48

.db $33,$33,$33,$00,$33,$33,$33,$33
.db $30,$00,$00,$00,$00,$02,$11,$13
.db $30,$00,$00,$04,$30,$02,$04,$03
.db $30,$00,$00,$00,$40,$02,$20,$23
.db $30,$00,$00,$00,$00,$00,$00,$53
.db $30,$00,$00,$00,$00,$02,$22,$23
.db $00,$00,$00,$40,$00,$02,$11,$13
.db $30,$00,$00,$00,$00,$02,$11,$13
.db $33,$33,$33,$33,$33,$33,$33,$33
.db 9,78,84,24

.db $33,$33,$33,$33,$23,$33,$33,$33
.db $35,$00,$00,$00,$00,$33,$11,$13
.db $30,$00,$00,$04,$00,$02,$11,$13
.db $33,$33,$30,$00,$04,$03,$33,$33
.db $31,$11,$20,$40,$00,$04,$00,$03
.db $33,$33,$32,$33,$00,$00,$00,$03
.db $30,$00,$31,$13,$30,$00,$00,$03
.db $30,$00,$31,$13,$13,$00,$00,$03
.db $33,$33,$33,$33,$13,$33,$33,$33
.db 15,17,6,6

.db $33,$00,$03,$33,$33,$33,$33,$13
.db $33,$04,$02,$03,$00,$30,$00,$23
.db $35,$40,$02,$00,$00,$20,$00,$33
.db $30,$00,$03,$00,$00,$30,$00,$03
.db $33,$22,$33,$32,$23,$33,$22,$33
.db $30,$00,$03,$34,$40,$31,$11,$13
.db $33,$44,$02,$00,$40,$31,$13,$33
.db $20,$00,$03,$00,$00,$31,$13,$00
.db $33,$33,$33,$33,$33,$33,$33,$03
.db 9,33,6,12

.db $33,$33,$33,$33,$33,$33,$33,$33  ;Created by Carlos Rodriguez
.db $31,$20,$00,$00,$00,$02,$11,$13
.db $31,$20,$00,$05,$00,$03,$33,$33
.db $31,$20,$30,$00,$00,$00,$21,$13
.db $31,$20,$00,$40,$00,$00,$24,$13
.db $31,$20,$40,$00,$00,$00,$23,$23
.db $31,$20,$04,$04,$30,$00,$21,$13
.db $31,$20,$00,$30,$00,$00,$21,$13
.db $33,$33,$33,$33,$33,$33,$33,$33
.db 17,39,42,12

.db $33,$33,$33,$33,$33,$33,$33,$33  ;Created by Tae-Ho Kim
.db $31,$11,$20,$00,$03,$11,$11,$11
.db $33,$33,$30,$00,$03,$43,$23,$33
.db $00,$00,$00,$00,$00,$00,$00,$00
.db $35,$44,$44,$44,$00,$00,$03,$33
.db $33,$20,$00,$00,$30,$00,$02,$23
.db $31,$23,$33,$33,$33,$23,$33,$13
.db $31,$11,$11,$13,$11,$11,$13,$13
.db $33,$33,$33,$33,$33,$33,$33,$33
.db 23,65,6,24

.db $33,$33,$33,$33,$33,$33,$33,$33  ;Created by Tae-Ho Kim
.db $30,$00,$00,$22,$11,$21,$11,$13
.db $35,$40,$44,$43,$33,$32,$33,$33
.db $13,$30,$00,$00,$00,$04,$21,$12
.db $11,$30,$00,$40,$33,$40,$21,$13
.db $11,$30,$00,$00,$33,$00,$33,$33
.db $33,$32,$30,$00,$33,$40,$21,$13
.db $21,$12,$20,$00,$33,$00,$21,$11
.db $33,$33,$33,$33,$33,$33,$33,$33
.db 22,33,6,12

.db $33,$33,$33,$30,$30,$00,$00,$00
.db $31,$11,$11,$11,$32,$03,$00,$30
.db $32,$32,$33,$32,$32,$00,$40,$50
.db $30,$20,$00,$30,$30,$00,$00,$00
.db $33,$00,$00,$00,$00,$00,$00,$00
.db $30,$40,$03,$00,$30,$40,$40,$00
.db $30,$00,$00,$03,$04,$00,$00,$00
.db $33,$00,$00,$00,$00,$00,$40,$03
.db $33,$33,$33,$32,$33,$33,$33,$33
.db 7,46,84,12

.db $33,$33,$33,$30,$33,$33,$33,$33 ;Created by Andreas Ess' brother
.db $30,$00,$33,$33,$33,$33,$30,$03
.db $33,$00,$00,$00,$00,$30,$04,$03
.db $30,$00,$00,$00,$00,$00,$00,$03
.db $30,$40,$40,$00,$00,$00,$00,$03
.db $32,$32,$33,$30,$00,$00,$00,$03
.db $31,$11,$31,$30,$00,$40,$00,$03
.db $31,$11,$21,$30,$00,$00,$00,$03
.db $33,$33,$33,$30,$05,$03,$33,$33
.db 8,137,54,48

.db $33,$00,$00,$00,$33,$33,$33,$33 ;Tae Ho
.db $20,$00,$00,$00,$31,$13,$12,$11
.db $30,$04,$44,$00,$33,$23,$33,$43
.db $20,$00,$00,$00,$00,$02,$13,$11
.db $30,$04,$44,$00,$34,$43,$33,$33
.db $20,$04,$54,$00,$00,$03,$21,$11
.db $32,$33,$33,$32,$33,$23,$13,$43
.db $21,$14,$24,$12,$31,$23,$13,$11
.db $33,$33,$33,$33,$33,$33,$33,$33
.db 19,84,24,30

.db $33,$33,$00,$00,$33,$33,$33,$33 ;Daniel Walls
.db $31,$13,$04,$00,$00,$22,$11,$13
.db $31,$12,$00,$03,$00,$22,$11,$13
.db $34,$33,$00,$40,$00,$22,$11,$13
.db $35,$04,$00,$00,$33,$00,$32,$33
.db $30,$00,$40,$00,$00,$03,$32,$33
.db $33,$33,$22,$33,$23,$20,$00,$33
.db $11,$20,$00,$00,$00,$04,$00,$22
.db $33,$33,$33,$33,$33,$33,$33,$33
.db 15,65,6,24

.db $33,$33,$33,$30,$03,$30,$03,$33  ;Tae Ho
.db $31,$31,$21,$20,$00,$00,$00,$41
.db $32,$33,$33,$30,$00,$00,$00,$21
.db $30,$00,$00,$40,$00,$04,$40,$33
.db $30,$30,$30,$00,$00,$00,$00,$00
.db $35,$40,$40,$40,$04,$00,$30,$40
.db $32,$32,$32,$32,$30,$00,$00,$33
.db $31,$31,$31,$31,$30,$00,$00,$21
.db $31,$31,$31,$33,$30,$03,$03,$31
.db 14,81,6,30

.db $53,$30,$00,$31,$33,$33,$33,$33  ;Tae Ho
.db $00,$40,$40,$32,$31,$12,$11,$13
.db $04,$00,$00,$00,$33,$33,$22,$33
.db $00,$40,$00,$00,$30,$00,$00,$33
.db $04,$00,$00,$00,$30,$43,$00,$33
.db $00,$00,$00,$00,$20,$00,$00,$33
.db $03,$00,$03,$23,$33,$33,$00,$03
.db $04,$04,$03,$11,$31,$22,$00,$03
.db $00,$00,$03,$33,$33,$33,$33,$33
.db 9,0,0,0

.db $13,$33,$33,$33,$33,$33,$33,$33  ;Tae Ho
.db $13,$12,$11,$12,$11,$13,$13,$13
.db $13,$33,$22,$13,$33,$13,$13,$13
.db $11,$23,$22,$33,$33,$33,$23,$23
.db $33,$20,$00,$00,$00,$00,$04,$03
.db $04,$00,$00,$04,$00,$30,$04,$03
.db $54,$00,$00,$03,$00,$40,$04,$03
.db $04,$00,$00,$03,$00,$40,$04,$03
.db $33,$00,$00,$00,$00,$00,$00,$03
.db 18,96,0,36

.db $00,$00,$00,$33,$33,$33,$33,$33 ;Tae Ho
.db $04,$44,$00,$02,$21,$12,$12,$13
.db $04,$54,$04,$03,$33,$33,$33,$33
.db $04,$44,$00,$03,$12,$20,$02,$13
.db $04,$04,$04,$03,$33,$30,$03,$13
.db $00,$00,$00,$02,$12,$00,$03,$33
.db $33,$33,$04,$02,$12,$00,$43,$13
.db $31,$12,$00,$03,$33,$00,$02,$13
.db $33,$33,$33,$33,$33,$33,$33,$33
.db 13,34,12,12

.db $00,$00,$00,$33,$33,$33,$33,$33 ;Tae Ho
.db $04,$44,$03,$32,$13,$12,$52,$13
.db $00,$00,$00,$21,$33,$30,$43,$13
.db $04,$33,$00,$21,$21,$30,$03,$13
.db $04,$04,$00,$33,$33,$32,$23,$33
.db $04,$04,$00,$20,$40,$00,$03,$13
.db $00,$00,$00,$20,$00,$40,$03,$13
.db $03,$44,$33,$33,$32,$32,$23,$13
.db $00,$00,$00,$31,$11,$31,$11,$13
.db 18,28,72,6

.db $33,$33,$33,$33,$11,$13,$50,$30 ;Tae Ho
.db $31,$12,$11,$13,$33,$33,$44,$40
.db $33,$33,$11,$12,$21,$13,$00,$00
.db $31,$12,$11,$13,$33,$33,$04,$00
.db $33,$33,$22,$23,$00,$00,$03,$40
.db $00,$00,$00,$03,$00,$00,$00,$00
.db $04,$00,$00,$00,$04,$00,$00,$00
.db $03,$00,$00,$00,$04,$00,$00,$03
.db $03,$00,$00,$03,$23,$33,$30,$00
.db 18,12,72,0

.db $31,$11,$33,$33,$33,$33,$33,$33 ;Tae Ho
.db $33,$23,$20,$00,$00,$00,$02,$11
.db $31,$11,$20,$03,$33,$33,$33,$33
.db $32,$14,$20,$02,$21,$21,$12,$11
.db $31,$11,$20,$03,$33,$33,$33,$33
.db $32,$32,$30,$00,$40,$40,$40,$40
.db $31,$31,$30,$00,$00,$00,$00,$40
.db $31,$31,$30,$04,$44,$44,$44,$30
.db $33,$33,$30,$00,$00,$00,$00,$05
.db 21,143,90,48

.db $33,$30,$00,$30,$03,$33,$31,$13 ;Tae Ho
.db $11,$30,$00,$00,$02,$13,$33,$23
.db $12,$20,$00,$00,$03,$33,$11,$13
.db $33,$30,$00,$04,$02,$45,$21,$13
.db $13,$30,$00,$00,$03,$34,$32,$23
.db $12,$00,$04,$40,$04,$00,$31,$13
.db $33,$00,$04,$00,$40,$00,$33,$23
.db $12,$00,$03,$40,$40,$43,$31,$13
.db $13,$03,$00,$00,$00,$03,$33,$33
.db 19,59,66,18

.db $33,$33,$33,$33,$33,$33,$33,$33 ;Tae Ho
.db $31,$13,$11,$12,$13,$11,$21,$13
.db $31,$12,$11,$13,$13,$11,$32,$13
.db $32,$33,$32,$23,$33,$33,$32,$33
.db $32,$31,$30,$00,$00,$30,$00,$33
.db $31,$31,$30,$44,$40,$00,$00,$00
.db $33,$31,$30,$00,$00,$00,$00,$00
.db $31,$21,$20,$43,$44,$44,$44,$40
.db $33,$33,$33,$00,$00,$00,$00,$05
.db 25,143,90,48

.db $33,$33,$33,$33,$33,$33,$33,$33 ;Tae Ho
.db $31,$12,$21,$21,$11,$33,$11,$13
.db $31,$13,$31,$31,$11,$22,$11,$13
.db $33,$33,$33,$32,$23,$33,$33,$23
.db $00,$00,$00,$00,$00,$00,$03,$23
.db $00,$00,$00,$00,$00,$00,$03,$13
.db $04,$40,$00,$00,$00,$00,$03,$13
.db $00,$04,$44,$40,$04,$44,$03,$33
.db $00,$00,$00,$00,$00,$00,$00,$05
.db 20,143,90,48

TitleBitmap:
.db
%00011000,%00011111,%11001111,%01110000,%00000000,%00000000,%00000000,%00011000
.db
%00111110,%00111100,%00001111,%00000000,%00000000,%00000000,%00000000,%01111100
.db
%01110100,%00111111,%11011110,%11110011,%11111001,%11111101,%11101110,%00101110
.db
%11100010,%00111111,%11011110,%11110111,%10011011,%11001111,%11101110,%01000111
.db
%01110001,%00111111,%11011100,%11101111,%00111111,%10011111,%11011100,%10001110
.db
%01111010,%00000001,%10111101,%11101111,%11110111,%11111011,%11111100,%01011110
.db
%11100111,%01111111,%10111101,%11101111,%11110111,%11111000,%00111100,%11100111
.db
%00000000,%00000000,%00000000,%00011110,%00001111,%00000011,%11111000,%00000000

curlevstr:
 .db "Cur Level:",0
maxlevstr:
 .db "Max Level:",0
won:
 .db "You Won!",0
MaxLevel:
 .db 0
CurrentLevel:
 .db 0
by:
 .db "Andrew Von Dollen",0
email:
 .db "warn@geocities.com",0

sprites:
.include slipspr.txt

.end
END
