	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	;;;                                                    ;;;
	;;;   SSSS                     GGG                     ;;;
	;;;  S                        G   G                    ;;;
	;;;  S      aaa  mm m   eee   G      aaa  mm m   eee   ;;;
	;;;   SSS      a m m m e   e  G GGG     a m m m e   e  ;;;
	;;;      S  aaaa m m m eeeee  G   G  aaaa m m m eeeee  ;;;
	;;;      S a   a m   m e      G   G a   a m   m e      ;;;
	;;;  SSSS   aaaa m   m  eee    GGG   aaaa m   m  eee   ;;;
	;;;                                                    ;;;
	;;;                   v1.3 by Adamman                  ;;;
	;;;                      10/17/97                      ;;;
	;;;                    For  Ash 3.0                    ;;;
	;;;                                                    ;;;
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;here's the source to SameGame...Remember to give me credit...If you find something really badly coded, email me...There's some weird stuff, but it's pretty well commented...That's it, enjoy!
;You may also want to turn off word wrap


#include ti82.h

GAME_BOARD = TEXT_MEM			;the pile of tiles you're playing on, 96
SCORE = TEXT_MEM+96			;your score, duh, 2
RANDSEED = TEXT_MEM+98			;the randseed for GETRAND, 2
GAME_MODE = TEXT_MEM+100		;the game mode, 1
COUNT = TEXT_MEM+101			;used in INPUT and Action Mode, 1
SMALL_COUNT = TEXT_MEM+102		;used in action mode, 1

SAVE_B = TEXT_MEM+103			;used in action mode, 1
string = TEXT_MEM+104			;used in DM_HL_DECI, 6
MATCH_THIS = TEXT_MEM+110		;stores the number you have to match
						;when you eliminate tiles, 1
noLet = TEXT_MEM+111			;used in INPUT, 1

.org START_ADDR
.db "SameGame v1.3 by Adamman", 0

START:
	res 7, (iy+$14)			;write menu style strings to the lcd
	res 1, (iy+$0D)			;write text style strings to the lcd

	ld a, (SAVED)			;is the game saved? (was the teacher key used?)
	or a					;cp 0
	jr z, NOT_SAVED			;nope, start new game

	ld de, (OLD_DE)			;yes, restore cursor positions de
	ld ix, (OLD_IX)			;and ix | Teacher key stuff, not in this version
	call UNDO				;restore whole game
	call REFRESH_SCREEN		;refresh the graph mem
	ld a, (GAME_MODE)			;check what the mode was
	or a					;cp 0
	jr nz, ACTION_SAVED		;it's action mode
	call z, PUZZLE_SAVED		;it's puzzle mode
	jr NOT_SAVED			;dont call ACTION_LOOP!
ACTION_SAVED:
	call ACTION_LOOP			;action looper
NOT_SAVED:

	ld hl, 0				;init score
	ld (SCORE), hl			;|

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                     ;;;
;;;  Display the nifty title screen!!!  ;;;
;;;                                     ;;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	ld hl, Title_Pic			;the title picture
	ld de, $88B8			;GRAPH_MEM
	ld bc, $300				;length of graph mem=$300=768
	ldir					;copy it
	ROM_CALL(DISP_GRAPH)		;copy the graph mem to the lcd

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                         ;;;
;;;  End of the Title Part  ;;;
;;;                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	ld a, r				;get partial randseed
	ld l, a				;|
	srl a					;|
	ld h, a				;|

	push hl
	ld de, $8A53			;addr in graph mem for the bullet
	xor a					;the current game mode (xor a=ld a, 0)
	ld (GAME_MODE), a			;0=puzzle, 1=action
	ld hl, HI_SCORE_P			;load the high score to be displayed
	call PUT_SCORE			;display the score
	pop hl

key_loop1:
	push hl				;GET_KEY destroys hl
	call GET_KEY
	push af				;save af twice
	push af				;|
	cp 1					;down arrow
	call z, Move
	pop af
	cp 4					;up arrow
	call z, Move
	pop af
	pop hl
	inc hl				;hl is our randseed, inc it every loop
	cp 15					;clear
	ret z
	push af
	ld a, $BF				;the mask for Y=+GRAPH detection
	out (1), a				;mask the port
	in a, (1)				;get input from the port
	cp $EE				;is Y= and GRAPH held down?
	call z, CLEAR_HIS			;yes, clear the high scores
	pop af
	cp 9					;enter
	jr nz, key_loop1

	ld (RANDSEED), hl			;store the randseed
	ld a, (GAME_MODE)			;where did we stop the bullet?
	or a					;cp 0
	push af
	call z, PUZZLE_MODE		;if GAME_MODE = 0
	pop af
	call nz, ACTION_MODE		;if it's 1
	jp START

Move:
	call Bullet_Put			;put the bullet (actually erase it...xor)
	ld a, (GAME_MODE)
	or a					;cp 0
	jr nz, Move_Bullet_Up		;if not, you will move it to 0 = puzzle mode

	ld de, $8AA7			;addr for lower bullet pos
	ld a, 1				;game mode is now 1 = action mode
	ld (GAME_MODE), a
	call Bullet_Put			;now update bullet at the new pos
	ROM_CALL(DISP_GRAPH)		;copy the graph mem to the lcd
	ld hl, HI_SCORE_A			;the action mode high score is displayed
	call PUT_SCORE			;display it
	ret

Move_Bullet_Up:
	ld de, $8A53			;addr for higher bullet pos
	xor a					;ld a, 0 | set mode to puzzle mode
	ld (GAME_MODE), a
	call Bullet_Put			;draw bullet
	ROM_CALL(DISP_GRAPH)		;copy the graph mem to the lcd
	ld hl, HI_SCORE_P			;load the puzzle mode high score for displaying
	call PUT_SCORE			;display the score
	ret

Bullet_Put:
	ld hl, Bullet			;load the sprite
	call PUTPIECE			;display the sprite
	ret

PUT_SCORE:
	push de
	push hl
	ld de, $3A30			;cursor pos for the score is y=58, x=48
	ld ($8215), de
	call LD_HL_MHL			;hl=(hl)
	call DM_HL_DECI			;display the score

	ld hl, $3A4C			;cursor pos is y=58, x=76
	ld ($8215), hl
	pop hl
	inc hl				;assumes that the name is 2 bytes
	inc hl				;after the start of the score
	ROM_CALL(D_ZM_STR)		;display the name of the hiscoree

	pop de
	ret

CLEAR_HIS:
	push hl
	ROM_CALL(DISP_GRAPH)		;copy the graph mem to the lcd
	ld hl, HI_SCORE_P			;start w/ puzzle mode
	ld b, 2				;loop twice
CLEAR_HIS_LOOP:
	ld (hl), $02			;$0002 = 2d
	inc hl
	ld (hl), $00
	inc hl
	inc hl
	ld (hl), 'A'			;self explanatory
	inc hl
	ld (hl), 'A'
	inc hl
	ld (hl), 'S'
	inc hl
	inc hl
	djnz CLEAR_HIS_LOOP		;loop
	ld hl, HI_SCORE_P			;since both scores are equal now
	call PUT_SCORE			;it doesn't matter which you display
	pop hl
	ret

PUZZLE_MODE:
	call PUT_MEMORY			;put the game pieces in the memory
	call REFRESH_SCREEN		;put the pieces on the screen
	ld de, $89DE			;middle of the screen
	ld ix, $80B9			;|
PUZZLE_SAVED:
	call STORE				;store old stats for undo functions
PUZZLE_LOOP:
	call CURSOR				;cursor app - lets you move the cursor around
	call CHECK_PIECES			;checks what pieces are adjacent to (ix) and
						;adjusts the game board
	call GRAVITY			;initiates 'gravity' functions
	call REFRESH_SCREEN		;put the pieces on the screen
	call CHECK_CLEARED		;have you cleared the screen???
	call CHECK_GAME_OVER		;are there no more moves???
	jr PUZZLE_LOOP

ACTION_MODE:
	call PUT_MEMORY			;put the game pieces in the memory
	ld de, $89DE			;middle of the screen
	ld ix, $80B9			;|
	xor a
	ld (SMALL_COUNT), a
	ld a, 50
	ld (COUNT), a
ACTION_LOOP:
	call ACTION_PUTPIECE		;dont ask...try and figger it out
	call REFRESH_SCREEN		;put the pieces on the screen
	ld a, (COUNT)
	ld (SAVE_B), a			;it just so happens that I cant push/pop bc, so I use this
	call CURSOR				;cursor stuff - it's what's happening almost the whole time
	call CHECK_PIECES			;what matches do you have?
	call GRAVITY			;do 'gravity' stuff
	jr ACTION_LOOP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                  ;;;
;;;  Puts the Game Pieces in memory  ;;;
;;;                                  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PUT_MEMORY:
	ld hl, GAME_BOARD+95		;the 12x8 array is stored in the text mem, start at end
	ld a, (GAME_MODE)			;what mode are we in?
	or a					;cp 0
	ld b, 96				;12x8=96 :)
	jr z, PUT_MEMORY_LOOP		;puzzle mode
	ld b, 48				;action mode; only fill half of the screen

PUT_MEMORY_LOOP:
	call RANDOM				;random number between 1 and 5
	ld (hl), a				;store the number
	dec hl				;go to next byte
	djnz PUT_MEMORY_LOOP

	ld a, (GAME_MODE)
	or a					;cp 0
	ret z					;puzzle mode, go back
	ld b, 48				;action mode, fill the rest w/ zeros
LOOP2:
	ld (hl), 0				;clear the remaining space
	dec hl
	djnz LOOP2
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                               ;;;
;;;  End of Put Pieces in memory  ;;;
;;;                               ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                      ;;;
;;;  Refresh the screen to coordinate with the text mem  ;;;
;;;                                                      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

REFRESH_SCREEN:
	push ix
	push de				;save de because it is important
	call BUFCLEAR			;clear the Graph mem
	ld ix, GAME_BOARD			;set ix to read our array
	ld de, $88B8			;Graph mem
	ld b, 12				;12 pieces to each row
	ld c, 8				;8 rows
REFRESH_SCREEN_LOOP:
	ld a, (ix)				;read the array
	or a					;cp 0
	jr z, REFRESH_SCREEN_NULL	;the piece is blank
	cp 1					;store
	ld hl, PIECE1			;the
	jr z, PUT_THE_PIECE		;pieces
	cp 2					;that
	ld hl, PIECE2			;correspond
	jr z, PUT_THE_PIECE		;with
	cp 3					;the
	ld hl, PIECE3			;text
	jr z, PUT_THE_PIECE		;mem
	cp 4
	ld hl, PIECE4
	jr z, PUT_THE_PIECE
	ld hl, PIECE5
PUT_THE_PIECE:
	push bc
	call PUTPIECE			;put the piece in the graph mem
	pop bc
REFRESH_SCREEN_NULL:
	inc de				;next byte in the graph mem
	inc ix				;next byte in the text mem
	djnz REFRESH_SCREEN_LOOP	;put all 12 pieces in that row
	dec de
	dec c					;when done with one row, dec the rows left counter
	jr nz, PUT_THE_PIECE_GO_ON1

	pop de				;restore de
	pop ix
	ret					;and go back home!!!

PUT_THE_PIECE_GO_ON1:
	ld hl, 85				;add 85
	add hl, de				;to get
	ld d, h				;8 rows
	ld e, l				;down
	ld b, 12				;reset the piece counter
	jr REFRESH_SCREEN_LOOP		;keep looping

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                               ;;;
;;;  End of the Screen Refresher  ;;;
;;;                               ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                ;;;
;;;  Draws the cursor and lets you move it around  ;;;
;;;                                                ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

CURSOR:
	ld hl, CURSOR_PIECE		;load the cursor sprite
	call PUTPIECE			;put the cursor
	ROM_CALL(DISP_GRAPH)		;copy the graph mem to the lcd

	ld a, (GAME_MODE)
	or a					;cp 0
	jp nz, CURSOR_ACTION2		;if it's action mode...

CURSOR_KEY_LOOP:
	ld a, (GAME_MODE)
	or a					;cp 0
	jr z, CURSOR_PUZZLE		;if it's puzzle mode...
	ld a, (GAME_BOARD+11)		;is the game over???
	or a					;cp 0
	jp nz, GAME_END			;yes, exit game

CURSOR_PUZZLE:
	call GET_KEY			;get immediate keystroke into a reg
	cp 4					;up arrow
	jr z, MOVE_UP
	cp 1					;down arrow
	jr z, MOVE_DOWN
	cp 3					;right arrow
	jr z, MOVE_RIGHT
	cp 2					;left arrow
	jp z, MOVE_LEFT
	cp 54					;2nd
	ret z
	cp 55					;mode
	call z, PAUSE
	cp 9					;enter
	ret z

	cp 53					;Y=
	jp z, TEACHER_KEY

	cp 15					;clear
	jp z, GAME_END

	ld (OLD_GAME_MODE), a		;save a temporarily
	ld a, (GAME_MODE)			;what mode are we in?
	or a					;cp 0
	jp nz, CURSOR_ACTION2		;if it's action mode...
	ld a, (OLD_GAME_MODE)		;restore a

	cp 56					;del
	jr nz, CURSOR_KEY_LOOP		;keep checking for keypresses
	call UNDO
	jr CURSOR

CURSOR_ERASE:
	push bc
	push hl
	ld hl, CURSOR_PIECE
	call PUTPIECE			;erase the cursor by re-xoring it
	pop hl
	pop bc
	add ix, bc				;get new offset
	ex de, hl
	add hl, de				;update cursor position
	ex de, hl
	jr CURSOR

MOVE_UP:
	ld hl, -96
	ld bc, -12				;to move up 8 lines
	ld a, d				;higher byte of de
	cp $88				;if you're on the top row,
	jr nz, CURSOR_ERASE
	ld hl, $2A0
	ld bc, 84				;wrap around and
	jr CURSOR_ERASE			;erase the cursor

MOVE_DOWN:
	ld hl, 96
	ld bc, 12				;to move down 8 lines
	ld a, d				;higher byte of de
	cp $8B				;if you're on the bottom row,
	jr nz, CURSOR_ERASE
	ld a, e
	cp $04
	jr c, CURSOR_ERASE
	ld hl, -$2A0
	ld bc, -84				;wrap around and
	jr CURSOR_ERASE			;erase the cursor

MOVE_RIGHT:
	ld a, e				;lower byte of de
	ld hl, RIGHT_LIMITS
	ld bc, 8
	cpir
	jr z, MOVE_RIGHT_GO_ON
	ld hl, 1
	ld bc, 1				;move right 1 byte
	jr CURSOR_ERASE			;if not on the right edge
MOVE_RIGHT_GO_ON:
	ld bc, -11				;wrap around and
	ld hl, -11
	jr CURSOR_ERASE			;erase the cursor
RIGHT_LIMITS:
	.db $C3, $23, $83, $E3, $43, $A3, $03, $63

MOVE_LEFT:
	ld a, e				;lower byte of de
	ld hl, LEFT_LIMITS
	ld bc, 8
	cpir
	jr z, MOVE_LEFT_GO_ON
	ld hl, -1
	ld bc, -1				;move right 1 byte
	jp CURSOR_ERASE			;if not on the right edge
MOVE_LEFT_GO_ON:
	ld hl, 11
	ld bc, 11				;wrap around and
	jp CURSOR_ERASE			;erase the cursor
LEFT_LIMITS:
	.db $B8, $18, $78, $D8, $38, $98, $F8, $58

TEACHER_KEY:
	ld a, 1				;1 = saved, 0 = not
	ld (SAVED), a
	call STORE				;save the game board, among other things
	ld (OLD_DE), de			;save de
	ld (OLD_IX), ix			;save ix
	inc sp				;don't return to
	inc sp				;PUZZLE_LOOP
	inc sp				;don't return to
	inc sp				;START
	ret

;;;;;;;;;;;;;;;;;;;;;;;
;;;                 ;;;
;;;  End of Cursor  ;;;
;;;                 ;;;
;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;
;;;                  ;;;
;;;  Action Mode!!!  ;;;
;;;                  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;

CURSOR_ACTION:
	call ACTION_PUTPIECE
	call REFRESH_SCREEN
	ld hl, CURSOR_PIECE		;load the cursor sprite
	call PUTPIECE			;put the cursor
	ROM_CALL(DISP_GRAPH)		;copy the graph mem to the lcd
	ld a, (GAME_BOARD+11)		;top right corner
	or a					;cp 0
	jp nz, GAME_END			;if a piece is there, end game
	ld a, (COUNT)			;restore b to the current count
	ld b, a				;|
ACTION_HALT_LOOP:
	halt					;halt 1/200 sec.
	ld a, b				;save b
	ld (SAVE_B), a			;|
	jp CURSOR_KEY_LOOP		;check for keypresses
CURSOR_ACTION2:
	ld hl, SAVE_B			;hl=addr for saved b value
	ld b, (hl)				;load it
	dec hl				;to small count
	inc (hl)				;increment that
	ld a, (hl)				;test it
	cp $FF
	jr c, DONT_DEC			;if <$FF, don't decrement count!
	dec hl				;hl=count
	dec (hl)				;decrement that
	inc hl				;hl=small count
	ld (hl), 0				;load 0
DONT_DEC:
	djnz ACTION_HALT_LOOP		;loop
	jr CURSOR_ACTION			;do the rest of the action mode stuff

ACTION_ZERO:
	ld b, 12				;12 pieces a row
	ld c, 8				;8 rows
	ld hl, GAME_BOARD+84		;bottom right
ACTION_ZERO_LOOP:
	ld a, (hl)				;test byte
	or a					;cp 0
	ret z					;if 0, put a piece there
	inc hl				;next byte
	djnz ACTION_ZERO_LOOP		;loop

	push de
	ld de, -24				;go up a row
	add hl, de				;|
	pop de
	ld b, 12				;reset to 12 for next row up
	dec c					;decrement row pointer
	jr nz, ACTION_ZERO_LOOP		;loop
	ret

ACTION_PUTPIECE:
	call ACTION_ZERO			;where's the first 0 space?
	call RANDOM				;a random # is always best
	ld (hl), a				;store the #
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                      ;;;
;;;  End of action mode  ;;;
;;;                      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                     ;;;
;;;  The pause feature  ;;;
;;;                     ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;

PAUSE:
	push af
	push de
	ROM_CALL(CLEARLCD)		;clear the screen so no one cheats in action mode
	pop de

	ld hl, $1122			;load coords
	ld ($8215), hl			;|
	ld hl, PAUSE_TEXT			;34, 17
	ROM_CALL(D_ZM_STR)		;display "P A U S E D"

	ld bc, $171D
	ld ($8215), bc			;29, 23
	ROM_CALL(D_ZM_STR)		;display "Score:"
	
	ld bc, $1D24
	ld ($8215), bc			;36, 29
	ROM_CALL(D_ZM_STR)		;display "Hi:"

	ld bc, $231E
	ld ($8215), bc			;30, 35
	ROM_CALL(D_ZM_STR)		;display "SameGame"

	ld bc, $2920
	ld ($8215), bc			;32, 41
	ROM_CALL(D_ZM_STR)		;display "Adamman"

	ld hl, (SCORE)
	ld bc, $1734			;23, 52
	ld ($8215), bc
	call DM_HL_DECI			;display durrent score

	ld bc, $1D2D			;29, 45
	ld ($8215), bc
	ld hl, (HI_SCORE_P)		;puzzle high score
	ld a, (GAME_MODE)
	or a
	jr z, ITS_PUZZLE
	ld hl, (HI_SCORE_A)		;action high score
ITS_PUZZLE:
	call DM_HL_DECI			;display high score

PAUSED:
	call GET_KEY
	or a					;cp 0
	jr z, PAUSED

	ROM_CALL(DISP_GRAPH)		;copy the graph mem to the lcd
	pop af
	ret

;;;;;;;;;;;;;;;;;;;;;;
;;;                ;;;
;;;  End of pause  ;;;
;;;                ;;;
;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                               ;;;
;;;  Functions for undo feature - UNDO and STORE  ;;;
;;;                                               ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

STORE:
	push de
	ld hl, GAME_BOARD			;copying starts at GAME_BOARD...
	ld de, OLD_GAME_BOARD		;copy to OLD_GAME_BOARD
	ld bc, 98				;98 bytes to copy
	ld a, (SAVED)			;has the game been saved?
	or a					;cp 0
	jr z, STORE_NOT_SAVED		;nope
	ld bc, 103				;yeah, copy 103 bytes
STORE_NOT_SAVED:
	ldir
	pop de
	ret

UNDO:
	push de
	ld de, GAME_BOARD			;look at STORE for comments
	ld hl, OLD_GAME_BOARD
	ld bc, 98
	ld a, (SAVED)
	or a
	jr z, UNDO_NOT_SAVED
	xor a					;game is no longer saved
	ld (SAVED), a			;|
	ld bc, 103
UNDO_NOT_SAVED:
	ldir
	call REFRESH_SCREEN
	pop de
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                         ;;;
;;;  End of undo functions  ;;;
;;;                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                    ;;;
;;;  Check what pieces can be removed  ;;;
;;;                                    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

CHECK_PIECES:
	push de				;de holds the cursor pos in the graph mem
	push ix				;ix in the text mem.  both are destroyed
	ld a, (ix)				;the byte in the text mem
	ld (MATCH_THIS), a		;store the piece to match
	or a					;cp 0
	jr z, DONE1				;if it's 0, the score will screw
	call ONLY_ONE			;is this the only piece around it?
	ld e, 0
	call STORE				;store old stats for undo functions
	ld hl, 0
	call CHECK_EDGES			;check the edges so no errors take place
	call UPDATE_SCORE
DONE1:
	pop ix				;restore ix
	pop de				;restore de
	ret

ONLY_ONE:
	ld e, $FF				;if e is $FF
	call CHECK_EDGES			;you will return immediately from CHECK_EDGES
	ld a, (ix)				;get piece
	bit 0, d				;can we check beyond this side?
	jr z, CANT_CHECK_RIGHT		;no
	cp (ix+1)				;compare it
	ret z					;if the same, return
CANT_CHECK_RIGHT:
	bit 1, d
	jr z, CANT_CHECK_LEFT
	cp (ix-1)
	ret z
CANT_CHECK_LEFT:
	bit 2, d
	jr z, CANT_CHECK_UP
	cp (ix-12)
	ret z
CANT_CHECK_UP:
	bit 3, d
	jr z, CANT_CHECK_DOWN
	cp (ix+12)
	ret z
CANT_CHECK_DOWN:
	inc sp
	inc sp
	jr DONE1


CHECK_EDGES:
	push hl
	ld d, 0				;d to know if you are on the edge

	.db $DD				;you need to do this to use the higher and
	ld a, l				;lower bytes of ix.  $DD is the prefix
	ld hl, RIGHT_EDGES		;find out if you are on the right edge
	ld bc, 8
	cpir					;cpir - a very useful instruction
	jr z, CHECK_LEFT_EDGE		;you are on the right edge - dont check beyond!!!
	set 0, d				;you arent on the edge, so you can check beyond

CHECK_LEFT_EDGE:
	.db $DD				;again, the prefix for ix
	ld a, l				;l = IXl
	ld hl, LEFT_EDGES			;find out if you are on the left edge
	ld bc, 8
	cpir
	jr z, CHECK_UPPER_EDGE		;you are - dont mess up!!!
	set 1, d				;you aren't - it's safe

CHECK_UPPER_EDGE:
	.db $DD				;the prefix
	ld a, l				;IXl
	ld hl, UPPER_EDGES		;are you on the upper edge?
	ld bc, 12
	cpir
	jr z, CHECK_LOWER_EDGE		;yes
	set 2, d				;no

CHECK_LOWER_EDGE:
	.db $DD				;ix prefix
	ld a, l				;you know the drill
	ld hl, LOWER_EDGES
	ld bc, 12
	cpir
	jr z, EDGES_ARE_DONE
	set 3, d

EDGES_ARE_DONE:
	pop hl
	ld a, e
	cp $FF				;when called from ONLY_ONE,
	ret z					;return at this point

	bit 0, d				;are you on the right edge?
	jr z, CHECK_LEFT			;yes, don't kill our memory!!!
	ld a, (MATCH_THIS)		;woohoo!!!  we get to check the text mem again!!!
	cp (ix+1)				;is the piece to the right the same?
	jr nz, CHECK_LEFT			;nah
	inc hl
	ld (ix), 0
	inc ix				;well maybe...move to there then
	call CHECK_EDGES			;are we on the edge now?
	dec ix				;no more matches
	jr CHECK_EDGES

CHECK_LEFT:
	bit 1, d
	jr z, CHECK_UP
	ld a, (MATCH_THIS)
	cp (ix-1)
	jr nz, CHECK_UP
	inc hl
	ld (ix), 0
	dec ix
	call CHECK_EDGES
	inc ix
	jp CHECK_EDGES

CHECK_UP:
	bit 2, d
	jr z, CHECK_DOWN
	ld a, (MATCH_THIS)
	cp (ix-12)
	jr nz, CHECK_DOWN
	inc hl
	ld (ix), 0
	ld bc, -12
	add ix, bc
	call CHECK_EDGES
	ld bc, 12
	add ix, bc
	jp CHECK_EDGES

CHECK_DOWN:
	bit 3, d
	jr z, CHECK_NO_MORE
	ld a, (MATCH_THIS)
	cp (ix+12)
	jr nz, CHECK_NO_MORE
	inc hl
	ld (ix), 0
	ld bc, 12
	add ix, bc
	call CHECK_EDGES
	ld bc, -12
	add ix, bc
	jp CHECK_EDGES

CHECK_NO_MORE:
	ld (ix), 0
	ret

RIGHT_EDGES:				;check these values with IXl
	.db $9A, $A6, $B2, $BE, $CA, $D6, $E2, $EE
LEFT_EDGES:
	.db $8F, $9B, $A7, $B3, $BF, $CB, $D7, $E3
UPPER_EDGES:
	.db $8F, $90, $91, $92, $93, $94, $95, $96, $97, $98, $99, $9A
LOWER_EDGES:
	.db $E3, $E4, $E5, $E6, $E7, $E8, $E9, $EA, $EB, $EC, $ED, $EE

UPDATE_SCORE:
	ld d, h				;ld
	ld e, l				;de
	ld b, h				;,
	ld c, l				;hl
	ld hl, 0				;reset hl
UPDATE_SCORE_LOOP:
	add hl, de				;* is repeated +
	dec bc				;add hl w/ de bc times
	ld a, b				;dec bc sets no flags
	or c
	jr nz, UPDATE_SCORE_LOOP	;loop
	ld de, (SCORE)			;old score
	add hl, de				;combined to make...
	ld (SCORE), hl			;new score
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                       ;;;
;;;  End of Check Pieces  ;;;
;;;                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                           ;;;
;;;  Now add the gravity effect to the tiles  ;;;
;;;                                           ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

GRAVITY:
	push ix				;ix and de need to be saved
	push de				;because they hold cursor positions
	ld ix, GAME_BOARD+84		;this is where we start - the lower left
	ld b, 12				;you need to check all 12 rows
GRAVITY_LOOP1:
	push ix				;if you save ix, it's easier to continue
	push bc				;same here
	ld c, 7				;all 7 pieces in each row
	ld b, 7				;7 times in the loop
	call GRAVITY_VERTICAL		;the vertical gravity thing
	pop bc
	pop ix				;restore ix
	inc ix				;update it
	djnz GRAVITY_LOOP1		;and loop da loop

	ld b, 11
	ld c, 11
	ld ix, GAME_BOARD+84
	call GRAVITY_HORIZ
	pop de				;restore de
	pop ix				;restore ix
	ret

GRAVITY_VERTICAL:
	ld a, (ix)				;check the byte
	or a					;is it zero?
	ld de, -12
	jr nz, GRAVITY_GO_ON1		;no
	push ix				;save ix
	push bc				;save bc
GRAVITY_VERTICAL_LOOP:
	ld a, (ix-12)			;1 row up
	ld (ix), a				;to here
	add ix, de				;now go up one row
	djnz GRAVITY_VERTICAL_LOOP	;loop
	ld (ix), 0				;zero the top byte
	pop bc				;restore bc
	pop ix				;restore ix
	jr GRAVITY_GO_ON2			;loop
GRAVITY_GO_ON1:
	add ix, de				;go up a row
GRAVITY_GO_ON2:
	dec b					;decrement piece counter
	dec c					;decrement row counter
	jr nz, GRAVITY_VERTICAL		;loop
	ret

GRAVITY_HORIZ:
	ld a, (ix)				;check the byte
	or a					;is it zero?
	ld de, -12
	jr nz, GRAVITY_GO_ON3		;no
	push ix				;save ix
	push bc				;save bc
	ld c, 8				;8 rows
GRAVITY_HORIZ_LOOP2:
	push bc
	push ix
GRAVITY_HORIZ_LOOP:
	ld a, (ix+1)			;get next byte
	ld (ix), a				;put it in current byte
	inc ix				;next byte
	djnz GRAVITY_HORIZ_LOOP		;loop
	ld (ix), 0				;zero that byte
	pop ix
	pop bc
	add ix, de				;go up a row
	dec c					;dec row counter
	jr nz, GRAVITY_HORIZ_LOOP2	;loop
	pop bc
	pop ix
	dec ix
GRAVITY_GO_ON3:
	inc ix
	dec b					;decrement counters
	dec c					;|
	jr nz, GRAVITY_HORIZ		;loop
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                         ;;;
;;;  End of the Gravitator  ;;;
;;;                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                             ;;;
;;;  Have you cleared the screen completely???  ;;;
;;;                                             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

CHECK_CLEARED:
	ld a, (GAME_BOARD+84)		;bottom right
	or a					;cp 0
	ret nz				;screen isn't cleared

	ROM_CALL(DISP_GRAPH)		;copy the graph mem to the lcd

	ld hl, (SCORE)			;multiply score by four
	add hl, hl				;two
	add hl, hl				;four
	ld (SCORE), hl			;store the score

	ld hl, $0401			;load coords
	ld ($800C), hl			;|
	ld hl, YouWonText			;4,1
	ROM_CALL(D_ZT_STR)		;display "H E Y !!"

	ld de, $0103			;1,3
	ld ($800C), de
	ROM_CALL(D_ZT_STR)		;display "You eliminated"

	ld de, $0204			;2,4
	ld ($800C), de
	ROM_CALL(D_ZT_STR)		;display "every tile!!"

	ld de, $0006			;0,6
	ld ($800C), de
	ROM_CALL(D_ZT_STR)		;display "CONGRATULATIONS!

CLEAR_LOOP:
	call GET_KEY
	or a					;cp 0
	jr z, CLEAR_LOOP

	jr GAME_END				;end game

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                               ;;;
;;;  End of screen clear checker  ;;;
;;;                               ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                        ;;;
;;;  Check if there aren't any moves left  ;;;
;;;                                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

CHECK_GAME_OVER:
	push ix
	push de
	ld ix, GAME_BOARD			;check starting at top right
	ld b, 96				;96 pieces to check
	call GAME_OVER_LOOP		;check
	pop de
	pop ix
	ret



GAME_OVER_LOOP:				;see ONLY_ONE for comments
	push bc
	ld e, $FF
	call CHECK_EDGES
	pop bc
	ld a, (ix)
	or a
	jr z, CANT_CHECK_DOWN2
	bit 0, d
	jr z, CANT_CHECK_RIGHT2
	cp (ix+1)
	ret z
CANT_CHECK_RIGHT2:
	bit 1, d
	jr z, CANT_CHECK_LEFT2
	cp (ix-1)
	ret z
CANT_CHECK_LEFT2:
	bit 2, d
	jr z, CANT_CHECK_UP2
	cp (ix-12)
	ret z
CANT_CHECK_UP2:
	bit 3, d
	jr z, CANT_CHECK_DOWN2
	cp (ix+12)
	ret z
CANT_CHECK_DOWN2:
	inc ix
	djnz GAME_OVER_LOOP
	pop de
	pop ix



	inc sp
	inc sp
GAME_END:
	ROM_CALL(DISP_GRAPH)
	inc sp
	inc sp
	ld hl, $0003			;load coords
	ld ($800C), hl			;|
	ld hl, GO_Text			;0,3
	ROM_CALL(D_ZT_STR)		;display "G A M E  O V E R"

	ld de, $0004			;0,4
	ld ($800C), de
	ROM_CALL(D_ZT_STR)		;display "S c o r e :"

	ld de, $281B			;40,27
	ld ($8215), de
	ROM_CALL(D_ZM_STR)		;display " Press CLEAR"

	ld hl, $0B04			;11,4
	ld ($800C), hl
	ld hl, (SCORE)
	ROM_CALL(D_HL_DECI)		;display score

SHORT_LOOP:
	call GET_KEY
	cp 15					;clear
	jr nz, SHORT_LOOP

	ld hl, (SCORE)			;final score
	ld a, (GAME_MODE)			;what mode are we in?
	ld de, (HI_SCORE_P)		;puzzle by default
	ld bc, HI_SCORE_P
	or a					;cp 0
	jr z, NOT_ACTION			;it IS puzzle!
	ld de, (HI_SCORE_A)		;no it's not!
	ld bc, HI_SCORE_A
NOT_ACTION:
	call CP_HL_DE			;compare score w/ hi score
	ret c					;if score is less
	ret z					;or equal return

	ld a, l
	ld (bc), a
	inc bc
	ld a, h
	ld (bc), a
	ROM_CALL(DISP_GRAPH)		;copy the graph mem to the lcd
	ld hl, $0102			;load coords
	ld ($800C), hl			;|
	ld hl, HISCORE_TEXT		;1,2
	ROM_CALL(D_ZT_STR)		;display "A new HiScore!"

	ld de, $1810			;24,17
	ld ($8215), de
	ROM_CALL(D_ZM_STR)		;display " Enter Your Initials:"

	ld de, $0604			;initials entered at 6,4
	ld ($800C), de			;|
	ld hl, HI_SCORE_A+3		;initials for action mode start here
	ld a, (GAME_MODE)			;what mode are we in?
	or a					;cp 0
	ld a, 3				;max chars = 3
	jr nz, NOT_PUZZLE			;it's action mode...
	ld hl, HI_SCORE_P+3		;initials for puzzle mode start here
NOT_PUZZLE:
	call INPUT				;input initials
	ret

; Input routine  - made by Jimmy Mrdell 97-03-05
;
; Reads a sentence entered from the keyboard. Only uppercase letters
; and space are allowed. Left arrowkey = backspace.
;
; When calling, HL should point to where the string should be stored
; and A should hold the maximum length of the string. Be sure there
; are enough space (A+1) to store the nullterminated string at HL!
; ($800C) should hold the screen position where the string starts.
;
; This input routine will also have a flashing cursor. If you don't like
; it, remove all rows where the explanation starts with a *.
;
; IMPORTANT: The input must NOT wrap to a new row! Then it will not work
; properly. The last char on a row should not be used either (if cursorcol=0
; when calling, the maximum char length is 20). If you have a cursor, the
; two last chars should not be used (max length 19 if the screen location
; starts to the far left).
;
; The routine requires one temporary variable, noLet.

; largely indented stuff added by Adamman

INPUT:
; push bc
; push de
; push hl
; ei
; set 2,(iy+12)         ; * Turn cursor blinking on (interrupts must be enabled)
 ld (noLet),a          ; Store the maximum lenght of the string
 ld e,0                ; E = numbers of letters written so far
WaK:
; ld a,32
; ld ($800E),a          ; * Set "character under cursor" to space
 push hl               ; Save HL since GET_KEY destroys it's content
	ld a, 217
	ROM_CALL(TX_CHARPUT)
	ld hl, $800D
	dec (hl)
 call GET_KEY
 cp $02                ; $02 = left key
 jr z,BackSpace
 cp $09                ; $09 = enter
 jr z,NameDone
 or a
 jr nz,CheckLetter
 pop hl
 jr WaK
CheckLetter:
 ld hl,Letters
 ld bc,26              ; 26 letters to check
 cpir                  ; Compare A with each letter until a match is found
 ld d,c                ; Then C = the letter. Store in D
 pop hl                ; HL -> current position in string
 jr nz,WaK             ; If not valid keystroke, wait for new key
 ld a,65               ; 65 = ascii char for A
 add a,d               ; A now holds the ascii char for the letter pressed
PutLetter:
 ld c,a
 ld a,(noLet)          ; A = max letters
 cp e                  ; Check if max size is reached
 jr z,WaK              ; If so, wait for a new key
 ld (hl),c             ; If not, store the key entered
 inc hl                ; Point to the next byte in the string
 inc e                 ; And increase the letter counter
 ld a,c
 ROM_CALL(TX_CHARPUT)  ; Show the chars pressed on the screen
 jr WaK                ; And jump back and wait for a new key
BackSpace:
 pop hl                ; HL -> current position in string
 ld a,e
 or a                  ; Check if string size = 0
 jr z,WaK              ; If so, backspace is impossible. Check for new key.
; res 2,(iy+12)         ; * Stopp cursor blinking
 dec e                 ; Decrease string size
 dec hl                ; And string pointer
 push hl
 ld hl,$800D           ; HL -> x cursor position
 dec (hl)              ; Decrease it
 ld a,32               ; Overwrite the last letter with a space
 ROM_CALL(TX_CHARPUT)  ; Put the space over the chars
 ROM_CALL(TX_CHARPUT)  ; * And over the (non) blinking cursor
 dec (hl)              ; * Decrease the x coordinate twice
 dec (hl)              ;
 pop hl
; set 2,(iy+12)         ; * Stopp cursor blinking
 jr WaK                ; Wait for a key
NameDone:
 pop hl                ; HL -> current position in string
 ld (hl),0             ; Put a terminating zero at the end of the string
; res 2,(iy+12)         ; * Stopp cursor blinking
; pop hl
; pop de
; pop bc
 ret

; The keycodes of the letters A-Z stored backways

Letters:
 .db $1A,$22,$2A         ;ZYX
 .db $0B,$13,$1B,$23,$2B ;WVUTS
 .db $0C,$14,$1C,$24,$2C ;RQPON
 .db $0D,$15,$1D,$25,$2D ;MLKJI
 .db $0E,$16,$1E,$26,$2E ;HGFED
 .db $1F,$27,$2F         ;CBA

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                            ;;;
;;;  End of Game Over checker  ;;;
;;;                            ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                ;;;
;;;     Routine for putting the Game Pieces (includes cursor)      ;;;
;;;  Special Thanks to Jimmy Mrdell for the Online Zshell School  ;;;
;;;                                                                ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PUTPIECE:
	push de
	ld b, 8				;all sprites in SameGame are (conveniently) 8x8
PP_NEW_ROW:
	push bc				;save bc
	push de				;save de
	ld a, (hl)				;get byte of sprite :)
	inc hl				;go to next byte
	ex de, hl				;exchange (hl=graph mem, de=sprite)
	xor (hl)				;SameGame also xors all sprites
	ld (hl), a				;load it into graph mem
	inc hl				;next byte of graph mem
	pop hl				;restore de (hl now)
	ld bc, 12				;12 = next row down
	add hl, bc				;get there!
	ex de, hl				;exchange back (hl=sprite, de=graph mem)
	pop bc				;restore counters
	djnz PP_NEW_ROW			;loop
	pop de
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                   ;;;
;;;  End of PutPiece  ;;;
;;;                   ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                               ;;;
;;;  DM_HL_DECI by Jimmy Mrdell  ;;;
;;;                               ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DM_HL_DECI:
	push de
	push hl
	ld de,string+5			;start at the end
	xor a					;ld a, 0
	ld (de),a				;zero terminated string
Repeat:
	call UNPACK_HL			;unpack one digit of hl to a
	add a,'0'				;add it with ASCII char 0
	dec de				;previous byte
	ld (de),a				;load the char
	ld a,h				;is hl 0?
	or l					;|
	jr nz,Repeat			;loop
	ex de,hl				;exchange so hl points to string
	ROM_CALL(D_ZM_STR)		;display string
	pop hl
	pop de
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                     ;;;
;;;  End of DM_HL_DECI  ;;;
;;;                     ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                            ;;;
;;;  Random Routine - Returns a random number between 1 and 5  ;;;
;;;                                                            ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


RANDOM:
	call GETRAND			;getrand is the routine in getrand.asm
	res 7, a				;bit 7 set = negetive #
RANDOM_LOOP:
	sub 5					;subtract 5 from a
	jp p, RANDOM_LOOP			;if positive, keep looping
	add a, 6				;add 5 for the last subtract, add 1 for 1-5
	ret

#include GETRAND.asm

;;;;;;;;;;;;;;;;;;;;;;;
;;;                 ;;;
;;;  End of Random  ;;;
;;;                 ;;;
;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                   ;;;
;;;  BufClear - Clears the Graph Mem  ;;;
;;;                                   ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

BUFCLEAR:
	ld hl, $88B8			;start at graph mem
	ld de, $88B9			;graph mem + 1
	ld bc, $2FF				;graph mem is $300 bytes, first byte is already done
	ld (hl), 0				;0 = number to fill
	ldir					;copy
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                   ;;;
;;;  End of BufClear  ;;;
;;;                   ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;

#include SGPieces.h
;the include file for all of the sprites

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                            ;;;
;;;  All of the various texts  ;;;
;;;                            ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

GO_Text:					;score: 11,4
	.db "G A M E  O V E R", 0	;1,4
	.db "S c o r e : ", 0		;1,5
	.db " Press CLEAR", 0		;40,27

YouWonText:
	.db "H E Y !!", 0			;4,1
	.db "You eliminated", 0		;1,3
	.db "every tile!!", 0		;2,4
	.db "CONGRATULATIONS!", 0	;0,6

HISCORE_TEXT:
	.db "A new HiScore!", 0		;2,3
	.db " Enter Your Initials:", 0;24,17

PAUSE_TEXT:					;score: 23,52; hi: 29,45
	.db "P A U S E D", 0		;34,17
	.db "Score:", 0			;29,23
	.db "Hi:", 0			;36,29
	.db "SameGame", 0			;30,35
	.db "Adamman", 0			;32,41

HI_SCORE_P:
	.db $02, $00			;first two are the actual score (58,48)
	.db " AAS", 0			;the next three are for the name (58,76)
HI_SCORE_A:
	.db $02, $00			;first two are the actual score (58,48)
	.db " AAS", 0			;the next three are for the name (58,76)

SAVED:					;is the game saved? (0 = no, 1 = yes)
	.db 0

OLD_GAME_BOARD:				;for when you want to undo or save game
	.db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	.db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	.db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	.db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	.db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	.db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	.db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	.db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00

OLD_SCORE:					;for when you undo or save game
	.db $00, $00
OLD_RANDSEED:				;for saved game
	.db $00, $00
OLD_GAME_MODE:				;for saved game
	.db $00
OLD_COUNT:					;for saved game
	.db $00
OLD_SMALL_COUNT:				;for saved game
	.db $00
OLD_DE:					;for saved game
	.db $00, $00
OLD_IX:					;for saved game
	.db $00, $00

Title_Pic:					;the beautiful picture you see at the title screen
	.db $10, $10, $10, $FE, $10, $10, $10, $10, $10, $38, $38, $FE
	.db $38, $38, $38, $E2, $38, $38, $38, $38, $38, $38, $74, $E2
	.db $28, $28, $6C, $FA, $28, $28, $28, $6C, $28, $E6, $FA, $FA
	.db $74, $74, $F6, $FA, $74, $74, $74, $F6, $74, $F6, $FE, $FA
	.db $74, $74, $7C, $FE, $74, $74, $74, $7C, $74, $FE, $FE, $FE
	.db $FE, $FE, $38, $FE, $FE, $FE, $FE, $38, $FE, $38, $7C, $FE
	.db $FE, $FE, $10, $FE, $FE, $FE, $FE, $10, $FE, $38, $38, $FE
	.db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	.db $FE, $00, $FE, $38, $38, $38, $38, $02, $38, $38, $10, $10
	.db $E2, $1C, $E2, $38, $38, $74, $74, $78, $38, $74, $38, $38
	.db $FA, $7F, $7A, $E6, $E6, $FA, $F9, $FC, $E6, $FA, $6C, $6C
	.db $F8, $FF, $BA, $F6, $F6, $FE, $F3, $FE, $76, $FE, $F6, $F6
	.db $F9, $E1, $DE, $FE, $FE, $FE, $E7, $87, $7E, $FE, $7C, $7C
	.db $FB, $C0, $DE, $38, $38, $7C, $4F, $03, $38, $7C, $38, $38
	.db $FB, $C0, $DE, $38, $38, $38, $1E, $03, $38, $38, $10, $10
	.db $01, $E0, $00, $00, $00, $00, $1C, $00, $00, $00, $00, $00
	.db $FD, $F8, $E0, $38, $00, $00, $38, $02, $00, $00, $0E, $1E
	.db $E0, $FC, $EF, $33, $DC, $18, $38, $F2, $78, $1E, $E0, $C2
	.db $E0, $7E, $D1, $A7, $FE, $3C, $70, $FA, $8C, $3F, $F1, $EA
	.db $EC, $1E, $40, $AE, $66, $66, $70, $3A, $04, $73, $33, $32
	.db $EC, $0F, $1F, $8C, $CE, $FC, $70, $38, $FC, $66, $77, $E6
	.db $EF, $1F, $31, $99, $9C, $C0, $78, $F9, $8C, $CC, $E6, $0E
	.db $EF, $FE, $63, $19, $99, $8C, $7F, $F3, $18, $CC, $CC, $6E
	.db $07, $FC, $7F, $33, $31, $F8, $3F, $C3, $F9, $99, $8F, $C0
	.db $39, $F0, $3E, $B3, $30, $F2, $8F, $19, $F5, $99, $87, $9E
	.db $74, $00, $00, $00, $04, $02, $C0, $74, $00, $00, $30, $22
	.db $FA, $E6, $FA, $20, $F8, $C2, $00, $FA, $28, $6C, $28, $FA
	.db $FE, $F6, $FE, $68, $02, $10, $00, $00, $04, $F6, $74, $FA
	.db $FE, $FE, $FE, $6C, $A5, $33, $69, $A3, $64, $7C, $74, $FE
	.db $7C, $38, $7C, $EA, $A7, $55, $55, $55, $56, $38, $FE, $FE
	.db $38, $38, $38, $EA, $45, $55, $55, $55, $56, $10, $FE, $FE
	.db $00, $00, $00, $0C, $85, $33, $45, $13, $50, $00, $00, $00
	.db $10, $10, $3F, $FF, $FF, $FF, $FF, $FF, $FF, $F0, $10, $38
	.db $38, $38, $30, $00, $00, $00, $00, $00, $00, $18, $38, $74
	.db $6C, $6C, $F7, $FF, $FF, $FF, $FF, $FF, $FF, $DC, $28, $FA
	.db $F6, $F6, $F4, $00, $00, $00, $00, $00, $00, $56, $74, $FE
	.db $7C, $7C, $F4, $06, $00, $01, $81, $10, $10, $5C, $74, $FE
	.db $38, $38, $34, $65, $57, $BC, $91, $B2, $32, $58, $FE, $7C
	.db $10, $10, $34, $D6, $51, $08, $A9, $55, $55, $50, $FE, $38
	.db $00, $00, $14, $F4, $52, $10, $B1, $15, $56, $50, $00, $00
	.db $FE, $FE, $14, $64, $77, $BC, $99, $12, $33, $58, $38, $10
	.db $E2, $E2, $34, $00, $00, $00, $00, $00, $00, $58, $38, $38
	.db $FA, $FA, $74, $00, $00, $00, $00, $00, $00, $56, $E6, $28
	.db $FA, $FA, $F4, $02, $04, $80, $11, $01, $00, $56, $F6, $74
	.db $FE, $FE, $74, $05, $36, $13, $1B, $23, $20, $5E, $FE, $74
	.db $FE, $FE, $34, $07, $44, $AA, $95, $55, $50, $58, $38, $FE
	.db $FE, $FE, $14, $05, $44, $AA, $91, $55, $60, $58, $38, $FE
	.db $00, $00, $14, $05, $32, $92, $91, $23, $30, $50, $00, $00
	.db $38, $FE, $14, $00, $00, $00, $00, $00, $00, $50, $10, $38
	.db $38, $E2, $37, $FF, $FF, $FF, $FF, $FF, $FF, $D8, $38, $74
	.db $E6, $FA, $70, $00, $00, $00, $00, $00, $00, $1C, $6C, $FA
	.db $F6, $FA, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $F6, $F6, $FE
	.db $FE, $FE, $7C, $7C, $7C, $74, $FE, $FE, $FE, $7C, $7C, $FE
	.db $38, $FE, $38, $38, $38, $FE, $7C, $7C, $7C, $38, $38, $7C
	.db $38, $FE, $10, $10, $10, $FE, $38, $38, $38, $10, $10, $38
	.db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
	.db $FE, $10, $38, $38, $38, $10, $38, $10, $10, $38, $FE, $38
	.db $E2, $38, $38, $38, $74, $38, $74, $38, $38, $74, $E2, $74

	.db $00, $00, $00, $06, $FA, $28, $FA, $6C, $28, $FA, $FA, $FA
	.db $A8, $C0, $00, $06, $FE, $74, $FE, $F6, $74, $FE, $FA, $FE
	.db $A1, $0C, $94, $96, $FE, $74, $FE, $7C, $74, $FE, $FE, $FE
	.db $E8, $91, $59, $40, $7C, $FE, $7C, $38, $FE, $7C, $FE, $7C
	.db $A8, $51, $51, $90, $38, $FE, $38, $10, $FE, $38, $FE, $38
	.db $A9, $8C, $90, $C0, $00, $00, $00, $00, $00, $00, $00, $00

.end
