;By Bill Nagel
;82 Port by Ilya Winham (ilyamojo@geocities.com)
;Added Clear button exit support and optimized it more! (V1.7)
;..everybody give Bill a big round of applause, shall we...
;In Version 2.0: Now works perfect on ALL ROM Versions!!
;While paused you can change the contrast.
;Press clear to quit and del to resume game.

#INCLUDE "Header.h"
.db "Pong82z v2.0 by Bill Nagel",0

 x  EQU TEXT_MEM         ;8265h
 y   EQU TEXT_MEM+1      ;8266h
 score1   EQU TEXT_MEM+2  ;8267h
 score2    EQU TEXT_MEM+3 ;8268h
 py1  EQU TEXT_MEM+4      ;8269h
 py2   EQU TEXT_MEM+5      ;826Ah
 bxs   EQU TEXT_MEM+6      ;826Bh
 bys   EQU TEXT_MEM+7      ;826Ch
 ball    EQU TEXT_MEM+8    ;826Dh
 mcountc  EQU TEXT_MEM+9   ;826Eh
 mcount   EQU TEXT_MEM+10   ;826Fh
 bxcount   EQU TEXT_MEM+11  ;8270h
 x2   EQU TEXT_MEM+12       ;8271h
 y2    EQU TEXT_MEM+13    ;8272h
 x3   EQU TEXT_MEM+14       ;8273h
 y3   EQU TEXT_MEM+15      ;8274h
 bycount  EQU TEXT_MEM+16   ;8275h
 x4   EQU TEXT_MEM+17       ;8276h
 y4   EQU TEXT_MEM+18       ;8277h
 x5   EQU TEXT_MEM+19       ;8278h
 y5   EQU TEXT_MEM+20       ;8279h
 tx    EQU TEXT_MEM+21      ;827Ah
 tx2   EQU TEXT_MEM+22      ;827Bh
 tx3    EQU TEXT_MEM+23     ;827Ch
 tx4   EQU TEXT_MEM+24      ;827Dh
 tx5   EQU TEXT_MEM+25      ;827Eh
 ty    EQU TEXT_MEM+26      ;827Fh
 ty2  EQU TEXT_MEM+27       ;8280h
 ty3    EQU TEXT_MEM+28     ;8281h
 ty4   EQU TEXT_MEM+29      ;8282h
 ty5   EQU TEXT_MEM+30      ;8283h
 txs   EQU TEXT_MEM+31      ;8284h
 tys   EQU TEXT_MEM+32      ;8285h
 done  EQU TEXT_MEM+33      ;8286h
 padupd    EQU TEXT_MEM+34  ;8287h
 cpadupd   EQU TEXT_MEM+35 ;8288h
 ballupd  EQU TEXT_MEM+36   ;8289h
 speed  EQU TEXT_MEM+37     ;828Ah
 index    EQU TEXT_MEM+38   ;828Bh

M6      EQU       %10111111
M5      EQU       %11011111
M4      EQU       %11101111
M3      EQU       %11110111
M2      EQU       %11111011
M1      EQU       %11111101
M0      EQU       %11111110

    CALL ROM_CALL
     .dw CLEARLCD
     RES 6,(IY+0Eh)
     call _zeroall
     RES 1,(IY+0Dh)
    ld      hl,title
    CALL ROM_CALL
    .dw D_ZT_STR
     ld      b,0
    ld      c,55
    ld      d,94
    ld      e,55
    ld      h,1
    call    _ILine
      ld bc,9*256
    ld      hl,credits
     CALL DMX
    ld bc,18*256+1
     ld      hl,str_balls
     CALL DMX
    ld bc,27*256+1 
    ld      hl,str_speed
     CALL DMX
    ld bc,57*256+29
    ld      hl,press_clear
    CALL DMX
    xor     a
    ld      (ball),a
    ld      a,1
    ld      (speed),a
    call    normball
    jp      oneball

options:
    CALL ROM_CALL
     .dw 0x2F48-0x1A
     CALL ROM_CALL
     .dw 0x19F5
     CALL ROM_CALL
      .dw 0x35A0
    cp 21
     jp      z,nballs
    cp 31
    jp      z,aspeed
    cp 45
    jr      z,startgame
    jr      options

startgame:
    xor     a
    ld      (score1),a
    ld      (score2),a
    call    _GRBUFCLR
    CALL ROM_CALL
     .dw CLEARLCD
    call    draw_screen
    call    restart
    call    scoreboard
Start:
     ld a,0ffh
     out (1),a
     ld a,0fdh
     out (1),a
     in a,(1)
     cp 191
     jp z,exit
    ld      a,(mcount)
    inc     a
    ld      (mcount),a
    ld      hl,padupd
    cp      (hl)
    call    Z,movepad

    ld      a,(mcountc)
    inc     a
    ld      (mcountc),a
    ld      hl,cpadupd
    cp      (hl)
    call    Z,movepadc

    ld      a,(bxcount)
    inc     a
    ld      (bxcount),a
    ld      hl,ballupd
    cp      (hl)
    call    Z,moveballx

    ld      a,(bycount)
    inc     a
    ld      (bycount),a
    ld      hl,ballupd
    cp      (hl)
    call    Z,movebally

    ;SCANKEY(M6,6)
     ld a,0ffh ;added
     out (1),a  ;added
    ld a,M6
    out (1),a
    in a,(1)
    bit 6,a
    jp      z,pause
    ld      a,(done)
    or      a
    jp      Z,Start
    jp      exit

nballs:
    ld      a,(ball)
    ld      b,a
    ld      a,1
    sub     b
    ld      (ball),a
    or      a
    jr      Z,oneball
    jr      twoball

oneball:
     ld bc,18*256+91
    ld      hl,str_1
    call DMX
    jp      options
    
twoball:
     ld bc,18*256+91
    ld      hl,str_2
    CALL DMX
    jp      options

aspeed:
    ld      a,(speed)
    inc     a
    cp      3
    call    Z,toofast
    ld bc,27*256+75
    ld      (speed),a
    or      a
    jr      Z,slowball
    cp      2
    jp      Z,fastball
    call    normball
    jp      options

toofast:
    xor     a
    ret
   
slowball:
    ;ld bc,27*256+75
    ld      hl,str_slow
    CALL DMX
    jp      options

normball:
    ld bc,27*256+75
    ld      hl,str_norm
    CALL DMX
    ret

fastball:
     ;ld bc,27*256+75
    ld      hl,str_fast
    CALL DMX
    jp      options

moveballx:
    xor     a
    ld      (bxcount),a

    ld      a,(ball)
    cp      1
    call    Z,tmoveballx

    call    erase_ball

    ld      a,(bxs)
    ld      b,a
    ld      a,(x)
    add     a,b
    sub     4
    ld      (x),a
    cp      94
    .DB 11110010b  
    .DW rightmiss
     or a
    .DB 11111010b  
     .DW leftmiss
    cp      91
    .DB 11110010b  
     .DW righthit
    cp      3
    .DB 11111010b  
     .DW lefthit
padmiss:
    call    draw_ball
    ret

movebally:
    xor     a
    ld      (bycount),a

    ld      a,(ball)
    cp      1
    call    Z,tmovebally

    call    erase_ball

    ld      a,(bys)
    ld      b,a
    ld      a,(y)
    add     a,b
    sub     4
    cp      62
    .DB 11110010b  
     .DW tophit
    cp      10
    .DB 11111010b  
     .DW bothit
    ld      (y),a

    call    draw_ball
    ret

erase_ball:
    ld      a,(x5)
    ld      b,a
    ld      a,(y5)
    ld      c,a
    ld h,0 
    call setiline
    inc     b
   call setiline
    dec     c
    call setiline
    dec     b
    call setiline

    ld      a,(x)
    cp      6
    call    Z,drawpaddle1
    ld      a,(x)
    cp      5
    call    Z,drawpaddle1
    ld      a,(x)
    cp      89
    call    Z,drawpaddle2
    ld      a,(x)
    cp      88
    call    Z,drawpaddle2


    ld      a,(x4)
    ld      (x5),a
    ld      a,(y4)
    ld      (y5),a

    ld      a,(x3)
    ld      (x4),a
    ld      a,(y3)
    ld      (y4),a

    ld      a,(x2)
    ld      (x3),a
    ld      a,(y2)
    ld      (y3),a

    ld      a,(x)
    ld      (x2),a
    ld      a,(y)
    ld      (y2),a
    ret

draw_ball:
    ld      a,(x)
    ld      b,a
    ld      a,(y)
    ld      c,a
    ld h,1
    call setiline 
    inc     b
    call setiline
    dec     c
    call setiline
    dec     b
    call setiline
    ret

lefthit:
    ld      a,(y)
    add     a,13
    ld      b,a
    ld      a,(py1)
    cp      b
    .DB 11110010b  
    .DW padmiss
    ld      a,(y)
    dec     a
    ld      b,a
    ld      a,(py1)
    cp      b
    .DB 11111010b  
    .DW padmiss

    ld      a,(bxs)
    cp      5
     .DB 11111100b  
     .DW switch
    call    random
    jp      padmiss

righthit:
    ld      a,(y)
    add     a,13
    ld      b,a
    ld      a,(py2)
    cp      b
    .DB 11110010b  
    .DW padmiss
    ld      a,(y)
    dec     a
    ld      b,a
    ld      a,(py2)
    cp      b
    .DB 11111010b  
     .DW padmiss

    ld      a,(bxs)
    cp      5
    .DB 11110100b  
     .DW switch
    call    random
    jp      padmiss

leftmiss:
    call    switch
    ld      hl,score2
    inc     (hl)
    call    scoreboard
    jp      padmiss

rightmiss:
    call    switch
    ld      hl,score1
    inc     (hl)
    call    scoreboard
    jp      padmiss

tophit:
    ld      a,(bys)
    sub     4
    ld      b,a
    ld      a,4
    sub     b
    ld      (bys),a
    jp      movebally

bothit:
    ld      a,(bys)
    ld      b,a
    ld      a,4
    sub     b
    add     a,4
    ld      (bys),a
    jp      movebally

switch:
    ld      a,(bxs)
    ld      b,a
    ld      a,8
    sub     b
    ld      (bxs),a
    ret

random:
    CALL ROM_CALL
     .dw 0x3566-0x1A
    ld hl,8
    CALL ROM_CALL
    .dw 0x359A
    CALL ROM_CALL
     .dw 0x0925
     CALL ROM_CALL
     .dw 0x0836
    CALL ROM_CALL
     .dw 0x35A0
    ld      a,e
    cp      6
    jr      Z,bysfast
    
    ld      a,(bys)
    cp      4
    .DB 11110010b  
    .DW upslow
    ld      a,3
    ld      (bys),a
    ret
upslow:
    ld      a,5
    ld      (bys),a
    ret

bysfast:
    ld      a,(bys)
    cp      4
    .DB 11110010b  
    .DW upfast
    ld      a,2
    ld      (bys),a
    ret
upfast:
    ld      a,6
    ld      (bys),a
    ret

;*******************Ball Two***************************

tmoveballx:
    call    terase_ball

    ld      a,(txs)
    ld      b,a
    ld      a,(tx)
    add     a,b
    sub     4
    ld      (tx),a
    cp      94
    .DB 11110010b  
     .DW trightmiss
     or a
    .DB 11111010b  
     .DW tleftmiss
    cp      91
    .DB 11110010b  
     .DW trighthit
    cp      3
    .DB 11111010b  
    .DW tlefthit
tpadmiss:
    call    tdraw_ball
    ret

tmovebally:

    call    terase_ball

    ld      a,(tys)
    ld      b,a
    ld      a,(ty)
    add     a,b
    sub     4
    cp      62
    .DB 11110010b  
    .DW ttophit
    cp      10
    .DB 11111010b  
      .DW tbothit
    ld      (ty),a

    call    tdraw_ball
    ret

terase_ball:
    ld      a,(tx5)
    ld      b,a
    ld      a,(ty5)
    ld      c,a
    ld h,0
   call setiline
    inc     b
   call setiline
    dec     c
    call setiline
    dec     b
   call setiline

    ld      a,(tx)
    cp      5
    call    Z,drawpaddle1
    ld      a,(tx)
    cp      89
    call    Z,drawpaddle2

    ld      a,(tx4)
    ld      (tx5),a
    ld      a,(ty4)
    ld      (ty5),a

    ld      a,(tx3)
    ld      (tx4),a
    ld      a,(ty3)
    ld      (ty4),a

    ld      a,(tx2)
    ld      (tx3),a
    ld      a,(ty2)
    ld      (ty3),a

    ld      a,(tx)
    ld      (tx2),a
    ld      a,(ty)
    ld      (ty2),a
    ret

tdraw_ball:
    ld      a,(tx)
    ld      b,a
    ld      a,(ty)
    ld      c,a
    ld h,1
    call setiline
    inc     b
    call setiline
    dec     c
    call setiline
    dec     b
   call setiline
    ret

tlefthit:
    ld      a,(ty)
    add     a,13
    ld      b,a
    ld      a,(py1)
    cp      b
    .DB 11110010b  
    .DW tpadmiss
    ld      a,(ty)
    dec     a
    ld      b,a
    ld      a,(py1)
    cp      b
    .DB 11111010b  
    .DW tpadmiss

    ld      a,5
    ld      (txs),a
    jp      tpadmiss

trighthit:
    ld      a,(ty)
    add     a,13
    ld      b,a
    ld      a,(py2)
    cp      b
    .DB 11110010b  
    .DW tpadmiss
    ld      a,(ty)
    dec     a
    ld      b,a
    ld      a,(py2)
    cp      b
    .DB 11111010b  
     .DW tpadmiss

    ld      a,3
    ld      (txs),a
    jp      tpadmiss

tleftmiss:
    ld      a,5
    ld      (txs),a
    ld      hl,score2
    inc     (hl)
    call    scoreboard
    jp      tpadmiss

trightmiss:
    ld      a,3
    ld      (txs),a
    ld      hl,score1
    inc     (hl)
    call    scoreboard
    jp      tpadmiss

ttophit:
    ld      a,(tys)
    sub     4
    ld      b,a
    ld      a,4
    sub     b
    ld      (tys),a
    jp      tmovebally

tbothit:
    ld      a,(tys)
    ld      b,a
    ld      a,4
    sub     b
    add     a,4
    ld      (tys),a
    jp      tmovebally

;**************************End Ball Two*****************
    
movepad:
    xor     a
    ld      (mcount),a

    ;SCANKEY(M0,0)
    ld a,M0
    out (1),a
   in a,(1)
    bit 0,a
    call    z,movedown

    ;SCANKEY(M0,3)
    ld a,M0
    out (1),a
    in a,(1)
    bit 3,a
    call    z,moveup
    ret

movepadc:
    xor     a
    ld      (mcountc),a

    ld      a,(bxs)
    cp      3
    ret     Z
    
    ld      a,(py2)
    sub     6
    ld      hl,y
    cp      (hl)
    .DB 11110010b  
    .DW compdown
    .DB 11111010b  
    .DW compup
      ret

moveup:
    ld      a,(py1)
    inc     a
    cp      62
    ret     Z
    ld      (py1),a
    ld      c,a
    ld      b,0
     ld h,1
     call setiline
    inc     b
    call setiline
    ld      a,(py1)
    sub     12
    ld      c,a
     ld h,0
     call setiline
    dec     b
    call setiline
    ret

movedown:
    ld      a,(py1)
    dec     a
    cp      19
    ret     Z
    ld      (py1),a
    sub     11
    ld      c,a
     ld h,1
    ld      b,0
    call setiline
    inc     b
    call setiline
    ld      a,(py1)
    inc     a
    ld      c,a
    ld h,0
   call setiline
    dec     b
    call setiline
    ret

compup:
    ld      a,(py2)
    inc     a
    ld      c,a
    ld      b,93
     ld h,1
    call setiline
    inc     b
    call setiline
    ld      a,(py2)
    inc     a
    cp      62
    ret     Z
    ld      (py2),a
    sub     12
    ld      c,a
   ld h,0
   call setiline
    dec     b
    call setiline
    ret

compdown:
    ld      a,(py2)
    sub     12
    ld      c,a
     ld h,1
    ld      b,93
    call setiline
    inc     b
    call setiline
    ld      a,(py2)
    dec     a
    cp      19
    ret     Z
    ld      (py2),a
    inc     a
    ld      c,a
     ld h,0
    call setiline
    dec     b
    call setiline
    ret

pause:
   CALL CR_KHAND
   cp K_DEL
   jp z,pcont
   cp K_CLEAR
   jr z,pquit
   jr pause

;     CALL ROM_CALL   ;All this crap was crashing on ROM 19.0
;     .dw 0x2F48-0x1A
;     CALL ROM_CALL
;     .dw 0x19F5
;     CALL ROM_CALL
;      .dw 0x35A0
;     cp 45
;    jp      z,pquit
;    cp 23
;    jp      z,pcont
;    jr      pause

pret:
;    CALL ROM_CALL  ;Un-needed!
;     .dw DISP_GRAPH
    call    draw_screen
    call    scoreboard
    ret

pcont:
    call    pret
    jp      Start

pquit:
    call    pret
    jp      exit

scoreboard:
    ld      hl,57*256+8
    ld      (CURSOR_X),hl
    ld      a,(score1)
    call    _setxxop1
    ld      a,2
    call    _dispop1a
    ld      hl,57*256+82
    ld      (CURSOR_X),hl
    ld      a,(score2)
    call    _setxxop1
    ld      a,2
    call    _dispop1a

    ld      a,(score1)
    cp      21
    call    Z,uwin

    ld      a,(score2)
    cp      21
    call    Z,compwin

    ret

compwin:
     ld bc,18*256+26
    ld      hl,comp_wins
    CALL DMX
    ld bc,24*256+31
    ld      hl,press_clear
     CALL DMX
    call    wait_for_enter
    ld      a,1
    ld      (done),a
    ret

uwin:
     ld bc,18*256+36
    ld      hl,you_win
     CALL DMX
     ld bc,24*256+31
    ld      hl,press_clear
    CALL DMX
    call    wait_for_enter
    ld      a,1
    ld      (done),a
    ret

drawpaddle1:
    ld      b,0
    ld      a,(py1)
    ld      c,a
    ld      d,0
    sub     11
    ld      e,a
    ld      h,1
    call    _ILine
    inc     b
    inc     d
    call    _ILine
    ret

drawpaddle2:
    ld      b,93
    ld      a,(py2)
    ld      c,a
    ld      d,93
    sub     11
    ld      e,a
    ld      h,1
    call    _ILine
    inc     b
    inc     d
    call    _ILine
    ret

restart:
    xor     a
    ld      (mcountc),a
    ld      (mcount),a
    ld      (bxcount),a
    ld      (bycount),a
    ld      (done),a

    ld      a,42
    ld      (py1),a
    ld      (py2),a
    ld      a,6
    ld      (bxs),a
    ld      a,5
    ld      (bys),a
    ld      a,5
    ld      (txs),a
    ld      a,6
    ld      (tys),a
    ld      a,46
    ld      (x),a
    ld      (x2),a
    ld      (x3),a
    ld      (x4),a
    ld      (x5),a
    ld      (tx),a
    ld      (tx2),a
    ld      (tx3),a
    ld      (tx4),a
    ld      (tx5),a
    ld      a,28
    ld      (y),a
    ld      (y2),a
    ld      (y3),a
    ld      (y4),a
    ld      (y5),a
    ld      (ty),a
    ld      (ty2),a
    ld      (ty3),a
    ld      (ty4),a
    ld      (ty5),a

    ld      a,150
    ld      (ballupd),a
    ld      a,100
    ld      (padupd),a
    ld      a,180
    ld      (cpadupd),a

    ld      a,(speed)
    cp      1
    call    Z,setnorm
    ld      a,(speed)
    cp      2
    call    Z,setfast

    ld      a,(ball)
    cp      1
    call    Z,fastcomp

    call    drawpaddle1
    call    drawpaddle2
    ret

fastcomp:
    ld      a,17
    ld      (cpadupd),a
    ret

setfast:
    ld      a,15
    ld      (ballupd),a
    ld      a,10
    ld      (padupd),a
    ld      a,18
    ld      (cpadupd),a
    ret

setnorm:
    ld      a,75
    ld      (ballupd),a
    ld      a,50
    ld      (padupd),a
    ld      a,90
    ld      (cpadupd),a
    ret

draw_screen:
     ld      b,0
    ld      d,94
    ld      c,63
    ld      e,63
    ld      h,1
    call    _ILine
    dec     c
    dec     e
    call    _ILine
    ld      e,8
    ld      c,8
    call    _ILine
    dec     c
    dec     e
    call    _ILine
    ld bc,57*256+30
    ld      hl,title 
    CALL DMX  
    ret
      
wait_for_enter:
    CALL ROM_CALL
     .dw 0x2F48-0x1A
     CALL ROM_CALL
     .dw 0x19F5
     CALL ROM_CALL
      .dw 0x35A0
    cp 45
    jr      nz,wait_for_enter
    ret
    
setiline:
	ld d,b
	ld e,c
	CALL ROM_CALL
	.dw 0x2E60-0x1A
	.dw 0x4025
	.db 0x04

exit:
    call    _GRBUFCLR
    CALL ROM_CALL
     .dw CLEARLCD
    ret

_GRBUFCLR:
	ld hl,0x88B8
	ld de,0x88B9
	ld bc,768
	ld (hl),0
	ldir
	ret

_zeroall:
	ld hl,OP1
	ld de,OP1+1
	ld bc,65
	ld (hl),0
	ldir
	ret


_ILine:
	CALL ROM_CALL
	.dw 0x2E60-0x1A
	.dw 0x4025
	.db 0x04

_setxxop1:
	push hl
	ld h,0
	ld l,a
	CALL ROM_CALL
	.dw 0x359A
	CALL ROM_CALL
	.dw 0x1D19
             pop hl
	ret

_dispop1a:
	CALL ROM_CALL
	.dw 0x2E46
	.dw 0x6CA4
	.db 0x04

DMX:
   ld (CURSOR_X),bc
   CALL ROM_CALL
   .dw D_ZM_STR
    ret

str_norm:
    .db     "NORM",0
str_slow:
    .db     "SLOW",0
title:
    .db     "    Pong 82Z",0
credits:
    .db     "Copyright (C) 1998 Bill Nagel",0
press_clear:
    .db     "Press Clear",0
game_over:
    .db     "Game Over",0
you_win:
    .db     "You Win!",0
comp_wins:
    .db     "Computer Wins.",0
str_balls:
    .db     "2nd: Balls",0
str_1:
    .db     "1",0
str_2:
    .db     "2",0
str_speed:
    .db     "Alpha: Speed",0
str_fast:
    .db     "FAST  ",0

