;            ***************************************
;            ***                                 ***
;            ***  PPPP               t           ***
;            ***  P   P              t           ***
;            ***  P   P  eee  n nn  ttt    eee   ***
;            ***  PPPP  e   e nn  n  t    e   e  ***
;            ***  P     eeeee n   n  t    eeeee  ***
;            ***  P     e     n   n  t  t e      ***
;            ***  P      eee  n   n   tt   eee   ***
;            ***                                 ***
;            ***   v1.0a Lite by Nick Blizard    ***
;            ***            4/17/98              ***
;            ***            Ash 3.0              ***
;            ***                                 ***
;            ***************************************
;
;Here is the source to Pente v1.0a Lite, remember to give me credit for anything you use.
;Any problems contact me at     nblizard@bellsouth.net
;
;Goals : AI , Link Play , Clean up Code , Add more comments


#include "ti82.h"
#include "keys.inc"


CURX1      = TEXT_MEM       ;cursor's x position in pixels  :  1 byte
CURY1      = TEXT_MEM+1     ;cursor's y position in pixels  :  1 byte
PTURN      = TEXT_MEM+2     ;determines which player's turn it is , 0=P1 , 1=P2  :  1 byte
BOARD      = APD_BUF        ;game board  :  160 bytes
CURX2      = TEXT_MEM+3     ;cursor's x position relative to board  :  1 byte
CURY2      = TEXT_MEM+4     ;cursor's y position relative to board  :  1 byte
TEMP1      = TEXT_MEM+5     ;temporary variable #1  :  1 byte
TEMP2      = TEXT_MEM+6     ;    "        "     #2  :  1 byte
TEMP3      = TEXT_MEM+18    ;    "        "     #3  :  1 byte
PTURN2     = TEXT_MEM+7     ;player's turn in game peice fashion(see below)
LPTURN     = TEXT_MEM+8     ;last player's turn in game peice fashion  ,  1=P1  ,  2=P2  :  1 byte
CC         = TEXT_MEM+9     ;round of check capture your on  :  1 byte
QPOS1X     = TEXT_MEM+10    ;position one queud to capture X  : 1 byte
QPOS1Y     = TEXT_MEM+11    ;position one queud to capture Y  :  1 byte
QPOSONE    = TEXT_MEM+12    ;position one queud to capture  :  1 byte
QPOS2X     = TEXT_MEM+13    ;position two queud to capture X  :  1 byte
QPOS2Y     = TEXT_MEM+14    ;position two queud to capture Y  :  1 byte
QPOSTWO    = TEXT_MEM+15    ;position two queud to capture  :  1 byte
NUMCAP1    = TEXT_MEM+16    ;number of pairs captured by player 1  :  1 byte
NUMCAP2    = TEXT_MEM+17    ;  "    "    "      "     "    "    2  :  1 byte
SPTEMP     = TEXT_MEM+19    ;variable to store SP in  :  2 bytes


.org START_ADDR
.db "Pente v1.0a Lite   by:Nick B.",0


Init:
	ld (SPTEMP),sp
	ROM_CALL(CLEARLCD)
	ld a,$8C
	out (2),a
	set 7,(IY+$14)
	ld a,44
	ld (CURX1),a
	ld a,26
	ld (CURY1),a
	ld a,7
	ld (CURX2),a
	ld a,4
	ld (CURY2),a
	ld a,0
	ld (NUMCAP1),a
	ld (NUMCAP2),a
	ld a,r
	srl a
	and %00000001
	ld (PTURN),a
Start:
	call ClearGraphMem
	call OpeningScreen
	call ClearBoardMem
	call DrawBoard
StartLoop1:
	call Turn
	call CursorMain
	jp CheckDuplicate
CDLoop:
	call GamePeice
	jp CheckCapture
CCLoop:
	jp CheckWin
CWRet:
	jr StartLoop1


;*** Subroutine to make board mem all zeros and clear graph_mem ***
ClearBoardMem:
	ld a,0
CBMLoop1:
	ld hl,BOARD
	ld c,a
	ld b,0
	add hl,bc
	ld b,h
	ld c,l
	push af
	ld a,0
	ld (bc),a
	pop af
	inc a
	ld b,160
	cp b
	jr z,ClearGraphMem
	jr CBMLoop1
ClearGraphMem:
	ld hl,GRAPH_MEM
	ld de,GRAPH_MEM+1
	ld bc,768
	ld (hl),0
	ldir
	ret


;*** Subroutine to draw the playing board and the other pics on the main screen ***
;--- draw vertical lines ---
DrawBoard:
	ld d,-4
	ld e,2
	ld l,56
BoardLoop1:
	ld a,d
	add a,6
	ld d,a
	push hl
	push de
	call VertLine
	pop de
	pop hl
	ld a,d
	ld b,a
	ld a,92
	cp b
	jr nz,BoardLoop1
;--- draw horizontal lines ---
	ld d,2
	ld e,-4
	ld h,92
	ld l,0
BoardLoop2:
	ld a,e
	add a,6
	ld e,a
	push hl
	push de
	call HorizLine
	pop de
	pop hl
	ld a,e
	ld b,a
	ld a,56
	cp b
	jr nz,BoardLoop2
	call DISP_GRAPH
;--- draw other pics and words ---
	ld a,60
	ld (CURSOR_X),a
	ld a,58
	ld (CURSOR_Y),a
	ld hl,BoardText1
	ROM_CALL(D_ZM_STR)
	ld a,79
	ld (CURSOR_X),a
	ld a,58
	ld (CURSOR_Y),a
	ld hl,BoardText2
	ROM_CALL(D_ZM_STR)
	ret


;*** Subroutine to show who goes next ***
Turn:
	ld a,(PTURN)
	ld b,0
	cp b
	jr z,Turn1
Turn2:
	ld hl,TurnText1
	ld a,2
	ld (CURSOR_X),a
	ld a,58
	ld (CURSOR_Y),a
	ROM_CALL(D_ZM_STR)
	ld hl,TurnText22
	ld a,26
	ld (CURSOR_X),a
	ld a,58
	ld (CURSOR_Y),a
	call D_ZM_STR
	ret
Turn1:
	ld hl,TurnText1
	ld a,2
	ld (CURSOR_X),a
	ld a,58
	ld (CURSOR_Y),a
	ROM_CALL(D_ZM_STR)
	ld hl,TurnText21
	ld a,26
	ld (CURSOR_X),a
	ld a,58
	ld (CURSOR_Y),a
	ROM_CALL(D_ZM_STR)
	ret


;*** Subroutine to use a cursor to place a game peice ***
;--- place the two cursor sprites ---
CursorMain:
CursorLoop1:
	ld a,(CURX1)
	ld b,a
	ld a,(CURY1)
	ld c,a
	ld hl,CursorSprite1
	call PlaceCursor
	ld b,1
	push bc
	jr CursorDelay
CursorLoop2:
	ld a,(CURX1)
	ld b,a
	ld a,(CURY1)
	ld c,a
	ld hl,CursorSprite2
	call PlaceCursor
	ld b,0
	push bc
;--- delay and key check for cursor ---
CursorDelay:
	call DISP_GRAPH
	ld b, 0
	ld c, 0
CursorDelay1:
	call GET_KEY
	cp G_LEFT
	jp z,CursorLeft
	cp G_RIGTH
	jp z,CursorRight
	cp G_DOWN
	jp z,CursorDown
	cp G_UP
	jp z,CursorUp
	cp G_2nd
	jp z,CursorPlacePeice
	cp G_CLEAR
	jp z,ExitProgram
	cp G_DEL
	jp z,Restart
	ld a,255
	inc b
	cp b
	jr nz,CursorDelay1
CursorDelayLoop1:
	ld a,35
	inc c
	cp c
	jr z,CursorDelay2
	ld b,0
	jr CursorDelay1
CursorDelay2:
	pop bc
	ld a,0
	cp b
	jp z,CursorLoop1
	jp CursorLoop2
;--- move cursor and check if it goes off screen or exists from an existing peice ---
CursorLeft:
	pop bc
	ld a,(CURX1)
	ld b,2
	cp b
	jp z,CursorEnd
	ld (TEMP1),a
	call CursorFixBoard
	ld a,(TEMP1)
	sub 6
	ld (CURX1),a
	ld a,(CURX2)
	dec a
	ld (CURX2),a
	jp CursorEnd
CursorRight:
	pop bc
	ld a,(CURX1)
	ld b,92
	cp b
	jp z,CursorEnd
	ld (TEMP1),a
	call CursorFixBoard
	ld a,(TEMP1)
	add a,6
	ld (CURX1),a
	ld a,(CURX2)
	inc a
	ld (CURX2),a
	jp CursorEnd
CursorUp:
	pop bc
	ld a,(CURY1)
	ld b,2
	cp b
	jp z,CursorEnd
	ld (TEMP1),a
	call CursorFixBoard
	ld a,(TEMP1)
	sub 6
	ld (CURY1),a
	ld a,(CURY2)
	dec a
	ld (CURY2),a
	jp CursorEnd
CursorDown:
	pop bc
	ld a,(CURY1)
	ld b,56
	cp b
	jp z,CursorEnd
	ld (TEMP1),a
	call CursorFixBoard
	ld a,(TEMP1)
	add a,6
	ld (CURY1),a
	ld a,(CURY2)
	inc a
	ld (CURY2),a
	jp CursorEnd
CursorPlacePeice:
	pop bc
	ret
;--- fix board after cursor move ---
CursorFixBoard:
	ld a,(CURX1)
	ld b,a
	ld a,(CURY1)
	ld c,a
	push bc
	dec b
	dec c
	ld hl,FixSprite1
	call PutSprite
	ld a,(CURY2)
	ld b,a
	ld c,16
	call Multiply
	ld a,(CURX2)
	add a,d
	ld c,a
	ld b,0
	ld hl,BOARD
	add hl,bc
	ld b,h
	ld c,l
	ld a,(bc)
	ld b,a
	ld a,1
	cp b
	jp z,CursorFixPeice1
	ld a,2
	cp b
	jp z,CursorFixPeice2
	pop bc
	ld a,2
	cp b
	call z,CursorFixBoard1
	ld a,92
	cp b
	call z,CursorFixBoard2
	ld a,2
	cp c
	call z,CursorFixBoard3
	ld a,56
	cp c
	call z,CursorFixBoard4
	ret
CursorFixBoard1:
	push bc
	dec b
	call RemovePixel
	pop bc
	ret
CursorFixBoard2:
	push bc
	inc b
	call RemovePixel
	pop bc
	ret
CursorFixBoard3:
	push bc
	dec c
	call RemovePixel
	pop bc
	ret
CursorFixBoard4:
	push bc
	inc c
	call RemovePixel
	pop bc
	ret
CursorFixPeice1:
	pop bc
	ld hl,GameSprite1
	call PlacePeice
	ret
CursorFixPeice2:
	pop bc
	ld hl,GameSprite2
	call PlacePeice
	ret
CursorEnd:
	jp CursorMain


;*** Subroutine to place the proper game peice and write to the correct mem location ***
GamePeice:
	ld a,(CURX1)
	ld b,a
	ld a,(CURY1)
	ld c,a
	ld a,(PTURN)
	ld d,1
	cp d
	jr z,GPPlayer2
GPPlayer1:
	ld hl,GameSprite1
	call PlacePeice
	call GPMemLoc
	ld a,1
	ld (bc),a
	ld a,1
	ld (PTURN),a
	ld (LPTURN),a
	ld a,2
	ld (PTURN2),a
	ret
GPPlayer2:
	ld hl,GameSprite2
	call PlacePeice
	call GPMemLoc
	ld a,2
	ld (bc),a
	ld a,0
	ld (PTURN),a
	ld a,2
	ld (LPTURN),a
	ld a,1
	ld (PTURN2),a
	ret
GPMemLoc:
	ld a,(CURY2)
	ld b,a
	ld c,16
	call Multiply
	ld a,(CURX2)
	add a,d
	ld c,a
	ld b,0
	ld hl,BOARD
	add hl,bc
	ld b,h
	ld c,l
	ret


;*** Subroutine to check and see if someone tries to place a peice on an existing peice ***
CheckDuplicate:
	ld a,(CURY2)
	ld b,a
	ld c,16
	call Multiply
	ld a,(CURX2)
	add a,d
	ld c,a
	ld b,0
	ld hl,BOARD
	add hl,bc
	ld b,h
	ld c,l
	ld a,(bc)
	ld b,0
	cp b
	jp z,CDLoop
	jp StartLoop1


;*** Subroutine to check if a capture has occured ***
CheckCapture:
	ld a,1
	ld (CC),a
CheckCLoop:
	ld a,(CURX2)
	ld (TEMP1),a
	ld a,(CURY2)
	ld (TEMP2),a
	call CheckC1
	ld a,(PTURN2)
	cp b
	jp nz,CheckCNext  
	ld a,(TEMP1)
	ld (QPOS1X),a
	ld a,(TEMP2)
	ld (QPOS1Y),a
	ld a,e
	ld (QPOSONE),a
	call CheckC1
	ld a,(PTURN2)
	cp b
	jp nz,CheckCNext
	ld a,(TEMP1)
	ld (QPOS2X),a
	ld a,(TEMP2)
	ld (QPOS2Y),a
	ld a,e
	ld (QPOSTWO),a
	call CheckC1
	ld a,(LPTURN)
	cp b
	jp nz,CheckCNext
	call CapturePeice
	ld a,(NUMCAP1)
	ld b,5
	cp b
	jp z,PlayerWin
	ld a,(NUMCAP2)
	ld b,5
	cp b
	jp z,PlayerWin
	jp CheckCNext
CheckC1:
	ld a,(TEMP1)
	ld b,a
	ld a,(TEMP2)
	ld c,a
	call CheckC2
	push bc
	ld b,16
	call Multiply
	pop bc
	ld a,c
	ld (TEMP2),a
	ld a,b
	ld (TEMP1),a
	add a,d
	ld e,a
	ld c,a
	ld b,0
	ld hl,BOARD
	add hl,bc
	ld b,h
	ld c,l
	ld a,(bc)
	ld b,a
	ret
CheckC2:
	ld a,(CC)
	ld d,a
	ld a,1
	cp d
	call z,CCUL
	ld a,2
	cp d
	call z,CCU
	ld a,3
	cp d
	call z,CCUR
	ld a,4
	cp d
	call z,CCL
	ld a,5
	cp d
	call z,CCR
	ld a,6
	cp d
	call z,CCDL
	ld a,7
	cp d
	call z,CCD
	ld a,8
	cp d
	call z,CCDR
	ret
CCUL:
	dec b
	dec c
	ret
CCU:
	dec c
	ret
CCUR:
	inc b
	dec c
	ret
CCL:
	dec b
	ret
CCR:
	inc b
	ret
CCDL:
	dec b
	inc c
	ret
CCD:
	inc c
	ret
CCDR:
	inc b
	inc c
	ret
CheckCNext:
	ld a,(CC)
	ld b,a
	ld a,8
	cp b
	jp z,CCLoop
	inc b
	ld a,b
	ld (CC),a
	jp CheckCLoop
CapturePeice:
	ld a,(QPOS1X)
	call CapPecLoop
	ld a,d
	ld (TEMP1),a
	ld a,(QPOS1Y)
	call CapPecLoop
	ld c,d
	ld a,(TEMP1)
	ld b,a
	ld hl,FixSprite2
	call PutSprite
	ld a,(QPOSONE)
	call CapPecLoop2
	ld a,(QPOS2X)
	call CapPecLoop
	ld a,d
	ld (TEMP1),a
	ld a,(QPOS2Y)
	call CapPecLoop
	ld c,d
	ld a,(TEMP1)
	ld b,a
	ld hl,FixSprite2
	call PutSprite
	ld a,(QPOSTWO)
	call CapPecLoop2
	call TallyPeice
	ret
CapPecLoop:
	ld b,a
	ld c,6
	call Multiply
	ret
CapPecLoop2:
	ld c,a
	ld b,0
	ld hl,BOARD
	add hl,bc
	ld b,h
	ld c,l
	ld a,0
	ld (bc),a
	ret
TallyPeice:
	ld a,(LPTURN)
	ld b,2
	cp b
	jr z,TPeice2
	ld a,72
	ld (CURSOR_X),a
	ld a,58
	ld (CURSOR_Y),a
	ld a,(NUMCAP1)
	add a,49
	ROM_CALL(M_CHARPUT)
	ld a,(NUMCAP1)
	inc a
	ld (NUMCAP1),a
	ret
TPeice2:
	ld a,91
	ld (CURSOR_X),a
	ld a,58
	ld (CURSOR_Y),a
	ld a,(NUMCAP2)
	add a,49
	ROM_CALL(M_CHARPUT)
	ld a,(NUMCAP2)
	inc a
	ld (NUMCAP2),a
	ret


;*** Subroutine to check if a win has occured ***
CheckWin:
	ld a,1
	ld (CC),a
	ld a,0
	ld (TEMP1),a
CWLoop1:
	ld a,(CURX2)
	ld b,a
	ld a,(CURY2)
	ld c,a
CWLoop5:
	call CWLoop2
	call CWLoop3
	cp b
	jp z,TallyMark
	ld a,(CC)
	inc a
	ld (CC),a
	call CWLoop4
	ld a,(CC)
	ld b,9
	cp b
	jp z,CWRet
	jr CWLoop1
CWLoop2:
	ld a,(CC)
	ld d,1
	cp d
	call z,CCL
	ld d,2
	cp d
	call z,CCR
	ld d,3
	cp d
	call z,CCUL
	ld d,4
	cp d
	call z,CCDR
	ld d,5
	cp d
	call z,CCU
	ld d,6
	cp d
	call z,CCD
	ld d,7
	cp d
	call z,CCUR
	ld d,8
	cp d
	call z,CCDL
	ret
CWLoop3:
	ld a,b
	ld (TEMP2),a
	ld a,c
	ld (TEMP3),a
	push bc
	ld b,16
	call Multiply
	pop bc
	ld a,b
	add a,d
	ld c,a
	ld b,0
	ld hl,BOARD
	add hl,bc
	ld b,h
	ld c,l
	ld a,(bc)
	ld b,a
	ld a,(LPTURN)
	ret
TallyMark:
	ld a,(TEMP1)
	inc a
	ld (TEMP1),a
	ld b,4
	cp b
	jp z,PlayerWin
	call TMLoop
	jp CWLoop5
CWLoop4:
	ld b,3
	cp b
	call z,CWL42
	ld b,5
	cp b
	call z,CWL42
	ld b,7
	cp b
	call z,CWL42
	ret
CWL42:
	ld a,0
	ld (TEMP1),a
	ret
TMLoop:
	ld a,(TEMP2)
	ld b,a
	ld a,(TEMP3)
	ld c,a
	ret


;*** Subroutine to display who wins and wait for keypress ***
PlayerWin:
	ld a,23
	ld (CURSOR_X),a
	ld a,23
	ld (CURSOR_Y),a
	set 3,(IY+$05)
	ld a,(PTURN2)
	ld b,1
	cp b
	call z,PlWLoop2
	ld b,2
	cp b
	call z,PlWLoop1
	ROM_CALL(D_ZM_STR)
	res 3,(IY+$05)
	ld d,23
	ld e,29
	ld h,71
	call HorizLine
	ld d,22
	ld e,23
	ld l,29
	call VertLine
	call DISP_GRAPH
PlWLoop3:
	call GET_KEY
	cp G_CLEAR
	jp z,ExitProgram
	cp G_DEL
	jp z,Restart
	jr PlWLoop3
PlWLoop2:
	ld hl,WinText2
	ret
PlWLoop1:
	ld hl,WinText1
	ret


;*** Subroutine to put a sprite stored in HL at B,C   by: Jimmy Mardell ***
PutSprite:
	push bc
	push de
	push hl
	push hl
	ld a,63
	sub c
	ld c,a
	call FIND_PIXEL
	ld de,$88B8
	add hl,de
	ex de,hl
	pop hl
	ld b,(hl)
	inc hl
	ld c,(hl)
	inc hl
	push hl
	pop ix
	ex de,hl
PS_NewRow:
	push bc
	ld d,(ix)
	inc ix
	push af
	push hl
PS_NewCol:
	rl d
	ld e,a
	jr nc,PS_NoPixel
	or (hl)
	ld (hl),a
	jr PS_NextPixel
PS_NoPixel:
	cpl
	and (hl)
	ld (hl),a
PS_NextPixel:
	ld a,e
	rrca
	jr nc,PS_SameByte
	inc hl
PS_SameByte:
	djnz PS_NewCol
	pop hl
	pop af
	ld de,12
	add hl,de
	pop bc
	dec c
	jr nz,PS_NewRow
	pop hl
	pop de
	pop bc
	ret


;*** Subroutine to Multiply B and C and store answer in D   by: Nick Blizard (nblizard@bellsouth.net) ***
Multiply:
	ld d,0
	ld a,b
	ld e,0
	cp e
	ret z
	ld a,c
	cp e
	ret z
	ld e,1
	cp e
	jr z,Multiply3
	ld a,b
	cp e
	jr z,Multiply4
	ld a,b
Multiply2:
	add a,b
	dec c
	ld d,a
	ld a,c
	ld e,1
	cp e
	ret z
	ld a,d
	jr Multiply2
Multiply3:
	ld a,b
	ld d,a
	ret
Multiply4:
	ld a,c
	ld d,a
	ret


;*** Subroutine to display the opening screen ***
OpeningScreen:
	ld a,6
	ld (CURSOR_X),a
	ld a,11
	ld (CURSOR_Y),a
	ld hl,OScreenText1
	ROM_CALL(D_ZM_STR)
	jp OSLoop2
OSLoop1:
	call DISP_GRAPH
	call GET_KEY
	cp G_CLEAR
	jp z,ExitProgram
	cp 0
	jp z,OSLoop1
	ret
OSLoop2:
	call OSLoop3
	ROM_CALL(D_ZM_STR)
	ld b,39
	cp b
	jp z,OSLoop1
	jp OSLoop2
OSLoop3:
	ld a,6
	ld (CURSOR_X),a
	ld a,(CURSOR_Y)
	add a,7
	ld (CURSOR_Y),a
	ret


;*** Subroutines to exit from the game ***
ExitProgram:
	res 7,(IY+$14)
	res 3,(IY+$05)
	ld sp,(SPTEMP)
	ret


;*** Subroutine to restart the program ***
Restart:
	ld sp,(SPTEMP)
	jp Init


;*** Subroutine to place the cursor at B,C ***
PlaceCursor:
	dec b
	dec c
	call PutSprite
	ret


;*** Subroutine to place a game peice at B,C ***
PlacePeice:
	dec b
	dec b
	dec c
	dec c
	call PutSprite
	ret


;*** Subroutine to draw a horizontal line from D,E to H   by: Nick Blizard (nblizard@bellsouth.net) ***
HorizLine:
	ld b,d
	ld c,e
	push hl
	push de
	call PutPixel
	pop de
	pop hl
	ld a,d
	ld b,h
	cp b
	ret z
	inc d
	jr HorizLine


;*** Subroutine to draw a vertical line from D,E to L   by: Nick Blizard (nblizard@bellsouth.net) ***
VertLine:
	ld b,d
	ld c,e
	push hl
	push de
	call PutPixel
	pop de
	pop hl
	ld a,e
	ld b,l
	cp b
	ret z
	inc e
	jr VertLine


;*** Subroutine to remove a pixel at (B,C), by: Jimmy Mardell ***
RemovePixel:
	ld a,63
	sub c
	ld c,a
	call FIND_PIXEL
	ld de,GRAPH_MEM
	add hl,de
	cpl
	and (hl)
	ld (hl),a
	ret


;*** Subroutine to put a pixel at (B,C)  by: Jimmy Mardell ***
PutPixel:
	ld a,63
	sub c
	ld c,a
	call FIND_PIXEL
	ld de,GRAPH_MEM
	add hl,de
	or (hl)
	ld (hl),a
	ret



;*** Text for the program ***
;--- text for the game board ---
BoardText1:
.db	"P1=0",0
BoardText2:
.db	"P2=0",0

;--- text for the player's turn ---
TurnText21:
.db	"1",39,"s Turn",0
TurnText1:
.db	"Player",0
TurnText22:
.db	"2",39,"s Turn",0

;--- text for winning ---
WinText1:
.db	"Player  1  Wins !",0
WinText2:
.db	"Player  2  Wins !",0

;--- text for opening screen ---
OScreenText1:
.db "Pente  v1.0a  Lite",0
.db "Nick  Blizard",0
.db "NBlizard@Bellsouth.net",0
.db "B|izzard  Productions  Inc.",0
.db "(c)  Apr.  17 ,  1998",0



;*** Sprites for the program ***
CursorSprite1:
.db 3,3
.db %11100000
.db %11100000
.db %11100000
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000

CursorSprite2:
.db 3,3
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000

FixSprite1:
.db 3,3
.db %01000000
.db %11100000
.db %01000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000
.db %00000000

FixSprite2:
.db 5,5
.db %00100000
.db %00100000
.db %11111000
.db %00100000
.db %00100000
.db %00000000
.db %00000000
.db %00000000

GameSprite1:
.db 5,5
.db %01110000
.db %11111000
.db %11111000
.db %11111000
.db %01110000
.db %00000000
.db %00000000
.db %00000000

GameSprite2:
.db 5,5
.db %01110000
.db %10001000
.db %10001000
.db %10001000
.db %01110000
.db %00000000
.db %00000000
.db %00000000



.end
