; *****************************************************************
         ; *
         ; *                   O R Z U N O I D v6.0 Beta
         ; *
         ; *Programmed by Patrick Davidson/Sam Heald
         ; *
         ; *           last updated : 9-August-1998
         ; *
         ;
;*****************************************************************
         .include "ti82.h"
         .include "keys.inc"
         .ORG     START_ADDR
         .db      "Orzunoid v6.0"
         .db      0
#DEFINE LOCATE(xc,yc)    ld de,(xc*256)+yc \ ld (CURSOR_ROW),de
scrlpos  =APD_BUF+165
temp     =APD_BUF+161
temp3    =APD_BUF+164
aball    =APD_BUF+167
speed    =APD_BUF+18
  ; ------------- INITIALIZATION
;-------------------------------------------
         
         ld       a,$8C
         out      (2),a
         ld       (iy+13),0
         ld       (exit_game+1),sp

  ; ------------- GAME REPEATING LOOP
;--------------------------------------
main:
         call     stuff                     ;Play the game!!!    
         ROM_CALL(CLEARLCD)
         ld       hl,hstitle
         call     DTX2
         LOCATE(11,1)

         ld       de,hsdata
         ld       b,7
high_display_loop:                         ;Display high scores
         ld       a,(de)
         ld       l,a
         inc      de
         ld       a,(de)
         ld       h,a
         inc      de
         push     de
         ROM_CALL(D_HL_DECI)
         ld       hl,CURSOR_ROW
         dec      (hl)
         pop      hl
         ROM_CALL(D_ZT_STR)
         ex       de,hl
         ld       hl,CURSOR_ROW
         inc      (hl)
         djnz     high_display_loop
         call     wait_key
         cp       K_CLEAR
         jr       nz,main

exit_game:                                   ;Exit the game
         ld       sp,0
 ret

restore_game:                             ;Restore the game
         ld       (hl),0
         call     init_display
         jp       restore_position

r3:      pop      af
         ret

stuff:
         ld       hl,saved_flag             ;Check for saved game
         ld       a,(hl)
         or       a
         jr       nz,restore_game
title:
           ROM_CALL(CLEARLCD)

         ld h,1

        ld      BC, 0*256+55
        ld      DE, 96*256+55
        call    _ILine

         ld       de,$0100                       ;Display title tex
         ld       hl,initial_msg
         call     DTX

         ld       de,$0904
         call     DMX

         ld       de,$1016
         call     DMX

         ld       de,$171F
         call     DMX

         ld       de,$2402       
         call     DMX

         ld       de,$2C08
         call     DMX


 ; -------------- INTRODUCTION SCROLL------------------------------------
main_loop:
         call     GET_KEY
         cp       G_CLEAR
         jr       z,r3
         cp       G_ALPHA
         ret      z  

         sub      $31
         jp       m,main_loop
         cp       5
         jp       p,main_loop

         ld       hl,speed
         ld       (hl),a
         ld       a,5
         sub      (hl)

         ld       hl,0
         ld       (score),hl

         ld       hl,stop    ;clear text memory
         ld       (hl),0
         ld       de,p
         ld       bc,167
         ldir

         ld       hl,lives
         ld       (hl),3
         dec      hl
         dec      hl
         ld       (hl),5

         call     un_expand


 ; ------------------- OUTER GAME LOOP ----------------------------------
         call     init_display
play_da_game:
         ld       b,20
lgain:   
         djnz     lgain

level_addr:
         ld       hl,universe-32
         ld       a,(level)
         ld       b,a
         inc      b
         ld       de,32
find_level_loop:
         add      hl,de
         djnz     find_level_loop

         ld       b,32                  ;Copy the map 
         ld       de,data
set_up_1:
         push     bc
         ld       b,4
         ld       a,(hl)
loop_row:
         rlca
         rlca
         ld       (de),a
         inc      de
         djnz     loop_row
         inc      hl
         pop      bc
         djnz     set_up_1

         ld       hl,data
         ld       b,128
land:    ld       a,(hl)
         and      3
         ld       (hl),a
         inc      hl
         djnz     land

         ld       hl,level
         inc      (hl)
level_loop:
         ld       hl,p
         ld       (hl),80
         inc      hl
         ld       (hl),96
         inc      hl
         ld       (hl),-1
         inc      hl
         ld       (hl),50
         inc      hl
         ld       (hl),-1
         inc      hl
         xor      a
         ld       (hl),a
         ld       de,x2+1
         ld       bc,7
         ldir
         ld       (guard),a
         ld       (bthru),a
         
         ld       hl,laserstatus             ;Clear data storage
         ld       de,laserstatus+1
         ld       (hl),0
         ld       bc,65
         ldir

         call     un_expand

restore_position:
         call     play_level
         xor      a
         out      (1),a
         ld       a,(won)
         or       a
         jr       z,finished_level
         ld       hl,lives
         dec      (hl)
         jr       z,game_over
         jr       level_loop
finished_level:
         ld       b,0
         ld       a,(x+3)
         or       a
         jr       z,n1
         inc      b
n1:      ld       a,(x2+3)
         or       a
         jr       z,n2
         inc      b
n2:      ld       a,(x3+3)
         or       a
         jr       z,n3
         inc      b
n3:      ld       a,b
         add      a,a
         add      a,a
         add      a,a
         add      a,a
gp:      ld       hl,(score)
         ld       de,10
         add      hl,de
         ld       (score),hl
         push     af
         call     update_score
         pop      af
         dec      a
         jr       nz,gp
         ld       a,(level)
         cp       20                      ;THIS IS WHERE YOU SELECT THE MAX Amount of levels
         jp       nz,play_da_game
         ld       a,(lives)
         add      a,a
         add      a,a
         add      a,a
         ld       b,a
lgain2:  ld       hl,(score)
         ld       de,100
         add      hl,de
         ld       (score),hl
         call     update_score
         djnz     lgain2

  ; ---------------------- END OF GAME -------------------------
game_won:                               
;;now, to load the flag
         ld a,1
         ld (realbeat),a        ;the flag is set
         ld       hl,youwin
         call     DTX2
         call     wait_key

         jr       scoring
game_over:                               
         ld       de,$2920
         ld       hl,lost
         call     DMX
         call     wait_key
scoring:                          ;Set up score page
         ld       hl,(lowest)      ;See if ya got a hi-score
         ld       de,(score)
         call     CP_HL_DE
         ret      nc
         ROM_CALL(CLEARLCD)
         ld       hl,hi_score_str
         call     DTX2
         ld       hl,lowest+2
         ld       (temp),hl
         ld       b,11
space_loop:
         ld       (hl),32
         inc      hl
         djnz     space_loop
         ld       ix,(temp)
         ld       b,0
enter_name_loop:
         call     GET_KEY
         or       a
         jr       z,enter_name_loop
         cp       G_DEL
         jr       z,backup
         cp       G_ENTER
         jr       z,nomore
         ld       c,a
         ld       a,10
         cp       b
         jr       z,enter_name_loop
         ld       hl,chartable-10
         ld       e,c
         ld       d,0
         add      hl,de
         ld       a,(hl)
         ld       (ix),a
         ROM_CALL(TX_CHARPUT) 
         inc      b




         inc      ix
         jr       enter_name_loop
backup:  dec      b
         ld       a,255
         cp       b
         jr       z,too_far
         dec      ix
         ld       (ix),32
         ld       hl,CURSOR_COL
         dec      (hl)
         ld       a,32
         ROM_CALL(TX_CHARPUT)
         dec      (hl)
         jr       enter_name_loop
too_far: inc      b
         jr       enter_name_loop
nomore:
         ld       hl,lowest
         ld       de,(score)
         ld       (hl),e
         push     hl
         inc      hl
         ld       (hl),d
         pop      ix              ; hiscore table
         ld       b,6
sort_scores:
         ld       e,(ix)
         ld       d,(ix+1)
         ld       l,(ix-14)
         ld       h,(ix-13)
         call     CP_HL_DE
         ret      nc
         push     bc
         ld       b,14
         ld       d,0
exg_loop:ld       e,(ix)
         ld       c,(ix-14)
         ld       (ix),c
         ld       (ix-14),e
         inc      ix
         inc      hl
         djnz     exg_loop
         ld       de,-28
         add      ix,de
         pop      bc
         djnz     sort_scores
         ret

 ;---------------------- THE MAIN GAME -----------------------
play_level:
         ld       a,1
         ld       (stop),a
game_main_loop:
         ld       hl,GRAPH_MEM
         ld       b,110
         xor      a
clgloop: ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         ld       (hl),a
         inc      hl
         djnz     clgloop
         
         call    operate_lasers

         call     Misc_Keys
         ld       hl,GRAPH_MEM+660

         ld       a,(guard)
         ld       b,12

dbloop:  ld       (hl),a
         inc      hl
         djnz     dbloop
         ld       a,(speed)             ;Slow down a bit
         or       a
         call     nz,waste_time
         ld       hl,(timer)
         inc      hl
         ld       (timer),hl
         call     redraw_solid          ;Redraw all blocks

         xor      a
         ld       (aball),a
         ld       hl,x
         ld       b,3
ldb:     push     hl
         push     bc
         call     ballstuff
         pop      bc
         pop      hl
         ld       de,4
         add      hl,de
         djnz     ldb

         ld       a,(aball)
         or       a
         ret      z

not_hit_right_edge:
         ld       a,$FD           ;Exit key = get out!
         out      (1),a
         in       a,(1)
         bit      6,a
         jp       z,exit_game
         ld       a,%01111110           ;Left arrow = go left!
         out      (1),a
         in       a,(1)
         rrca

         rrca
         push     af
         call     nc,go_left
         pop      af
         rrca
         call     nc,go_right

         ld       a,(p)                 ; Draw paddle
         srl      a
         ld       d,a
         ld       e,52
         ld       ix,paddlen
         ld       a,(expand)
         or       a
         jr       z,nw111
         ld       ix,paddlew
nw111:
         call     drw_sprw

         call     bonus_blocks





         call     DISP_DELAY
         ld       a,7               
         out      (16),a

         ld       c,17
         ld       a,$80
         ld       hl,GRAPH_MEM
loop_display:
         call     DISP_DELAY
         out      (16),a
         inc      a
         ld       e,a
         ld       a,$20
         call     DISP_DELAY
         out      (16),a
         ld       a,e

         call     DISP_DELAY \ outi
         call     DISP_DELAY \ outi
         call     DISP_DELAY \ outi
         call     DISP_DELAY \ outi
         call     DISP_DELAY \ outi
         call     DISP_DELAY \ outi
         call     DISP_DELAY \ outi
         call     DISP_DELAY \ outi
         call     DISP_DELAY \ outi
         call     DISP_DELAY \ outi
         call     DISP_DELAY \ outi
         call     DISP_DELAY \ outi

         cp       $b8
         jr       nz,loop_display




         call     update_score
         ld       a,(stop)
         or       a
         jr       nz,stopped
         ld       a,$DF
         out      (1),a
         in       a,(1)
         bit      7,a
         ret      z
         ld       a,(won)
         or       a
         jp       nz,game_main_loop
         ret

stopped: SUB      A
         ld       (stop),a

         ld       de,$2911
         ld       hl,press_enter
         call     DMX
we1:   
         call     wait_key
         cp       G_GRAPH
         jr z, cheattest
;;bookmark
lgt_key:
         cp       G_ENTER
         jr       nz,we1
         jp       game_main_loop
cheater2: ld      hl,game_main_loop
          push    hl
new: 
         ld       hl,data       
         ld       bc,127        
         ld       de,data+1     
         ld       (hl),0        
         ldir                   
    
         xor      a
         ld       (won),a
     
         ret
Misc_Keys:
         call     GET_KEY
 
         cp       G_GRAPH
         jr       z,cheattest42
lgt42:
         cp       G_MODE
         jr       z,stopped

         cp       G_DOWN
         ret      nz
         ld       hl,saved_flag
         ld       (hl),1
         jp       exit_game

cheattest:
         ld a, (realbeat)
         cp 0           ;zf = not beaten
         jr z, lgt_key  ; game not beaten
         jr cheater2
cheattest42:
         ld a, (realbeat)
         cp 0           ;zf = not beaten
         jr z, lgt42    ; game not beaten
         jr new


 ; -------------- BONUS BRICKS----------------------------------------------
killbb:  dec      hl
         dec      hl
         ld       (hl),0
         ret
bonus_blocks:
         ld       hl,bonust
         ld       a,(hl)
         dec      a
         RET      M
         jp       z,b9
         dec      a
         jr       z,b7
         dec      a
         jr       z,b3
         dec      a
         jr       z,b2
         dec      a
         jr       z,b5
         dec      a
         jr       z,b6
         dec      a
         jr       z,b4
         dec      a
         jr       z,b8
         ld       ix,bonus_4
         jr       done

b2:      ld       ix,bonus_2
         jr       done
b3:      ld       ix,bonus_3
         jr       done
b4:      ld       ix,bonus_1
         jr       done
b5:      ld       ix,bonus_5
         jr       done
b6:      ld       ix,bonus_6
         jr       done
b7:      ld       ix,bonus_7
         jr       done 
b8:      ld       ix,bonus_8
         jr       done
b9:     ld       ix,bonus_9
done:    inc      hl
         LD       D,(hl)
         srl      d
         inc      hl
         ld       e,(HL)
         call     drw_sprw
         ld       hl,bonusy
         ld       a,(timer)
         and      1
         add      a,(hl)
         ld       (hl),a
         ld       a,(hl)
         cp       56
         jr       z,killbb
         cp       50
         ret      m
         dec      hl
         ld       a,(p)
         neg
         add      a,(hl)
         add      a,20
         ret      m
exp1:    sub      52
         ret      p
         dec      hl
         ld       a,(hl)
         ld       (hl),0
         dec      a
         JR       Z,got9
         dec      a
         jr       z,got7
         dec      a
         jr       Z,got3
         dec      a
         jr       z,got2
         dec      a
         jr       z,got5
         dec      a
         jr       z,got6
         dec      a
         jr       z,got4
         dec      a
         jp       z,got8

got1:    ld       hl,lives
         inc      (hl)
         reT
got9:
        ld       de,50
        jr       score__

got7:    ld       hl,bthru
         inc      (hl)
         inc      (hl)
         jr       score25

got4:    ld       de,100
         jr       score__

got5:    LD       A,255
         LD       (guard),a
         jr       score25

got6:    ld       hl,catch
         inc      (hl)
         inc      (hl)
         ret

got3:
         ld       a,32
         ld       (expand),a
         ld       a,84
         ld       (exp1+1),a
         ld       hl,$3fcb
         ld       (exp2),hl

score25: ld       de,25
score__: ld       hl,(score)
         add      hl,de
         ld       (score),hl
         ret

got2:    ld       de,4              ;Find first active ball
         ld       hl,x+3
         ld       a,(hl)
         or       a
         jr       nz,copyball
         add      hl,de
         ld       a,(hl)
         or       a
         jr       nz,copyball
         add      hl,de

copyball:                           ;Exchange that into first ball
         ld       de,x+3
         ld       b,4
lcopyball:
         ld       a,(hl)
         ld       (hl),0
         ld       (de),a
         dec      hl
         dec      de
         djnz     lcopyball


         ld       a,(x2+3)          ;Test if second ball is used
         or       a
         jr       nz,b1_no
         ld       hl,x              ;Split into second ball if it
         ld       de,x2           
         ld       bc,4
         ldir
         ld       hl,x2+1
         inc      (hl)
b1_no:
         ld       a,(x3+3)          ;Test if third ball is used
         or       a
         ret      nz
         ld       hl,x              ;Split into third ball
         ld       de,x3
         ld       bc,4
         ldir
         ld       hl,x3+1
         dec      (hl)
         jr       score25


got8:
         ld       hl,laserstatus             ;Code called when collected
         ld       a,15
         add      a,(hl)
         ld       (hl),a
         ld       hl,(score)
         ld       de,10
         add      hl,de
         ld       (score),hl
operate_lasers:

         ld       hl,laserstatus
         ld       a,(hl)
         or       a
         ret      z
 
         push     hl
         
        PUSH    BC
        LD      A,$fe
        OUT     ($01),A ; Port 1 Keypad
        NOP \ NOP \ NOP \ NOP     
        IN      A,($01) ; Port 1 Keypad
        LD      B,A
        LD      A,$ff
        IN      A,($01) ; Port 1 Keypad
        LD      A,B
        LD      A,$bf
        OUT     ($01),A ; Port 1 Keypad
        IN      A,($01) ; Port 1 Keypad
        OR      $0f
        AND     B
        POP     BC
         pop      hl
         inc      hl
         bit      5,a
         jp       nz,nof1
         ld       a,(hl)
         or       a
         jr       nz,doneshooting
         ld       (hl),1

         dec      hl
         ld       a,(hl)
         dec      A
         jr       z,doneshooting
         ld       (hl),a

         inc      hl
         inc      hl                         ;Put left bullet
         ld       b,32
shooteml:ld       a,(hl)
         or       a
         jr       nz,sactivel
         ld       (hl),52
         inc      hl
         ld       a,(p)
         ld       (hl),a
         dec      hl
         ld       b,1
sactivel:inc      hl
         inc      hl
         djnz     shooteml

         ld       hl,lasercoords             ;Put right bullet
         ld       b,32
shootemr:ld       a,(hl)
         or       a
         jr       nz,sactiver
         ld       (hl),52
         inc      hl
         ld       a,(p)
         ld       b,a
         ld       a,(expand)
         add      a,b
         add      a,30
         ld       (hl),a
         dec      hl
         ld       b,1
sactiver:inc      hl
         inc      hl
         djnz     shootemr

doneshooting:

         ld       hl,lasercoords             ;Handle laser blasts
         ld       b,32
laserloop:
         push     hl                         
         ld       a,(hl)                     ;Test if blast active
         or       a
         jr       z,nolaserhere

         push     bc

         dec      (hl)                       ;Draw blast
         ld       a,63
         sub      (hl)
         ld       c,a
         inc      hl
         ld       b,(hl)
         srl      b
         call     FIND_PIXEL
         ld       de,GRAPH_MEM
         add      hl,de
         or       (hl)
         ld       (hl),a

         pop      bc

         pop      hl
         push     hl
         ld       a,(hl)
         bit      5,a
         jr       nz,nolaserhere
         and      28
         add      a,a
         add      a,a
         ld       e,a
         inc      hl
         ld       a,(hl)
         rra
         rra
         rra
         rra
         and      15
         or       e
         ld       e,a
         ld       d,0
         ld       hl,data
         add      hl,de
         ld       a,(hl)
         or       a
         jr       z,nolaserhere
         cp       3
         jr       z,nolaserhere
         dec      a
         ld       (hl),a
         ld       hl,(score)
         inc      hl
         ld       (score),hl
         pop      HL
         ld       (hl),0
         push     hl

nolaserhere:
         pop      hl
         inc      hl
         inc      hl
         djnz     laserloop
         ret
nof1:    ld       (hl),0
         jr       doneshooting



  ; ------------------- UTILITY ROUTINES------------------------------------
un_expand:
         ld       a,52
         ld       (exp1+1),a
         xor      a
         ld       hl,exp2
         ld       (hl),a
         inc      hl
         ld       (hl),a
         ld       (expand),a
         ret

update_score:
         ld       hl,$207
         ld       (CURSOR_ROW),hl
         ld       a,(lives)
         ld       l,a
         ld       h,0
         ROM_CALL(D_HL_DECI)
dispit2: ld       hl,$b07
         ld       (CURSOR_ROW),hl
         ld       hl,(score)
         ROM_CALL(D_HL_DECI)
         ret

init_display:
         ROM_CALL(CLEARLCD)
         ld       de,7
         ld       (CURSOR_ROW),de
         ld       hl,ingame
         jp       DTX

wait_key:ld       a,40                   ;Wait for a keypress
         call     waste_time
wait_inner:
         call     GET_KEY
         or       a
         ret      nz
         jr       wait_inner


go_right:
         ld       a,(expand)
         neg
         add      a,160
         ld       d,a
         ld       a,(p)
         cp       d
         jr       z,right_edge
         inc      a
         ld       c,1
         in       e,(c)
         bit      3,e
         jr       z,quit_moving
         cp       d
         jr       z,right_edge
         inc      a
         cp       d
         jr       z,right_edge
         inc      a
         cp       d
         jr       z,right_edge
         inc      a
         cp       d
         jr       z,right_edge
         inc      a
quit_moving:
         ld       (p),a
         ret
right_edge:                   ;If paddle is at right edge
         ld       a,d
         ld       (p),a
         ret
go_left:
         ld       a,(p)
         cp       0
         jr       z,left_edge
         dec      a
         jr       z,left_edge
         ld       c,1
         in       e,(c)
         bit      3,e
         jr       z,quit_moving
         dec      a
         jr       z,left_edge
         dec      a
         jr       z,left_edge
         dec      a
         jr       z,left_edge
         dec      a
         ld       (p),a
         xor      a
         ret
left_edge:                     ;If paddle is at left edge
         xor      a
         ld       (p),a
         ret
waste_time:
l:
       ei
       halt
         dec      a
         jr       nz,l
         ret

redraw_solid:                 ;Redraw all bricks
         ld       hl,won
         ld       (hl),0
         ld       ix,GRAPH_MEM
         ld       hl,data
         ld       b,8
rs_outer:push     bc
         ld       b,12
rs_inner:ld       a,(hl)
         dec      a
         jr       z,draw_block
         dec      a
         JR       Z,draw_block_tough
         dec      a
         jr       z,draw_block_solid
ok:      inc      hl
         inc      ix
         djnz     rs_inner
         ld       de,36
         add      ix,de
         inc      hl
         inc      hl
         inc      hl
         inc      hl
         pop      bc
         djnz     rs_outer
         ret
draw_block:                   ;Draw a standard block
         cpl
         ld       (won),a
         ld       (ix+0),255
         ld       (ix+12),129
         ld       (ix+24),129
         ld       (ix+36),255
         jr       ok
draw_block_solid:             ;Draw a solid block
         ld       (ix+0),255
         ld       (ix+12),255
         ld       (ix+24),255
         ld       (ix+36),255
         jr       ok
draw_block_tough:             ;Draw a tough block
         cpl
         ld       (won),a
         ld       (ix+0),255
         ld       (ix+12),195
         ld       (ix+24),195
         ld       (ix+36),255
         jr       ok
 ; -------------- SRPITE DRAWING ROUTINE------------------------------------
drw_spr:

         ld       a,63
         ld       b,d
         sub      e
         ld       c,a
         call     FIND_PIXEL
         ld       (smc1+1),a
         ld       de,GRAPH_MEM
         add      hl,de
          
         ld       d,(ix)       
         ld       b,(ix+1)        
oloop:   push     bc                ;Save # of rows
         push     hl                ;Save screen address
         ld       b,d               ;Load width
         ld       c,(ix+2)          ;Load one line of image
         inc      ix
smc1     ld       a,1               ;Load pixel mask
iloop:   sla      c                 ;Test leftmost pixel
         jr       nc,noplot         ;See if a plot is needed
         ld       e,a               ;OR pixel with screen
         or       (hl)
         ld       (hl),a
         ld       a,e
noplot:  rrca
         jr       nc,notedge        ;Test if edge of byte reached
         inc      hl                ;Go to next byte
notedge: djnz     iloop
         pop      hl                ;Restore address
         ld       bc,12             ;Go to next line
         add      hl,bc
         pop      bc                ;Restore data
         djnz     oloop
         ret

drw_sprw:

         ld       a,63
         ld       b,d
         sub      e
         ld       c,a
         call     FIND_PIXEL
         ld       (wsmc1+1),a
         ld       (wsmc2+1),a
         ld       de,GRAPH_MEM
         add      hl,de

         ld       d,(ix)
         ld       b,(ix+1)        
woloop:  push     bc                ;Save # of rows
         push     hl                ;Save screen address
         ld       b,d               ;Load width
         ld       c,(ix+2)          ;Load one line of image
         inc      ix
wsmc1    ld       a,1               ;Load pixel mask
wiloop:  sla      c                 ;Test leftmost pixel
         jr       nc,wnoplot         ;See if a plot is needed
         ld       e,a               ;OR pixel with screen
         or       (hl)
         ld       (hl),a
         ld       a,e
wnoplot: rrca
         jr       nc,wnotedge        ;Test if edge of byte reached
         inc      hl                ;Go to next byte
wnotedge
wsmc2:   cp       1
         jr       z,wover_1

         djnz     wiloop
         pop      hl                ;Restore address
         ld       bc,12             ;Go to next line
         add      hl,bc
         pop      bc                ;Restore data
         djnz     woloop
         ret
wover_1: ld       c,(ix+2)
         inc      ix
         djnz     wiloop
         dec      ix
         pop      hl
         ld       bc,12
         add      hl,bc
         pop      bc
         djnz     woloop
         ret

 ; -------------- SPRITE FOR PADDLE-----------------------------------------
paddlen: .db      16,4
         .db      %01111111,%11111110
         .db      %10000000,%00000001
         .db      %10000000,%00000001
         .db      %01111111,%11111110
paddlew: .db      32,4
         .db      %01111111,%11111111,%11111111,%11111110
         .db      %10000000,%00000000,%00000000,%00000001
         .db      %10000000,%00000000,%00000000,%00000001
         .db      %01111111,%11111111,%11111111,%11111110

spr_ball:.db      3,3
         .db      %11100000
         .db      %11100000
         .db      %11100000
 ; -------------- PROCESS A BALL-------------------------------------------
release: ld       (hl),50
         inc      hl
         ld       (hl),-1
         dec      hl
         dec      hl
         dec      hl
         ld       a,(p)
         add      a,(hl)
         ld       (hl),a
         jp       ballstuff

coughtit:
         dec      (hl)
         pop      hl                         ;HL -> Y
         inc      hl
         ld       (hl),55
         dec      hl
         dec      hl
         dec      hl                         ;HL -> X
         ld       a,(p)
         sub      (hl)
         neg
         ld       (hl),a
         inc      hl
         inc      hl

caught_ball:                                 ;HL -> Y
         ld       a,$BF
         out      (1),a
         ld       e,51
         in       a,(1)
         bit      5,a
         jr       z,release
         ld       a,(p)
         dec      hl
         dec      hl
         add      a,(hl)
         srl      a
         Dec      a
         ld       d,a
         dec      a
         ld       ix,spr_ball
         jp       drw_spr

paddle:
         push     hl
         dec      hl
         dec      hl
         ld       a,(hl)                     ;HL -> X
         ld       hl,p
         sub      (hl)
         pop      hl                         ;HL -> Y
         jp       m,doneyb
         srl      a
exp2:    nop
         nop
         ld       e,a
         and      240
         jp       nz,doneyb
         push     hl
         inc      hl                         ;HL -> YV
         ld       (hl),-1

         ld       d,0
         ld       hl,bounces
         add      hl,de
         ld       a,(hl)
         pop      hl
         push     hl                
         dec      hl                         ;HL -> XV
         ld       (hl),a
         ld       a,15
         ld       (incr),a
         ld       hl,bthru
         ld       a,(hl)
         or       a
         jr       z,ndbt
         dec      a
         ld       (hl),a
ndbt:

         ld       hl,catch
         ld       a,(hl)
         or       a
         jr       nz,coughtit
         pop      hl

         jr       doneyb

top:     inc      hl
         ld       (hl),1
         dec      hl
         jr       doneyb

bottom:  ld       a,(guard)
         or       a
         jr       nz,guarded
         inc      hl
         ld       (hl),0
         ret
guarded: inc      hl
         ld       (hl),-1
         dec      hl
         rrca
         ld       a,%10101010
         ld       (guard),a
         jr       c,doneyb
         xor      a
         ld       (guard),a
         jr       doneyb

ballstuff:
         inc      hl
         inc      hl
         inc      hl                         ;HL -> YV
         ld       a,(hl)

         or       a
         ret      z
         ld       (aball),a
         cp       55
         dec      hl                         ;HL -> Y

         jp       z,caught_ball
         add      a,(hl)
         ld       (hl),a
         dec      a
         jr       z,top
         cp       50
         jr       z,paddle
         cp       51

         jr       z,paddle
         cp       52
         jr       z,paddle
         cp       53
         jr       z,bottom
doneyb:                                      ;HL -> Y
         push     hl
         call     test_hit
         pop      hl
         jr       nc,nohit1
         ld       a,(bthru)
         or       a
         jr       nz,nohit1
         inc      hl
         ld       a,(hl)
         neg
         ld       (hl),a
         dec      hl
         add      a,(hl)
         ld       (hl),a                     ;HL -> Y

nohit1:  dec      hl                         ;Bounce off left/right sides
         dec      hl
         ld       a,(hl)
         inc      hl
         rrca
         rrca
         and      63
         jr       z,forceright
         cp       47
         jr       z,forceleft
dodraw:  ld       a,(hl)                     ;Move ball horizontally
         dec      hl
         add      a,(hl)
         ld       (hl),a

         push     hl
         inc      hl
         inc      hl
         call     test_hit
         pop      hl
         
         jr       nc,nohit2
         ld       a,(bthru)
         or       a
         jr       nz,nohit2
         inc      hl
         ld       a,(hl)
         neg
         ld       (hl),a
         dec      hl
         add      a,(hl)
         ld       (hl),a
nohit2:
         ld       d,(hl)
         inc      hl
         inc      hl                      
         srl      d
         dec      d
         ld       e,(hl)
         dec      e

         ld       ix,spr_ball
         jp       drw_spr

forceright:                                  ;Make ball go right
         ld       a,(hl)
         neg
         jp       m,dodraw
         ld       (hl),a
         jr       dodraw
forceleft:                                   ;Make ball go left
         ld       a,(hl)
         neg
         jp       p,dodraw
         ld       (hl),a
         jr       dodraw
 ; -------------- TEST IF THE BALL HITS A BRICK ------------------------
test_hit:
         ld       a,(hl)
         ld       e,a
         bit      5,a
         jr       nz,bottom_half
         and      28
         add      a,a
         add      a,a
         ld       b,a
         dec      hl
         dec      hl
         ld       a,(hl)
         and      240
         ld       d,a
         rrca
         rrca
         rrca
         rrca
         and      15
         or       b
         ld       c,a
         ld       b,0
         ld       hl,data
         add      hl,bc
         ld       a,(hl)
         dec      a
         jr       z,hit_1
         dec      a
         jr       z,hit_2
         dec      a
         jr       z,hit_3
bottom_half:
         scf
         ccf
         ret
hit_1:   ld       (hl),0
         ld       hl,(score)
         ld       a,(incr)
         add      a,5
         ld       (incr),a
         ld       c,a
         ld       b,0
         add      hl,bc
         ld       (score),hl
         ld       a,r
         rrca
         ret      c
         and      5
         inc      a

         ld       b,a
         ld       a,d
         rla
         jr       c,abcdef
         ld       hl,bonust
         ld       a,(hl)
         or       a
         scf
         ret      nz
         ld       (hl),b
         inc      hl
         ld       (hl),d
         inc      hl
         ld       (hl),e
         scf
         ret

abcdef:  inc      b
         inc      b
         inc      b
         ld       hl,bonust
         ld       a,(hl)
         or       a
         scf
         ret      nz
         ld       (hl),b
         inc      hl
         ld       a,d
         sub      8
         ld       (hl),a
         inc      hl
         ld       (hl),e
         scf
         ret

hit_2:   ld       (hl),1
         ld       hl,(score)


         inc      hl
         ld       (score),hl
hit_3:   scf
         ret
         
 ; -------------- DATA -------------------------------------------------
bounces: .db      -3
         .db      -2,-2,-2
         .db      -1,-1,-1
         .db      0,0
         .db      1,1,1
         .db      2,2,2
         .db      3
initial_msg: 
         .db      "Orzunoid TI-82",0
copyright:
        .db "Version 6.0 Copyright 98 by:",0
patstr:
        .db "Patrick Davidson",0
samstr: .db "Sam Heald",0
control1:
        .db "Choose Speed(Top Buttons):",0
control11:
        .db "Y=(Slow) to GRAPH(Fast)",0

ingame:  .db      "L:       S:     ",0
 ; -------------------- GAME DATA-------------------------------------------

saved_flag: 
         .db      0
stop:     .db   0
p:        .db    0
x:        .db    0,0,0,0
x2:       .db    0,0,0,0
x3:       .db    0,0,0,0
incr:     .db    0
level:    .db    0
lives:    .db    0
won:      .db    0,0
score:    .db    0,0
uchoice:  .db    0
inc:      .db    0
bonust:   .db    0                                         
bonusx:   .db    0
bonusy:   .db    0
expand:   .db    0
timer:    .db    0,0
guard:    .db    0
catch:    .db    0
bthru:    .db    0,0
data:     .dw    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
          .dw    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
          .dw    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
          .dw    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
laserstatus:
          .db    0
f1status: .db    0
lasercoords:
          .dw    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
          .dw    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 ; -------------------- UNIVERSE DATA---------------------------------------
 ;This is where the level designs are kept. To make your own levels go to "gp:" near the middle 
 ;of this document and change the "cp" to whatever the new maximum level amount will be. Next
 ;make your levels here. Make eight lines following the outline of another level. Going from 
 ;left to right each two digit number stands for a block in the game. "00" is a blank space.
 ;"11" is a solid space. "01" is a standard block. "10" is a block that takes two hits to get
 ;rid of. So have fun! If you think my game is too easy or too hard customize your own.
universe:
         .db      %11111100,%00000000,%00111111,0
         .db      %11110000,%00000000,%00001111,0
         .db      %11000000,%00000000,%00000011,0
         .db      %00000000,%00000000,%00000000,0
         .db      %00000010,%10101010,%10000000,0
         .db      %00000001,%01010101,%01000000,0
         .db      %00000000,%00000000,%00000000,0
         .db      %00000000,%00000000,%00000000,0

         .db      %11000000,%00000000,%00000011,0
         .db      %11010101,%01010101,%01010111,0
         .db      %11000000,%00000000,%00000011,0
         .db      %11010101,%01010101,%01010111,0
         .db      %11000000,%00000000,%00000011,0
         .db      %11010101,%01010101,%01010111,0
         .db      %11000000,%00000000,%00000011,0
         .db      %11000000,%00000000,%00000011,0

         .db      %01000100,%01000100,%01000100,0
         .db      %00010001,%00010001,%00010001,0
         .db      %01000100,%01000100,%01000100,0
         .db      %00010001,%00010001,%00010001,0
         .db      %01000100,%01000100,%01000100,0
         .db      %00010001,%00010001,%00010001,0
         .db      %00000000,%00000000,%00000000,0
         .db      %11111100,%00000000,%00111111,0

         .db      %11111000,%00000000,%00101111,0
         .db      %11100000,%10000010,%00001011,0
         .db      %11100000,%00000000,%00001011,0
         .db      %00010100,%00101000,%00010100,0
         .db      %00010100,%00000000,%00010100,0
         .db      %00000000,%01000001,%00000000,0
         .db      %00000000,%00010100,%00000000,0
         .db      %00000000,%11111111,%00000000,0

         .db      %11111000,%00000000,%00101111,0
         .db      %11010000,%10101010,%00000111,0
         .db      %11000000,%10010110,%00000011,0
         .db      %11000000,%10101010,%00000011,0
         .db      %11000000,%00000000,%00000011,0
         .db      %01110000,%00000000,%00001101,0
         .db      %01011100,%00000000,%00110101,0
         .db      %10101011,%11000011,%11010101,0

         .db      %11111100,%00010100,%00111111,0
         .db      %11110000,%01000001,%00001111,0
         .db      %11000001,%00000000,%01000011,0
         .db      %00000100,%10000010,%00010000,0
         .db      %00010000,%00010100,%00000100,0
         .db      %01000000,%00000000,%00000001,0
         .db      %01000000,%01000001,%00000001,0
         .db      %01000000,%00010100,%00000001,0

         .db      %11111111,%11111111,%11111111,0
         .db      %11010001,%00010001,%00010011,0
         .db      %11000100,%01000100,%01000111,0
         .db      %11010001,%00010001,%00010011,0
         .db      %11000100,%01000100,%01000111,0
         .db      %11010001,%00010001,%00010011,0
         .db      %11000100,%01000100,%01000111,0
         .db      %11110001,%00010001,%00011111,0

	   .db      %10110101,%01110101,%01111010,0
	   .db      %10101101,%01011101,%01011110,0
	   .db      %10110101,%01110101,%01111010,0
	   .db      %10101101,%01011101,%01011110,0
	   .db      %10110101,%01110101,%01111010,0
	   .db      %10101101,%01011101,%01011110,0
	   .db      %10110101,%01110101,%01111010,0
	   .db      %10101101,%01011101,%01011110,0

	   .db      %00000000,%11101110,%00000000,0
	   .db      %00100000,%00000000,%00001000,0
	   .db      %00001000,%00000000,%00100000,0
	   .db      %00001010,%10101010,%10100000,0
	   .db      %00001010,%10101010,%10100000,0
	   .db      %00000010,%10101010,%10000000,0
	   .db      %00000000,%10101010,%00000000,0
	   .db      %00000000,%00000000,%00000000,0

	   .db      %01010101,%01010101,%01010101,0
	   .db      %01010101,%01010101,%01010101,0
	   .db      %00000000,%00000000,%00000000,0
	   .db      %10101010,%10101010,%10101010,0
	   .db      %00000000,%00000000,%00000000,0
	   .db      %11001100,%11001100,%11001100,0
	   .db      %00000000,%00000000,%00000000,0
	   .db      %10101010,%10101010,%10101010,0

	   .db      %01111101,%11111101,%11110011,0
	   .db      %01110101,%11001101,%11011111,0
	   .db      %01111101,%11111101,%11010111,0
	   .db      %01011101,%11011101,%11010111,0
	   .db      %01111101,%11011101,%11010111,0
	   .db      %00000000,%00000000,%00000000,0
	   .db      %00100010,%00100010,%00100010,0
	   .db      %10001000,%10001000,%10001000,0


         .db      %01010101,%10101010,%01000001,0
         .db      %01000001,%10000000,%01000001,0
         .db      %01000001,%10000000,%01000001,0
         .db      %01010101,%10101010,%01010101,0
         .db      %01000001,%00000010,%01000001,0
         .db      %01000001,%00000010,%01000001,0
         .db      %01000001,%10101010,%01000001,0
         .db      %00000000,%00000000,%00000000,0

         .db      %00000000,%01010000,%00000101,0
         .db      %00010100,%01010001,%01000101,0
         .db      %00010100,%00000001,%01000000,0
         .db      %00000000,%01010000,%00000101,0
         .db      %00000000,%01010000,%00000101,0
         .db      %00010100,%00000001,%01000000,0
         .db      %00010100,%01010001,%01000101,0
         .db      %00000000,%01010000,%00000101,0

	   .db      %10001000,%10001000,%10001000,0
	   .db      %10001000,%10001000,%10001000,0
	   .db      %10001000,%10001000,%10001000,0
	   .db      %10001000,%10001000,%10001000,0
	   .db      %10001000,%10001000,%10001000,0
	   .db      %10001000,%10001000,%10001000,0
	   .db      %10001000,%10001000,%10001000,0
	   .db      %10001000,%10001000,%10001000,0

         .db      %00000000,%00000000,%00000000,0
         .db      %01001000,%01001000,%10001000,0
         .db      %10000100,%10000100,%01000100,0
         .db      %01001000,%01001000,%10001000,0
         .db      %10000100,%10000100,%01000100,0
         .db      %01001000,%01001000,%10001000,0
         .db      %10000100,%10000100,%01000100,0
         .db      %11001100,%11001100,%11001100,0

         .db      %00000000,%00000000,%00000000,0
         .db      %00000000,%00000000,%00000000,0
         .db      %00110111,%00110111,%00110110,0
         .db      %00110111,%00110111,%00110110,0
         .db      %00110111,%00110111,%00110110,0
         .db      %00111011,%00111011,%00111010,0
         .db      %00001100,%00001100,%00001100,0
         .db      %00000000,%00000000,%00000000,0

         .db      %00000000,%00000000,%00000000,0
         .db      %10000000,%01010101,%00000010,0
         .db      %00001100,%01010101,%00110000,0
         .db      %00110011,%00000000,%11001100,0
         .db      %00010101,%11000011,%01010100,0
         .db      %00010101,%00111100,%01010100,0
         .db      %00000000,%00000000,%00000000,0
         .db      %00000000,%00000000,%00000000,0

         .db      %01000000,%01000000,%01000001,0
         .db      %00010001,%00010001,%00010001,0
         .db      %00010001,%00010001,%00010001,0
         .db      %00010001,%00010001,%00010001,0
         .db      %00010001,%00010001,%00010001,0
         .db      %00010001,%00010001,%00010001,0
         .db      %00000100,%00000100,%00000100,0
         .db      %00000000,%00000000,%00000000,0

 
         .db      %01010101,%01000100,%00000001,0
         .db      %01000000,%00000100,%00000001,0
         .db      %01000000,%00000100,%00000001,0
         .db      %01010101,%01000101,%01010101,0
         .db      %00000000,%01000100,%00000001,0
         .db      %00000000,%01000100,%00000001,0
         .db      %01010101,%01000100,%00000001,0
         .db      %00000000,%00000000,%00000000,0

         .db      %00000000,%00000000,%00000000,0
         .db      %00010101,%01000101,%00000000,0
         .db      %00010000,%01000100,%01000000,0
         .db      %00010000,%01000100,%00010000,0
         .db      %00010101,%01000100,%00000100,0
         .db      %00010000,%00000100,%00000100,0
         .db      %00010000,%00000100,%00010000,0
         .db      %00010000,%00000101,%01000000,0
 ; ---------------------- BONUS BLOCKS--------------------------------------
bonus_1: .db      11,5
         .db      %10011000,%11000000
         .db      %10100101,%00100000
         .db      %10100101,%00100000
         .db      %10100101,%00100000
         .db      %10011000,%11000000
bonus_2: .db      11,3
         .db      %01000100,%01000000
         .db      %11101110,%11100000
         .db      %01000100,%01000000
bonus_3: .db      12,5
         .db      %00100000,%01000000
         .db      %01000000,%00100000
         .db      %11111111,%11110000
         .db      %01000000,%00100000
         .db      %00100000,%01000000
bonus_4: .db      11,3
         .db      %01111111,%11000000
         .DB      %10000000,%00100000
         .db      %01111111,%11000000
bonus_5: .db      12,2
         .db      %11111111,%11110000
         .db      %11111111,%11110000
bonus_6: .db      12,4
         .db      %10000000,%00010000
         .db      %10000000,%00010000
         .db      %11111111,%11110000
         .db      %10000000,%00010000
bonus_7: .db      12,5
         .db      %00100000,%00000000
         .db      %01000000,%10000000
         .db      %11111111,%11110000
         .db      %01000000,%10000000
         .db      %00100000,%00000000
bonus_8: .db      11,5
         .db      %10001010,%00100000
         .db      %01010001,%01000000
         .db      %00100000,%10000000
         .db      %01010001,%01000000
         .db      %10001010,%00100000
bonus_9:
         .db      10,5
         .db      %11110011,%10000000
         .db      %10000100,%01000000
         .db      %11110100,%01000000
         .db      %00010100,%01000000
         .db      %11110011,%10000000
 ; -------------------- HIGH SCORES-----------------------------------------
hi_score_str:
         .db      "--> ORZUNOID <--"
         .db      "   You got a    "
         .db      "  high score!   "
         .db      "Enter your name:",0
hstitle: .db      "== HIGHSCORES ==",0
hsdata:  .dw      40000
         .db      "ORZUNOID!  ",0
         .dw      30000
         .db      "ORZUNOID!  ",0
         .dw      20000
         .db      "ORZUNOID!  ",0
         .dw      10000
         .db      "ORZUNOID!  ",0
         .dw      7500
         .db      "ORZUNOID!  ",0
         .dw      5000
         .db      "ORZUNOID!  ",0
lowest   .dw      2500
         .db      "ORZUNOID!  ",0
chartable:
         .db      ":WRMH."
         .DB      "..0VQLG!..ZUPKFC"
         .DB      "..YTOJEBX.>SNIDA"
         .DB      ".12345.."
press_enter:
         .db      "Press ENTER to play",0


realbeat        .db      0

lost:
         .db      "Game Over!",0

youwin:
         .db      "    You Win!    "
         .db      "You get a secret"
         .db      "    control!    "
         .db      " Anytime during "
         .db      "play press GRAPH"
         .db      " to skip to the "         
         .db      "   next level!  "
         .db      "     Enjoy!     ",0





DMX:
 ld (CURSOR_X),de
 ROM_CALL(D_ZM_STR)
 ret

DTX2:
 ld de,0
DTX:
 ld (CURSOR_ROW),de
 ROM_CALL(D_ZT_STR)
 ret

_ILine:
 ROM_CALL($2E60-$1A)
 .dw $4025
 .db $04

         .end


