;
;
; PROGRAM: Little Dude 2 trainer
; VERSION: 1.10
; AUTHOR:  David Eriksson <david@2goodsoft.com>
; WEB:     http://www.2goodsoft.com/
; DATE:    05/07/98
;
; Provides cheating by certain key presses.
;
; THIS SOFTWARE IS NOT SUPPORTED BY THE AUTHOR OF LITTLE DUDE 2
;
; The author of LD2, Chris Edwards <cxe162@psu.edu>, has informed me that
; I should tell you this, and he also says that it will NOT work on his 
; next game :)
;
; To find out the right memory locations and to test the trainer during
; development I used CalcEm - The Calculator Emulator.
;		http://www.2goodsoft.com/calcem/
; (In fact, this has not yet been tested on a calculator!)
;
; The interrupt stuff is an almost exact rip of Crash to CrASH v1.3
;
;

.NOLIST
#INCLUDE "crash82.inc"
.LIST

.DB "CalcEm Little Dude 2 Trainer",0

INT_LD2TRAIN	.EQU	0d2h	; I have no registered ID byte :-(((

;
; Main
;
Main:
	call	CR_GRBCopy			; Clear screen

	ld		bc, 0000h			; (0, 0)
	ld		(GRAF_CURS), bc

	SET		3, (IY+05)			; Display inverted
	ld		hl, szInfo1
	ROM_CALL(D_ZM_STR)
	RES		3, (IY+05)			; Display normal

	ld		bc, 0804h			; (4, 8)
	ld		(GRAF_CURS), bc
	ld		hl, szInfo2
	call	DrawStringList

	ld		bc, 1C30h			; (48, 28)
	ld		(GRAF_CURS), bc
	ld		hl, szInfo3
	call	DrawStringList

	ld		bc, 3604h			; (4, 54)
	ld		(GRAF_CURS), bc

	ld		a, (INT_STATE)		; Check out CrASH's interrupt byte
	cp		INT_LD2TRAIN
	jr		z, Remove
	
	or		a
	jr		z, Install
	
	ld		hl, szAnother
	ROM_CALL(D_ZM_STR)

WaitKey:                   ; After this, it will return to CrASH
	jp		CR_KHAND

;
; Install interrupt
;
Install:
	ld		hl, szInstall
	ROM_CALL(D_ZM_STR)
	
	ld		hl, 8400h
	ld		de, 8401h
	ld		(hl), 83h
	ld		bc, 100h
	ldir
	
	ld		hl, IntProcStart
	ld		de, 8383h
	ld		bc, IntProcEnd-IntProcStart+1
	ldir
	
	ld		hl, 15bh
	ld		(APD_FREE), HL
	
	ld		a, 84h
	ld		i, a
	
	im		2
	
	jr		WaitKey

;
; Remove interrupt
;
Remove:
	ld		hl, szRemove
	ROM_CALL(D_ZM_STR)
	
	im		1
	
	ld		hl, 300h
	ld		(APD_FREE), hl
	
	xor		a
	ld		i, a
	ld		(INT_STATE), a
		
	jr		WaitKey

;
; DrawStringList
;
; Draws one string on each row until an empty string is reached
;
; Input: HL = string pointer
;
DrawStringList:
	ld		a, (CURSOR_X)		; Save X
	ld		b, a

dsl_loop:
	ROM_CALL(D_ZM_STR)			; Draw string
	
	ld		a, (CURSOR_Y)		; Advance Y
	add		a, 6
	ld		(CURSOR_Y), a
	
	ld		a, b				; Restore X
	ld		(CURSOR_X), a
	
	ld		a, (hl)				; Check for empty string
	or		a
	jr		nz, dsl_loop
	
	ret


;
; Interrupt proc
;
IntProcStart:
	di
	ex		af, af'
	exx
	
	; Set CrASH's interrupt byte
	ld		a, INT_LD2TRAIN
	ld		(INT_STATE), A
	
	; Check 'location'
	ld		a, (8121h)
	cp		0ffh			; Inside CrASH?
	jr		nz, ExitInt
		
	; Check keyboard
	ld		a, 11111101b
	out		(P_KEYBOARD), a
	in		a, (P_KEYBOARD)
	
	cp		0ffh			; Nothing? (most probable)
	jr		z, ExitInt

	bit		4, a			; Test / key
	jr		z, Ammo

	bit		3, a			; Test * key
	jr		z, Health

	bit		2, a			; Test - key
	jr		z, Lives
	
	bit		1, a			; Test + key
	jr		z, Timer

ExitInt:
	exx
	ex		af, af'
	jp		38h

;
; We will be modifying inside TEXT_MEM so no one gets hurt...
;
; If these values were 255, the counter would wrap if you 
; pick up another item :-)
;

Lives:
	ld		a, 063h
	ld		(80cch), a		; Lives
	jr		ExitInt

Timer:
	ld		a, 255
	ld		(80d8h), a		; Timer
	jr		ExitInt

Health:
	ld		a, 063h
	ld		(80a7h), a		; Health
	jr		ExitInt

Ammo:
	ld		a, 063h
	ld		(80d1h), a		; Shotgun
	ld		(80d2h), a		; Freeze ray
	ld		(80d3h), a		; Rocket launcher
	ld		(80d4h), a		; Grenades
	jr		ExitInt

IntProcEnd:

;
; Static data
;
szInfo1:
.DB		" (c) 2GooD Productions ", 12
.DB		" v 1.10", 0

szInfo2:
.DB		"This software is NOT", 0
.DB		"supported by the author of",0
.DB		"Little Dude 2!",0
.DB		0

szInfo3:
.DB		' ',0c1h,"/]   Ammo",0
.DB		0c1h,"*]  Health",0
.DB		' ',0c1h,"-]   Lives",0
.DB		' ',0c1h,"+]   Timer",0
.DB		0

szInstall:
.DB		"Installing...",0

szRemove:
.DB		"Removing...",0

szAnother:	
.DB		"Unable to install!",0
