;
; Knight Moves v1.2                     by Wouter Demuynck (kadem@unicall.be)
; http://ti82corner.home.ml.org                                  ICQ #4538550
;
; Revisions
;  - v1.0 (February 1998) : First release, 10x10 board, 548 bytes
;  - v1.1 (March 1998) : bug fixed, commented source, 8x8 board, 499 bytes
;  - v1.2 (August 1998) : Chopped off some more bytes, 470 bytes!
;
; Last Update : July 28, 1998

#include "ti82.h"
#include "keys.inc"

.org START_ADDR
MsgKnight
.db "Knight"
_Change_Title:
.db " "
.db "Moves",0 

FIELD   = TEXT_MEM          ; 64 bytes  Board data
YPOS    = TEXT_MEM + 65     ; 1 byte    Y-position of cursor
XPOS    = TEXT_MEM + 66     ; 1 byte    X-position of cursor
HORSIEY = TEXT_MEM + 67     ; 1 byte    Y-position of knight
HORSIEX = TEXT_MEM + 68     ; 1 byte    X-position of knight
SCORE   = TEXT_MEM + 69     ; 1 byte    Score 
string  = TEXT_MEM + 70     ; 5 bytes   (needed for DM_HL_DECI)

 ;game set up
 ld hl,TEXT_MEM
 inc (hl)                   ; set first byte of board data to 1 (used)

JustBeforeKeyLoop:
 call DrawField             ; draw the board
KeyLoop:
 call GET_KEY               ; get key scancode
 cp G_MODE                  ; [mode] pressed ?
 ret z                      ;   -> Exit
 cp G_CLEAR                 ; [clear] pressed ?
 ret z                      ;   -> Exit
 ld hl,(YPOS)               ; H=XPOS \ L=YPOS (for later use)
 cp G_ENTER                 ; [enter] pressed ?
 jr z,EnterPressed          ;   -> Check if OK to move knight
 cp G_2nd                   ; [2nd] pressed ?              
 jr z,EnterPressed          ;   -> Check if OK to move knight
 sub G_DOWN                 ; [DOWN] pressed ?
 jr z,MoveDown              ;   -> Move cursor down
 dec a                      ; [LEFT] pressed ?
 jr z,MoveLeft              ;   -> Move cursor to the left
 dec a                      ; [RIGHT] pressed ?
 jr z,MoveRight             ;   -> Move cursor to the right
 dec a                      ; [UP] not pressed ?
 jr nz,KeyLoop              ;   -> Keep waiting for a keypress

MoveUp:
 dec l                      ; decrease YPOS (cursor)
 jp p,Move                  ; as long as l is positive it's OK 
MoveDown:
 inc l                      ; increase YPOS (cursor)
 ld a,8     
 cp l
 jr nz,Move                 ; as long as it's not 8, it's OK
 jr MoveUp                  ; if not OK, move it up again
MoveLeft:
 dec h                      ; decrease XPOS (cursor)
 jp p,Move                  ; positive? -> OK
MoveRight:
 inc h                      ; increase XPOS (cursor)
 ld a,8                     
 cp h
 jr z,MoveLeft              ; lower than or equal to 8 -> OK
Move:
 ld (YPOS),hl               ; change cursorcoords
 jr JustBeforeKeyLoop       ; return

EnterPressed:
 ld de,(YPOS)
 ld l,d \ ld h,e
 call Eight_l_Plus_h
 ld b,a                       ; B contains 8*POSX+ POSY
 ld de,(HORSIEY)
 ld l,d \ ld h,e
 call Check_SaveSpace
 jr nz,KeyLoop
 ld hl,(YPOS)
 call Eight_l_Plus_h
 ld b,a                       ; B contains 8*POSY + POSX
   ld h,0                     ; check if horsie has been on that spot
   ld l,b
   ld de,FIELD                ; already, and if so, go back to
   add hl,de                  ; the keyloop
   ld a,1
   cp (hl)
 jr z,KeyLoop
 ld hl,(HORSIEY)
 call Check_SaveSpace
 jr nz,KeyLoop
MoveThePiece:
 ld de,FIELD
 ld h,0                       ; hl = offset of the cursor on the field
 add hl,de                    ; calculate absolute offset
 inc (hl)                     ; set that info to 1 (used)
 ld hl,(YPOS)
 ld (HORSIEY),hl              ; change coords of knight
 ld hl,SCORE
 inc (hl)                     ; update score
 jp JustBeforeKeyLoop         ; return


; zero set if OK to move, else nz
Check_SaveSpace:
 call Eight_l_Plus_h          ; A contains 8*HORSIEY + HORSIEX
 cp b                    
 ld l,b                       ; L is used later in the routine
 jr nc,DontSwap              ; if a < b then swap a and b
 ld b,a
 ld a,l                       ; swap a and b
 \DontSwap:
 sub b                        ; substract b from a
 cp 10   
 ret z    ; jr z,MoveThePiece
 cp 6 
 ret z    ; jr z,MoveThePiece
 cp 17
 ret z    ; jr z,MoveThePiece  
 cp 15
 ret      ; jp nz,KeyLoop


; routine : Eight_l_Plus_h
; purpose : Calculates 8l + h and gives answer in A
; input   : hl
; output  : a = 8l + h
Eight_l_Plus_h:
 ld a,l                               ; a = l
 add a,a                              ; a = 2l
 add a,a                              ; a = 4l
 add a,a                              ; a = 8l
 add a,h                              ; a = 8l + h
 ret

DrawField:
 ld hl,FIELD                          ; hl points to the current location
 ld de,0                              ; d=0=xpos ; e=0=ypos
 ld a,1                               ; a=1(black) or 2(white)
 ld b,8                               ; loop 8 times
 \Drawfield_Loop1:
   push bc \ push af                  ; save regs (A)
   ld b,8                             ; loop 8 times
   \Drawfield_Loop2:
     push bc \ push af \ push hl      ; save regs (B)
     ld b,a                           ; b = 1 or 2
     ld a,(hl)
     cp 1                             ; if current location not occupied
     jr nz,Normal                     ; use normal treatment
     ld hl,Sprite_Used                ; else, use the sprite for used spot
     jr OK
     \Normal:
     ld hl,Sprite_1-8                 ; hl will be added 1 or 2 times with 8
     \Drawfield_Loop3:                ; to make hl point to the right sprite
       push de                        ; (black or white)
       ld de,8           
       add hl,de
       pop de
       djnz Drawfield_Loop3
     \OK:
     push de                          ; save DE
     ld b,d \ ld c,e                  ; b,c contain screen coords for sprite
     call WSprite                     ; draw the sprite to GRAPH_MEM
     pop de                           ; restore DE
     ld a,d \ add a,8 \ ld d,a        ; add d with 8 (screen coords)
     pop hl \ pop af \ pop bc         ; restore regs (B)
     inc hl                           ; go on to next location in mem
     xor %00000011                    ; change a from 1 to 2 or from 2 to 1  
     djnz Drawfield_Loop2
   ld a,e \ add a,8 \ ld e,a          ; add e with 8 (screen coords)
   ld d,0                             ; put d back to 0 (screen coords)
   pop af \ pop bc                    ; restore regs (A)
   xor %00000011                      ; change a from 2 -> 1 or vice versa
   djnz Drawfield_Loop1

 call ChangeIt                        ; b is zero after djnz...

 ld hl,(HORSIEY)                      ; draw the horse sprite
 call GetCoords                       ; get screen coords
 ld hl,Sprite_Horsie                  ; point to sprite
 call WSprite                         ; display it to GRAPH_MEM
  
 ld hl,(YPOS)                         ; draw the cursor sprite
 call GetCoords
 ld hl,Sprite_Cursor
 call WSprite

 set 7,(IY+$14)                       ; make text go ONLY to GRAPH_MEM
 ld hl,5*256+70                       ; hl contain coords
 ld (CURSOR_X),hl                     ; write coords to mem
 ld hl,MsgKnight                      ; load address to string
 call D_ZM_STR_Shortcut               ; display string "Knight"
 ld de,15*256+70                      ; 'DE' is used so HL gets saved 
 ld (CURSOR_X),de                     ; (hl already points to new string)
 call D_ZM_STR_Shortcut               ; display string "Moves"
 ld de,25*256+70
 ld (CURSOR_X),de
 ld hl,MsgScore
 call D_ZM_STR_Shortcut               ; display string "Score"
 res 7,(IY+$14)                       ; write ONLY to screen
 
 ROM_CALL(DISP_GRAPH)                 ; show what's in the GRAPH_MEM

 ld de,35*256+70
 ld (CURSOR_X),de
 ld hl,(SCORE)                        ; upper hl byte will contain score
 
; CALL DM_HL_DECI                      ; display score (directly to screen)

;routine : DM_HL_DECI
;purpose :  same as D_HL_DECI, but in menu text style
;author  : Jimmy Mardell ? I don't really know
DM_HL_DECI:
        ld de,string+5                ;start at the end
        xor a                         ;ld a, 0
        ld (de),a                     ;zero terminated string
Repeat:
        call UNPACK_HL                ;unpack one digit of hl to a
        add a,'0'                     ;add it with ASCII char 0
        dec de                        ;previous byte
        ld (de),a                     ;load the char
        ld a,h                        ;is hl 0?
        or l                          ;|
        jr nz,Repeat                  ;loop
        ex de,hl                      ;exchange so hl points to string
        call D_ZM_STR_Shortcut

 ld b,$20                             ; $20 equals a space
ChangeIt:
 ld hl,_Change_Title
 ld (hl),b
 ret                                   ; return


;
; calls
;

; sprite routine for knight moves by Wouter Demuynck
WSprite:
 push hl                          
 ld hl,GRAPH_MEM                  
 ld de,0                                  
 ld e,b                                   
 srl e  ; /2
 srl e  ; /4
 srl e  ; /8                               
 add hl,de
 ld de,12
 ld b,c
 xor a
 or c
 jr z,WSprite_EndLoop
 \WSprite_CalcAddr:
 add hl,de
 djnz WSprite_CalcAddr
 \WSprite_EndLoop:
 ld b,8
 \WSprite_Loop:
 pop de
 ld a,(DE)
 ld (HL),a
 inc DE
 push de
 ld de,12
 add hl,de
 djnz WSprite_Loop
 pop hl               
 ret

D_ZM_STR_Shortcut:        
 ROM_CALL(D_ZM_STR)            ;display string
 ret                           ;return to caller

GetCoords:
 add hl,hl                            ; h * 2 ; l * 2
 add hl,hl                            ; h * 4 ; l * 4
 add hl,hl                            ; h * 8 ; l * 8
 ld b,h \ ld c,l                      ; ld bc,hl
 ret

;
; DATA (Sprites and Strings)
;

;MsgKnight:
;.db "Knight",0 
;MsgMoves:
;.db "Moves",0
MsgScore:
.db "Score"
Sprite_Horsie:
.db %00000000  ; Msgscore goes to here (1b saved)
.db %00110000
.db %01111000
.db %00011000
.db %00011000
.db %00111100
.db %01111110
.db %00000000
Sprite_Cursor:
.db %11111111  
.db %10000001
.db %10111101
.db %10100101
.db %10100101
.db %10111101
.db %10000001
Sprite_1:
.db %11111111 ; sprite_cursor goes to here...   (1 byte saved)
.db %11111111
.db %11111111
.db %11111111
.db %11111111
.db %11111111
.db %11111111
.db %11111111
Sprite_2:
.db 0,0,0,0,0,0,0,0
Sprite_Used:
.db %01010101
.db %10101010
.db %01010101
.db %10101010
.db %01010101
.db %10101010
.db %01010101
.db %10101010

.end

