; last modif 07/02/98 06:41pm EST

#include "crash82.inc"

ballx = TEXT_MEM
bally = TEXT_MEM+1
blockcnt = TEXT_MEM+2
score = TEXT_MEM+3
tmpx = TEXT_MEM+5		; used in movelt/rt
data = TEXT_MEM+6		; for converting SOS stuff
string = TEXT_MEM+8

.db "FallDown 1.1",0
;-------------------------------------------
main:
  sbc	hl,hl	
  ld (score),hl

  ; Title Screen ;
  call CR_GRBCopy
  set 3,(iy+$05)
  ld de,2
  ld hl,name
  call DispText
  res 3,(iy+$05)
  ld de,30*256+4
  ld hl,AuthorStr
  call vDispText
  ld de,37*256+7
  ld hl,AuthorWeb
  call vDispText
  ld de,57*256+0
  ld hl,HighScr
  call vDispText
  ld de,57*256+60
  ld hl,(HighS)
  call SdispHL
  call CR_KHAND	
  ;-------------
  call _clrbuf
  ld hl, ballx
  ld (hl), 44
  inc hl
  ld (hl), 0

Initialize:
  call RandomBlocks
  ld hl, (score)
  add hl, hl			; hl=score*2
  ld a, 24
  sub h				; a=0 if sc<128, 1 if 128<=sc<256, ...
  ld b, a
  
ScrollDLoop:

  push bc		; 11 c, 1 b

  call Scroll_U

  call check_coll		; check collisions & gravity stuff
  call put_ball			; put ball (xor)

  call CR_GRBCopy
  call put_ball			; remove ball (xor)

  HALT				; one halt, try to go always at same speed

Continue:

	ld	a,$BF
	out	($01),a
	in	a,($01)
	cp	191
	jr	nz,nopause

pause:	call    CR_KHAND

nopause:
; check clear :
  ld a, $fd		; clear row
  out (1), a
  in a, (1)
  and $40
  
  pop bc		; 10 c, 1 b

  jp z, show_sc

  ld a, $fe
  out (1), a
  in a, (1)

  bit 1,a
  jr z, moveleft

  bit 2,a
  jr z, moveright 

donemv:
;  ld a, (blockcnt)	; 7 c, 3 b
;  ld b, a		; 4 c, 1 b

  djnz ScrollDLoop
  jr  Initialize

moveleft:
 ld a, (ballx)
 sub 2
 jr c, donemv			; exit if we're already at left side
 ld (tmpx), a
 jr x_check

moveright:
 ld hl, ballx
 ld a, (hl)
 add a,2
 cp 96-4
 jr nc, donemv			; exit if we're already at right side
 ld (tmpx), a
 add a, 5			; we check right side
x_check:
 push af
 ld a, (bally)
 ld e, a
 pop af
 call getphysaddr
 ld a, (hl)
 or a
 jr nz, donemv			; don't move if there is something in the way
 ld de, 5*12
 add hl, de			; same stuff if there's something a bit lower
 ld a, (hl)
 or a
 jr nz, donemv
 ld a, (tmpx)
 ld (ballx), a			; else move the ball
 jr donemv

RandomBlocks:
  ld b, 12		; 12 blocks max to put
  ld hl, $88b8+(60*12)	; where to put blocks

rb_loop:
  push bc
  push hl
  ld b, 5
  call vector1		; one luck on 5 to have a hole
  pop hl
  or a			; put a space ?
  jr z, rb_djnz		; yeah, so skip it
; else put the brick
  ld ix, block
  ld de, 12
  ld b, 4		; 4 lines to put
  push hl
rb_putloop:
  ld a, (ix+0)
  ld (hl), a
  inc ix
  add hl, de
  djnz rb_putloop
  pop hl
rb_djnz:
  inc hl  
  pop bc
  djnz rb_loop
; now, check there is at least one hole
;;  ld hl, $88b8+(60*12) ; not needed : works as well with second row
  ld b, 12
  xor a			; c used as number of bricks counter
rb_cloop:		; check loop
  ld c,(hl)
  rrc c
  adc a, 0
  djnz rb_cloop
  cp 12			; if less than 12 brick ( so at least one hole)
  ret c			; then exit
  ld b, a		; a was 12 if we didn't exit
  call vector1		; put a hole somewhere
  ld hl, $88b8+(60*12)
  ld d, 0
  ld e, a
  add hl, de		; find where to put the hole
  ld b, 4		; 4 rows to clear
  ld e, 12		; d = 0
rb_cl_loop:		; clear loop
  ld (hl), d		; d = 0
  add hl, de		; next row
  djnz rb_cl_loop
  ret


Scroll_U:                   ; [?16228? Clock Cycles]
  LD  HL, $88b8+12          ; Copy from one row below top
  LD  DE, $88b8             ;   to top row
  LD  BC, 756               ;   756 bytes
  LDIR
  LD  H, D                  ; Fill Blanks
  LD  L, E
  INC E
  LD  (HL), B
  LD  C, 11
  LDIR
  RET


check_coll:
; gravity and collision stuff :
 ld a, (bally)
 add a, 6
 ld e,a
 ld a, (ballx)
 call getphysaddr		; check left
 ld a, (hl)
 or a				; can move down ?
 jr nz, cc_downno		; no ==> move it up

 ld a, (ballx)
 and 7
 cp 3				; if < 3, then same block lt&rt
 jr c, cc_movedn		; so skip this check
 inc hl				; check right
 ld a, (hl)
 dec hl
 or a				; can move down ?
 jr nz, cc_downno		; no ==> move it up

cc_movedn:
 ld hl,(score)			; increase the score
 inc hl
 ld (score),hl

 ld hl, bally			; move the ball down 
 inc (hl)
 ld a, (hl)
 cp 60-5			; is it too far down ?
 ret c				; no : ok
 dec (hl)			; else stay where it was
 ret

cc_downno:			; if the ball can't move down
; a short check to see it it must really go up, or if it can stay where it is
 ld de, -12
 add hl, de			; go one line upper
 ld a, (hl)			; check left
 or a				; something down ?
 jr nz, cc_mvup			; yeah ==> move up

 ld a, (ballx)
 and 7
 cp 3				; if < 3, then same block lt&rt
 ret c				; so skip this check
 inc hl				; check right
 ld a, (hl)
 ret z

cc_mvup:
 ld hl, bally
 dec (hl)
 ld a, (hl)
 and $80			; check if y<0
 ret z				; if ball is out of the screen, you've loose

loose:
 ld hl, loostxt
 pop de				; don't return to the main loop
 pop de				; bc has been pushed in the main loop
 ld de, $0202
 call DispText
show_sc:
 ld de, $0003
 ld hl,scoretxt
 call DispText
 ld hl,(score)
 ROM_CALL(D_HL_DECI)
 call GET_KEY			; flush keypress buffer

CheckHigh:
 ld de,(HighS)
 ld hl,(score)
 call scorechk
 or a
 jp nz,EndLoop
 ld (HighS),hl
 ld hl,4
 ld (CURSOR_POS),hl
 ld hl,NHSMsg
 ROM_CALL(D_ZT_STR)
EndLoop:
 call GET_KEY
 or a
 jr z,EndLoop
 cp G_RIGHT				; wait 4 a key except arrows
 jr z,EndLoop
 cp G_LEFT
 jr z,EndLoop
 ret

getphysaddr:		; get physic address from x/y
; input : e=y, a=x
; output : hl = addr
 ld hl,0			; Do y*12
 ld d,h
 add hl,de
 add hl,de
 add hl,de
 add hl,hl
 add hl,hl

 ld e,a				; do x/8
 srl e
 srl e
 srl e
 add hl,de			; d was already 0
 ld de, $88b8
 add hl, de

 ret
 

vDispText:
  ld (CURSOR_X),de
  ROM_CALL(D_ZM_STR)
  ret

DispText:
 ld ($800c), de
 ROM_CALL(D_ZT_STR)
 ret

SdispHL:
 ld (CURSOR_X),de

_disphl:
        push de
        push hl
        ld de,string+5
        xor a
        ld (de),a
Repeat:
        call UNPACK_HL
        add a,'0'
        dec de
        ld (de),a
        ld a,h
        or l
        jr nz,Repeat
        ex de,hl
        ROM_CALL(D_ZM_STR)
        pop hl
        pop de
        ret


_clrbuf:
        ld hl,$88B8
        ld de,$88B9
        ld bc,$2FF
        ld (hl),0
        ldir
        ret

put_ball:
 ld a, (bally)
 ld l, a
 ld a, (ballx)
 ld ix, ballspr
 ld	b,8
 jp	vector0
	

name: 		.db $f1," "
ttl:		.db "FallDown 1.1 ",$f1,0
loostxt:        .db "* Game Over *",0
HighScr:	.db "High "
scoretxt:	.db "Score: ",0
AuthorStr:	.db "By Ahmed E. and Florent Dh.",0
AuthorWeb:	.db "Idea: Thomas FERNIQUE ",0
NHSMsg:		.db "New High Score!",0
HighS:		.dw 0

block:
	.db %11111111
	.db %10000001
	.db %10111111
	.db %11111111

ballspr:
 .db %01111000
 .db %10110100
 .db %11001100
 .db %11001100
 .db %10110100
 .db %01111000
 .db %00000000
 .db %00000000


;---------= High Score =---------
; Input: de=previous high score
;	hl=current score
; Output: hl=high score
;	z=1 (a=0) if new high score, z=0 (a=1) if not
; Registers destroyed: af, de, hl
scorechk:
	push	hl
	xor	a
	sbc	hl,de
	pop	hl
	jr	z,nnhs
	jr	nc,nhs
nnhs:	ex	de,hl
	inc	a
nhs:	or	a
	ret

;---------= Random number generator =---------
; input b=upper bound
; ouput a=answer 0<=a<b
; all registers are preserved except: af and bc
; Method: modified R250/register r
vector1:
	push	hl
	push	de
	ld	hl,(data)
	ld	a,r
	rra
	ld	h,a
	ld	a,(hl)
	xor	l
	ld	(data),a
	sbc	hl,hl
	ld	e,a
	ld	d,h
randl:	add	hl,de
	djnz	randl
	ld	a,h
	pop	de
	pop	hl
nomore:	ret


;---------= XOR a sprite =---------
; b=size of sprite
; l=yc
; a=xc
; ix holds pointer
vector0:
	ld	e,l
	ld	h,$00
	ld	d,h
	add	hl,de
	add	hl,de
	add	hl,hl
	add	hl,hl
	ld	e,a
	and	$07
	ld	c,a
	srl	e
	srl	e
	srl	e
	add	hl,de
	ld	de,$88b8
	add	hl,de
sl1:	ld	d,(ix)
	ld	e,$00
	ld	a,c
	or	a
	jr	z,sl3
sl2:	srl	d
	rr	e
	dec	a
	jr	nz,sl2
sl3:	ld	a,(hl)
	xor	d
	ld	(hl),a
	inc	hl
	ld	a,(hl)
	xor	e
	ld	(hl),a
	ld	de,$0B
	add	hl,de
	inc	ix
	djnz	sl1
	ret

.end
END