;------------------------------
;|The Chase 0.9
;|By: Ahmed El-Helw
;|ahmedre@worldnet.att.net
;|Completed on: Feb 23, 1998
;|Last Edited: Feb 25, 1998
;|http://asm8x.home.ml.org
;-------------------------------

#INCLUDE "ti82.h"
#INCLUDE "keys.inc"

.org START_ADDR
.DB "The Chase 0.9!!", 0      

Init:
	ROM_CALL(CLEARLCD)
	ld hl,0
	ld (CURSOR_POS),hl
	ld hl,TitleText
	ROM_CALL(D_ZT_STR)
	
Loop:
	call GET_KEY
	cp G_1
	jp z,Chaser
	cp G_2
	jp z,Chased
	cp G_CLEAR
	ret z
	jr nz,Loop	

Chased:
	ROM_CALL(CLEARLCD)
	ld a,175
	ld (Timer),a
	ld (TimerX),a
	ld a,8
	ld (BallX),a
	ld (BallY),a
	ld a,50
	ld (BoxY),a
	ld (BoxX),a
	call DispBall
	call DispBox

ChasedLoop:
	jp DecTimer

ChasedLLoop:
	ld 	a,0ffh		;Reset keyport
	out 	(1),a			;Clear Port
	ld 	a,0feh		;Load desired port
	out   (1),a			;Clear Keys
	in 	a,(1)			;Input Key
	cp	251			;If key is right
	jp 	z,M_Right		;Goto Right
	cp 	253			;If key is left
	jp 	z,M_Left		;Goto Left
	cp	247			;Is it key Up
	jp	z,M_Up		;Move Up
	cp	254			;Is it Down
	jp	z,M_Down		;Move Down	
	ld 	a,0ffh		;Reset keyport
	out 	(1),a			;Clear Port
	ld 	a,0bfh		;Load desired port
	out   (1),a			;Clear Keys
	in 	a,(1)			;Input Key
	cp	127			;Is it delete
	call	z,GamePause		;Pause
	cp	191			;Is it Quit?
	ret   z			;Return from Program if so
	jr	nz,NoKey		;NoKey Otherwise

GamePause:
	call GET_KEY
	cp $00
	ret nz
	jr GamePause

NoKey:
	jp BoxMove

M_Right:
	ld a,(BallX)
	cp 88
	jp z,NoKey
	call DispBall
	ld a,(BallX)
	add a,4
	ld (BallX),a
	call DispBall
	ld (Ticks),a
	jp NoKey

M_Left:
	ld a,(BallX)
	or a
	jp m,NoKey
	jp z,NoKey
	call DispBall
	ld a,(BallX)
	sub 4
	ld (BallX),a
	call DispBall
	ld a,1
	ld (Ticks),a
	jp NoKey

M_Up:
	ld a,(BallY)
	or a
	jp m,NoKey
	jp z,NoKey
	call DispBall
	ld a,(BallY)
	sub 4
	ld (BallY),a
	call DispBall
	ld a,1
	ld (Ticks),a
	jp NoKey

M_Down:
	ld a,(BallY)
	cp 56
	jp z,NoKey
	call DispBall
	ld a,(BallY)
	add a,4
	ld (BallY),a
	call DispBall
	ld a,1
	ld (Ticks),a
	jp NoKey

BoxMove:
	ld a,4
	call Random
	cp 1
	jp z,MoveXCoord
	cp 2
	jp z,MoveXCoord
	jp nz,MoveYCoord

MoveXCoord:
	ld a,(BallX)	
	ld b,a
	ld a,(BoxX)
	sub b
	or a
	jp m,IncXCoord
	jp z,FinishBoxMove
	jp DecXCoord

IncXCoord:
	ld a,4
	call Random
	cp 1
	jp z,IncX1
	cp 2
	jp z,IncX1
	jp nz,IncX2

DecXCoord:
	ld a,4
	call Random
	cp 1
	jp z,DecX1
	cp 2
	jp z,DecX1
	jp nz,DecX2

DecX1:
	call DispBox
	ld a,(BoxX)
	dec a
	ld (BoxX),a
	call DispBox
	jp FinishBoxMove

DecX2:
	call DispBox
	ld a,(BoxX)
	dec a
	dec a
	ld (BoxX),a
	call DispBox
	jp FinishBoxMove

IncX1:
	call DispBox
	ld a,(BoxX)
	inc a
	ld (BoxX),a
	call DispBox
	jp FinishBoxMove

IncX2:
	call DispBox
	ld a,(BoxX)
	inc a
	inc a
	ld (BoxX),a
	call DispBox
	jp FinishBoxMove


MoveYCoord:
	ld a,(BallY)	
	ld b,a
	ld a,(BoxY)
	sub b
	or a
	jp m,IncYCoord
	jp z,FinishBoxMove
	jp DecYCoord

IncYCoord:
	ld a,4
	call Random
	cp 1
	jp z,IncY1
	cp 2
	jp z,IncY1
	jp nz,IncY2

DecYCoord:
	ld a,4
	call Random
	cp 1
	jp z,DecY1
	cp 2
	jp z,DecY1
	jp nz,DecY2

DecY1:
	call DispBox
	ld a,(BoxY)
	dec a
	ld (BoxY),a
	call DispBox
	jp FinishBoxMove

DecY2:
	call DispBox
	ld a,(BoxY)
	dec a
	dec a
	ld (BoxY),a
	call DispBox
	jp FinishBoxMove

IncY1:
	call DispBox
	ld a,(BoxY)
	inc a
	ld (BoxY),a
	call DispBox
	jp FinishBoxMove

IncY2:
	call DispBox
	ld a,(BoxY)
	inc a
	inc a
	ld (BoxY),a
	call DispBox
	jp FinishBoxMove

FinishBoxMove:
	ld a,90
	ld (Ticks),a
	ld a,(BallX)
	ld b,a
	ld a,(BoxX)
	sub b
	jp z,CheckBoxY
	jp nz,ChasedLoop

CheckBoxY:
	ld a,(BallY)
	ld b,a
	ld a,(BoxY)
	sub b
	jp nz,ChasedLoop
	jp YouChasedLose

DecTimer:
	ld a,(Timer)
	dec a
	ld (Timer),a
	or a
	jp z,DecTimerX
	jp nz,ChasedLLoop

DecTimerX:
	ld a,(TimerX)
	dec a
	ld (TimerX),a
	or a
	jp z,GameWinner
	ld a,175
	ld (Timer),a
	jp nz,ChasedLoop

YouChasedLose:
	jp GameOverText



;------------------------
;|Begin the Chaser Part
;------------------------

Chaser:
	ROM_CALL(CLEARLCD)
	ld a,250
	ld (Timer),a
	ld a,250
	ld (TimerX),a
	ld a,8
	ld (BallX),a
	ld (BallY),a
	ld a,50
	ld (BoxY),a
	ld (BoxX),a
	ld a,50
	ld (Ticks),a
	call DispBall
	call DispBox

ChaserLoop:
	jp DecTimerY

ChaserLLoop:
	ld 	a,0ffh		;Reset keyport
	out 	(1),a			;Clear Port
	ld 	a,0feh		;Load desired port
	out   (1),a			;Clear Keys
	in 	a,(1)			;Input Key
	cp	251			;If key is right
	jp 	z,M_BoxRight	;Goto Right
	cp 	253			;If key is left
	jp 	z,M_BoxLeft		;Goto Left
	cp	247			;Is it key Up
	jp	z,M_BoxUp		;Move Up
	cp	254			;Is it Down
	jp	z,M_BoxDown		;Move Down	
	ld 	a,0ffh		;Reset keyport
	out 	(1),a			;Clear Port
	ld 	a,0bfh		;Load desired port
	out   (1),a			;Clear Keys
	in 	a,(1)			;Input Key
	cp	127			;Is it delete
	call	z,GamePause		;Pause
	cp	191			;Is it Quit?
	ret   z			;Return from Program if so
	jr	nz,NoChaserKey	;NoKey Otherwise

NoChaserKey:
	ld a,(Ticks)
	dec a
	ld (Ticks),a
	or a
	jp z,BallMove
	jp nz,ChaserLoop
	jp ChaserLoop

M_BoxRight:
	ld a,(BoxX)
	cp 88
	jp z,NoChaserKey
	cp 89
	jp z,NoChaserKey
	cp 90
	jp z,NoChaserKey
	cp 91
	jp z,NoChaserKey
	cp 92
	jp z,NoChaserKey
	call DispBox
	ld a,(BoxX)
	add a,4
	ld (BoxX),a
	call DispBox
	ld a,1
	ld (Ticks),a
	jp NoChaserKey

M_BoxLeft:
	ld a,(BoxX)
	or a
	jp z,NoChaserKey
	cp 1
	jp z,NoChaserKey
	cp 2
	jp z,NoChaserKey
	cp 3
	jp z,NoChaserKey
	cp 4
	jp z,NoChaserKey
	call DispBox
	ld a,(BoxX)
	sub 4
	ld (BoxX),a
	call DispBox
	ld a,1
	ld (Ticks),a
	jp NoChaserKey

M_BoxUp:
	ld a,(BoxY)
	or a
	jp z,NoChaserKey
	cp 1
	jp z,NoChaserKey
	cp 2
	jp z,NoChaserKey
	cp 3
	jp z,NoChaserKey
	cp 4
	jp z,NoChaserKey
	cp 5
	jp z,NoChaserKey
	call DispBox
	ld a,(BoxY)
	sub 4
	ld (BoxY),a
	call DispBox
	ld a,1
	ld (Ticks),a
	jp NoChaserKey

M_BoxDown:
	ld a,(BoxY)
	cp 56
	jp z,NoChaserKey
	cp 55
	jp z,NoChaserKey
	cp 54
	jp z,NoChaserKey
	cp 53
	jp z,NoChaserKey
	cp 52
	jp z,NoChaserKey
	call DispBox
	ld a,(BoxY)
	add a,4
	ld (BoxY),a
	call DispBox
	ld a,1
	ld (Ticks),a
	jp NoChaserKey

BallMove:
	ld a,(BallX)
	ld b,a
	ld a,(BoxX)
	sub b
	or a
	jp m,ReverseX
	ld (TempVar),a
	
CheckBallY:
	ld a,(BallY)
	ld b,a
	ld a,(BoxY)
	sub b
	or a
	jp m,ReverseY
	ld (TempVar1),a
	jr CompareDist

ReverseX:
	ld a,(BoxX)
	ld b,a
	ld a,(BallX)
	sub b
	ld (TempVar),a
	jr CheckBallY

ReverseY:
	ld a,(BoxY)
	ld b,a
	ld a,(BallY)
	sub b
	ld (TempVar1),a
	

CompareDist:
	ld a,(TempVar)
	ld b,a
	ld a,(TempVar1)
	sub b
	or a
	jp m,MoveBallY

MoveBallX:
	ld a,(BallX)
	or a
	jp z,IncreaseBallX
	cp 1
	jp z,IncreaseBallX
	cp 2
	jp z,IncreaseBallX
	cp 3
	jp z,IncreaseBallX
	cp 88
	jp z,DecreaseBallX
	cp 89
	jp z,DecreaseBallX
	cp 90
	jp z,DecreaseBallX
	cp 91
	jp z,DecreaseBallX
	cp 92
	jp z,DecreaseBallX
	cp 93
	jp z,DecreaseBallX
	ld a,(BallX)
	ld b,a
	ld a,(BoxX)
	sub b
	or a
	jp m,IncreaseBallX

DecreaseBallX:	
	call DispBall
	ld a,5
	call Random
	inc a
	ld b,a

DecLoopX:
	ld a,(BallX)
	dec a
	ld (BallX),a
	djnz DecLoopX
	call DispBall
	jp DoneWithBall

IncreaseBallX:
	call DispBall
	ld a,5
	call Random
	inc a
	ld b,a

IncLoopX:
	ld a,(BallX)
	inc a
	ld (BallX),a
	djnz IncLoopX
	call DispBall
	jp DoneWithBall

MoveBallY:
	ld a,(BallY)
	cp 4
	jp z,IncreaseBallY
	cp 3
	jp z,IncreaseBallY
	cp 2
	jp z,IncreaseBallY
	cp 1
	jp z,IncreaseBallY
	or a
	jp z,IncreaseBallY
	cp 4
	jp z,IncreaseBallY
	cp 5
	jp z,IncreaseBallY
	cp 51
	jp z,DecreaseBallY
	cp 52
	jp z,DecreaseBallY
	cp 53
	jp z,DecreaseBallY
	cp 54
	jp z,DecreaseBallY
	cp 55
	jp z,DecreaseBallY
	cp 56
	jp z,DecreaseBallY

	ld a,(BallY)
	ld b,a
	ld a,(BoxY)
	sub b
	or a
	jp m,IncreaseBallY

DecreaseBallY:
	call DispBall	
	ld a,5
	call Random
	inc a
	ld b,a

DecLoopY:
	ld a,(BallY)
	dec a
	ld (BallY),a
	djnz DecLoopY
	call DispBall
	jp DoneWithBall


IncreaseBallY:
	call DispBall
	ld a,5
	call Random
	inc a
	ld b,a

IncLoopY:
	ld a,(BallY)
	inc a
	ld (BallY),a
	djnz IncLoopY
	call DispBall
	jp DoneWithBall

DoneWithBall:
CheckWinner:
	ld a,(BallX)			
	add a,12			
	ld b,a			
	ld a,(BoxX)		
	cp b				
	jp c,ContinueCheck		
      jp ChaserLoop                 
       
ContinueCheck:
	ld a,(BoxX)			
	add a,12			
	ld b,a			
	ld a,(BallX)			
	cp b				
	jp c,CheckYHit		
	jp ChaserLoop

CheckYHit:
	ld a,(BallY)			
	add a,12			
	ld b,a			
	ld a,(BoxY)		
	cp b				
	jp c,ContinueCheckY	
      jp ChaserLoop              
       
ContinueCheckY:
	ld a,(BoxY)		
	add a,12			
	ld b,a			
	ld a,(BallY)			
	cp b				
	jp c,GameWinner			
	jp ChaserLoop

GameWinner:
	jp GameWinnerText
		
DecTimerY:
	ld a,(Timer)
	dec a
	ld (Timer),a
	or a
	jp z,DecTimerY1
	jp ChaserLLoop

DecTimerY1:
	ld a,(TimerX)
	dec a
	ld (TimerX),a
	or a
	jp z,ChaserLost
	ld a,175
	ld (Timer),a
	jp ChaserLLoop	

ChaserLost:
	jp GameOverText


;---------------------------
;|General Routines for Game
;---------------------------

DispBox:
	ld a,(BoxY)
	ld e,a
	ld a,(BoxX)
	ld bc,Box
	call PutSprite
	ret

DispBall:
	ld a,(BallY)
	ld e,a
	ld a,(BallX)
	ld bc,Ball
	call PutSprite
	ret

SetText:
	ld (CURSOR_Y),a
	ld a,4
	ld (CURSOR_X),a
	ret

GameWinnerText:
	ROM_CALL(CLEARLCD)
	ld b,5
	ld hl,GameWinnerT
	call WriteNextRow
	call WaitKey
	call WaitKey	
	ret

GameOverText:
	ROM_CALL(CLEARLCD)
	ld b,4
	ld hl,GameOver
	call WriteNextRow
	call WaitKey
	call WaitKey	
	ret

WaitKey:
	call GET_KEY
	cp $00
	jr z,WaitKey
	ret

WriteNextRow:
 push hl
 call LD_HL_MHL
 ld (CURSOR_X),hl
 pop hl
 inc hl
 inc hl
 ROM_CALL(D_ZM_STR)
 djnz WriteNextRow
 ret

Random:			
   ld b,a
   ld a,r
   add a,a
   ld hl,0
   ld d,0
   ld e,a
RMul:
   add hl,de
   djnz RMul
   ld a,h
   ret

;Ŀ
; Z80 ۳    Sprite83    ۳ movax ۳
;

; Sprite xor routine v1.0
; Coded by Hannes Edfeldt in 1997

; This routine uses xor to draw the sprite, therefore you can erase the sprite
; by just drawing it again at the same x and y coordinates. See xordemo.z80
; for an example of how to use this routine.

; Feel free to use this routine in your own productions as long as you give me
; some credit.

; This file should of course be viewed in a DOS texteditor ;)

; Hannes Edfeldt -+- movax@algonet.se -+- http://www.algonet.se/~movax


; SPRXOR 
;Ŀ
; Xor 8x8 sprite  a=x, e=y, bc=sprite address                               
;
PutSprite:

        push    bc              ; Save sprite address

;   Calculate the address in graphbuf   

        ld      hl,0            ; Do y*12
        ld      d,0
        add     hl,de
        add     hl,de
        add     hl,de
        add     hl,hl
        add     hl,hl

        ld      d,0             ; Do x/8
        ld      e,a
        srl     e
        srl     e
        srl     e
        add     hl,de

        ld      de,$88B8
        add     hl,de           ; Add address to graphbuf

        ld      b,00000111b     ; Get the remainder of x/8
        and     b
        cp      0               ; Is this sprite aligned to 8*n,y?
        jp      z,ALIGN


;   Non aligned sprite blit starts here   

        pop     ix              ; ix->sprite
        ld      d,a             ; d=how many bits to shift each line

        ld      e,8             ; Line loop
LILOP:  ld      b,(ix+0)        ; Get sprite data

        ld      c,0             ; Shift loop
        push    de
SHLOP:  srl     b
        rr      c
        dec     d
        jp      nz,SHLOP
        pop     de

        ld      a,b             ; Write line to graphbuf
        xor     (hl)
        ld      (hl),a
        inc     hl
        ld      a,c
        xor     (hl)
        ld      (hl),a

        ld      bc,11           ; Calculate next line address
        add     hl,bc
        inc     ix              ; Inc spritepointer

        dec     e
        jp      nz,LILOP        ; Next line

        jp      DONE1


;   Aligned sprite blit starts here   

ALIGN:                          ; Blit an aligned sprite to graphbuf
        pop     de              ; de->sprite
        ld      b,8
ALOP1:  ld      a,(de)
        xor     (hl)
        ld      (hl),a
        inc     de
        push    bc
        ld      bc,12
        add     hl,bc
        pop     bc
        djnz    ALOP1

DONE1:
	  ROM_CALL(DISP_GRAPH)
        ret
; SPRXOR 


;Ŀ
; Z80 ۳    Sprite83    ۳ movax ۳
;


;-----------------
;|Variables
;-----------------

BallX:	.db 0
BallY:	.db 0
BoxX:		.db 0
BoxY:		.db 0
Ticks:	.db 0
TempVar:	.db 0
TempVar1:	.db 0

Timer:	.db 0
TimerX:	.db 0

;------------------
;|Text
;------------------
TitleText:	.db	" The Chase  0.9 ",
		.db	"Ahmed  El-Helw  ",
		.db	"asm8x.home.ml.or",
		.db	" 1-  The Chaser ",
		.db	" 2-  The Chased ",0

GameWinnerT:
.db 0,0,"You Won!!!!",0
GameOver:
.db 0,10,"The Chase 0.9, by AE",0
.db 0,17,"Thanks to Quran Kareem",0
.db 0,24,"who created the idea.",0
.db 0,50,"Press a key...",0

;------------------
;|Sprites
;------------------
Ball:
 .db	%00000000
 .db	%00011000
 .db	%00100100
 .db	%00100100
 .db	%00011000
 .db	%00000000
 .db	%00000000

Box: 
 .db  %00000000
 .db	%00000000
 .db	%00111100
 .db	%00111100
 .db	%00111100
 .db	%00111100
 .db	%00000000
 .db	%00000000


.end
END