#INCLUDE "ti82.h"

NUMROWS = 60            ; number of rows
NUMCOLS = 41            ; number of columns
STARTSPOT = 171 ;NUMCOLS * 4 + 7 

rows = TEXT_MEM                 ; probably not needed 
cols = TEXT_MEM+1                       ; same  
mapstart = TEXT_MEM+2
yourspot = TEXT_MEM+4
didwin = TEXT_MEM+5

.org START_ADDR
.db "Brick Maze v1.0",0

prog_start:                             ;prog_start lable
        ROM_CALL(CLEARLCD)              ;clears the screen
        ld      hl,258                  ;256*#over+#down
        ld      (CURSOR_ROW),hl         
        ld      hl,title                ;gets "Brick Maze v1.0"
        ROM_CALL(D_ZT_STR)                      ;prints it out like on the homescreen
        ld      hl,23*256+40      ;256*23+25
        ld      (CURSOR_X),hl           ;loads the position into 
        ld      hl,by                   ;gets "bY"
        ROM_CALL(D_ZM_STR)                      ;prints it out like on the graph screen
        ld      hl,29*256+21       ;256*29+20
        ld      (CURSOR_X),hl           ;loads the position into 
        ld      hl,name                 ;gets "Tim Redmond"
        ROM_CALL(D_ZM_STR)              
        ld      hl,35*256+7     ;256*35+10
        ld      (CURSOR_X),hl           ;loads the position into 
        ld      hl,email                ;gets "quija13@geocities.com"
        ROM_CALL(D_ZM_STR)                      ;prints it out 
        ld      hl,14103                ;256*55+23
        ld      (CURSOR_X),hl           ;loads the position into 
        ld      hl,penter               ;gets "(Press Enter)"
        ROM_CALL(D_ZM_STR)                      ;prints it out 
        call    pause                   ;calls the pause label
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-end title screen and start game-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
        ld a,0                          ;load 0 into a
        ld (didwin),a                   ;load a into didwin
        ld hl,map                       ;load the map into hl
        ld a,(hl)                       ;load hl into a
        ld (rows),a                     ;load a into rows
        inc hl                          ;add 1 to hl
        ld a,(hl)                       ;load hl into a
        ld (cols),a                     ;load a into cols
        ld hl,map+43                    ;(STARTSPOT)-(NUMCOLS*3)-5=?
        ld (mapstart),hl                ;load hl into mapstart
        ld hl,map+STARTSPOT             ;add map+STARTSPOT and put them in hl
        ld (yourspot),hl                ;load hl into yourspot
        call drawmap                    ;call the drawmap label
        ld a,40                         ;load 40 into a
        ld e,24                         ;load 24 into e
        ld hl,you_up                    ;load the you_up sprite into hl
        call sprite                     ;call the sprite lable to draw you
        ROM_CALL(DISP_GRAPH)                    ;copy the buffer
        call keyloop                    ;keyloop is really gameloop :)
        ret                             ;return
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-moving left part -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
moveleft:                               ;moveleft lable
        ld hl,(yourspot)                ;load yourspot into hl
        dec hl                          ;subtract 1 from hl
        ld a,(hl)                       ;load hl into a
        cp 9                            ;compare a to 9
        ret c                           ;if its < 9 you can't go there so return
        ld (yourspot),hl                ;load hl into yourspot
        ld hl,(mapstart)                ;load mapstart into hl
        dec hl                          ;subtract 1 from hl
        ld (mapstart),hl                ;load hl into mapstart
        call drawmap                    ;call the drawmap lable
        ld a,40                         ;load 40 into a
        ld e,24                         ;load 24 into e
        ld hl,you_left                  ;load the you_left sprite into hl
        call sprite                     ;call the sprite lable to draw you
        ROM_CALL(DISP_GRAPH)                    ;copy the buffer
        ret                             ;return
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-moving right part-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
moveright:                              ;moveright lable
        ld hl,(yourspot)                ;load yourspot into hl
        inc hl                          ;add 1 to hl
        ld a,(hl)                       ;load hl into a
        cp 9                            ;compare a to 9
        ret c                           ;if its < 9 you can't go there so return
        ld (yourspot),hl                ;load hl into yourspot
        ld hl,(mapstart)                ;load mapstart into hl
        inc hl                          ;add 1 to hl
        ld (mapstart),hl                ;load hl into mapstart
        call drawmap                    ;call the drawmap lable
        ld a,40                         ;load 40 into a
        ld e,24                         ;load 24 into e
        ld hl,you_right                 ;load the you_right sprite into hl
        call sprite                     ;call the sprite lable to draw you
        ROM_CALL(DISP_GRAPH)                    ;copy the buffer
        ret                             ;return
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-moving up part -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
moveup:                                 ;moveup lable
        ld hl,(yourspot)                ;load yourspot into hl
        ld b,NUMCOLS                    ;load NUMCOLS into b
upchkloop:                              ;upchkloop lable
        dec hl                          ;subtract 1 from hl
        djnz upchkloop                  ;decrement b and if its not 0 goto upchkloop lable
        ld a,(hl)                       ;load hl into a
        cp 9                            ;compare a to 9
        ret c                           ;if its < 9 you can't go there so return
        ld (yourspot),hl                ;load hl into yourspot
        ld hl,(mapstart)                ;load mapstart into hl
        ld b,NUMCOLS                    ;load NUMCOLS into b
uploop:                                 ;uploop lable
        dec hl                          ;subtract 1 from hl
        djnz uploop                     ;decrement b and if its not 0 goto uploop lable
        ld (mapstart),hl                ;load hl into mapstart
        call drawmap                    ;call the drawmap lable
        ld a,40                         ;load 40 into a
        ld e,24                         ;load 24 into e
        ld hl,you_up                    ;load the you_up sprite into hl
        call sprite                     ;call the sprite lable to draw you
        ROM_CALL(DISP_GRAPH)                    ;copy the buffer
        ret                             ;return
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-moving down part -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
movedown:                               ;movedown lable
        ld hl,(yourspot)                ;load yourspot into hl
        ld b,NUMCOLS                    ;load NUMCOLS into b
downchkloop:                            ;downchkloop lable
        inc hl                          ;add 1 to hl
        djnz downchkloop                ;decrement b and if its not 0 goto downchkloop lable
        ld a,(hl)                       ;load hl into a
        cp 10                           ;compare a to 10
        jp z,won                        ;if a = 10 goto won
        cp 9                            ;compare a to 9
        ret c                           ;if its < 9 you can't go there so return
        ld (yourspot),hl                ;load hl into yourspot
        ld hl,(mapstart)                ;load mapstart into hl
        ld b,NUMCOLS                    ;load NUMCOLS into b
downloop:                               ;downloop lable
        inc hl                          ;add 1 to hl
        djnz downloop                   ;decrement b and if its not 0 goto downloop lable
        ld (mapstart),hl                ;load hl into mapstart
        call drawmap                    ;call the drawmap lable
        ld a,40                         ;load 40 into a
        ld e,24                         ;load 24 into e
        ld hl,you_down                  ;load the you_down sprite into hl
        call sprite                     ;call the sprite lable to draw you
        ROM_CALL(DISP_GRAPH)                    ;copy the buffer
        ret                             ;return
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-part that allows the user to do things -=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
keyloop:                        ;keyloop lable
        call GET_KEY            ;Clear the keybuffer
        call    delay           ;call delay
        ld      a,0FEh          ;Check the arrow keys
        out     (1),a           ;need it to run direct input
        in      a,(1)           ;need it to run direct input
        cp      254             ;copare a to the downkey
        CALL    z,movedown      ;call MoveDown if a = 254
        cp      253             ;compare a to the leftkey
        CALL    z,moveleft    ;call MoveLeft if a = 253
        cp      251             ;compare a to the rightkey
        CALL    z,moveright    ;call MoveRight if a = 251
        cp      247             ;compare a to the upkey
        CALL    z,moveup        ;call MoveUp if a = 247
        ld      a,0FDh          ;Check Clear
        out     (1),a           ;need it to run direct input
        in      a,(1)           ;need it to run direct input
        cp      191             ;compare a to the clearkey
        jp      z,exit          ;goto exit if a = 191
        ld      a,(didwin)      ;load didwin into a
        cp      123             ;compare a to 123
        jp      z,exit          ;if a = 123 goto exit
        jp      keyloop         ;goto keyloop
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-part that draws the map-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
drawmap:
        call BUFCLR
        ld hl,(mapstart)
        ld de,$88B8          
draw_loop:
        ld b,8
draw2:
        push bc                    ; b = screen sizes for loops
        ld b,12
draw_loop2:
        push bc
        ld a,(hl)
        cp 0
        call z,drawicorn
        cp 1
        call z,drawwall
        cp 2                            ; what to draw (theres better ways)
        call z,drawdwall                ; ..that is, push hl before the cps
        cp 3                            ; so u dont have one in every drawxxxx
        call z,drawdrwall
        cp 4
        call z,drawrwall
        cp 5
        call z,drawdlwall
        cp 6
        call z,drawurwall
        cp 7
        call z,drawdcorn
        cp 8
        call z,drawucorn
        cp 10
        call z,drawfend
        cp 11
        call z,drawdwall
        inc hl
        inc de
        pop bc
        djnz draw_loop2
        push de
        ld a,(cols)                ; complex scroll stuff
        sub 12                     ; draw 12, then the next row is at
        ld b,a                     ; NUMCOLS - 12, because you just inc'd
nextcol:                           ; 12 in the drawing the first 12
        inc hl
        djnz nextcol
        pop de
        push hl
        ld hl,84                   ; 84 is the number to get the to the
        add hl,de                  ; next row on the screen
        ex de,hl
        pop hl
        pop bc
        djnz draw2
        ret

drawwall:
        push hl
        ld hl,wall
        call drawblock              ; ld hl and draw
        pop hl
        ret
drawicorn:
        push hl
        ld hl,icorn                 ; etc
        call drawblock
        pop hl
        ret
drawdwall:
        push hl
        ld hl,dwall                 ; etc
        call drawblock
        pop hl
        ret
drawdrwall:
        push hl
        ld hl,drwall                 ; etc
        call drawblock
        pop hl
        ret
drawrwall:
        push hl
        ld hl,rwall                 ; etc
        call drawblock
        pop hl
        ret
drawdlwall:
        push hl
        ld hl,dlwall                 ; etc
        call drawblock
        pop hl
        ret
drawurwall:
        push hl
        ld hl,urwall                 ; etc
        call drawblock
        pop hl
        ret
drawdcorn:
        push hl
        ld hl,dcorn
        call drawblock
        pop hl
        ret
drawucorn:
        push hl
        ld hl,ucorn
        call drawblock
        pop hl
        ret
drawfend:
        push hl
        ld hl,fend
        call drawblock
        pop hl
        ret
drawblock:
        push bc
        push de
        ld b,8                      ; my GREAT sprite routine
block_loop:
        push bc
        push hl
        ld a,(hl)
        ld (de),a
        ld hl,12
        add hl,de
        ex de,hl
        pop hl
        inc hl
        pop bc
        djnz block_loop
        pop de
        pop bc
        ret


delay:
        PUSH AF
        PUSH BC
        LD BC, $1000
DelayLoop:
        DEC BC
        LD A, B
        OR C
        JR NZ, DelayLoop
        POP BC
        POP AF
        RET
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-pause for the title and winning screens-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
pause:                          ;pause lable
        call GET_KEY            ;call _getkey command
        cp      09h             ;compare the key to enter
        jp      nz,pause        ;goto paue if it isn't enter
        ret                     ;return
;
; movax's sprite routine is only for drawing you on the screen
;
; SPRITE 
;Ŀ
; Blit or erase sprite  a=x, e=y, hl=sprite address                         
;
sprite:

        push    hl              ; Save sprite address

;   Calculate the address in graphbuf   

        ld      hl,0            ; Do y*12
        ld      d,0
        add     hl,de
        add     hl,de
        add     hl,de
        add     hl,hl
        add     hl,hl

        ld      d,0             ; Do x/8
        ld      e,a
        srl     e
        srl     e
        srl     e
        add     hl,de

        ld      de,$88B8
        add     hl,de           ; Add address to graphbuf

        ld      b,00000111b     ; Get the remainder of x/8
        and     b
       
;   Aligned sprite blit starts here   

ALIGN:                          ; Blit an aligned sprite to graphbuf
        pop     de              ; de->sprite
        ld      b,8
ALOP1:  ld      a,(de)
        or      (hl)            ; xor=erase/blit
        ld      (hl),a
        inc     de
        push    bc
        ld      bc,12
        add     hl,bc
        pop     bc
        djnz    ALOP1

DONE1:
        ret
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-sprites-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
icorn:                          ;tiny corner
  .db 10001000b
  .db 11111111b
  .db 00100010b
  .db 11111111b
  .db 10001000b
  .db 11111111b
  .db 00100111b
  .db 11111111b
wall:                           ;normal wall
  .db 10001000b
  .db 11111111b
  .db 00100010b
  .db 11111111b
  .db 10001000b
  .db 11111111b
  .db 00100010b
  .db 11111111b
dwall:                          ;wall pointing down
  .db 10001000b
  .db 11111111b
  .db 00100010b
  .db 11111111b
  .db 10001000b
  .db 11111111b
  .db 11111111b
  .db 11111111b
drwall:                         ;corner
  .db 10001111b
  .db 11111111b
  .db 00100111b
  .db 11111111b
  .db 10001111b
  .db 11111111b
  .db 11111111b
  .db 11111111b
rwall:                          ;wall pointing right
  .db 10001111b
  .db 11111111b
  .db 00100111b
  .db 11111111b
  .db 10001111b
  .db 11111111b
  .db 00100111b
  .db 11111111b
dlwall:                         ;wall pointing down and left
  .db 10001000b
  .db 11111111b
  .db 00100010b
  .db 11111111b
  .db 10001000b
  .db 11111111b
  .db 01111111b
  .db 00111111b
dcorn:                          ;corner pointing left
  .db 10001111b
  .db 11111111b
  .db 00100111b
  .db 11111111b
  .db 10001111b
  .db 11111111b
  .db 01111111b
  .db 00111111b
urwall:                         ;wall pointing right and up
  .db 10001100b
  .db 11111110b
  .db 00100111b
  .db 11111111b
  .db 10001111b
  .db 11111111b
  .db 00100111b
  .db 11111111b
ucorn:                          ;corner pointing up
  .db 10001100b
  .db 11111110b
  .db 00100111b
  .db 11111111b
  .db 10001111b
  .db 11111111b
  .db 11111111b
  .db 11111111b
you_up:                         ;you facing up
  .db 00111100b
  .db 01000010b
  .db 10011001b
  .db 10100101b
  .db 10000001b
  .db 10100101b
  .db 01000010b
  .db 00111100b
you_down:                       ;you facing down
  .db 00111100b
  .db 01000010b
  .db 10100101b
  .db 10000001b
  .db 10100101b
  .db 10011001b
  .db 01000010b
  .db 00111100b
you_left:                       ;you facing left
  .db 00111100b
  .db 01000010b
  .db 10010101b
  .db 10100001b
  .db 10100001b
  .db 10010101b
  .db 01000010b
  .db 00111100b
you_right:                      ;you facing right
  .db 00111100b
  .db 01000010b
  .db 10101001b
  .db 10000101b
  .db 10000101b
  .db 10101001b
  .db 01000010b
  .db 00111100b
fend:                           ;the ending
  .db 11111111b
  .db 11111111b
  .db 11111111b
  .db 11100111b
  .db 11100111b
  .db 11111111b
  .db 11111111b
  .db 11111111b
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-identification list for the programmer -=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
        ; 0 = icorn
        ; 1 = wall
        ; 2 = dwall
        ; 3 = drwall
        ; 4 = rwall
        ; 5 = dlwall
        ; 6 = urwall
        ; 7 = dcorn
        ; 8 = ucorn
        ; 9 = empty
        ; 10= ending
        ; 11= fakewall
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-map-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
map:
 .db NUMROWS, NUMCOLS
 .db    0,2,2,2,2,2,0,2,2,0,2,2,2,2,2,0,2,2,2,2,2,0,2,2,2,2,2,2,0,2,2
 .db    2,2,2,2,2,2,2,2,2,1
 .db    4,9,9,9,9,9,7,9,9,4,9,9,9,9,9,7,9,9,9,9,9,7,9,9,9,9,9,9,4,9,9
 .db    9,9,9,9,9,9,9,9,9,1
 .db    4,9,0,2,6,9,9,9,1,4,9,6,9,6,9,9,9,6,9,6,9,9,9,6,9,9,6,9,4,9,6
 .db    9,6,9,1,0,2,2,6,9,1
 .db    4,9,4,9,0,2,2,2,2,3,9,5,2,2,2,0,2,2,2,0,2,2,2,2,6,9,5,2,3,9,1
 .db    2,2,0,2,4,9,9,4,9,1
 .db    4,9,4,9,4,9,9,9,9,9,9,9,9,9,9,4,9,9,9,4,9,9,9,9,4,9,9,9,9,9,4
 .db    9,9,4,9,4,9,5,4,9,1
 .db    4,9,4,9,4,9,0,2,2,8,9,6,9,6,9,4,9,6,9,4,9,1,6,9,0,2,2,2,2,2,3
 .db    9,0,3,9,4,9,9,4,9,1
 .db    4,9,4,9,4,9,4,9,9,9,9,4,9,4,9,4,9,4,9,4,9,5,3,9,4,9,9,9,9,9,9
 .db    9,4,9,9,0,8,9,4,9,1
 .db    4,9,4,9,4,9,4,9,5,2,2,4,9,4,9,4,9,4,9,4,9,9,9,9,4,9,1,1,0,2,1
 .db    2,0,8,9,4,9,9,4,9,1
 .db    4,9,4,9,4,9,4,9,9,9,9,4,9,4,9,5,2,3,9,4,9,5,2,2,3,9,5,2,3,9,7
 .db    9,7,9,9,4,9,5,4,9,1
 .db    4,9,7,9,4,9,5,0,2,8,9,7,9,4,9,9,9,9,9,4,9,4,9,9,9,9,9,9,9,9,9
 .db    9,9,9,9,4,9,9,4,9,1
 .db    4,9,9,9,4,9,9,4,9,9,9,9,9,4,9,0,2,2,0,3,9,4,9,0,2,2,2,2,2,2,2
 .db    2,2,2,2,2,6,9,4,9,5
 .db    2,8,9,5,0,8,9,4,9,0,2,8,9,4,9,4,9,9,4,9,9,4,9,4,9,9,9,9,9,9,9
 .db    4,9,9,9,9,4,9,4,9,9
 .db    9,9,9,9,4,9,9,4,9,4,9,9,9,4,9,4,9,9,4,9,0,3,9,4,9,6,9,0,2,6,9
 .db    4,9,9,6,9,4,9,7,9,0
 .db    2,2,2,2,4,9,5,4,9,4,9,0,2,3,9,5,2,0,3,9,7,9,9,4,9,4,9,4,9,4,9
 .db    0,2,2,3,9,4,9,9,9,4
 .db    9,9,9,9,4,9,9,4,9,4,9,4,9,9,9,9,9,4,9,9,9,9,9,4,9,4,9,4,9,4,9
 .db    4,9,9,9,9,4,9,6,9,4
 .db    9,0,8,9,0,8,9,4,9,4,9,5,2,2,2,2,2,4,9,0,2,2,2,4,9,4,9,4,9,4,9
 .db    4,9,5,2,2,4,9,4,9,4
 .db    9,4,9,9,4,9,9,4,9,4,9,9,9,9,9,9,9,4,9,4,9,9,9,4,9,4,9,4,9,4,9
 .db    4,9,9,9,9,4,9,4,9,4
 .db    9,4,9,5,4,9,5,2,2,2,2,2,2,2,2,2,2,3,9,4,9,5,2,4,9,4,9,4,9,7,9
 .db    5,2,8,9,9,4,9,4,9,4
 .db    9,4,9,9,4,9,9,9,9,9,9,9,9,9,9,9,9,9,9,4,9,9,9,4,9,4,9,4,9,9,9
 .db    9,9,9,9,9,4,9,4,9,4
 .db    9,4,6,9,4,9,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,8,9,4,9,5,2,2,2,0,2
 .db    2,2,2,6,9,4,9,4,9,4
 .db    9,4,9,9,4,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,4,9,9,9,9,9,4,9
 .db    9,9,9,4,9,4,9,4,9,4
 .db    9,4,9,5,4,9,5,2,2,2,2,2,0,2,2,2,2,2,2,0,2,0,2,2,2,6,9,6,9,4,9
 .db    6,9,9,4,9,4,9,4,9,4
 .db    9,4,9,9,4,9,9,9,9,9,9,9,4,9,9,9,9,9,9,4,9,7,9,9,9,5,2,3,9,4,9
 .db    5,6,9,4,9,4,9,4,9,4
 .db    9,4,6,9,5,2,1,0,8,9,5,2,4,9,5,2,2,6,9,4,9,9,9,6,9,9,9,9,9,4,9
 .db    9,5,1,4,9,4,9,4,9,4
 .db    9,4,9,9,9,9,0,3,9,9,9,9,4,9,9,9,9,4,9,0,8,9,0,2,2,2,2,6,9,5,6
 .db    9,9,1,4,9,4,9,4,9,5
 .db    2,3,9,5,1,0,3,9,9,9,5,2,2,2,2,8,9,4,9,4,9,9,4,9,9,9,9,4,9,9,5
 .db    6,9,1,4,9,4,9,4,9,9
 .db    9,9,9,9,0,3,9,9,6,9,9,9,9,9,9,9,9,4,9,4,9,5,4,9,1,6,9,1,6,9,9
 .db    4,9,5,3,9,0,2,2,2,2
 .db    2,2,2,2,4,9,9,0,2,2,0,2,2,2,2,6,9,4,9,4,9,9,4,9,5,4,9,0,3,2,2
 .db    4,9,9,9,9,4,9,9,9,9
 .db    9,9,9,9,4,9,0,3,9,9,4,9,9,9,9,4,9,4,9,0,8,9,4,9,9,4,10,4,9,9,9
 .db    7,9,5,2,2,0,2,0,2,2
 .db    0,2,8,9,4,9,4,9,9,9,4,9,0,8,9,4,9,4,9,4,9,9,4,9,1,0,2,1,6,9,9
 .db    9,9,9,9,9,4,9,7,9,9
 .db    8,9,9,9,4,9,7,9,8,9,7,9,4,9,9,4,9,4,9,4,9,5,3,9,5,3,9,5,3,8,9
 .db    6,9,1,6,9,4,9,9,9,6
 .db    9,9,6,9,4,9,9,9,4,9,9,9,4,9,9,4,9,4,9,4,9,9,9,9,9,4,9,4,9,9,9
 .db    0,2,2,2,11,5,2,2,2,2
 .db    2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,9,5,2,2,2,2,2,3,9,5,2,2,2
 .db    3,9,9,9,9,9,9,9,9,9
 .db    9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9
 .db    9,9,0,2,2,2,2,2,2,2
 .db    0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,9,0,2,2,2,2,2,2,0,2,0,2
 .db    2,2,4,9,9,9,9,9,9,9
 .db    4,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,4,9,4,9,9,9,9,9,9,4,9,4,9
 .db    9,9,5,2,2,2,2,2,2,2
 .db    2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,9,4,9,4,9,0,2,2,6,9,4,9,4,9
 .db    6,9,9,9,9,9,9,9,9,9
 .db    9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,4,9,4,9,4,9,4,9,9,4,9,4,9,0,2
 .db    3,9,5,2,2,2,2,2,2,2
 .db    2,2,2,2,6,9,0,2,0,2,0,2,0,2,8,9,4,9,4,9,4,9,0,8,9,4,9,4,9,4,9
 .db    9,9,9,9,9,9,9,9,9,9
 .db    9,9,9,9,4,9,4,9,4,9,7,9,7,9,9,9,4,9,4,9,4,9,4,9,9,4,9,4,9,4,9
 .db    6,9,5,2,2,2,2,2,0,2
 .db    2,2,8,9,4,9,4,9,4,9,9,9,9,9,6,9,4,9,4,9,4,9,4,9,5,3,9,4,9,4,9
 .db    4,9,9,9,9,9,9,9,4,9
 .db    9,9,9,9,4,9,4,9,4,9,0,2,0,2,2,2,4,9,4,9,4,9,4,9,9,9,9,4,9,4,9
 .db    4,9,0,2,2,2,6,9,4,9
 .db    0,2,2,2,3,9,7,9,4,9,4,9,4,9,9,9,4,9,4,9,4,9,5,2,2,2,2,3,9,4,9
 .db    4,9,9,9,9,9,4,9,4,9
 .db    4,9,9,9,9,9,9,9,4,9,4,9,4,9,8,9,4,9,4,9,4,9,9,9,9,9,9,9,9,4,9
 .db    5,2,2,2,2,2,3,9,4,9
 .db    0,2,2,2,6,9,6,9,5,2,3,9,4,9,4,9,7,9,4,9,0,2,2,8,9,0,2,6,9,4,9
 .db    9,9,9,9,9,9,9,9,4,9
 .db    4,9,9,9,4,9,4,9,9,9,9,9,4,9,4,9,9,9,4,9,4,9,9,9,9,7,9,4,9,0,2
 .db    2,2,2,2,2,2,2,2,3,9
 .db    0,2,2,2,3,9,5,2,2,0,2,2,3,9,5,2,2,2,4,9,4,9,5,6,9,9,9,4,9,4,9
 .db    9,9,9,9,9,9,9,9,9,9
 .db    4,9,9,9,9,9,9,9,9,4,9,9,9,9,9,9,9,9,4,9,4,9,9,4,9,6,9,4,9,5,2
 .db    2,2,2,2,2,2,2,2,2,2
 .db    2,2,2,2,2,2,2,8,9,5,2,2,2,2,2,2,8,9,4,9,0,2,2,2,2,2,2,3,9,9,9
 .db    9,9,9,9,9,9,9,9,9,9
 .db    9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,4,9,4,9,9,9,9,9,9,9,9,5,2
 .db    2,2,2,2,2,2,2,2,2,2
 .db    0,2,2,2,2,2,2,8,9,5,2,2,2,2,2,2,2,2,3,9,5,2,2,2,2,2,2,6,9,9,9
 .db    9,9,9,9,9,9,9,9,9,9
 .db    4,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,4,9,5,2
 .db    2,2,2,2,2,2,0,2,2,2
 .db    2,2,2,2,1,1,1,6,9,5,2,2,2,2,2,2,2,2,6,9,0,2,0,2,2,6,9,4,9,9,9
 .db    9,9,9,9,9,9,4,9,9,9
 .db    9,9,9,9,5,1,1,4,9,9,9,9,9,9,9,9,9,9,4,9,4,9,4,9,9,4,9,5,2,2,2
 .db    6,9,9,0,2,2,3,9,0,2
 .db    2,2,6,9,9,5,1,0,2,2,2,2,2,2,2,2,6,9,4,9,4,9,4,9,9,4,9,9,9,9,9
 .db    4,9,9,4,9,9,9,9,4,9
 .db    9,9,5,6,9,9,5,4,9,9,9,9,9,9,9,9,4,9,4,9,4,9,4,9,5,3,9,5,2,6,9
 .db    5,2,2,3,9,5,6,9,4,9
 .db    0,2,0,2,6,9,9,4,9,5,2,2,2,2,2,2,3,9,4,9,4,9,4,9,9,9,9,9,9,4,9
 .db    9,9,9,9,9,9,4,9,4,9
 .db    4,9,4,9,5,6,9,9,9,9,9,9,9,9,9,9,9,9,4,9,4,9,4,9,9,5,2,8,9,0,2
 .db    2,2,2,2,2,2,2,2,4,9
 .db    4,9,4,9,0,5,0,2,0,2,0,2,2,2,2,0,2,2,0,2,4,9,4,9,9,9,9,9,9,4,9
 .db    9,9,9,9,9,9,9,9,4,9
 .db    7,9,7,9,7,9,7,9,7,9,7,9,9,9,9,7,9,9,7,9,7,9,5,2,2,2,2,2,2,3,9
 .db    5,2,2,2,2,2,8,9,7,9
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-part you see if you found the ending -=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
won:                                    ;won lable
        ROM_CALL(CLEARLCD)              ;clear the screen
        ld      hl,1026                 ;load the place for the words into hl
        ld      (CURSOR_ROW),hl         ;load hl into CURSOR_ROW
        ld      hl,winner               ;gets "You Won!"
        ROM_CALL(D_ZT_STR)                       
        ld      a,123                   ;load 123 into a
        ld      (didwin),a              ;load a into didwin
        ld      hl, 7191                ;256*28+23
        ld      (CURSOR_X),hl           ;load hl into CURSOR_X
        ld      hl, penter              ;gets "(Press Enter)"
        ROM_CALL(D_ZM_STR)                       
        call    pause                   ;calls the pause lable
exit:                                   ;exit lable
        ROM_CALL(CLEARLCD)              ;clear the screen
        ret                             ;return

BUFCLR:
        ld hl,$88B8
        ld de,$88B9
        ld bc,$2FF
        ld (hl),0
        ldir
        ret
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-all the words printed during the game-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
title:  .db     "Brick Maze v1.0",0
by:     .db     "bY",0
name:   .db     "Tim R./Ilya W.",0
email:  .db     "ilyamojo@geocities.com",0
winner: .db     "You Won!",0
penter: .db     "(Press Enter)",0

.end
.end



