;BoxWorld for the 82, ported from the 83 version
;by Ilya Winham. I will update this when the 83
;version is. **Note, this is NOT a complete or
;final version.
;email: ilyamojo@geocities.com

#INCLUDE "ti82.h"



;---------- Variables ----------
loc = TEXT_MEM	; location of '+'
lev = TEXT_MEM+2  ; current level
posc = TEXT_MEM+3 ; temporary curcol var
posr = TEXT_MEM+4  ; temporary currow var
level = APD_BUF   ; current level matrix ($80 bytes)

	.ORG START_ADDR
	.db "BoxWorld v1.0 - Ilya",0

;---------- Setup the game -----------
	ROM_CALL(CLEARLCD)
	ld		hl,$0202
	ld		(CURSOR_ROW),hl
	ld		hl,info1
	ROM_CALL(D_ZT_STR)
	ld		hl,$0503
	ld		(CURSOR_ROW),hl
	ld		hl,info2
	ROM_CALL(D_ZT_STR)
	ld		hl,$0204
	ld		(CURSOR_ROW),hl
	ld		hl,info3
	ROM_CALL(D_ZT_STR)
wlp:	
	call GET_KEY
	or a
	jp z,wlp
	ld		hl,$0000
	ld		(loc),hl
	ld		a,1
	ld		(lev),a

;---------- Load a level ----------
start:
	ld		hl,level
	ld		b,$11
lsl0:	
	ld		(hl),''
	inc		hl
	djnz		lsl0
	ld		hl,level1
	ld		b,$60
lsl1:	
	dec		hl
	djnz		lsl1
	ld		a,(lev)
	ld		b,a
	ld		de,$0060
lsl2:	
	add		hl,de
	djnz		lsl2
	ld		de,level+$11
	ld		bc,$005E
	ldir
	ld		a,(hl)
	ld		(posc),a
	ld		d,a
	inc		hl
	ld		a,(hl)
	ld		(posr),a
	ld		b,a
	ld		e,$10
	ld		a,$00
lsl3:	
	add		a,e
	djnz		lsl3
	add		a,d
	ld		(loc),a
	ld		hl,level+$6F
	ld		b,$11
lsl4:	
	ld		(hl),''
	inc		hl
	djnz		lsl4

;---------- Draw the level ----------
	ld		hl,$0000
	ld		(CURSOR_ROW),hl
	ld		hl,level
	ld		b,$7F
dloop:	
	push		bc
	ld		a,(hl)
	ROM_CALL(TR_CHARPUT)
	call UPDATECURSORPOS
	dec		b
	inc		hl
	pop		bc
	djnz		dloop
	ld		a,(hl)
	ROM_CALL(TR_CHARPUT)
	ld		a,(posr)
	ld		(CURSOR_ROW),a
	ld		a,(posc)
	ld		(CURSOR_COL),a
	ld		a,'+'
	ROM_CALL(TR_CHARPUT)

;---------- Main program loop ----------
main:	
	call GET_KEY
	cp 15
	jp		z,exit
	cp $02
	jp		z,mLeft
	cp $03
	jp          z,mRight
	cp $04
	jp		z,mUp
	cp $01
	jp		z,mDown
	cp 56
	jp		z,start
	cp 10
	jp		z,levup
	cp 11
	jp		z,levdwn
	jr		main

;---------- Move right ----------
mRight:	
	ld		a,(CURSOR_COL)
	cp		0Eh
	jp		z,main
	call		align
	inc		de
	ld		(loc),de
	ld		a,(hl)
	ROM_CALL(TR_CHARPUT)
	call UPDATECURSORPOS
	ld		a,'+'
	ROM_CALL(TR_CHARPUT)
	call		align
	ld		a,(hl)
	cp		''
	jp		z,mLeft
	cp		'*'
	jr		z,mor
	jp		main
mor:	
	call		align
	inc		hl
	ld		a,(hl)
	cp		''
	jp		z,mLeft
	cp		'*'
	jp		z,mLeft
	cp		':'
	jr		z,mrcn1
	ld		a,'*'
	ld		(hl),a
mrcn1:	
	dec		hl
	ld		a,' '
	ld		(hl),a
	ld		a,(CURSOR_COL)
	inc		a
	ld		(CURSOR_COL),a
	call		align
	inc		hl
	ld		a,(hl)
	cp		':'
	jr		z,mrcn2
	ld		a,'*'
	ROM_CALL(TR_CHARPUT)
mrcn2:	
	ld		a,(CURSOR_COL)
	dec		a
	ld		(CURSOR_COL),a
	jp		winc

;---------- Move left ----------
mLeft:	
	ld		a,(CURSOR_COL)
	cp		1
	jp		z,main
	dec		a
	ld		(CURSOR_COL),a
	ld		a,'+'
	ROM_CALL(TR_CHARPUT)
	call UPDATECURSORPOS
	call		align
	dec		de
	ld		(loc),de
	ld		a,(hl)
	ROM_CALL(TR_CHARPUT)
	ld		a,(CURSOR_COL)
	dec		a
	ld		(CURSOR_COL),a
	call		align
	ld		a,(hl)
	cp		''
	jp		z,mRight
	cp		'*'
	jr		z,mol
	jp		main
mol:	
	call		align
	dec		hl
	ld		a,(hl)
	cp		''
	jp		z,mRight
	cp		'*'
	jp		z,mRight
	cp		':'
	jr		z,mlcn1
	ld		a,'*'
	ld		(hl),a
mlcn1:	
	inc		hl
	ld		a,' '
	ld		(hl),a
	ld		a,(CURSOR_COL)
	dec		a
	ld		(CURSOR_COL),a
	call		align
	dec		hl
	ld		a,(hl)
	cp		':'
	jr		z,mlcn2
	ld		a,'*'
	ROM_CALL(TR_CHARPUT)
mlcn2:	
	ld		a,(CURSOR_COL)
	inc		a
	ld		(CURSOR_COL),a
	jp		winc

;---------- Move up ----------
mUp:	
	ld		a,(CURSOR_ROW)
	cp		1
	jp		z,main
	call		align
	ld		a,(hl)
	ROM_CALL(TR_CHARPUT)
	ld		a,(CURSOR_ROW)
	dec		a
	ld		(CURSOR_ROW),a
	ld		hl,(loc)
	ld		bc,$0010
	sbc		hl,bc
	ld		(loc),hl
	ld		a,'+'
	ROM_CALL(TR_CHARPUT)
	call		align
	ld		a,(hl)
	cp		''
	jp		z,mDown
	cp		'*'
	jr		z,moup
	jp		main
moup:	
	call		align
	ld		bc,$0010
	sbc		hl,bc
	ld		a,(hl)
	cp		''
	jp		z,mDown
	cp		'*'
	jp		z,mDown
	cp		':'
	jr		z,mucn1
	ld		a,'*'
	ld		(hl),a
mucn1:	
	ld		bc,$0010
	add		hl,bc
	ld		a,' '
	ld		(hl),a
	ld		a,(CURSOR_ROW)
	dec		a
	ld		(CURSOR_ROW),a
	ld		bc,$0020
	sbc		hl,bc
	ld		a,(hl)
	cp		':'
	jr		z,mucn2
	ld		a,'*'
	ROM_CALL(TR_CHARPUT)
mucn2:	
	ld		a,(CURSOR_ROW)
	inc		a
	ld		(CURSOR_ROW),a
	jp		winc

;---------- Move down ----------
mDown:	
	ld		a,(CURSOR_ROW)
	cp		6
	jp		z,main
	call		align
	ld		a,(hl)
	ROM_CALL(TR_CHARPUT)
	ld		a,(CURSOR_ROW)
	inc		a
	ld		(CURSOR_ROW),a
	ld		hl,(loc)
	ld		bc,$0010
	add		hl,bc
	ld		(loc),hl
	ld		a,'+'
	ROM_CALL(TR_CHARPUT)
	call		align
	ld		a,(hl)
	cp		''
	jp		z,mUp
	cp		'*'
	jr		z,modwn
	jp		main
modwn:	
	call		align
	ld		bc,$0010
	add		hl,bc
	ld		a,(hl)
	cp		''
	jp		z,mUp
	cp		'*'
	jp		z,mUp
	cp		':'
	jr		z,mdcn1
	ld		a,'*'
	ld		(hl),a
mdcn1:	
	call		align
	ld		a,' '
	ld		(hl),a
	ld		a,(CURSOR_ROW)
	inc		a
	ld		(CURSOR_ROW),a
	ld		bc,$0020
	add		hl,bc
	ld		a,(hl)
	cp		':'
	jr		z,mdcn2
	ld		a,'*'
	ROM_CALL(TR_CHARPUT)
mdcn2:	
	ld		a,(CURSOR_ROW)
	dec		a
	ld		(CURSOR_ROW),a
	jp		winc

;---------- Point hl to level matrix element ----------
align:	
	ld		de,(loc)
	ld		hl,level
	add		hl,de
	ret

;---------- Move up/down a level ----------
levdwn:	; move down a level
	ld		a,(lev)
	cp		1
	jr		z,levx
	dec		a
	jr		levx
levup:	; move up a level
	ld		a,(lev)
	cp		$06
	jr		z,levx
	inc		a
levx:	
	ld		(lev),a
	jp		start

;---------- Winner? ----------
winc:	
	ld		hl,level
	ld		b,$80
wincl:	
	ld		a,(hl)
	cp		'*'
	inc		hl
	jp		z,main
	djnz		wincl
	ld		a,(lev)
	inc		a
	ld		(lev),a
	cp		$06+1
	jp		nz,start
	ROM_CALL(CLEARLCD)
	ld		hl,$0403
	ld		(CURSOR_ROW),hl
	ld		hl,won
	ROM_CALL(D_ZT_STR)
bs1:	
	call GET_KEY
	or a
	jr z,bs1
exit:	
	ROM_CALL(CLEARLCD)
	ret		; exit the program

UPDATECURSORPOS:  ;routine added for 82 version by me!
	ld a,(CURSOR_COL)
	inc a
	ld (CURSOR_COL),a
	cp 16
	call z,changeypos
	ret
changeypos:
	ld a,0
	ld (CURSOR_COL),a
	ld a,(CURSOR_ROW)
	inc a
	ld (CURSOR_ROW),a
	cp 8
	call z,changexpos
	ret
changexpos:
	ld hl,0
	ld (CURSOR_ROW),hl
	ret

;---------- Constants ----------
info1:	.db "BoxWorld v1.0",0
info2:	.db "by Joe",0
info3:	.db "Wingbermuehle"
		.db "   +Ilya Winham",0
won:	      .db "You Won!",0

;---------- Levels ----------
; (level data) - (top+x)(left+x)
level1:	
	.db		 "   "
	.db		"*  "
	.db		"  *"
	.db		"  * *     "
	.db		"          "
	.db		" *   *       :"
	.dw		$0607
level2:	
	.db		 "    "
	.db		"     "
	.db		"* * * "
	.db		" *  "
	.db		" *  "
	.db		":      "
	.dw		$0607
level3:	
	.db		 ":    "
	.db		"   *"
	.db		"  ** * "
	.db		" **  * "
	.db		"       "
	.db		"   "
	.dw		$0608
level4:	
	.db		 ":     "
	.db		"   *   * "
	.db		" **     "
	.db		"     ** "
	.db		" *   *   "
	.db		"      "
	.dw		$0609
Level5:	
	.db		 "         "
	.db		" * *    *   "
	.db		"  *     "
	.db		" *  ** *  "
	.db		"   *  "
	.db		":       "
	.dw		$0608
level6:	
	.db		 "      "
	.db		"  *** * "
	.db		"  *  * "
	.db		"  *** * "
	.db		":          "
	.db		""
	.dw		$0308

.end
.end
