;This is the source code for Alpha-10 v1.00 beta. Most of this stuff is
; pretty messy since I've been developing it for almost four months. There
; are obvious discrepancies between the early code (since I was still
; learning assembly) and the more recent functions. It all works, however
; eventually I'd like to go through the whole thing and "neaten" it up, also
; make it more consistent. Basically what I'm saying is this is not a good
; place to look if you're after sample code to learn from.
; All of this code is my own work. I don't mind people using bits and pieces
; of it, though I do ask that you give credit where credit is due.
; Thanks.
; Jeremy Wazny

#include "crash82.inc"

.db "Alpha-10 v1.00",0

count           =APD_BUF           ;How far into the top sprite-line
xPlayer         =APD_BUF+2         ;player's x coord
yPlayer         =APD_BUF+3         ;player's y coord
curShots        =APD_BUF+4         ;number of player shots currently on screen
canShoot        =APD_BUF+5         ;keeps track of count between player shots
numEnemyShips   =APD_BUF+6         ;number of enemy ships on screen
PlayerShots     =APD_BUF+7         ;player's shots on screen: (y,x)
numExplosions   =APD_BUF+24
playerInvinc    =APD_BUF+26            ;how long player is invincable for.
numClouds       =APD_BUF+99
clouds          =APD_BUF+100       
world           =APD_BUF+110    ;which of the 4 worlds is the level on
level           =APD_BUF+111    ;which of 4 levels on current world player 
                                ; is on
inLevelCounter  =APD_BUF+112    ;16 bit, inc by one from the start of the
                                ; level, for each row of bg scrolled
leftToKill      =APD_BUF+114
killType        =APD_BUF+115   ;1=ships, 2=buildings

rechargeCounter =APD_BUF+117    ;keeps track of lines of bg scrolled since
                                ; last energy inc
extraWeapon     =APD_BUF+119    ;number/type of the secondary weapon in use
extraWeaponDmg  =APD_BUF+120    ;amount of damage dealt by secondary weapon
justBomb        =APD_BUF+121    ;type of the bomb loaded
score           =APD_BUF+123    ;player's score
invert          =APD_BUF+130    ;foolin'
explosions      =APD_BUF+131    ;probably will need more room for explosions
girder          =APD_BUF+200    ;the y-pos of current girder (world 1) 0=off
numSmallRocks   =APD_BUF+201
smallRocks      =APD_BUF+202
TEMP            =APD_BUF+218
numDShots       =APD_BUF+219
numSShots       =APD_BUF+220
sShots          =APD_BUF+260    ;directional shots, ie. shot moves towards
                                ; players position at time of release.
enCounter       =APD_BUF+400      ;how many enemies of this type left to gen.
enPos           =APD_BUF+401      ;pos. of enemy data currently read
listMem         =APD_BUF+402      ;actual mem.location of start of gen. data
drewBuilding    =APD_BUF+408    ;non-zero if build was just drawn
numBuildings    =APD_BUF+409
buildings       =APD_BUF+410    ;building data ( type,y,x,hp)
dShotTemp       =APD_BUF+450
sShotTemp       =APD_BUF+455
moveBig         =APD_BUF+460   ;big ships should move less frequently
                                ; than small ships
numBld          =APD_BUF+498
maxShotPower    =APD_BUF+499
levelData       =APD_BUF+500
shotPower       =APD_BUF+500
scrollSpeed     =APD_BUF+501
lives           =APD_BUF+502
maxEnergy       =APD_BUF+503
energy          =APD_BUF+504
recharge        =APD_BUF+505
rechargeCount   =APD_BUF+506
buildType       =APD_BUF+507
buildHp         =APD_BUF+508
numBombs        =APD_BUF+509
buildFreq       =APD_BUF+510
shipFreq        =APD_BUF+511
shotFreq        =APD_BUF+512
maxBld          =APD_BUF+513
shipsNeedKill   =APD_BUF+514
bldNeedKill     =APD_BUF+515
dShots          =APD_BUF+520   ;straight, vertically moving shots
                                ; form: (y,dir'n/speed,x,dmg)
                                ; y: y.co-ord        
                                ; dir'n: amt to add to y each time (1,-1 etc)
                                ; x: x.co-ord
                                ; dmg: amt of energy player loses on impact
enemyShips      =APD_BUF+650   ;enemy ship data: (type,y,x,dmg,hp)
                                ;type: as defined above
                                ;dmg: amount of damage a shot from this
                                ;       ship deals
                                ;hp: amount of energy (hitpoints) of ship
                                ;       hp<=0 ~death

step = 1                        ;pixels to move player for every keypress
initLives = 3                   ;player starts with this many lives
invincTime = 128
maxDShots = 12                   
maxSShots = 4
maxShots = 8                    ;maximum number of player shots on screen
b_n_shots = 7                   ;counts between shots
initEnergy = 15                 ;amt of energy player starts game with
initRechargeRate = 8            ;try a few values before settling on one!!!!
powerPerShot = 5                ;might want to make this variable
sBombDmg = 5
maxEnemies = 16                 ;max. number of enemies on screen at once
maxBuildings = 4                ; keep it low
maxExplosions = maxEnemies+1    ;should be larger, much larger
explosionFrames = 5
maxClouds = 4                   ;max. number of clouds on screen
maxSmallRocks = 7


start:
;==========================================================
;TITLE SCREEN HERE!!!!!!!!!

 set 7,(iy+$14)
titleScreen:

 ld de,GRAPH_MEM+1
 ld hl,GRAPH_MEM
 ld (hl),0
 ld bc,768
 ldir

 ld hl,title
 ld de,GRAPH_MEM
 ld bc,204
 ldir

 ld b,$FF

 ld b,64
 ld hl,GRAPH_MEM
static1:

 push bc
 ld b,12
static2:

 call RAND
 ld c,a
 call RAND
 sla a
 xor c
 ld (hl),a
 inc hl
 djnz static2
 pop bc
 djnz static1


 ld hl,title
 ld de,GRAPH_MEM+108
 ld b,204
ttl:
 ld a,(de)
 ld c,(hl)
 or c
 ld (de),a
 inc de \ inc hl
 djnz ttl

 call RAND
 and %00000011
 jr nz,ttlCont
 call RAND
 and 1
 jr z,coolttl
 call inverseScreen
 jr ttlCont

coolttl:
 call cool_inverseScreen

ttlCont:

 call RAND
 and %00000111
 jr nz,ttlCont2


 ld bc,768
 ld hl,GRAPH_MEM+2
 ld de,GRAPH_MEM
 ldir
 
ttlCont2:

 ld b,24
 ld hl,plaque-1
 ld de,GRAPH_MEM+444
plq:
 push bc
 inc de \ inc de \ inc de
 ld bc,6
 ldir
 inc de \ inc de \ inc de
 pop bc
 djnz plq

 ld hl,$271D            ;by J.wazny
 ld (CURSOR_X),hl
 ld hl,ttlText1
 ROM_CALL(D_ZM_STR)
  
 ld hl,$2F1E            ;ENTER:Play
 ld (CURSOR_X),hl
 ld hl,ttlText2
 ROM_CALL(D_ZM_STR)

 ld hl,$3522            ;CLR: Quit
 ld (CURSOR_X),hl
 ld hl,ttlText3
 ROM_CALL(D_ZM_STR)

 ld hl,$3A4F           ;1998
 ld (CURSOR_X),hl
 ld hl,ttlText0a
 ROM_CALL(D_ZM_STR)
 ld hl,$3451           ;v1.0
 ld (CURSOR_X),hl
 ld hl,ttlText0b
 ROM_CALL(D_ZM_STR)

 call CR_GRBCopy

wait:

 call GET_KEY
 or a
 jp z,titleScreen
 cp G_CLEAR
 jr z,exitTitle
 cp G_ENTER
 jr z,slideOut
 jp titleScreen

exitTitle:
 ret

preSlide:
 pop bc \ pop bc

slideOut:

 ld b,32
 ld hl,GRAPH_MEM
 ld de,GRAPH_MEM+767
 xor a

sout:

 push bc
 ld b,12
sout2:
 ld (hl),a
 ld (de),a
 inc hl
 dec de
 djnz sout2
 call CR_GRBCopy

 pop bc
 djnz sout

;==========================================================
briefScreen:

 set 7,(iy+$14)
 ld a,(name)
 or a
 jp nz,dispBrief

newPilot:

 ld hl,name
 ld (hl),0
 ld de,name+1
 ld bc,19
 ldir

 ld hl,briefScr
 ld de,GRAPH_MEM
 ld bc,768
 ldir

 ld hl,GRAPH_MEM+67
 ld de,8
 ld b,36
blackScr:
 push bc
 ld b,4
blkScrLoop:
 ld (hl),$FF
 inc hl
 djnz blkScrLoop
 pop bc
 add hl,de
 djnz blackScr
 
 ld hl,$0507                ;welcome, enter name
 ld (CURSOR_X),hl
 ld hl,wlcmTxt1
 ROM_CALL(D_ZM_STR)

 ld hl,$0B07               
 ld (CURSOR_X),hl
 ld hl,wlcmTxt2
 ROM_CALL(D_ZM_STR)

 ld hl,$1207               
 ld (CURSOR_X),hl
 ld hl,wlcmTxt3
 ROM_CALL(D_ZM_STR)

 ld hl,$1807               
 ld (CURSOR_X),hl
 ld hl,wlcmTxt4
 ROM_CALL(D_ZM_STR)

 ld hl,$1E07               
 ld (CURSOR_X),hl
 ld hl,wlcmTxt5
 ROM_CALL(D_ZM_STR)

 call CR_GRBCopy
 call enterName

 ld hl,GRAPH_MEM
 ld de,GRAPH_MEM+1
 ld bc,768
 ld (hl),0
 ldir
 

dispBrief:

 ld hl,$2E07           ;location
 ld (CURSOR_X),hl
 ld hl,btxtLocn
 ROM_CALL(D_ZM_STR)

 ld hl,$2E27            ;actual location name based on world
 ld (CURSOR_X),hl
 ld a,(sWorld)
 add a,a \ add a,a      ;mult 16
 add a,a \ add a,a
 ld hl,worldNames
 ld b,0 \ ld c,a
 add hl,bc
 ROM_CALL(D_ZM_STR)
 
 ld hl,$3407           ;mission
 ld (CURSOR_X),hl
 ld hl,btxtMisn
 ROM_CALL(D_ZM_STR)


 ld hl,$3422            ;actual location name based on world
 ld (CURSOR_X),hl
 ld a,(sWorld)
 or a
 jr z,bW0
 cp 1
 jr z,bW1
 ld hl,btxtW2L0
 jr contBText

bW0:
 ld hl,btxtW0L0
 jr contBText
bW1:
 ld hl,btxtW1L0
 
contBText:
 ld a,(sLevel)
 add a,a \ add a,a      ;mult 16
 add a,a \ add a,a
 ld b,0 \ ld c,a
 add hl,bc
 ROM_CALL(D_ZM_STR)

 ld hl,$0507           ;player's name
 ld (CURSOR_X),hl
 ld hl,name
 ROM_CALL(D_ZM_STR)

 ld hl,$0B07
 ld (CURSOR_X),hl
 ld hl,txtScore
 ROM_CALL(D_ZM_STR)

 ld hl,$0B1D
 ld (CURSOR_X),hl
 ld hl,savedScore
 call D_HLM_DECI

 ld hl,$2210
 ld (CURSOR_X),hl
 ld hl,txtEnter
 ROM_CALL(D_ZM_STR)

 ld hl,$1107
 ld (CURSOR_X),hl
 ld hl,txtGoal
 ROM_CALL(D_ZM_STR)

 ld hl,$1707
 ld (CURSOR_X),hl
 ld a,(sWorld)
 add a,a \ add a,a
 ld c,a
 ld a,(sLevel)
 add a,c
 add a,a
 ld c,a
 add a,a
 add a,c
 ld d,0 \ ld e,a
 ld hl,goalData
 add hl,de
 ld a,(hl)
 or a
 jr z,noGoalTxt
 inc hl
 push hl
 ROM_CALL(D_ZM_STR)
 pop hl
 dec hl
 ld a,(hl)
 cp 1
 jr z,dispShipTxt
dispBldTxt:
 ld hl,bldTxt
 ROM_CALL(D_ZM_STR)
 jr statc
dispShipTxt:
 ld hl,shipTxt
 ROM_CALL(D_ZM_STR)
 jr statc
noGoalTxt:
 ld hl,surviveTxt
 ROM_CALL(D_ZM_STR)

statc:
 ld hl,GRAPH_MEM+67
 ld de,8
 ld b,36
stcScr:
 push bc
 ld b,4
stcScrLoop:
 call RAND
 ld c,a
 call RAND
 sla a
 xor c
 ld (hl),a
 inc hl
 djnz stcScrLoop
 pop bc
 add hl,de
 djnz stcScr
 
 call RAND
 and %00000011
 jr nz,briefBmp
 call cool_inverseScreen

briefBmp:
 ld hl,briefScr
 ld de,GRAPH_MEM
 ld b,192
briefBmpDisp:
 push bc
 ld b,4
briefBmpLoop:
 ld c,(hl)
 ld a,(de)
 or c
 ld (de),a
 inc de \ inc hl
 djnz briefBmpLoop
 pop bc
 djnz briefBmpDisp


briefKey:

 call CR_GRBCopy 
 call GET_KEY
 or a
 jp z,dispBrief
 cp G_CLEAR
 ret z
 cp G_MODE
 jp z,newPilot
 cp G_ENTER
 jp nz,dispBrief


;==========================================================
; actual game after this point
 

Init:

 res 7,(iy+$14)
 ROM_CALL(CLEARLCD)

 ld hl,APD_BUF                  ;clears APD_BUF
 ld (hl),0
 ld de,APD_BUF+1
 ld bc,767
 ldir

 ld hl,TEXT_MEM                 ;clears TEXT_MEM (useful after the first run
 ld de,TEXT_MEM+1               ; of the game)
 ld (hl),0
 ld bc,127
 ldir

 ld hl,tempScrn+767
 ld (hl),0
 ld de,tempScrn+766
 ld bc,767
 lddr

 ld hl,TileMap
 ld de,TileMap+1
 ld (hl),0
 ld bc,11
 ldir

 ld de,GRAPH_MEM+1
 ld hl,GRAPH_MEM
 ld (hl),0
 ld bc,767
 ldir


 ld hl,count
 ld (hl),7
 ld hl,xPlayer
 ld (hl),47             ;start at bottom middle of screen
 ld hl,yPlayer
 ld (hl),50

;the following sets up the variables which "define" the level in terms of
; lives, number of sbombs, recharging shields etc.

 ld a,(sWorld)
 add a,a \ add a,a
 ld c,a
 ld a,(sLevel)
 add a,c                ; multiply by 14
 add a,a
 ld c,a
 add a,a
 ld e,a
 add a,a
 add a,e
 add a,c
 ld d,0 \ ld e,a
 ld hl,levelSetData
 add hl,de
 ld de,levelData
 ld bc,14
 ldir

 ld a,(shotPower)
 ld (maxShotPower),a

 ld a,(sWorld)
 add a,a \ add a,a
 ld c,a
 ld a,(sLevel)
 add a,c
 add a,a                
 ld b,0 \ ld c,a
 ld hl,worldPointers
 add hl,bc              ;load appropriate location in hl for world/level
 ld a,(hl) \ ld b,a
 inc hl
 ld a,(hl) \ ld h,a
 ld l,b
 ld de,listMem
 ld a,h
 ld (de),a              ;listMem contains the address of the start of the
 inc de                 ; gen data for this world/level. 
 ld a,l
 ld (de),a

 ld a,(hl)              ;initialise enCounter
 ld (enCounter),a
 xor a
 ld (enPos),a

 ld hl,(savedScore)     ;start off with same score as at end of last level
 ld (score),hl

 ld a,(sWorld)                  ;sets up how many left to kill for goal
 add a,a \ add a,a
 ld c,a
 ld a,(sLevel)
 add a,c
 add a,a
 ld c,a
 add a,a
 add a,c
 ld d,0 \ ld e,a
 ld hl,goalData
 add hl,de
 ld a,(hl)
 ld (killType),a
 ld de,5
 add hl,de
 ld a,(hl)
 ld (leftToKill),a

 ld b,70        ;number of rows to start with
initLoop:       ; sets up initial random screen of tiles

 push bc
 call TopLine
 call Scroll1
 call ShowScreen
 call drawStatBar
 call CR_GRBCopy
 call RedrawGraph
 pop bc
 djnz initLoop


;====================================================================
Main:           ;main loop which is repeatedly executed

 ld hl,inLevelCounter+1 ;used temporarily because may not want to use a full
 inc (hl)               ; counter, just something to regulate when ships can
                        ; be generated so as to be spaced vertically

 call TopLine           ;Draw next line of background
 call Scroll1           ;Scroll screen down 1 line
 call ShowScreen        ;stores bg to tempScreen

 call moveBld           ;move buildings down

 ld a,(maxShotPower)
 ld c,a
 ld a,(shotPower)
 cp c
 jr nc,carryOn
 inc a
 ld (shotPower),a

carryOn:
 ld a,(count)
 or a
 jr nz,mainCont5
 ld a,(drewBuilding)
 or a
 jr nz,mainCont6
 call genBld            ;new building?
 jr mainCont5

mainCont6:
 xor a
 ld (drewBuilding),a

mainCont5:

 ld a,(inLevelCounter+1)        ;enemy ships only generated every 8 lines
 and %00000111                  ; prevents them from overlapping- sorta
 jr nz,mainCont2
 call enFormGen

mainCont2:

 ld a,(sWorld)
 cp 1
 jr z,w1Dist
 cp 2
 jr z,w2Dist

w0Dist:
 ld a,(numClouds)
 cp maxClouds
 call nz,genCloud
 jr mainCont3

w1Dist:
 call genGirder         
 jr mainCont3           
                        
w2Dist:                 
 ld a,(numSmallRocks)
 cp maxSmallRocks
 call nz,genSmallRock
 jr mainCont3           
                        
 
mainCont3:

 call incExplosionFrame


 ld a,(recharge)                ;if recharge=0 don't recharge, goto Main2
 or a
 jr z,Main2

 ld a,(rechargeCounter)         ;inc rechargeCounter
 inc a
 ld (rechargeCounter),a

 ld c,a                         ;if rechargeCounter!=rechargeCount
 ld a,(rechargeCount)           ; not time to recharge yet, goto Main2
 cp c
 jr nz,Main2

 ld a,(maxEnergy)               ;inc energy by 1
 ld c,a
 ld a,(energy)
 cp c
 jr z,resetEnergyCount
 inc a
 ld (energy),a

resetEnergyCount:
 xor a                          ;reset rechargeCounter
 ld (rechargeCounter),a

Main2:
 ld hl,scrollSpeed
 ld b,(hl)      
mainLoop:

 push bc

 ld a,(sWorld)
 cp 1
 jr z,w1DistMov
 cp 2
 jr z,w2DistMov

w0DistMov:

 ld a,(numClouds)
 or a
 call nz,moveClouds
 jr mainCont

w1DistMov:

 call moveGirder        
 jr mainCont            
                        
w2DistMov:              
 call moveSmallRocks
 jr mainCont            


mainCont:

 call drawBld           ;everything but background should be drawn over 
                        ; buildings
 ld a,(sWorld)
 cp 1
 jr z,w1DistDraw
 cp 2
 jr z,w2DistDraw

w0DistDraw:
 ld a,(numClouds)
 or a
 call nz,drawClouds
 jr maincont03

w1DistDraw:
 call drawGirder
 jr maincont03

w2DistDraw:
 ld a,(numSmallRocks)
 or a
 call nz,drawSmallRocks
 jr maincont03

maincont03:

 ld hl,inLevelCounter
 inc (hl)

 pop bc                 ;call allEnMove twice during the innerloop
 ld a,b                 ; when b (loop counter) = 1, and b=.5*scrollSpeed
 push bc
 push af
 cp 1
 call z,allEnMove
 pop af
 ld c,a
 ld a,(scrollSpeed)
 sra a
 cp c
 call z,allEnMove
  
mainCont4:


 call colDetect         ;any collisions?
 call colPEnDShots      ;any collisions b/n you and Dshots
 call colPEnSShots      ;any collisions b/n you and Sshots
 call colBld

 call KeyPress          ;Keypress?
 
 ld a,(playerInvinc)    ;decr. the invincibility counter, if >0
 or a 
 jr z,maincont06
 dec a
 ld (playerInvinc),a

 and 1                  ;only display player every 2nd frame when invincible
 jr nz,maincont05
maincont06:
 call DrawPlayer        ;Display the player, on now scrolled screen

maincont05:
  
 call MoveShots         ;move player shots up
 call DrawShots         ;draw the shots

 call addEnShots 
 call moveDShots
 call moveSShots
 call drawDShot
 call drawSShots

 call allEnDraw

 call drawExplosions

 ld a,(playerInvinc)            ;may not be the best place to put this
 or a
 jr z,maincont07
 ld a,(maxEnergy)
 ld (energy),a

maincont07:
 call chkPlayerDeath
 call chkEnShipDeath
 call chkBldDeath
 
 call drawStatBar
 call CR_GRBCopy

 ld a,(canShoot)
 or a
 jr z,maincont08
 dec a
 ld (canShoot),a
maincont08:

 call RedrawGraph       ;restores saved b/g
 pop bc
 dec b
 jp nz,mainLoop
 jp Main

;==========================================================
KeyPress:

 ld a,$FE
 out (1),a
 in a,(1)
 bit 1,a                
 call nz,MoveRight 
 bit 0,a
 call nz,MoveUp 
 bit 2,a
 call nz,MoveLeft 
 bit 3,a
 call nz,MoveDown 

 ld a,$BF
 out (1),a
 in a,(1)
 bit 5,a
 call z,Shoot
 in a,(1)
 bit 6,a
 jp z,smartBomb
 ld hl,justBomb
 ld (hl),0

 call GET_KEY
 cp G_CLEAR
 jp z,preSlide
 cp G_ENTER
 jr z,Paused
 ret

Paused:

 ld hl,$0501
 ld (CURSOR_ROW),hl
 ld hl,pauseMsg
 ROM_CALL(D_ZT_STR)

 ld hl,$0203
 ld (CURSOR_ROW),hl
 ld hl,txtScore
 ROM_CALL(D_ZT_STR)
 ld hl,(score)
 ROM_CALL(D_HL_DECI)
 ld hl,$0204
 ld (CURSOR_ROW),hl
 ld hl,livesTxt
 ROM_CALL(D_ZT_STR)
 ld a,$0C
 ld (CURSOR_COL),a
 ld a,(lives)
 add a,'0'
 ROM_CALL(TR_CHARPUT)
 ld hl,$0205
 ld (CURSOR_ROW),hl
 ld hl,sBombTxt
 ROM_CALL(D_ZT_STR)
 ld a,$0C
 ld (CURSOR_COL),a
 ld a,(numBombs)
 add a,'0'
 ROM_CALL(TR_CHARPUT)

 ld hl,$0006
 ld (CURSOR_ROW),hl
 ld hl,neededToKillTxt
 ROM_CALL(D_ZT_STR)
 ld a,(leftToKill)
 ld h,0 \ ld l,a
 ROM_CALL(D_HL_DECI)

pKey:
 ld c,0
 call GET_KEY
 or a
 jr z,pKey
 cp G_PLUS
 jr z,incCont
 cp G_MINUS
 jr z,decCont
 cp G_ENTER
 jr nz,pKey
 ret

decCont:
 ld c,-2
incCont:
 inc c
 ld a,(CONTRAST)
 add a,c
 jr z,pKey
 cp $1F
 jr z,pKey
 call changeContrast
 jr pKey

pauseMsg: .db "PAUSED",0
livesTxt: .db "Lives:",0
sBombTxt: .db "Bombs:",0
;contTxt:  .db "+/- contrast",0
;==========================================================
MoveUp:

 push af
 ld a,(yPlayer)
 cp 8
 jr z,retKey
 sub step
 ld (yPlayer),a
 pop af
 ret

MoveDown:

 push af
 ld a,(yPlayer)
 cp 54
 jr z,retKey
 add a,step
 ld (yPlayer),a
 pop af
 ret

MoveLeft:

 push af
 ld a,(xPlayer)
 cp 1
 jr z,retKey 
 sub step
 ld (xPlayer),a
 pop af
 ret

MoveRight:

 push af
 ld a,(xPlayer)
 cp 87
 jr z,retKey
 add a,step
 ld (xPlayer),a
 pop af
 ret

smartBomb:
 ld a,(justBomb)
 or a
 ret nz
 ld a,(numBombs)
 or a
 ret z
 dec a
 ld (numBombs),a
 ld b,maxEnemies
 ld hl,enemyShips+4
 ld de,5
yesBomb:
 ld a,(hl)
 sub sBombDmg
 ld (hl),a
 add hl,de
 djnz yesBomb
 ld hl,justBomb
 inc (hl)
 ret

retKey:
 pop af
 ret

Pause:                  ;bad func. name
 pop bc \ pop bc        ;clear stack
 ret


;==========================================================
Shoot:                  ; add a new shot to the list of player
                        ; shots on screen
 ld a,(canShoot)
 or a
 ret nz

 ld a,(shotPower)
 cp powerPerShot
 ret c

 sub powerPerShot
 jr nc,carryOn2
 xor a
carryOn2:
 ld (shotPower),a

 ld a,b_n_shots
 ld (canShoot),a
 
 ld hl,curShots
 ld a,(hl)              ; if maxShots already, return
 cp maxShots
 ret nc
 inc a                  ; else inc curShots
 ld (hl),a

 ld hl,PlayerShots
findShot:
 ld a,(hl)
 or a
 jr z,foundShot
 inc hl \ inc hl
 jr findShot
 
foundShot:
 ld a,(yPlayer)
 ld (hl),a
 inc hl
 ld a,(xPlayer)
 ld (hl),a
 ret

;==========================================================
MoveShots:      ;moves the player's shots up the screen

 ld de,PlayerShots
 ld b,maxShots

upShot:
 ld a,(de)
 or a
 jr z,nextShot
 cp 3
 jr c,decShot
 sub 2
 jr noDecShot

decShot:
 ld hl,curShots
 ld c,(hl)
 dec c
 ld (hl),c
 xor a

noDecShot:
 ld (de),a

nextShot:
 inc de \ inc de
 djnz upShot
 ret

;==========================================================
DrawShots:      ;draws the player's shots

 ld hl,PlayerShots
 ld b,maxShots

drawShotLoop:
 push hl
 ld a,(hl)
 or a
 jr z,nextDShot
 ld c,a
 inc hl
 ld a,(hl)
 ld de,PlayerShotSprite
 push bc
 call DrawSprite
 pop bc

nextDShot:
 pop hl
 inc hl \ inc hl
 djnz drawShotLoop
 ret

;==========================================================
enFormGen:

 ld a,(numEnemyShips)
 ld c,a
 ld a,maxEnemies
 sub c
 ret z

 bit 4,a
 jr z,cont01
 ld a,8

cont01:
 ld b,a
 ld hl,enemyShips

enGenLoop:
 call RAND
 ld c,a
 ld a,(shipFreq)
 and c
 jr nz,nextEnGen
 ld d,0 \ ld e,5
enGenFind:
 ld a,(hl)
 or a
 jr z,enGenFound
 add hl,de
 jr enGenFind
enGenFound:
 push hl
 call whichEnGen
 pop hl

 or a
 jr z,nextEnGen
 ld (hl),a              ;'type' of enemy
 inc hl

 bit 4,a                ;if ship follows a path, set (x,y) to (1,0) for now
 jr z,noPath
 ld (hl),1;0
 inc hl
 bit 5,a
 jr z,posXGen
negXGen:
 ld (hl),90
 jr contPathGen
posXGen:
 ld (hl),1
contPathGen:
 inc hl
 ld (hl),d
 inc hl
 ld (hl),e
 ld hl,numEnemyShips
 inc (hl)
 ret                    ; at most 1 ship is generated if it has path movement

noPath:
 ld (hl),1              ; starting y-pos of down-moving ship
 bit 5,a
 jr z,cont02
 ld (hl),63             ; starting y-pos of up-moving ship
 
cont02:
 inc hl
 cp 11                  ;different xpos for ships 11-15 (1x2,2x2)
 jr nc,wideX

narrowX:
 call RAND      ;x-position of enemy ship
 and %00111111
 ld c,a
 call RAND
 and %00011111
 add a,c
 and %11111000
 jr contEnGen

wideX:
 call RAND      ;x-position of enemy ship
 and %00111111
 ld c,a
 call RAND
 and %00011111
 add a,c
 and %11110000
           
contEnGen:

 ld (hl),a
contEnGen2:
 inc hl
 ld (hl),d
 inc hl
 ld (hl),e
 inc hl

 ld a,(numEnemyShips)
 inc a
 ld (numEnemyShips),a
 
nextEnGen:
 djnz enGenLoop
 ret

;==========================================================
whichEnGen:

 ld de,listMem
 ld a,(de) \ ld h,a
 inc de
 ld a,(de) \ ld l,a
 ld a,(enPos)           ;add offset
 ld d,0 \ ld e,a
 add hl,de
 push hl
       
 inc hl
 ld a,(hl)              ;TYPE
 inc hl
 ld d,(hl)              ;DMG
 inc hl
 ld e,(hl)              ;HP
 pop hl
 push af

 ld a,(enCounter)
 dec a
 jr nz,whichCont
 
 push de
 ld a,(enPos)
 add a,4
 ld (enPos),a
 ld d,0 \ ld e,4
 add hl,de
 ld a,(hl)
 pop de

 cp 255                 ;if number=255 then the level has ended.
 jr z,levelEnd

whichCont:
 ld (enCounter),a
 pop af
 ret
     
;==========================================================
levelEnd:       ;checks if goal has been achieved and sets vars accordingly

 pop bc \ pop bc        ;clear up ye olde stack
 pop bc \ pop bc
 ld a,(leftToKill)
 or a
 jr z,nextLevel
 ld hl,$0006
 ld (CURSOR_ROW),hl
 ld hl,neededToKillTxt
 ROM_CALL(D_ZT_STR)
 ld a,(leftToKill)
 ld h,0 \ ld l,a
 ROM_CALL(D_HL_DECI)
 ld hl,lostLvl
 jr backToBrief

nextLevel:
 ld a,(sLevel)
 inc a                 
 and %00000011         
 ld c,a
 jr nz,sameWorld
 ld a,(sWorld)
 inc a
 cp 3
 ld (sWorld),a
 jr z,gameFinished             ;jumps if the last level of the last world was
                               ; just completed
sameWorld:
 ld a,c
 ld (sLevel),a

 ld hl,(score)                 ;update the saved score 
 ld (savedScore),hl
 ld hl,wonLvl

backToBrief:
backWait:
 push hl
 ld hl,$0402
 ld (CURSOR_ROW),hl
 pop hl
 ROM_CALL(D_ZT_STR)
 push hl
 ld hl,$0303
 ld (CURSOR_ROW),hl
 pop hl
 ROM_CALL(D_ZT_STR)
backKey:
 call GET_KEY
 cp G_ENTER
 jr nz,backKey

 jp slideOut

gameFinished:           ;all levels completed

 ld hl,0
 ld (CURSOR_ROW),hl
 ld hl,endTxt1
 ROM_CALL(D_ZT_STR)

tmp:
 call GET_KEY
 or a
 jr z,tmp

 ROM_CALL(CLEARLCD)
 ld hl,0
 ld (CURSOR_ROW),hl
 ld hl,endTxt8
 ROM_CALL(D_ZT_STR)
 ld hl,(score)
 ROM_CALL(D_HL_DECI)

tmp2:
 call GET_KEY
 or a
 jr z,tmp2

 xor a
 ld (name),a
 jp start

endTxt1: .db "Congratulations!"
endTxt2: .db "You have managed"
endTxt3: .db "to overthrow "
endTxt4: .db "theevil forces."
endTxt5: .db "Your people can"
endTxt6: .db " now live in"
endTxt7: .db " peace.",0
endTxt8: .db "Your final"
endTxt9: .db " score was:",0

;==========================================================
allEnMove:

 ld b,maxEnemies
 ld hl,enemyShips
 ld de,5

enMoveLoop:

 ld a,(hl)
 or a
 jr z,nextEnMove

contEnMove:
 bit 4,a
 jr nz,enPathMove
 bit 5,a
 jr nz,enMoveUp

enMoveDown:
 inc hl
 ld a,(hl)
 inc a
 ld (hl),a
 dec hl
 or a
 cp 71;63               ;71 to accomodate the 2x1 and 2x2 ships
 jr nz,nextEnMove
 jr enMoveClear

enMoveUp:
 inc hl
 ld a,(hl)
 dec a
 ld (hl),a
 dec hl
 or a
 jr nz,nextEnMove
enMoveClear:
 ld (hl),0
 ld a,(numEnemyShips)
 dec a
 ld (numEnemyShips),a
 
nextEnMove:
 add hl,de
 djnz enMoveLoop
 ret

enPathMove:
 inc hl \ inc hl
 bit 5,a
 jr z,posX
negX:
 dec (hl)
 jr contPathMv
posX:
 inc (hl)
contPathMv:
 ld c,a
 ld a,(hl)
 push hl \ push de

 bit 0,c                        ;gets to correct path for this ship
 jr z,ship4Path
ship5Path:
 bit 5,c
 jr z,s5PathP
 ld hl,enPath0
 jr PathSet
s5PathP:
 ld hl,enPath1
 jr PathSet
ship4Path:
 bit 5,c
 jr z,s4PathP
 ld hl,enPath2
 jr PathSet
s4PathP:
 ld hl,enPath3
 
PathSet:
 ld d,0 \ ld e,a
 add hl,de
 ld a,(hl)
 pop de \ pop hl
 dec hl
 ld (hl),a
 dec hl
 cp 255
 jr z,enMoveClear
 jr nextEnMove

;==========================================================
allEnDraw:              ;don't let 2x1 or 2x2 ships travel up the screen!
                        ; won't draw correctly
 ld b,maxEnemies
 ld hl,enemyShips

enDrawLoop:
 ld a,(hl)
 and %00001111
 jp z,nextEnDraw
 bit 3,a
 jp z,draw1x1

drawLargeEn:
 cp 13
 jr nc,draw2x2
 cp 11
 jr nc,draw1x2

draw2x1:                
 push hl                
 sub 8                  
 add a,a \ add a,a
 add a,a \ add a,a   
 ld hl,ships2x1
 ld d,0 \ ld e,a
 add hl,de
 ld d,h \ ld e,l
 pop hl \ push hl
 push de
 inc hl
 ld a,(hl)
 inc hl
 ld c,(hl)
 push af
 sub 8
 jr c,bot2x1

top2x1:
 ld h,c \ ld c,a
 ld a,h
 push bc
 call DrawSprite
 pop bc

bot2x1:
 pop af \ pop de \ pop hl
 cp 63
 jr nc,doneDraw2x1

 push hl
 inc hl
 ld c,(hl)
 inc hl
 ld a,(hl)
 ld hl,8
 add hl,de
 ld d,h \ ld e,l
 push bc
 call DrawSprite
 pop bc
 pop hl

doneDraw2x1:
 jp nextEnDraw


draw1x2:
 sub 11   
 jr z,cont1x2a
 ld a,16
cont1x2a:
 push hl
 ld hl,ships1x2
 ld d,0 \ ld e,a
 add hl,de
 ld d,h
 ld e,l
 pop hl

 inc hl
 ld c,(hl)
 inc hl
 ld a,(hl)
 push hl \ push bc \ push af
 call DrawSprite
 pop af \ pop bc
 add a,8
 push bc
 call DrawSprite
 pop bc \ pop hl
 dec hl \ dec hl               
 jp nextEnDraw          

draw2x2:                ;SLOOOOW, can optimise?
 push hl
 sub 13
 add a,a \ add a,a            
 add a,a \ add a,a
 add a,a    

 ld d,0 \ ld e,a
 ld hl,ships2x2
 add hl,de
 ld d,h \ ld e,l
 pop hl \ push hl
 push de
 inc hl
 ld a,(hl)
 inc hl
 ld c,(hl)
 push af
 sub 8
 jr c,bot2x2

top2x2:
 ld h,c \ ld c,a
 ld a,h
 push de \ push bc \ push af
 call DrawSprite
 pop af \ pop bc \ pop de
 ld hl,8
 add hl,de
 ld d,h \ ld e,l
 add a,8
 push bc \ push af \ push de
 call DrawSprite
 pop de \ pop af \ pop bc


bot2x2:
 pop af \ pop de \ pop hl
 cp 63
 jr nc,done2x2

 push hl
 inc hl
 ld c,(hl)
 inc hl
 ld a,(hl)
 ld hl,16
 add hl,de
 ld d,h \ ld e,l
 push de \ push bc \ push af
 call DrawSprite
 pop af \ pop bc \ pop de
 ld hl,8
 add hl,de
 ld d,h \ ld e,l
 add a,8
 push bc \ push af \ push de
 call DrawSprite
 pop de \ pop af \ pop bc
 pop hl

done2x2:
 jr nextEnDraw


draw1x1:                ;the quick and easy one :)
 dec a
 add a,a \ add a,a
 add a,a
 push hl
 ld hl,ships1x1
 ld d,0 \ ld e,a
 add hl,de
 ld d,h
 ld e,l
 pop hl

 inc hl
 ld c,(hl)
 inc hl
 ld a,(hl)
 push bc \ push hl
 call DrawSprite
 pop hl \ pop bc
 dec hl \ dec hl               


nextEnDraw:
 ld d,0 \ ld e,5
 add hl,de
 dec b
 jp nz,enDrawLoop
 ret

;==========================================================
genBld:

 ld a,(numBuildings)
 cp maxBuildings
 ret z
 ld a,(maxBld)
 ld c,a
 ld a,(numBld)
 cp c
 ret z

 call RAND
 ld c,a
 ld a,(buildFreq)
 and c
 ret nz

 ld hl,buildings
 ld de,4
findBuild:
 ld a,(hl)
 or a
 jr z,foundBuild
 add hl,de
 jr findBuild

foundBuild:

 ld a,(buildType)
 ld (hl),a      
 inc hl
 ld (hl),0
 inc hl
 call RAND      ;x-position of build
 and %00111111
 ld c,a
 call RAND
 and %00011111
 add a,c
 and %11110000
 ld (hl),a
 inc hl
 ld a,(buildHp)
 ld (hl),a              ;hp
 ld a,(numBuildings)
 inc a
 ld (numBuildings),a
 ld (drewBuilding),a
 ld hl,numBld
 inc (hl)
 ret

;==========================================================
moveBld:

 ld b,maxBuildings
 ld hl,buildings
 ld de,4

movBldLp:
 ld a,(hl)
 or a
 jr z,nxtMovBldLp

 inc hl
 ld a,(hl)
 inc a
 ld (hl),a
 dec hl
 cp 71
 jr nz,nxtMovBldLp
 ld (hl),0
 ld a,(numBuildings)
 dec a
 ld (numBuildings),a

nxtMovBldLp:
 add hl,de
 djnz movBldLp
 ret 

;==========================================================
drawBld:                ;get rid of ridiculous "bldSpritePut" func.
                        ; integrate it with the one that draws the clouds
 ld hl,buildings
 ld b,maxBuildings

drawBldLp:

 ld a,(hl)
 or a
 jr z,nxtDrawBldLp

bldDrw:

 push bc
 push hl
 ld hl,bld16x16
 dec a
 add a,a \ add a,a  
 add a,a \ add a,a
 add a,a 
 ld d,0 \ ld e,a
 add hl,de
 ld d,h \ ld e,l
 pop hl \ push hl
 push de
 inc hl
 ld a,(hl)
 sub 8
 jr c,bldBot

bldTop:
 ld c,a
 inc hl
 ld a,(hl)
 push de \ push bc \ push af
 call bldSpritePut
 pop af \ pop bc \ pop de
 add a,8
 ld hl,8
 add hl,de
 ld d,h \ ld e,l
 call bldSpritePut
 
bldBot:
 pop de
 ld hl,16
 add hl,de
 ld d,h \ ld e,l
 pop hl \ push hl
 inc hl
 ld a,(hl)
 cp 63
 jr nc,doneDrwBld

 ld c,a
 inc hl
 ld a,(hl)
 push de \ push af \ push bc
 call bldSpritePut
 pop bc \ pop af \ pop de
 add a,8
 ld hl,8
 add hl,de
 ld d,h \ ld e,l
 call bldSpritePut

doneDrwBld:
 pop hl
 pop bc

nxtDrawBldLp:
 ld de,4
 add hl,de
 djnz drawBldLp
 ret

bldSpritePut:
 ld hl,0                ;get to the right line
 ld b,0
 add hl,bc              ;mult. by 12
 add hl,bc
 add hl,bc
 add hl,hl
 add hl,hl

 ld c,a                 
 sra c \ sra c \ sra c
 add hl,bc
 ld bc,GRAPH_MEM
 add hl,bc              ;hl contains the location of the sprite
 ld b,8

bldSPutlp:
 ld a,(de)
 ld (hl),a
 inc de
 push bc
 ld bc,12
 add hl,bc
 pop bc
 djnz bldSPutlp
 ret


;==========================================================
addEnShots:

 ld hl,enemyShips
 ld b,maxEnemies

addEnShotsLp:
 push bc
 ld a,(hl)
 or a
 jr z,nxtAddEnShots

 bit 6,a
 jr z,nxtAddEnShots
 call RAND
 ld c,a
 ld a,(shotFreq)
 and c
 push hl
 call z,whichEnShots
 pop hl
 
nxtAddEnShots:
 pop bc
 ld d,0 \ ld e,5
 add hl,de
 djnz addEnShotsLp
 ret 

;==========================================================
whichEnShots:           ;determines which shot funcs. to call for
                        ; a particular ship
 ld a,(hl)
 and %00001111
 cp 4
 jr c,ss1_2_3
 cp 6
 jp c,ss4_5
 jp z,ss6
 cp 8
 jp c,ss7
 jp z,ss8
 cp 12
 jp c,ss9
 jp z,ss12
 cp 14
 jp c,ss13
 jp z,ss14

ss15:
 ld ix,dShotTemp
 inc hl
 ld a,(hl)
 ld (ix+0),a
 ld (ix+1),1
 inc hl
 ld a,(hl)
 ld (ix+2),a
 inc hl
 ld a,(hl)
 ld (ix+3),a
 push ix
 call addDshot
 pop ix
 ld a,(ix+2)
 add a,14
 ld (ix+2),a
 push ix
 call addDshot
 pop ix
 inc (ix+0)
 ld a,(ix+2)
 sub 7
 ld (ix+2),a
 call addDshot
 ret
 
ss1_2_3:
 ld ix,dShotTemp
 ld c,1
 cp 2
 jr nz,down1_2_3
 ld c,-1                        ;c is direction of shot 
down1_2_3:
 inc hl
 ld a,(hl)
 ld (ix+0),a
 ld (ix+1),c
 inc hl
 ld a,(hl)
 add a,3
 ld (ix+2),a
 inc hl
 ld a,(hl)
 ld (ix+3),a
 call addDshot
 ret

ss4_5:
 ld de,sShotTemp
 ld bc,3
 inc hl
 ldir
 call addSShot
 ret

ss6:
 ld ix,dShotTemp
 inc hl
 ld a,(hl)
 ld (ix+0),a
 ld (ix+1),1
 inc hl
 ld a,(hl)
 ld (ix+2),a
 inc hl
 ld a,(hl)
 ld (ix+3),a
 push ix
 call addDshot
 pop ix
 ld a,(ix+2)
 add a,6
 ld (ix+2),a
 call addDshot
 ret

ss7:
 ld ix,dShotTemp
 inc hl
 ld a,(hl)
 ld (ix+0),a
 ld (ix+1),-1
 inc hl
 ld a,(hl)
 ld (ix+2),a
 inc hl
 ld a,(hl)
 ld (ix+3),a
 push ix
 call addDshot
 pop ix
 ld a,(ix+2)
 add a,5
 ld (ix+2),a
 push ix
 call addDshot
 pop ix
 ld a,(ix+2)
 sub 3
 ld (ix+2),a
 ld (ix+1),1
 call addDshot
 ret

ss8:
 ld ix,dShotTemp
 inc hl
 ld a,(hl)
 ld (ix+0),a
 ld (ix+1),1
 inc hl
 ld a,(hl)
 add a,3
 ld (ix+2),a
 inc hl
 ld a,(hl)
 ld (ix+3),a
 call addDshot
 ret

ss9:
 ld ix,dShotTemp
 inc hl
 ld a,(hl)
 sub 8
 ld (ix+0),a
 ld (ix+1),1
 inc hl
 ld a,(hl)
 dec a
 ld (ix+2),a
 inc hl
 ld a,(hl)
 ld (ix+3),a
 push ix
 call addDshot
 pop ix
 ld a,(ix+2)
 add a,8
 ld (ix+2),a
 call addDshot
 ret
 
ss12:
 ld ix,sShotTemp
 inc hl
 ld a,(hl)
 add a,2
 ld (ix+0),a
 inc hl
 ld a,(hl)
 add a,8
 ld (ix+1),a
 inc hl
 ld a,(hl)
 ld (ix+2),a
 call addSShot
 ret
 
ss13:
 ld ix,sShotTemp
 inc hl
 ld a,(hl)
 ld (ix+0),a
 inc hl
 ld a,(hl)
 add a,8
 ld (ix+1),a
 inc hl
 ld a,(hl)
 ld (ix+2),a
 call addSShot
 ret

ss14:
 ld ix,dShotTemp
 inc hl
 ld a,(hl)
 ld (ix+0),a
 ld (ix+1),1
 inc hl
 ld a,(hl)
 ld (ix+2),a
 inc hl
 ld a,(hl)
 ld (ix+3),a
 push ix
 call addDshot
 pop ix
 ld a,(ix+2)
 add a,14
 ld (ix+2),a
 push ix
 call addDshot
 pop ix
 inc (ix+0)
 ld a,(ix+2)
 sub 3
 ld (ix+2),a
 push ix
 call addDshot
 pop ix
 ld a,(ix+2)
 sub 8
 ld (ix+2),a
 call addDshot
 ret

;==========================================================
addDshot:

 ld hl,numDShots
 ld a,(hl)
 cp maxDShots
 ret z
 inc (hl)
 ld hl,dShots
 ld de,4
findDShot:
 ld a,(hl)
 or a
 jr z,foundDShot
 add hl,de
 jr findDShot

foundDShot:
 ld d,h \ ld e,l
 ld hl,dShotTemp
 ld bc,4
 ldir
 ret

;==========================================================
addSShot:               ;CURRENTLY INEFFICIENT, IN TERMS OF SPACE.
                        ; EACH RECORD REQUIRES 9 BYTES, CAN BE REDUCED TO 6.

 ld hl,numSShots
 ld a,(hl)
 cp maxSShots
 ret z
 inc (hl)
 ld hl,sShots
 ld de,9

findSShot:
 ld a,(hl)
 or a
 jr z,foundSShot
 add hl,de
 jr findSShot

foundSShot:

 ld d,h \ ld e,l
 ld hl,sShotTemp
 ld a,(hl)                         
 ld c,a
 ld (de),a                       
 inc hl \ inc de
 ld a,(hl)
 ld b,a                 ;b and c contain x and y pos of firing enemy
 ld (de),a
 inc hl \ inc de        ;dmg, major axis
 push hl
 push de
 ld de,$0101

 ld a,(xPlayer)
 add a,3
 sub b
 bit 7,a
 jr z,abs1
 neg      
 ld d,$FF
 
abs1:
 ld h,a    
 ld a,(yPlayer)         ;h = |(xPlayer-xEnemyShip)|, d=1 if h was -ve
 add a,4
 sub c                  ;l = |(yPlayer-yEnemyShip)|, e=1 if l was -ve
 bit 7,a                ; ie. h,l =1 if path from enemy to player in +ve dir'n
 jr z,abs2
 neg
 ld e,$FF

abs2:
 ld l,a
 ld b,d
 ld c,e
 pop de
 ld a,h
 cp l                                   
 jr nc,setXMajor

setYMajor:
 ld a,1
 ld (de),a
 inc de
 ld a,c
 ld (de),a
 inc de
 ld a,b
 ld (de),a
 inc de
 ld a,h
 ld (de),a
 inc de
 ld a,l
 ld (de),a
 jr cont08

setXMajor:
 xor a
 ld (de),a
 inc de
 ld a,b
 ld (de),a
 inc de
 ld a,c
 ld (de),a
 inc de
 ld a,l
 ld (de),a
 inc de
 ld a,h
 ld (de),a

cont08:
 pop hl
 inc de
 xor a
 ld (de),a
 inc de
 ld a,(hl)      ;dmg
 ld (de),a
 ret

;==========================================================
moveSShots:

 ld hl,sShots
 ld b,maxSShots

mvSShotsLp:

 push bc
 ld a,(hl)
 or a
 jp z,nxtMvSShot
 push hl
 inc hl \ inc hl
 ld a,(hl)
 or a
 jr z,xMaj

yMaj:
 inc hl
 ld c,(hl)
 pop hl \ push hl
 ld a,(hl)
 add a,c
 jr z,clearSShot
 cp 63
 jr c,contMvSShotY
 jr clearSShot

contMvSShotY:
 ld (hl),a
 inc hl \ inc hl
 inc hl \ inc hl
 ld c,(hl)                              ;min. dir'n
 inc hl
 ld d,(hl)                              ;min. length
 inc hl
 ld e,(hl)                              ;maj. length
 inc hl
 ld a,(hl)                              ;remainder (running tally)
 add a,d
 cp e
 jr c,noXMov
 sub e
 ld (hl),a
 pop hl \ push hl
 inc hl 
 ld a,(hl)
 add a,c
 ld (hl),a
 cp 87
 jr c,Xcont

 pop hl \ push hl
 ld (hl),0
 ld a,(numSShots)
 dec a
 ld (numSShots),a
 jr Xcont

noXMov:
 ld (hl),a

Xcont:
 pop hl
 jr nxtMvSShot

xMaj:
 inc hl
 ld c,(hl)
 pop hl \ push hl
 inc hl
 ld a,(hl)
 add a,c
 cp 87
 jr c,contMvSShotX
 jr clearSShot

contMvSShotX: 
 ld (hl),a    
 inc hl \ inc hl \ inc hl
 ld c,(hl)                              ;min. dir'n
 inc hl
 ld d,(hl)                              ;min. length
 inc hl
 ld e,(hl)                              ;maj. length
 inc hl
 ld a,(hl)                              ;remainder (running tally)
 add a,d
 cp e
 jr c,noYMov
 sub e
 ld (hl),a
 pop hl \ push hl
 ld a,(hl)
 add a,c
 jr z,clearSShot
 ld (hl),a
 cp 63
 jr c,Ycont
 pop hl \ push hl
 ld (hl),0
 ld a,(numSShots)
 dec a
 ld (numSShots),a
 jr Ycont

noYMov:
 ld (hl),a

Ycont:
 pop hl
 
nxtMvSShot:
 ld de,9
 add hl,de
 pop bc
 dec b
 jp nz,mvSShotsLp
 ret

clearSShot:
 pop hl
 ld (hl),0
 ld a,(numSShots)
 dec a
 ld (numSShots),a
 jr nxtMvSShot


drawSShots:

 ld hl,sShots
 ld b,maxSShots

drwSShotLp:
 ld a,(hl)
 or a
 jr z,nxtDrwSShotLp
 push hl
 ld c,a
 inc hl
 ld a,(hl)
 ld de,enemySShotSprite
 push bc
 call DrawSprite
 pop bc
 pop hl

nxtDrwSShotLp:
 ld de,9
 add hl,de
 djnz drwSShotLp
 ret

;==========================================================

moveDShots:

 ld hl,dShots
 ld b,maxDShots
 ld d,0 \ ld e,4

mvDShotsLp:
 ld a,(hl)
 or a 
 jr z,nxtMvDShotLp
 push hl
 inc hl
 ld c,(hl)
 add a,c
 cp 64
 jr nc,decNumDShot
 cp 0
 jr z,decNumDShot
cont05:
 pop hl
 ld (hl),a
nxtMvDShotLp:
 add hl,de
 djnz mvDShotsLp
 ret
decNumDShot:
 ld a,(numDShots)
 dec a
 ld (numDShots),a
 xor a
 jr cont05
drawDShot:
 ld hl,dShots
 ld b,maxDShots
drawDShotLp:
 ld a,(hl)
 or a
 jr z,nxtDrawDShotLp
 push hl \ push bc
 ld c,a
 inc hl \ inc hl
 ld a,(hl)
 ld de,enemyDShotSprite
 call DrawSprite
 pop bc \ pop hl
nxtDrawDShotLp:
 ld d,0 \ ld e,4
 add hl,de
 djnz drawDShotLp
 ret


;==========================================================
addExplosion:           ;(adds an explosion at (d,e) to memory)

 ld a,(numExplosions)
 cp maxExplosions
 ret z
 ld hl,explosions
 ld b,maxExplosions

findExPos:
 ld a,(hl)
 or a
 jr z,foundExPos
 inc hl \ inc hl \ inc hl
 jr findExPos

foundExPos:
 ld a,(numExplosions)
 inc a
 ld (numExplosions),a
 ld (hl),e
 inc hl
 ld (hl),d
 inc hl
 ld (hl),0
 ret

;==========================================================
incExplosionFrame:

 ld b,maxExplosions
 ld hl,explosions

iExpFrLp1:
 push hl
 ld a,(hl)
 or a
 jr z,nxtIExpFrLp1
 inc hl \ inc hl
 ld a,(hl)
 cp explosionFrames
 jr nz,nxtIExpFrLp1
 dec hl \ dec hl
 ld (hl),0
 ld a,(numExplosions)    ;dec numExplosions
 dec a
 ld (numExplosions),a
nxtIExpFrLp1:
 pop hl
 inc hl \ inc hl
 ld a,(hl)
 inc a
 ld (hl),a
 inc hl
 djnz iExpFrLp1
 ret

;==========================================================
drawExplosions:

 ld b,maxExplosions
 ld hl,explosions

drwExpLp1:
 push bc \ push hl
 ld a,(hl)
 or a
 jr z,nxtDrwExpLp1
 ld c,a
 inc hl
 ld a,(hl)
 inc hl
 ld e,(hl)
 sla e \ sla e \ sla e
 ld d,0
 ld hl,smallExplosion
 add hl,de
 ld d,h
 ld e,l
 call DrawSprite
nxtDrwExpLp1:
 pop hl \ pop bc
 inc hl \ inc hl \ inc hl
 djnz drwExpLp1
 ret

;==========================================================
;==========================================================
TopLine:

 ld hl,TileMap
 ld b,12
 ld de,GRAPH_MEM
 
TLoop:
 push bc
 push hl
 ld a,(hl)      ;get to the byte needed
 ld b,0
 ld c,a
 ld hl,Tiles    
 add hl,bc      ;hl points to start of the tile
 ld a,(count)   
 ld b,0
 ld c,a
 add hl,bc      ;hl points to current byte in the tile
 ld a,(hl)      ;plot the byte in mem
 ld (de),a
 pop hl         ;next col
 pop bc
 inc de
 inc hl
 djnz TLoop
 ld a,(count)     ;go to next row of sprite
 or a
 jr nz,decCount
 call GenNext     ;if a=0, generate the next row of the tilemap
 ld a,8           ;let count=7 

decCount:
 dec a
 ld (count),a
 ret

;==========================================================
GenNext:

 ld hl,TileMap
 ld b,12
 ld a,(sWorld)
 cp 1
 jr z,GenLoop1
 cp 2
 jr z,GenLoop2

;== world0      -planet surface: grass and basic top-down, circular 'trees'
GenLoop0:
 call RAND
 and %00000011          ; pick from tiles 8*(0-3)
 jr z,genContA0
 xor a
 jr genContB0
genContA0:
 ld a,8
genContB0:
 ld (hl),a
 inc hl
 djnz GenLoop0
 ret

;== world1      -inside a space dock: metal plated floors, hazard line sides
GenLoop1:       ;-also large metal plates, and grilles (possibly INCOMPLETE!)

 ld a,b
 cp 12
 jr z,genSetSide1
 cp 1
 jr z,genSetSide1
 ld a,(hl)
 cp 56
 jr z,metalPlate1
 call RAND
 and %00011111
 jr z,genMetalPlate1
 call RAND
 and %00011111
 jr z,genGrille1
 ld (hl),16
 inc hl
 ld (hl),24
 inc hl
 dec b
 djnz GenLoop1
 ret
genGrille1:
 ld (hl),40
 inc hl
 ld (hl),48
 inc hl
 dec b
 djnz GenLoop1
 ret
genMetalPlate1:
 ld (hl),56
 inc hl
 ld (hl),64
 inc hl
 dec b
 djnz GenLoop1
 ret
metalPlate1:
 ld (hl),72
 inc hl
 ld (hl),80
 inc hl
 dec b
 djnz GenLoop1
 ret

genSetSide1:
 ld (hl),32
 inc hl
 djnz GenLoop1
 ret

;== world2      - space; a moving "random" starscape with mini space rocks
GenLoop2:       

 call RAND
 and %00000011
 add a,a \ add a,a \ add a,a
 add a,88
 ld (hl),a
 inc hl
 djnz GenLoop2
 ret
   

;==========================================================
colDetect:             

 ld b,maxShots          ;check for collision b/n player's shots 
 ld hl,PlayerShots      ; and enemy ships

colLoop1:
 push bc
 ld a,(hl)
 or a
 jr z,colNext1a
 ld e,a
 inc hl
 ld d,(hl)
 inc hl
 push hl
 ld b,maxEnemies
 ld hl,enemyShips

colLoop2:
 push bc
 ld a,(hl)
 or a
 jr z,colNext2
 inc hl
 ld c,(hl)
 inc hl
 ld b,(hl)
 dec hl \ dec hl        
 call colTester
 or a
 jr nz,colNext2

 inc hl \ inc hl
 inc hl \ inc hl
 ld a,(hl)
 dec a
 ld (hl),a

 pop bc \ pop hl        ;clear player shot
 dec hl \ dec hl
 ld (hl),0
 ld a,(curShots)        ; dec number of player shots on screen
 dec a
 ld (curShots),a

 jr colNext1a
 
colNext2:

 inc hl \ inc hl
 inc hl \ inc hl
 inc hl
 pop bc
 djnz colLoop2

colNext1b:
 pop hl
 pop bc
 djnz colLoop1
 ret

colNext1a:

 pop bc
 inc hl \ inc hl
 djnz colLoop1


colPEn:                 ;check for collision b/n player and enemy ships

 ld b,maxEnemies
 ld a,(xPlayer)
 ld d,a
 ld a,(yPlayer)
 ld e,a
 ld hl,enemyShips

colPEnLp1:
 ld a,(hl)
 or a
 jr z,nxtColPEnLp1
 push bc
 inc hl
 ld c,(hl)
 inc hl
 ld b,(hl)
 dec hl
 dec hl
 call colTester
 or a
 pop bc
 jr nz,nxtColPEnLp1

 push hl
 inc hl \ inc hl
 inc hl \ inc hl
 ld (hl),0

 pop hl
 inc hl \ inc hl
 inc hl
 ld c,(hl)
 dec hl \ dec hl
 dec hl
 ld a,(energy)
 sub c
 ld (energy),a
    
nxtColPEnLp1:

 inc hl \ inc hl
 inc hl \ inc hl
 inc hl
 djnz colPEnLp1
 ret
        

colBld:         ;collision b/n player's shot and buildings

 ld hl,buildings        ;faster this way hopefully, because fewer buildings
 ld b,maxBuildings        ; than player shots usually

colBldLp:
 ld a,(hl)
 or a
 jr z,nxtColBldLp       ;no bld entry
 cp 1
 jr z,nxtColBldLp

 push bc
 push hl
 inc hl
 ld e,(hl)
 inc hl
 ld d,(hl)
 push de
 ld hl,PlayerShots
 ld a,maxShots

inColBldLp:
 push af
 ld a,(hl)
 or a
 jr z,noShotBld         
 ld e,a
 pop af
 inc hl
 ld d,(hl)
 inc hl
 pop bc \ push bc
 push af
 ld a,$0F               ;any value sufficiently high to cause colTester
 call colTester       ; to switch to 16x16 mode detection
 or a
 jr z,hitBld
 jr noHitBld

noShotBld:
 inc hl \ inc hl

noHitBld:
 pop af
 dec a
 jr nz,inColBldLp
 pop bc
 pop hl \ pop bc
 jr nxtColBldLp

hitBld:
 pop af
 pop bc
 dec hl \ dec hl
 ld (hl),0              ;clear player shot
 ld a,(curShots)
 dec a
 ld (curShots),a
 pop hl \ push hl
 inc hl \ inc hl
 inc hl
 ld a,(hl)
 dec a                  ; dec buildings hp
 ld (hl),a
 pop hl \ pop bc

nxtColBldLp:
 ld de,4
 add hl,de
 djnz colBldLp
 ret

;==========================================================
colTester:      ;checks collision b/n 8x8 sprite and 8x8->16x16
                ; sprite at (d,e) and (b,c) respectively, and defined by a

 push de                       
 push af                       
 ld a,d \ add a,50 \ ld d,a    
 ld a,e \ add a,50 \ ld e,a     
 ld a,b \ add a,50 \ ld b,a    
 ld a,c \ add a,50 \ ld c,a    
 pop af                        
                               
 and %00001111
 cp 8
 jr c,col8x8
 cp 11
 jr c,col8x16
 cp 13
 jr c,col16x8

col16x16:
 ld a,d
 sub 15
 cp b
 jr nc,colTstrMs
 add a,22
 cp b
 jr c,colTstrMs
 ld a,c
 sub 15;7
 cp e
 jr nc,colTstrMs
 add a,22
 cp e
 jr c,colTstrMs
 jr colTstrHt

col16x8:
 ld a,d
 sub 15
 cp b
 jr nc,colTstrMs
 add a,22
 cp b
 jr c,colTstrMs

 ld a,c
 sub 7
 cp e
 jr nc,colTstrMs
 add a,14
 cp e
 jr c,colTstrMs
 jr colTstrHt

col8x16:
 ld a,d
 sub 7
 cp b
 jr nc,colTstrMs
 add a,14
 cp b
 jr c,colTstrMs
 ld a,c
 sub 15;7
 cp e
 jr nc,colTstrMs
 add a,22
 cp e
 jr c,colTstrMs
 jr colTstrHt
 
col8x8:
 ld a,d
 sub 7
 cp b
 jr nc,colTstrMs
 add a,14
 cp b
 jr c,colTstrMs
 ld a,c
 sub 7
 cp e
 jr nc,colTstrMs
 add a,14
 cp e
 jr c,colTstrMs

colTstrHt:              ;return a=0 on a hit
 xor a
 pop de
 ret
colTstrMs:
 ld a,1
 pop de                 ;result of the crap above
 ret


;==========================================================
colPEnDShots:                    

 ld a,(xPlayer) \ ld d,a
 ld a,(yPlayer) \ ld e,a
 ld hl,dShots
 ld b,maxDShots

colPEnDShotsLp:
 push hl
 ld a,(hl)
 or a
 jr z,nxtColPEnDShotsLp

 sub e
 bit 7,a
 jr z,cont06
 neg

cont06:
 cp 7
 jr nc,nxtColPEnDShotsLp
 inc hl \ inc hl
 ld a,(hl)
 inc a
 cp d
 jr c,nxtColPEnDShotsLp
 sub 8
 cp d
 jr nc,nxtColPEnDShotsLp

 ld a,(numDShots)
 dec a
 ld (numDShots),a

 inc hl
 ld c,(hl)
 ld a,(energy)
 sub c
 ld (energy),a

 pop hl \ push hl
 ld (hl),0

nxtColPEnDShotsLp:

 pop hl
 inc hl \ inc hl
 inc hl \ inc hl
 djnz colPEnDShotsLp
 ret


;==========================================================
colPEnSShots:                    

 ld a,(xPlayer) \ ld d,a
 ld a,(yPlayer) \ ld e,a
 ld hl,sShots
 ld b,maxSShots

colPEnSShotsLp:

 push hl
 ld a,(hl)
 or a
 jr z,nxtColPEnSShotsLp

 sub 8
 cp e
 jr nc,nxtColPEnSShotsLp

 ld a,(hl)
 add a,4
 cp e
 jr c,nxtColPEnSShotsLp
 inc hl
 ld a,(hl)
 sub 8
 cp d
 jr nc,nxtColPEnSShotsLp

 ld a,(hl)
 add a,4
 cp d
 jr c,nxtColPEnSShotsLp

 ld a,(numSShots)
 dec a
 ld (numSShots),a
 
 push bc \ ld bc,7
 add hl,bc \ pop bc

 ld c,(hl)
 ld a,(energy)
 sub c
 ld (energy),a

 pop hl \ push hl
 ld (hl),0

nxtColPEnSShotsLp:

 pop hl
 push bc \ ld bc,9
 add hl,bc \ pop bc
 djnz colPEnSShotsLp
 ret


;==========================================================
chkPlayerDeath:

 ld a,(energy)
 bit 7,a
 ret z

 ld a,(lives)
 dec a
 jr z,playerDead
 ld (lives),a
 ld a,(maxEnergy)
 ld (energy),a

 ld a,invincTime
 ld (playerInvinc),a
 ret

playerDead:

 ld hl,$0402
 ld (CURSOR_ROW),hl
 ld hl,deadMsg
 ROM_CALL(D_ZT_STR)
kle:
 call GET_KEY
 or a
 cp G_ENTER
 jr nz,kle
 pop bc \ pop bc
 jp slideOut

deadMsg:
.db "Game Over",0

;==========================================================
chkEnShipDeath:         ;clear out dead enemies, add explosions

 ld hl,enemyShips
 ld ix,enemyShips+4
 ld de,5
 ld b,maxEnemies

chkEnSDthLp:
 ld a,(hl)
 or a
 jr z,nxtChkEnSDthLp
 ld a,(ix)
 or a
 jr z,deadShip
 bit 7,a
 jr z,nxtChkEnSDthLp

deadShip:
 ld a,(hl)                      ;add to score
 ld (hl),0
 push de
 push hl
 and %00001111
 dec a
 ld d,0 \ ld e,a
 ld hl,shipPoints
 add hl,de
 ld a,(hl)
 ld e,a
 ld hl,(score)
 add hl,de
 ld (score),hl
 pop hl \ push hl
 push bc
 inc hl
 ld e,(hl)
 inc hl
 ld d,(hl)
 call addExplosion              ;should add multiple explosions for big ships
 pop bc  
 ld hl,numEnemyShips
 dec (hl)
 ld a,(killType)
 cp 1
 jr nz,nonShipGoal
 ld a,(leftToKill)
 or a
 jr z,nonShipGoal
 dec a
 ld (leftToKill),a
nonShipGoal:
 pop hl \ pop de

nxtChkEnSDthLp:
 add hl,de
 add ix,de
 djnz chkEnSDthLp
 ret

;==========================================================
chkBldDeath:

 ld ix,buildings
 ld hl,buildings+3
 ld b,maxBuildings

bldDthLp:

 ld a,(ix)
 or a
 jr z,nxtBldDthLp
 ld a,(hl)
 or a
 jr nz,nxtBldDthLp
 ld (ix),1              ;debris/rubble
 dec (hl)

 push hl                ;add 4 explosions
 dec hl
 ld d,(hl)
 dec hl
 ld e,(hl)
 push ix
 push bc
 push de 
 call addExplosion
 pop de
 ld a,d
 sub 8 
 ld d,a
 push de
 call addExplosion
 pop de
 ld a,e
 sub 8
 jr c,noTopBldExp
 ld e,a
 push de 
 call addExplosion
 pop de
 ld a,8
 add a,d
 ld d,a
 call addExplosion
noTopBldExp:
 ld a,(killType)
 cp 2
 jr nz,nonBldGoal
 ld a,(leftToKill)
 or a
 jr z,nonBldGoal
 dec a
 ld (leftToKill),a

nonBldGoal:

 ld hl,(score)
 ld de,5
 add hl,de
 ld (score),hl

 pop bc
 pop ix
 pop hl
 
nxtBldDthLp:

 ld de,4
 add hl,de
 add ix,de
 djnz bldDthLp
 ret


;==========================================================
Scroll1:
 
 ld hl,GRAPH_MEM+756    ;scroll down by 1
 ld de,GRAPH_MEM+768
 ld bc,768
 lddr
 ret

;==========================================================
genGirder:

 ld a,(girder)
 or a
 ret nz
 call RAND
 and %00001111
 ret nz
 inc a
 ld (girder),a
 ret

moveGirder:             ;moves current girder down screen by 1

 ld a,(girder)
 or a
 ret z
 inc a
 cp 63
 jr nz,contGirderMv
 xor a

contGirderMv:

 ld (girder),a
 ret

drawGirder:

 ld a,(girder)
 or a
 ret z
 ld c,a
 xor a
 ld b,12

drawGirderLp:

 push bc
 push af
 ld de,girderSprite
 call DrawSprite
 pop af
 pop bc
 add a,8
 djnz drawGirderLp
 ret
 
;==========================================================
genCloud:

 call RAND
 and %00000111          ;if numClouds<maxClouds, try to draw 'nuther cloud
 ret nz

 ld hl,clouds
genCldLoop:
 ld a,(hl)
 or a
 jr z,addCloud
 inc hl \ inc hl
 jr genCldLoop

addCloud:
 ld (hl),1
 inc hl
 call RAND

 and %00000111
 inc a
 ld (hl),a
 ld a,(numClouds)
 inc a
 ld (numClouds),a
 ret

;==========================================================
drawClouds:

 ld hl,clouds
 ld b,maxClouds

drwCldLoop:
 ld a,(hl)
 or a
 jr z,nxtDrwCld

botCloud:
 cp 63
 jr nc,topCloud

 ld c,a
 inc hl
 ld a,(hl)
 ld de,cloudBits+24

 push hl \ push af \ push bc
 call dispCloud
 pop bc \ pop af \ pop hl
 inc a
 ld de,cloudBits+16
 push hl \ push bc
 call dispCloud
 pop bc \ pop hl 
 dec hl

topCloud:
 ld a,(hl)
 sub 8
 bit 7,a
 jr nz,nxtDrwCld
 ld c,a
 inc hl
 ld a,(hl)
 ld de,cloudBits
 push hl \ push af \ push bc
 call dispCloud
 pop bc \ pop af \ pop hl
 inc a
 ld de,cloudBits+8
 push hl \ push bc
 call dispCloud
 pop bc \ pop hl 
 dec hl

nxtDrwCld:
 inc hl \ inc hl
 djnz drwCldLoop
 ret

dispCloud:

 ld hl,0                ;get to the right line
 ld b,0
 add hl,bc              ;mult. by 12
 add hl,bc
 add hl,bc
 add hl,hl
 add hl,hl
 ld c,a                 
 add hl,bc
 ld bc,GRAPH_MEM
 add hl,bc              ;hl contains the location of the sprite
 ld b,8
cLoopCld:
 ld a,(de)
 ld (hl),a
 inc de
 push bc
 ld bc,12
 add hl,bc
 pop bc
 djnz cLoopCld
 ret

;==========================================================
moveClouds:

 ld hl,clouds
 ld b,maxClouds

movCldLoop:
 ld a,(hl)
 or a
 jr z,nxtMovCld
 inc a
 cp 71                  ;if y=71, then delete cloud record - offscreen!
 jr nz,nxtMovCld        
 ld a,(numClouds)
 dec a
 ld (numClouds),a
 xor a
 
nxtMovCld:
 ld (hl),a
 inc hl \ inc hl
 djnz movCldLoop
 ret

;==========================================================
genSmallRock:

 call RAND
 and %00000111         
 ret nz
 ld hl,smallRocks
 
genSRockLoop:
 ld a,(hl)
 or a
 jr z,addSRock
 inc hl \ inc hl
 jr genSRockLoop

addSRock:
 ld (hl),1
 inc hl
 call RAND
 and %00111111
 ld c,a
 call RAND
 and %00011111
 add a,c

 ld (hl),a
 ld a,(numSmallRocks)
 inc a
 ld (numSmallRocks),a
 ret

;==========================================================
moveSmallRocks:

 ld hl,smallRocks
 ld b,maxSmallRocks

movSRockLoop:
 ld a,(hl)
 or a
 jr z,nxtMovSRock
 inc a
 cp 63
 jr nz,nxtMovSRock        
 ld a,(numSmallRocks)
 dec a
 ld (numSmallRocks),a
 xor a
 
nxtMovSRock:
 ld (hl),a
 inc hl \ inc hl
 djnz movSRockLoop
 ret

;==========================================================
drawSmallRocks:

 ld hl,smallRocks
 ld b,maxSmallRocks

drawSRockLp:
 ld a,(hl)
 or a
 jr z,nxtDrwSRLp

 push bc \ push hl
 ld c,a
 inc hl
 ld a,(hl)
 ld de,smallRock
 call DrawSprite
 pop hl \ pop bc
 
nxtDrwSRLp:
 inc hl \ inc hl
 djnz drawSRockLp
 ret

;==========================================================
drawStatBar:

 ld hl,statusBox
 ld de,GRAPH_MEM
 ld bc,96
 ldir

 ld a,(shotPower)
 ld c,2
 call _horizLine
 ld a,(energy)
 ld c,3
 call _horizLine
 ret

;==========================================================
ShowScreen:

 ld de,tempScrn
 ld hl,GRAPH_MEM
 ld bc,768
 ldir
 ret

;==========================================================
RedrawGraph:

 ld de,GRAPH_MEM
 ld hl,tempScrn
 ld bc,768
 ldir
 ret

;==========================================================
DrawPlayer:             ;or the player onto screen

 ld a,(yPlayer)
 ld c,a
 ld a,(xPlayer)
 ld de,PlayerShip
 call DrawSprite
 ret
;==========================================================
;======================
;Sprite drawing routine
;======================

DrawSprite:             ;(de: sprite location)(a: xpos)(c: ypos) 

 ld hl,0                ;get to the right line
 ld b,0
 add hl,bc              ;mult. by 12
 add hl,bc
 add hl,bc
 add hl,hl
 add hl,hl
 ld c,a                 
 sra c \ sra c \ sra c  ;div 8
 add hl,bc
 ld bc,GRAPH_MEM
 add hl,bc              ;hl contains the location of the sprite
 and %00000111          ;number of right shifts
 jr z,Centred           ;jump if sprite is aligned to byte
 ld b,a
 ld c,8
 ld ix,8

Shift:
 push bc
 ld c,0
 ld a,(de)
sLoop:
 rra 
 rr c
 djnz sLoop
 ld b,(hl)
 or b
 ld (hl),a
 ld a,c
 inc hl
 ld b,(hl)
 or b
 ld (hl),a
 inc de
 ld bc,11
 add hl,bc
 pop bc
 dec c
 jr nz,Shift
 ret

Centred:
 ld b,8
cLoop:
 ld a,(de)
 ld c,(hl)
 or c
 ld (hl),a
 inc de
 push bc
 ld bc,12
 add hl,bc
 pop bc
 djnz cLoop
 ret

;==========================================================
_horizLine:     ;draws a horizontal line from (8,c)-(8+a,c)

 ld b,0
 ld hl,0
 add hl,bc
 add hl,bc
 add hl,bc
 add hl,hl
 add hl,hl
 ld bc,GRAPH_MEM
 add hl,bc
 inc hl
 ld c,a
 srl a \ srl a \ srl a
 or a
 jr z,_remainHoriz
 ld b,a
_mnHorizLp:
 ld (hl),$FF
 inc hl
 djnz _mnHorizLp

_remainHoriz:
 ld a,c
 and %00000111
 jr z,_endHoriz
 ld b,a
 xor a
_rmHorizLp:
 scf
 rra
 djnz _rmHorizLp
 ld (hl),a

_endHoriz:
 ret

;==========================================================
D_HLM_DECI:             ;D_HL_DECI, but menu style
 call LD_HL_MHL
 ld b,5
 ld de,rvScore+4
bScoreLp1:               ;display score menu-style
 call UNPACK_HL
 add a,'0'
 ld (de),a
 dec de
 djnz bScoreLp1
 ld hl,rvScore
 ROM_CALL(D_ZM_STR)
 ret

;==========================================================
enterName:

 ld hl,name
 ld (hl),'A'
 ld c,0
 
_txtEnter:              ;used to enter the player's name
 push hl
 ld hl,$0106
 ld (CURSOR_POS),hl
 ld hl,name
 ROM_CALL(D_ZT_STR)

_keyPress:
 push bc
 call GET_KEY
 pop bc
 pop hl
 inc hl
 ld (hl),0
 dec hl
 cp G_UP
 jr z,_charUp
 cp G_DOWN
 jr z,_charDown
 cp G_LEFT
 jr z,_backspace
 cp G_RIGHT
 jr z,_saveLetter
 cp G_ENTER
 ret z
 jr _txtEnter


_charUp:
 ld a,(hl)
 inc a
 cp 'Z'+1
 jr nz,_cCharUp
 ld a,'A'
_cCharUp:
 ld (hl),a
 jr _txtEnter

_charDown:
 ld a,(hl)
 dec a
 cp 'A'-1
 jr nz,_cCharDown
 ld a,'Z'
_cCharDown:
 ld (hl),a
 jr _txtEnter

_backspace:
 ld a,c
 or a
 jr z,_noBckspce
 ld (hl),' '
 dec hl
 dec c
_noBckspce:
 jr _txtEnter

_saveLetter:
 ld a,c
 cp 8
 jr z,_noSaveLtr
 inc hl
 inc c
 ld (hl),'A'
_noSaveLtr:
 jr _txtEnter


;==========================================================
cool_inverseScreen:

 ld b,32
 ld hl,GRAPH_MEM

cool1:
 push bc
 ld b,12
cool2:
 ld (hl),0
 inc hl
 djnz cool2
 pop bc
 ld de,12
 add hl,de
 djnz cool1
 ret
     
;==========================================================
inverseScreen:

 ld b,3
 ld hl,GRAPH_MEM
l1a:
 push bc
 ld b,$FF

l2a:                      ;code to invert the screen
 ld a,(hl)               
 xor $FF                
 ld (hl),a
 inc hl
 djnz l2a
 pop bc
 djnz l1a
 ret

;==========================================================
changeContrast:         ;contrast = contrast + c 
                        ; NB. does not check that contrast setting is VALID!
 ld hl,CONTRAST
 ld a,(hl)
 add a,c
 ld (hl),a
 add a,$1E
 or $C0 
 di
 call $7F3 
 out ($10),A 
 ei
 ret

;==========================================================
;CHEAT!

name:           ;current player's name (9 bytes + '0')
.db 0,0,0,0,0,0,0,0,0,0

savedScore:          ;current player's score
.dw $0000
rvScore:
.db 0,0,0,0,0,0

sWorld: .db 2
sLevel: .db 3

;==========================================================
;various title and in-game text

ttlText0a: .db "1998",0
ttlText0b: .db "v1.0",0
ttlText1: .db "by J.Wazny",0
;ttlText2: .db "2nd: Play",0
ttlText2: .db "ENTER:Play",0
;ttlText3: .db "MODE: Quit",0
ttlText3: .db "CLR: Quit",0

wlcmTxt1: .db "Welcome to",0
wlcmTxt2: .db "the elite",0
wlcmTxt3: .db "forces.",0
wlcmTxt4: .db "Please enter",0
wlcmTxt5: .db "your name.",0

btxtLocn: .db "Location:",0
btxtMisn: .db "Mission:",0

txtGoal:  .db "Goal:",0
txtScore: .db "Score:",0
txtEnter: .db "<Enter>",0


;location names
worldNames:
btxtW0: .db "Planet Arctus  ",0
btxtW1: .db "Enemy Base     ",0
btxtW2: .db "Outer Space    ",0
;btxtW3: .db "Dimension Tau  ",0

;mission names
W0MsnNames:
btxtW0L0: .db "Perimeter Scout",0
btxtW0L1: .db "Clearing Up    ",0
btxtW0L2: .db "Initial Assault",0
btxtW0L3: .db "Final Strike   ",0

btxtW1L0: .db "Docking Bay    ",0
btxtW1L1: .db "Outer Quarters ",0
btxtW1L2: .db "Inner Quarters ",0
btxtW1L3: .db "Destroy Systems",0

btxtW2L0: .db "Interstellar 1 ",0
btxtW2L1: .db "Interstellar 2 ",0
btxtW2L2: .db "Guardian Fleet ",0
btxtW2L3: .db "Enemy's Heart  ",0


wonLvl:  .db "Mission",0,"Successful",0
lostLvl: .db "Mission",0,"Unsuccessful",0

;==========================================================
; ENEMY GEN. LEVEL DATA. This represents the number, order and type of
;  enemy being generated during the level. Used by "whichEnGen".
; FORMAT: number, en.type, dmg, hp
;note: MAX 64 entries per level!

#include "shipgen.inc"

worldPointers:
.dw W0L0,W0L1,W0L2,W0L3
.dw W1L0,W1L1,W1L2,W1L3
.dw W2L0,W2L1,W2L2,W2L3

;==========================================================
;goals for each mission... currently only of the form:
; "kill x% of ships\buildings"
;format: type (0=no goal 1=ship, 2=building), txt string for goal disp.
:, actual number needed to kill

goalData:
.db 0,"30%",0,0
.db 1,"30%",0,80
.db 0,"20%",0,0
.db 2,"50%",0,25

.db 0,"20%",0,0
.db 1,"30%",0,57
.db 2,"40%",0,20
.db 2,"40%",0,40

.db 1,"30%",0,75
.db 1,"30%",0,88
.db 0,"10%",0,0
.db 1,"25%",0,80

bldTxt:         .db "  Buildings",0
shipTxt:        .db "  Ships",0
surviveTxt:     .db "Survive!",0
neededToKillTxt:.db "Need Extra:",0

;==========================================================
; setup data for each level: shotPower, scrollSpeed, lives,
;  maxEnergy, energy, recharge, rechargeCount, buildType,
; buildHp, numBombs, buildFreq, shipFreq, shotFreq, maxBld 

levelSetData:
.db 16,4,1,10,10,0,0,0,0,0,%00000000,%00000111,%00000000,0
.db 16,4,1,10,10,0,0,0,0,2,%00000000,%00000111,%00111111,0
.db 24,4,1,16,16,0,8,0,0,3,%00000000,%00000011,%00011111,0
.db 24,2,2,16,16,1,16,3,5,3,%0000001,%00001111,%00011111,50

.db 24,3,2,16,16,1,16,0,0,3,%00000000,%00000011,%00001111,0
.db 24,3,2,16,16,1,16,0,0,3,%00000000,%00000111,%00001111,0
.db 24,3,1,16,16,1,16,4,5,3,%00000001,%00000111,%00001111,50
.db 32,2,3,24,24,1,16,5,4,3,%00000001,%00000111,%00001111,100

.db 32,3,1,24,24,1,16,0,0,4,%00000000,%00000111,%00001111,0
.db 32,3,2,24,24,1,16,0,0,3,%00000000,%00000111,%00001111,0
.db 32,2,2,40,40,1,8,0,0,3,%00000000,%00000011,%00000111,0
.db 32,3,3,40,40,1,8,0,0,5,%00000000,%00000001,%00000011,0

;==========================================================
;enemy ship movement paths

enPath0:
.db 255
.db 1,1,1,1,1,1,3,5,7,10,12,14,16,18,20,22,24,26,28,29
.db 31,33,34,36,37,38,40,41,42,43,44,45,46,47,48,49,49,50,51,51
.db 52,52,52,53,53,53,53,53,53,53,53,53,52,52,52,51,51,50,49,49
.db 48,47,46,45,44,43,42,41,40,38,37,36,34,33,31,29,28,26,24,22
.db 20,18,16,14,12,10,7,5,3,1
.db 255
enPath1:
.db 255
.db 62,62,62,62,62,62,62,62,62,61,61,61,61,61,61,61,61,61,61,60
.db 60,60,60,60,60,60,59,59,59,59,59,58,58,58,58,57,57,57,57,56
.db 56,56,55,55,54,54,54,53,53,52,52,51,50,50,49,48,48,47,46,45
.db 44,43,42,41,40,39,38,37,35,34,33,31,29,28,26,24,22,20,18,16
.db 13,11,8,6,3,1
.db 255
enPath2:
.db 255
.db 60,60,59,58,57,56,54,52,50,47,45,42,40,37,34,32,30,27,26,24
.db 22,21,21,20,20,20,21,22,23,25,26,29,31,33,36,38,41,44,46,49
.db 51,53,55,57,58,59,60,60,60,60,59,58,57,55,53,51,49,46,44,41
.db 38,36,33,31,29,26,25,23,22,21,20,20,20,21,21,22,24,26,27,30
.db 32,34,37,40,42,45,47,50,52,54,56,57,58,59,60
.db 255
enPath3:
.db 255
.db 63,62,62,61,60,60,59,58,58,57,56,56,55,54,54,53,52,52,51,50
.db 50,49,48,48,47,46,46,45,44,44,43,42,42,41,40,40,39,38,38,37
.db 36,36,35,34,34,33,32,32,31,30,30,29,28,28,27,26,26,25,24,24
.db 23,22,22,21,20,20,19,18,18,17,16,16,15,14,14,13,12,12,11,10
.db 10,9,8,8,7,6,6,5,4,4,3,2,2,1
.db 255

;==========================================================
shipPoints:              ;how many points each ship is worth 
.db 2,3,5,8,8,10,9,12,15,15,15,15,25,30,25

;==========================================================
PlayerShip:             ;player's sprite
.db %00011000
.db %00011000
.db %10011001
.db %10011001
.db %10111101
.db %11111111
.db %11111111
.db %11011011

PlayerShotSprite:
.db %11000011
.db %11000011
.db %11000011
.db %11000011
.db %00000000
.db %00000000
.db %00000000
.db %00000000

enemyDShotSprite:

.db %00000000
.db %11000000
.db %11000000
.db %11000000
.db %11000000
.db %11000000
.db %11000000
.db %00000000

enemySShotSprite:

.db %01100000
.db %11110000
.db %11110000
.db %01100000
.db %00000000
.db %00000000
.db %00000000
.db %00000000


ships1x1:

.db %01000010
.db %01111110
.db %01111110
.db %01111110
.db %01111110
.db %00111100
.db %00111100
.db %00011000

.db %00011000
.db %00111100
.db %00111100
.db %01111110
.db %01111110
.db %01111110
.db %01111110
.db %01000010

.db %01000010
.db %01100110
.db %11100111
.db %11111111
.db %11111111
.db %11100111
.db %01100110
.db %01000010

.db %00011000
.db %00111100
.db %01100110
.db %11000011
.db %11000011
.db %01100110
.db %00111100
.db %00011000

.db %11000011
.db %11000011
.db %00100100
.db %00011000
.db %00011000
.db %00100100
.db %11000011
.db %11000011

.db %00111100
.db %01111110
.db %11111111
.db %11011011
.db %10011001
.db %10000001
.db %10000001
.db %10000001

.db %10010010
.db %10111010
.db %11101110
.db %01101100
.db %00111000
.db %00010000
.db %00010000
.db %00010000

ships2x1:       ;(top-bottom)

.db %00011000
.db %01011010
.db %01011010
.db %10111101
.db %10111101
.db %11111111
.db %01111110
.db %01111110

.db %00111100
.db %00111100
.db %00011000
.db %00111100
.db %01111110
.db %01111110
.db %00111100
.db %00011000


.db %11000011
.db %11011011
.db %01111110
.db %00011000
.db %01111110
.db %00011000
.db %11111111
.db %00011000

.db %11111111
.db %00011000
.db %01111110
.db %00011000
.db %01111110
.db %00011000
.db %00111100
.db %00011000

.db %00000000
.db %00111100
.db %01111110
.db %11111111
.db %11111111
.db %11111111
.db %11111111
.db %11111111

.db %11111111
.db %11111111
.db %11111111
.db %11111111
.db %01111110
.db %01111110
.db %00111100
.db %00000000

ships1x2:        ;(left-right)

.db %00001111
.db %00111111
.db %01111111
.db %11111111
.db %11111111
.db %01111111
.db %00111111
.db %00001111

.db %11110000
.db %11111100
.db %11111110
.db %11111111
.db %11111111
.db %11111110
.db %11111100
.db %11110000

.db %00001100
.db %00111100
.db %01111111
.db %11111100
.db %11111111
.db %01111100
.db %00111100
.db %00001100

.db %00110000
.db %00111100
.db %11111110
.db %00111111
.db %11111111
.db %00111110
.db %00111100
.db %00110000

ships2x2:       ;(top.left-top.right-bot.left-bot.right)

;1
.db %00000011
.db %00001111
.db %00011111
.db %00111111
.db %01111110
.db %01111110
.db %11111100
.db %11110000

.db %11000000
.db %11110000
.db %11111000
.db %11111100
.db %01111110
.db %01111110
.db %00111111
.db %00001111

.db %11110000
.db %11111100
.db %01111110
.db %01111110
.db %00111111
.db %00011111
.db %00001111
.db %00000011

.db %00001111
.db %00111111
.db %01111110
.db %01111110
.db %11111100
.db %11111000
.db %11110000
.db %11000000


;2
.db %10000001
.db %11011011
.db %11111111
.db %11111111
.db %10111111
.db %10011111
.db %10001111
.db %10000111

.db %10000001
.db %11011011
.db %11111111
.db %11111111
.db %11111101
.db %11111001
.db %11110001
.db %11100001

.db %10000011
.db %10000001
.db %10001111
.db %00011111
.db %00010111
.db %00010011
.db %00000011
.db %00000001

.db %11000001
.db %10000001
.db %11110001
.db %11111000
.db %11101000
.db %11001000
.db %11000000
.db %10000000

;3
.db %00001110
.db %00001110
.db %01001110
.db %11100100
.db %11111111
.db %11111111
.db %11101111
.db %01000111

.db %01110000
.db %01110000
.db %01110010
.db %00100111
.db %11111111
.db %11111111
.db %11110111
.db %11100010

.db %01000111
.db %01000011
.db %01000011
.db %01000011
.db %01000011
.db %00000011
.db %00000001
.db %00000000

.db %11100010
.db %11000010
.db %11000010
.db %11000010
.db %11000010
.db %11000000
.db %10000000
.db %00000000

;Buildings
;16x16          (tl,tr,bl,br order)
;1
bld16x16:

;1- building rubble
.db %01000000
.db %00001110
.db %10100010
.db %01100100
.db %01100110
.db %01001000
.db %01010100
.db %00000000

.db %00000000
.db %01011010
.db %10001100
.db %00000101
.db %01100100
.db %01000010
.db %01101000
.db %00001000

.db %00010000
.db %01000100
.db %00000110
.db %00100010
.db %10110100
.db %00110001
.db %00001011
.db %10100000

.db %10000001
.db %00010101
.db %11000011
.db %00001010
.db %00110110
.db %11001101
.db %00111000
.db %11100010


;2
.db %00000000
.db %00000000
.db %00011111
.db %00110000
.db %01010011
.db %10010101
.db %10110111
.db %10010000

.db %00000000
.db %00000000
.db %11100000
.db %00010110
.db %00011101
.db %01010101
.db %00010111
.db %01011010

.db %10110010
.db %10010000
.db %10010110
.db %10110000
.db %10011111
.db %10100000
.db %11001001
.db %11111111

.db %00010100
.db %00011000
.db %10110000
.db %00010000
.db %11110110
.db %00101101
.db %01001011
.db %10000110

;3
.db %00100000
.db %00000111
.db %10011000
.db %00100001
.db %01001000
.db %01010000
.db %01010000
.db %01001100

.db %00010010
.db %11000000
.db %00110001
.db %10001000
.db %01100100
.db %00010100
.db %00010100
.db %00100100

.db %01100000
.db %01011000
.db %01010111
.db %00100101
.db %10110000
.db %00011101
.db %10000111
.db %00001000

.db %00001100
.db %00110100
.db %11010101
.db %01001000
.db %00011000
.db %01110100
.db %11000001
.db %00101000

;4
.db %00001000
.db %10011100
.db %00101010
.db %01001001
.db %01001001
.db %01001001
.db %01001001
.db %01001001

.db %00000000
.db %00010010
.db %01000000
.db %00011100
.db %00100010
.db %00111110
.db %00100010
.db %00100010

.db %01001001
.db %01001001
.db %01010101
.db %01100011
.db %01010101
.db %00100010
.db %00011100
.db %01000000

.db %01100010
.db %00100010
.db %00100010
.db %00011100
.db %00000000
.db %00100001
.db %00000100
.db %01000000

;5
.db %00000000
.db %01110011
.db %10001010
.db %11111010
.db %11001010
.db %10101011
.db %10011011
.db %11001000

.db %00000000
.db %10001110
.db %11010001
.db %01011111
.db %01010101
.db %01010011
.db %11011001
.db %00010101

.db %10101010
.db %10011101
.db %11001000
.db %10101011
.db %11111010
.db %10001011
.db %01110001
.db %00000000

.db %10110011
.db %01011001
.db %00010101
.db %00010011
.db %10011111
.db %01010001
.db %11101110
.db %00000000

;6
.db %00100111
.db %10111000
.db %01000001
.db %10001101
.db %10011000
.db %10010101
.db %10000011
.db %11100111

.db %11100001
.db %10011100
.db %10000010
.db %00110001
.db %00011001
.db %10101001
.db %11000001
.db %11101101

.db %10110111
.db %10000011
.db %10010101
.db %10011000
.db %10001100
.db %01000001
.db %10111001
.db %00100111

.db %11100111
.db %11000001
.db %10101001
.db %00011001
.db %10110001
.db %10000010
.db %00011100
.db %11100101


smallExplosion:

.db %00000000
.db %00000000
.db %00001000
.db %00010000
.db %00000100
.db %00001000
.db %00000000
.db %00000000

.db %00000000
.db %01011000
.db %00100000
.db %01001010
.db %01010010
.db %00000100
.db %01011000
.db %00000001

.db %00010000
.db %01000100
.db %00000001
.db %01001000
.db %00010100
.db %10001001
.db %00000000
.db %00100100

.db %10000010
.db %00100000
.db %00000100
.db %00000000
.db %00100000
.db %00001000
.db %01000000
.db %00000001

.db %00000000
.db %01000010
.db %00000000
.db %00000000
.db %00000000
.db %00100000
.db %00000010
.db %00000000

TileMap:        ;Lay out of tiles, 12 per line
                ;Data is read, and disp'd, from top to bottom
.db 0,0,0,0,0,0,0,0,0,0,0,0

;==========================================================
Tiles:

;== world0
;0, ground
.db %00000000
.db %00100000
.db %00000100
.db %10000000
.db %00000000
.db %00001000
.db %01000000
.db %00000000

;8, tree
.db %00011000
.db %01100110
.db %01000010
.db %10000001
.db %10000001
.db %01000010
.db %01100110
.db %00011000

;== world1
;16, metal-plated floor (a)

.db %00000000
.db %00000000
.db %00100000
.db %00000000
.db %10100000
.db %00001001
.db %00000100
.db %00000000

;24, metal-plated floor (b)

.db %00000100
.db %00000000
.db %00010100
.db %00000000
.db %00101010
.db %01000000
.db %00000000
.db %00100000

;32, vert. hazard stripes

.db %11100001
.db %11000011
.db %10000111
.db %10001111
.db %10011111
.db %10111101
.db %11111001
.db %11110001

;40, left grille

.db %01111111
.db %11111111
.db %10101010
.db %10101010
.db %10101010
.db %10101010
.db %11111111
.db %01111111

;48, right grille

.db %11111100
.db %11111110
.db %10101010
.db %10101010
.db %10101010
.db %10101010
.db %11111110
.db %11111100


;56, mplate bot.left
.db %10000001
.db %10000000
.db %10000001
.db %10000000
.db %10110001
.db %10100000
.db %10000001
.db %11111111  

;64, mplate bot.right
.db %00000001
.db %00000001
.db %00000001
.db %00000001
.db %00001101
.db %00001001
.db %00000001
.db %11111110

;72, mplate top.left
.db %01111111
.db %10000000
.db %10110000
.db %10100000
.db %10000000
.db %10000000
.db %10000000
.db %11111111

;80, mplate top.right
.db %11111110
.db %00000001
.db %10001101
.db %00001001
.db %10000001
.db %00000001
.db %10000001
.db %11111111

;88 stars 1
.db %00000000
.db %01001000
.db %00011100
.db %00001000
.db %00000000
.db %00100000
.db %00000010
.db %00000000

;96 stars 2
.db %10000001
.db %00000000
.db %00000000
.db %01100010
.db %01100000
.db %00000000
.db %00000100
.db %00000000

;104 stars 3
.db %01000000
.db %00000010
.db %00000000
.db %00010000
.db %00000000
.db %00000100
.db %10000000
.db %00000000

;112 stars 4
.db %00000010
.db %00100000
.db %00000000
.db %00000100
.db %01000000
.db %00010101
.db %00000000
.db %00000100

;120 honeycomb
;.db %10000000
;.db %00000010
;.db %00100000
;.db %00000100
;.db %00010000
;.db %00000010
;.db %00100000
;.db %00000001

;.db %00100100
;.db %00011000
;.db %00100100
;.db %11000011
;.db %00100100
;.db %00011000
;.db %00100100
;.db %11000011
                      

;==========================================================
;cloud

cloudBits:

;0:up left
.db %00000000
.db %00001100
.db %00010010
.db %00010001
.db %00001000
.db %00010000
.db %00100000
.db %00100000

;8:up right
.db %00000000
.db %01100000
.db %10010110
.db %00001001
.db %00000001
.db %00000010
.db %00000100
.db %00000100

;16:bot. right
.db %00000010
.db %00000010
.db %00000001
.db %00000001
.db %00000010
.db %10000100
.db %01100100
.db %00011000

;24:bot. left
.db %00010000
.db %00100000
.db %01000000
.db %01000000
.db %00100000
.db %00010001
.db %00010010
.db %00001100

smallRock:

.db %00000000
.db %00000000
.db %00010110
.db %00111110
.db %00011100
.db %00001100
.db %00000000
.db %00000000


girderSprite:

.db %11111111
.db %11100111
.db %01111110
.db %00111100
.db %00111100
.db %01111110
.db %11100111
.db %11111111

;==========================================================
briefScr:
.db 63,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-4,96,0,0,0,0,0,0,0,0,0,0,6,-49,-1,-1,-1,-57,-1,-64
.db 127,-1,-1,31,-13,-112,0,0,0,0,0,17,0,0,0,0,1,-93,-1,-1,-1,-1,-1,-54,127,-1,-1,-2,5,-92,0
.db 0,0,0,0,32,-128,0,0,1,1,-88,0,0,0,0,0,17,0,0,0,0,-11,-88,0,0,0,0,0,21,0,0
.db 0,0,-127,-88,0,0,0,0,0,21,0,0,0,0,-11,-88,0,0,0,0,0,21,0,0,0,0,-127,-88,0,0,0
.db 0,0,21,0,0,0,0,-11,-88,0,0,0,0,0,21,0,0,0,0,-127,-88,0,0,0,0,0,21,0,0,0,0
.db -11,-88,0,0,0,0,0,21,0,0,0,0,-127,-88,0,0,0,0,0,21,0,0,0,0,-11,-88,0,0,0,0,0
.db 21,0,0,0,0,-127,-88,0,0,0,0,0,21,0,0,0,0,-11,-88,0,0,0,0,0,21,0,0,0,0,-127,-88
.db 0,0,0,0,0,17,0,0,0,0,-11,-88,0,0,0,0,0,17,0,0,0,0,-127,-88,0,0,0,0,0,21,0
.db 0,0,0,-11,-88,0,0,0,0,0,17,0,0,0,0,-127,-88,0,0,0,0,0,17,0,0,0,0,-11,-88,0,0
.db 0,0,0,21,0,0,0,0,-127,-88,0,0,0,0,0,21,0,0,0,0,-11,-88,0,0,0,0,0,21,0,0,0
.db 0,-127,-88,0,0,0,0,0,21,0,0,0,0,-11,-88,0,0,0,0,0,21,0,0,0,0,-127,-88,0,0,0,0
.db 0,21,0,0,0,0,-11,-88,0,0,0,0,0,21,0,0,0,0,-127,-88,0,0,0,0,0,21,0,0,0,0,-11
.db -88,0,0,0,0,0,21,0,0,0,0,-127,-88,0,0,0,0,0,21,0,0,0,0,-11,-88,0,0,0,0,0,21
.db 0,0,0,0,-127,-88,0,0,0,0,0,21,0,0,0,0,-11,-88,0,0,0,0,0,21,0,0,0,0,-127,-88,0
.db 0,0,0,0,17,0,0,0,0,-11,-88,0,0,0,0,0,17,0,0,0,0,-127,-88,0,0,0,0,0,17,0,0
.db 0,0,-11,-88,0,0,0,0,0,17,0,0,0,0,-127,-92,0,0,0,0,0,32,-128,0,0,1,9,-77,-1,-1,-1
.db -1,-1,-54,127,-1,-1,-2,17,-104,0,0,0,0,0,17,0,0,0,0,17,-113,-1,-1,-1,-1,-1,-64,31,-1,-1,-1
.db -47,-104,0,0,0,0,0,0,0,0,0,0,17,-77,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-55,-92,0,0,0,0,0
.db 0,0,0,0,0,33,-88,0,0,0,0,0,0,0,0,0,0,17,-88,0,0,0,0,0,0,0,0,0,0,21,-88
.db 0,0,0,0,0,0,0,0,0,0,17,-88,0,0,0,0,0,0,0,0,0,0,17,-88,0,0,0,0,0,0,0
.db 0,0,0,21,-88,0,0,0,0,0,0,0,0,0,0,21,-88,0,0,0,0,0,0,0,0,0,0,21,-88,0,0
.db 0,0,0,0,0,0,0,0,21,-88,0,0,0,0,0,0,0,0,0,0,21,-88,0,0,0,0,0,0,0,0,0
.db 0,21,-88,0,0,0,0,0,0,0,0,0,0,21,-92,0,0,0,0,0,0,0,0,0,0,37,-93,-1,-1,-1,-1
.db -1,-1,-1,-1,-1,-1,-63,-112,0,0,0,0,0,0,0,0,0,0,9,-49,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-13
.db 96,0,0,0,0,0,0,0,0,0,0,6,63,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-4,-1


;==========================================================
statusBox:

.db $7F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FE
.db 128,0,0,0,0,0,0,0,0,0,0,1
.db 129,0,0,0,0,0,0,0,0,0,0,1
.db 129,0,0,0,0,0,0,0,0,0,0,1
 .db 129,0,0,0,0,0,0,0,0,0,0,1
.db 129,%01010101,%01010101,%01010101,%01010101,%01010101,%01010101,%01010101,0,0,0,1
.db 128,0,0,0,0,0,0,0,0,0,0,1
.db $7F,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FE

title:
.db 15,-63,-16,0,31,0,0,0,0,-2,1,-8,31,-63,-16,0,31,0,0,0,0,-2,3,-4,31,-31,-16,0,31,0,0
.db 0,0,-2,7,-2,31,-31,-16,0,31,0,0,0,0,-2,15,-1,63,-31,-13,-1,31,-8,63,-16,0,62,15,-97,63,-15
.db -13,-1,-97,-4,127,-16,0,62,15,-97,127,-15,-13,-1,-33,-4,-1,-9,-16,62,15,-97,125,-15,-13,-25,-33,124,-7,-9,-16
.db 62,15,-97,127,-7,-13,-25,-33,124,-7,-9,-16,62,15,-97,-1,-7,-13,-25,-33,124,-7,-9,-16,62,15,-1,-1,-7,-13,-1
.db -33,124,-1,-16,0,62,7,-2,-4,-3,-13,-1,-97,124,127,-16,0,62,3,-4,-8,-3,-13,-1,31,124,63,-16,0,62,1
.db -8,0,0,3,-32,0,0,0,0,0,0,0,0,0,0,3,-32,0,0,0,0,0,0,0,0,0,0,3,-32,0,0
.db 0,0,0,0,0,0,0,0,3,-32,0,0,0,0,0,0,0,0,-1

plaque:
.db 127,-1,-1,-1,-1,-2,-32,0,0,0,0,1-40,0,0,0,0,25
.db -76,0,0,0,0,53,-68,0,0,0,0,61,-104,0
.db 0,0,0,25,-128,0,0,0,0,1,-128,0,0,0,0,1
.db -128,0,0,0,0,1,-128,0,0,0,0,1,-128,0,0,0
.db 0,1,-128,0,0,0,0,1,-128,0,0,0,0,1
.db -128,0,0,0,0,1,-128,0,0,0,0,1,-128,0,0,0,0,1
.db -128,0,0,0,0,1,-128,0,0,0,0,1,-104
.db 0,0,0,0,25,-76,0,0,0,0,53,-68,0,0,0,0,61
.db -40,0,0,0,0,25,-32,0,0,0,0,1,127,-1,-1
.db -1,-1,-2


tempScrn:
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0,0,0,0,0




.end




                      
