;	--==7G==--  v3.2

;        BOB the CAT

;          |\___/|  ('
;          ( O O )   )
;     --oOo------oOo---
;     bob.cat@wanadoo.fr




.INCLUDE CrASH82.INC
.DB "  --==7G==--     v3.2", 0


top	=	TEXT_MEM		;Set variables
bot	=	TEXT_MEM+2		;	]
ShipY	=	TEXT_MEM+4		;	[
Crashtest	=	TEXT_MEM+6	;	]
Score	=	TEXT_MEM+8		;	[
Minefactor	=	TEXT_MEM+10	;	]
Speed	=	TEXT_MEM+14		;	[
string	=	TEXT_MEM+20
Highscore	=	TEXT_MEM+12	;       V

DefaultSpriteHeight = 5			;Using with the sprite routine



Start:
	ld a,0
	ld (Crashtest),a
	ld (Highscore),a
	ld hl,2000
	ld (Speed),hl
	ld a,20
	ld (Minefactor),a
	ld hl,GRAPH_MEM
	ld de,GRAPH_MEM+1
	ld bc,767
	ld (hl),255
	ldir
	set 3,(IY+05)



		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		;;       TITLE SCREEN        ;;
		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	ld hl,TitlePic
	ld de,GRAPH_MEM
	ld bc,248
	ldir
	call CR_GRBCopy
	ld de,$301A
	ld hl,ClearStr
	call PutStr
	ld de,$161E
	ld hl,Choice2
	call PutStr
	ld de,$2020
	ld hl,Choice3
	call PutStr
SetChoice1:
	call GET_KEY
	cp G_1
	jr z,SetSpeed5
	cp G_2
	jr z,SetSpeed4
	cp G_3
	jr z,SetSpeed3
	cp G_4
	jr z,SetSpeed2
	cp G_5
	jr z,SetSpeed1
	cp G_CLEAR
	ret z
	jr SetChoice1
SetSpeed1:
	ld hl,0
	ld (Speed),hl
	jr PutChoice2
SetSpeed2:
	ld hl,1000
	ld (Speed),hl
	jr PutChoice2
SetSpeed3:
	ld hl,2000
	ld (Speed),hl
	jr PutChoice2
SetSpeed4:
	ld hl,3000
	ld (Speed),hl
	jr PutChoice2
SetSpeed5:
	ld hl,4000
	ld (Speed),hl
PutChoice2:
	ld de,$1618
	ld hl,Choice1
	call PutStr
SetChoice2:
	call GET_KEY
	cp G_1
	jr z,SetDif1
	cp G_2
	jr z,SetDif2
	cp G_3
	jr z,SetDif3
	cp G_4
	jr z,SetDif4
	cp G_5
	jr z,SetDif5
	cp G_CLEAR
	ret z
	jr SetChoice2
SetDif1:
	ld hl,0
	ld (Minefactor),hl
	jr EndChoice
SetDif2:
	ld hl,10
	ld (Minefactor),hl
	jr EndChoice
SetDif3:
	ld hl,20
	ld (Minefactor),hl
	jr EndChoice
SetDif4:
	ld hl,40
	ld (Minefactor),hl
	jr EndChoice
SetDif5:
	ld hl,128
	ld (Minefactor),hl
EndChoice:
	

		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		;;   MAKE THE START SCREEN   ;;
		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


	ld hl,16			;Set top and bottom of the cave
	ld (top),hl
	ld hl,20
	ld (bot),hl

	ld hl,start			;Display start screen
	ld de, $88B8			;including the ship sprite
	ld bc, $300				
	ldir	
	ld hl,29
	ld (ShipY),hl
	call PutSpr
	call CR_GRBCopy
Wait1:					;Wait for RIGHT to start
	call GET_KEY
	cp G_RIGHT
	ld hl,0
	ld (Score),hl
	jr nz,Wait1
	jr Main


	
		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		;;      LOSING SECTION       ;;
		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



Lose:					;	[
	ld de,$0203			;	]
	ld hl,Youlose			;	[
	call PutStr			;	]
	ld hl,Scorestr			;	[
	ld de,$0A03			;	]
	call PutStr			;	[
	ld de,$0A1C			;	]
	ld hl,(Score)			;	[
	call DispHL			;	]
	call Highupdate			;	[
	ld hl,Highstr			;	]
	ld de,$1203			;	[
	call PutStr			;	]
	ld hl,(Highscore)		;	[
	ld de,$1229			;	]
	call DispHL			;	[
Keywait:				;	]
	call GET_KEY			;	[
	cp G_2ND			;	]
	jr nz,Keywait			;	[
	jp Start			;	V



	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	;;  MAIN PART OF THE PROGRAM  ;;
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


Main:
	call Scroll			;call the scrolling routine

	call RAND			;randomize the top and
	cp 65				;bottom of the cave
	call c,Topinc
	call nc,Topdec
	call RAND
	cp 65
	call c,Botinc
	call nc,Botdec


	call PutSpr			;Set all sprites
	call Putsmoke
	ld a,(Minefactor)
	cp 0
	call nz,Mine
	call CR_GRBCopy
	
	ld a,(Speed)
	cp 0
	call nz,Delay			;Speed setting



  LD  A, $FF \ OUT ($01), A     	;Control keys
  LD  A, $BF \ OUT ($01), A     
  IN  A, ($01)
  BIT 6, A \ RET Z              
  LD  A, $FF \ OUT ($01), A     
  LD  A, $FE \ OUT ($01), A     
  IN  A, ($01)
  BIT 0, A \ CALL Z, Down
  BIT 3, A \ CALL Z, Up

	jp Hittest			;Check if you 've hit anything



		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		;;  DELAY AND CRASHING TEST  ;;
		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

Delay:					;Speed settings
	  LD  hl,(Speed)
DelayLoop:
	DEC hl
	LD  A, h
	OR  l
	JR  NZ, DelayLoop
	RET

Hittest:				;"Hit anything" routine
	ld b,25
	ld a,(ShipY)
	call Hit
	ld b,25
	ld a,(ShipY)
	inc a
	inc a
	inc a
	inc a
	call Hit
	ld b,31
	ld a,(ShipY)
	inc a
	inc a
	call Hit
	ld b,25
	ld a,(ShipY)
	inc a
	inc a
	call Hit
	jp z,Lose
	jp Main
	
Hit:
	LD  C,A
	LD  A, B                      
	LD  B, 0
	LD  H, B
	LD  L, C
	ADD HL, HL
	ADD HL, BC
	ADD HL, HL
	ADD HL, HL
	LD  C, A
	SRL C
	SRL C
	SRL C
	ADD HL, BC
	LD  BC, GRAPH_MEM
	ADD HL, BC
	LD  B, %10000000
	AND %00000111
	JR  Z, Hitdone
	LD  C, A
	LD  A, B
	LD  B, C
ShloopGetPix:
	RRA
	DJNZ ShloopGetPix
	LD  B, A
Hitdone:
	LD  A, (HL)
	AND B
	RET



		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		;;     SCROLLING ROUTINE     ;;
		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

Scroll:
	ld hl,(Score)			;updating score
	inc hl
	ld (Score),hl
	ld a,8
Scrollloop:
	call Scrollscr
	dec a
	jr nz,Scrollloop
	ret
Scrollscr:           
	LD  HL, GRAPH_MEM+767         
	LD  B, 64                     
_LLoop:
	SLA (HL)                      
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	RL  (HL)
	DEC HL
	DJNZ _LLoop
	ret


		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		;;       DRAW THE CAVE       ;;
		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

Topinc:
	ld de,(top)
	ld a,e
	cp 40
	jr z,Toploop
	inc de
	ld (top),de
	jr Toploop
	ld a,e
	ld hl,GRAPH_MEM+11
Topdec:
	ld de,(top)
	ld a,e
	cp 2
	jr z,Toploop
	dec de
	ld (top),de
	ld a,e
	ld hl,GRAPH_MEM+11
Toploop:
	ld c,$FF
	ld (hl),c
	ld b,12
Toploopinc:
	inc hl
	dec b
	jr nz,Toploopinc
	dec a
	jr nz,Toploop
	ret


Botinc:
	ld c,$FF
	ld hl,GRAPH_MEM+767
	ld de,(bot)
	ld a,e
	cp 50
	jr z,Botloop
	ld a,e
	ld de,(top)
	add a,e
	cp 56
	jr nc,Botdec
	ld de,(bot)
	inc de
	ld (bot),de
	ld a,e
	jr Botloop
Botdec:
	ld c,$FF
	ld hl,GRAPH_MEM+767
	ld de,(bot)
	ld a,e
	cp 2
	jr z,Botloop
	dec de
	ld (bot),de
	ld a,e
Botloop:
	ld (hl),c
	ld b,12
Botloopinc:
	dec hl
	dec b
	jr nz,Botloopinc
	dec a
	jr nz,Botloop
	ret


		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		;;         CONTROLS          ;;
		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

Up:
	ld hl,(ShipY)
	dec hl
	dec hl
	ld (ShipY),hl
	ret
Down:
	ld hl,(ShipY)
	inc hl
	inc hl
	ld (ShipY),hl
	ret


		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		;;      SPRITE SELECTION     ;;
		;;     AND SPRITE ROUTINE    ;;
		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

Putsmoke:
	ld a,9
	call SetSpriteHeight
	ld b,16
	ld hl,(ShipY)
	ld c,l
	dec c
	dec c
	ld hl,Smoke
	call PutSprClp
	ret

PutSpr:
	ld a,5
	call SetSpriteHeight
	ld b,24
	ld hl,(ShipY)
	ld c,l
	ld hl,Ship

PutSprClp:
  PUSH BC \ PUSH DE \ PUSH HL \ PUSH IX                  ; ** Save Registers

  PUSH HL \ POP IX              ; LD  IX, HL

__Change_1:
  LD  D, DefaultSpriteHeight
  BIT 7, C \ JR  NZ, _PSC_NoBotClip ; If Y is negative, clip top
_PSC_BotClip:
  LD  A, 63
  SUB C \ JP  C, _PSC_Done
__Change_2:
  CP  DefaultSpriteHeight-1
  JR  NC, _PSC_NoVertClip       ; If the sprite fits, done clipping

  INC A
  JR  _PSC_ClipTop
_PSC_NoBotClip:
  LD  A, C
__Change_3:
  CP  -(DefaultSpriteHeight-1)
  JR  C, _PSC_Done              ; If Y < -(DefaultSpriteHeight-1) then done
_PSC_TopClip:
  LD  L, A
  NEG \ LD  E, A                ; Find number to shift
  LD  A, L
__Change_4:
  ADD A, DefaultSpriteHeight
  LD  D, 0 \ ADD IX, DE
  LD  C, D                      ; C = 0 or -1 if at top-left
_PSC_ClipTop:
  LD  D, A
_PSC_NoVertClip:
  LD  E, $FF \ LD  A, B
  BIT 7, A \ JR  Z, _PSC_NoLeftClip ; If X is non-negative, check right side
_PSC_LeftClip:
  CP  -7 \ JR  C, _PSC_Done     ; If X is less than -7, done
  NEG \ LD  H, B \ LD  B, A     ; Find number to shift right
_PSC_LeftLoop:
  SRL E                         ; Shift mask to right
  DJNZ _PSC_LeftLoop
  LD  A, H \ ADD A, 96 \ LD  B, A ; Shift sprite up a row.
  JR  _PSC_ClipDone2
_PSC_NoLeftClip:
  SUB 89 \ JR C, _PSC_ClipDone  ; If X < 89 then no need to clip on right
_PSC_RightClip:
  CP  7 \ JR NC, _PSC_Done      ; If Shift # > 7 then done
  LD  H, B \ LD  B, A \ INC B
_PSC_RightLoop:
  SLA E                         ; Shift mask to left
  DJNZ _PSC_RightLoop
  LD  B, H
_PSC_ClipDone:
  INC C
_PSC_ClipDone2:
  LD  A, B \ LD  B, 0           ; [11] Save B, Clear B so we can add BC
  LD  H, B \ LD  L, C           ; [ 8] HL = BC
  ADD HL, BC \ ADD HL, BC       ; [22] HL = HL + 12
  ADD HL, HL \ ADD HL, HL       ; [22]
  LD  C, A                      ; [ 4]
  SRL C \ SRL C \ SRL C         ; [24] C = B \ 8
  ADD HL, BC                    ; [11]
  LD  BC, GRAPH_MEM-12          ; [10]
  ADD HL, BC                    ; [11]
  LD  B, D                      ; Number of Rows

  AND %00000111                 ; [ 7]
  JR  Z, _PSC_NoShift

  LD  C, A                      ; Number to Shift
_PSC_LineLoop:
  PUSH BC
  PUSH DE
  LD  A, E
__Change_5:
  AND (IX+DefaultSpriteHeight)
  LD  D, A
  LD  A, E
  CPL \ OR  (IX+0)
  LD  B, C
  LD  C, %11111111
  LD  E, %00000000

_PSC_ShiftNum:
  SCF \ RRA \ RR  C
  SRL D \ RR  E                 ; Shift
  DJNZ _PSC_ShiftNum

  AND (HL) \ XOR D \ LD (HL), A \ INC HL    ; Or data with background
  LD  A, C \ AND (HL) \ XOR E \ LD  (HL), A ; Xor Mask, etc.

  INC IX \ LD  C, 11 \ ADD HL, BC ; Next row
  POP DE
  POP BC
  DJNZ _PSC_LineLoop

_PSC_Done:
  POP IX \ POP HL \ POP DE \ POP BC                    ; ** Restore registers
  RET

_PSC_NoShift:
  LD  DE, 12                    ; Add 12 each row
_PSC_NoShiftLoop:
  LD  A, (HL)
  AND (IX+0)
__Change_6:
  XOR (IX+DefaultSpriteHeight)
  LD  (HL), A                   ; Or data with background
  ADD HL, DE \ INC IX           ; Next row
  DJNZ _PSC_NoShiftLoop

  JR _PSC_Done

SetSpriteHeight:
  LD  (__Change_1+1), A
  LD  (__Change_2+1), A
  LD  (__Change_4+1), A
  LD  (__Change_5+2), A
  LD  (__Change_6+2), A
  DEC A
  NEG
  LD  (__Change_3+1), A
  RET

		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		;;     MINE RANDOMIZER       ;;
		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

Mine:
	ld bc,(Minefactor)
	call RAND 
	cp c
	jr nc,Endmine
	ld a,0
	ld de,(top)
	add a,e
	ld de,(bot)
	add a,e
	cp 25
	jr nc,Endmine
	ld a,59
	sub e
	ld c,a
Randmine:
	call RAND
	cp c
	jr nc,Randmine
	ld de,(top)
	cp e
	jr c,Randmine	
	ld c,a
	ld b,88
	ld a,5
	call SetSpriteHeight
	ld hl,Minespr
	call PutSprClp
	ret
Endmine:
	ret


		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		;;     HIGHSCORE UPDATE      ::
		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

Highupdate:
	ld a,(Minefactor)
	cp 0
	call z,Hightooeasy
	cp 10
	call z,Higheasy
	cp 20
	call z,Highnormal
	cp 40
	call z,Highhard
	cp 128
	call z,Highimp
	ret
Hightooeasy:
	ld de,(Hightooeasynb)
	ld hl,(Score)
	call CP_HL_DE
	jr nc,Hightooeasyupd
	ld hl,(Hightooeasynb)
	ld (Highscore),hl
	ret
Hightooeasyupd:
	ld hl,(Score)
	ld (Hightooeasynb),hl
	ld (Highscore),hl
	ret
Higheasy:
	ld de,(Higheasynb)
	ld hl,(Score)
	call CP_HL_DE
	jr nc,Higheasyupd
	ld hl,(Higheasynb)
	ld (Highscore),hl
	ret
Higheasyupd:
	ld hl,(Score)
	ld (Higheasynb),hl
	ld (Highscore),hl
	ret
Highnormal:
	ld de,(Highnormalnb)
	ld hl,(Score)
	call CP_HL_DE
	jr nc,Highnormalupd
	ld hl,(Highnormalnb)
	ld (Highscore),hl
	ret
Highnormalupd:
	ld hl,(Score)
	ld (Highnormalnb),hl
	ld (Highscore),hl
	ret
Highhard:
	ld de,(Highhardnb)
	ld hl,(Score)
	call CP_HL_DE
	jr nc,Highhardupd
	ld hl,(Highhardnb)
	ld (Highscore),hl
	ret
Highhardupd:
	ld hl,(Score)
	ld (Highhardnb),hl
	ld (Highscore),hl
	ret
Highimp:
	ld de,(Highimpnb)
	ld hl,(Score)
	call CP_HL_DE
	jr nc,Highimpupd
	ld hl,(Highimpnb)
	ld (Highscore),hl
	ret
Highimpupd:
	ld hl,(Score)
	ld (Highimpnb),hl
	ld (Highscore),hl
	ret


	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	;;      DISPLAY ROUTINE       ;;
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


PutStr:
	ld ($8215),de
	ROM_CALL(D_ZM_STR)
	ret

DispHL:
        push hl
        push de
        ld de,string+5
        xor a
        ld (de),a
Repeat:
        call UNPACK_HL
        add a,'0'
        dec de
        ld (de),a
        ld a,h
        or l
        jr nz,Repeat
        ex de,hl
        pop de
        ld ($8215),de
        ROM_CALL(D_ZM_STR)
        pop hl
        ret


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


Minespr:				;Sprites and datas
	.db	%01011010		;	]
	.db	%00111100		;	[
	.db	%01111110		;	]
	.db	%00111100		;	V
	.db	%01011010

	.db	%01011010
	.db	%00111100
	.db	%01111110
	.db	%00111100
	.db	%01011010



Ship:

	.db	%01000000
	.db	%11111000
	.db	%01111111
	.db	%11111100
	.db	%01100000

	.db	%01000000
	.db	%11111000
	.db	%01111111
	.db	%11111100
	.db	%01100000

Smoke:

	.db	%10111111
	.db	%00000000
	.db	%00000000
	.db	%00000000
	.db	%00000000
	.db	%00000000
	.db	%00000000
	.db	%00000000
	.db	%10011111

	.db	%00000000
	.db	%00000000
	.db	%00000000
	.db	%10110110
	.db	%00000000
	.db	%11010110
	.db	%00000000
	.db	%00000000
	.db	%00000000

start:
    .db     0,0,0,0,0,0,0,0,0,3,255,255,0,0,0,0,0,0,0,0,0,3,255,255,0,0,0,0,0,0,0
    .db     0,0,3,255,255,0,0,0,0,0,0,0,0,0,3,255,255,0,0,0,0,0,0,0,0,0,1,255,255,0,0
    .db     0,0,0,0,0,0,0,1,255,255,0,0,0,0,0,0,0,0,0,3,255,255,0,0,0,0,0,0,0,0,0
    .db     3,255,255,0,0,0,0,0,0,0,0,0,3,255,255,0,0,0,0,0,0,0,0,0,3,255,255,0,0,0,0
    .db     0,0,0,0,0,3,255,255,0,0,0,0,0,0,0,0,0,3,255,255,192,0,0,0,0,0,0,0,0,3,255
    .db     255,63,128,0,0,0,0,0,0,0,1,255,255,0,127,255,254,0,0,0,0,0,0,129,255,0,0,0,1,128,0
    .db     0,0,0,0,0,0,63,254,0,0,64,0,0,0,0,0,0,0,62,2,166,76,32,0,0,0,0,0,0,0,63
    .db     254,168,168,30,0,0,0,0,0,0,0,62,2,164,172,1,128,0,0,0,0,0,0,63,254,162,232,2,64,0,0
    .db     0,0,0,0,32,2,236,168,2,32,0,0,0,0,0,0,63,254,0,0,2,160,0,0,0,0,0,0,0,0,0
    .db     0,2,160,0,0,0,0,0,0,255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0
    .db     0,0,255,255,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    .db     0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,0,33,240,16,0,0,0,0,0,0,0,0,0
    .db     16,254,8,0,0,0,0,0,0,0,0,0,41,248,20,0,0,0,0,0,0,0,0,0,68,192,34,0,0,0,0
    .db     0,0,0,0,0,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,32,0,0,0,0,0,0,247,255
    .db     255,249,255,224,0,0,0,0,0,0,20,0,0,18,0,32,0,0,0,0,0,0,21,231,218,164,7,192,0,0,0
    .db     0,0,0,21,72,53,72,8,0,0,0,0,0,0,0,20,151,106,144,8,0,0,0,0,0,0,0,21,62,213,32
    .db     8,0,0,0,0,0,0,0,20,0,2,64,8,0,0,0,0,0,0,0,247,255,252,255,248,0,0,0,0,0,62
    .db     63,0,0,0,0,32,0,0,0,0,0,255,255,255,255,255,255,224,0,0,0,0,0,255,255,0,0,0,64,0,0
    .db     0,0,0,1,255,255,255,255,252,64,0,0,0,0,0,1,255,255,0,0,0,64,0,0,0,0,0,1,255,255,0
    .db     0,0,128,0,0,0,0,0,3,255,255,255,255,240,128,0,0,0,0,0,3,255,255,0,0,1,0,0,0,0,0
    .db     0,3,255,255,0,0,6,0,0,0,0,0,0,3,255,255,255,224,56,0,0,0,0,0,0,3,255,255,0,31,192
    .db     0,0,0,0,0,0,1,255,255,0,0,0,0,0,0,0,0,0,1,255,255,0,0,0,0,0,0,0,0,0,1
    .db     255,255,0,0,0,0,0,0,0,0,0,1,255,255,0,0,0,0,0,0,0,0,0,1,255,255,0,0,0,0,0
    .db     0,0,0,0,3,255,255,0,0,0,0,0,0,0,0,0,3,255,255,0,0,0,0,0,0,0,0,0,3,255,255
    .db     0,0,0,0,0,0,0,0,0,3,255,255,0,0,0,0,0,0,0,0,0,3,255,255



Youlose:
	.db	"You lose !",0
Choice1:
	.db	"Set Difficulty",0
Choice2:
	.db	"Set Speed",0
Choice3:
	.db	"1<-3->5",0
ClearStr:
	.db	"CLEAR to quit",0
Scorestr:
	.db	"Score:",0
Highstr:
	.db	"Highscore:",0
Hightooeasynb:
	.db	$00,$00
Higheasynb:
	.db	$00,$00
Highnormalnb:
	.db	$00,$00
Highhardnb:
	.db	$00,$00
Highimpnb:
	.db	$00,$00


TitlePic:
    .db     255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,253,255,255,255,255,255,249
    .db     255,255,255,255,255,5,0,0,0,0,0,9,0,0,0,0,0,5,127,243,255,207,118,146,91,189,255,255,255,5,127
    .db     243,255,207,118,146,91,189,255,255,255,5,125,231,128,30,237,36,183,123,255,249,251,5,125,231,128,30,237,36,183,123
    .db     255,250,245,5,123,207,0,61,218,73,110,247,255,250,183,5,123,207,0,61,218,73,110,247,207,122,151,5,7,158,254
    .db     123,180,146,221,239,238,185,183,5,7,158,254,123,180,146,221,237,78,186,183,5,15,61,252,247,105,37,187,221,110,186
    .db     181,5,15,60,60,247,105,37,187,222,203,121,219,5,30,127,249,238,210,75,119,191,255,255,255,5,30,127,249,238,210
    .db     75,119,191,255,255,255,5,0,0,0,0,4,128,0,0,0,0,0,253,255,255,255,255,252,255,255,255,255,255,255,0
    .db	    0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255

