;##################################################################
;
;   Phoenix-Z80 (Variable and data structure defintions)
;
;   Programmed by Patrick Davidson (pad@calc.org)
;        
;   This program is in the public domain.  There is no warranty.
;
;   This file was last updated April 7, 2001.
;
;##################################################################   

#define VERSION " 1.3"
#define VERS_BYTE $12
;#define ENABLE_CHEATS

;############## Player bullet structure definition

pb_type         =0
pb_dmg          =1
pb_x            =2
pb_w            =3
pb_y            =4
pb_h            =5
pb_img          =6
pb_data         =8

pb_size         =9

pb_num          =16

;############## Enemy structure definition

e_type          =0          ; Type (offset in jump table)
e_phase         =1          ; Phase of movement (enemy-specific use)
e_timer         =2          ; Timer (enemy-specific use)
e_x             =3          ; X coordinate
e_w             =4          ; Width 
e_y             =5          ; Y coordinate
e_h             =6          ; Height
e_pwr           =7          ; Shield strength
e_img           =8          ; Image pointer (not required)

e_size          =12

e_num           =18

;############## Enemy bullet structure definition

eb_type         =0
eb_dmg          =1
eb_x            =2
eb_w            =3
eb_y            =4
eb_h            =5
eb_data         =6

eb_size         =6

eb_num          =15

;############## Permanent variables

perm_var_start  =TEXT_MEM

posqueue        =TEXT_MEM
player_y        =TEXT_MEM+20
player_x        =TEXT_MEM+21
enemies_left    =TEXT_MEM+22
level           =TEXT_MEM+23              
player_pwr      =TEXT_MEM+24
player_cash     =TEXT_MEM+25
weapon_upgrade  =TEXT_MEM+27
weapon_2        =TEXT_MEM+28
weapon_3        =TEXT_MEM+29
weapon_4        =TEXT_MEM+30
weapon_5        =TEXT_MEM+31
fire_counter    =TEXT_MEM+32
chosen_weapon   =TEXT_MEM+33
game_timer      =TEXT_MEM+34
pattern         =TEXT_MEM+36
companion_pwr   =TEXT_MEM+38
companion_y     =TEXT_MEM+39
companion_x     =TEXT_MEM+40
companion_img   =TEXT_MEM+41
difficulty      =TEXT_MEM+43
which_shot      =TEXT_MEM+44
time_score      =TEXT_MEM+45
bonus_score     =TEXT_MEM+47
completed       =TEXT_MEM+49
speed           =TEXT_MEM+50
swing_type      =TEXT_MEM+51        ;0 = rectangle, 1 = line
spacing         =TEXT_MEM+52        ;space between enemies in a line

perm_vars_to_zero =53

ext_level       =TEXT_MEM+53
is_boss1l       =TEXT_MEM+54
is_boss1r       =TEXT_MEM+56
is_boss2l       =TEXT_MEM+58
is_boss2r       =TEXT_MEM+60
is_boss3l       =TEXT_MEM+62
is_boss3r       =TEXT_MEM+64
is_enemy3       =TEXT_MEM+66
is_bounce       =TEXT_MEM+68
is_operator     =TEXT_MEM+70

perm_var_size   =72

;############## Temporary variables

gfx_target      =TEXT_MEM+108
in_game         =TEXT_MEM+110
misc_flags      =TEXT_MEM+111
data_addr       =TEXT_MEM+112
level_addr      =TEXT_MEM+115
doing_enemies   =TEXT_MEM+117
tempdata        =TEXT_MEM+118
shop_item       =TEXT_MEM+121
test_coords     =TEXT_MEM+122
timer           =TEXT_MEM+126
jp2nd           =TEXT_MEM+127
